/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecUtil {
    private static final Logger logger = LoggerFactory.getLogger(CodecUtil.class);
    private static final ArrayList<String> codecs = new ArrayList();

    private static void initCodecs() {
        InputStream is = CodecUtil.class.getClassLoader().getResourceAsStream("resources/ffmpeg_formats.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                if (line.contains(" ")) {
                    codecs.add(line.substring(0, line.indexOf(" ")));
                    continue;
                }
                codecs.add(line);
            }
            br.close();
            codecs.add("iso");
        }
        catch (IOException e) {
            logger.error("Error while retrieving codec list", e);
        }
    }

    public static ArrayList<String> getPossibleCodecs() {
        return codecs;
    }

    public static int getAC3Bitrate(PmsConfiguration configuration, DLNAMediaAudio media) {
        int defaultBitrate = configuration.getAudioBitrate();
        if (media != null && defaultBitrate >= 384) {
            if (media.getAudioProperties().getNumberOfChannels() == 2 || configuration.getAudioChannelCount() == 2) {
                defaultBitrate = 448;
            } else if (media.getAudioProperties().getNumberOfChannels() == 1) {
                defaultBitrate = 192;
            }
        }
        return defaultBitrate;
    }

    public static String getDefaultFontPath() {
        String font = null;
        if (Platform.isWindows()) {
            File fontsDir;
            File winDirFile;
            String winDir = PMS.get().getRegistry().getWindowsDirectory();
            if (winDir != null && (winDirFile = new File(winDir)).exists() && (fontsDir = new File(winDirFile, "Fonts")).exists()) {
                File arialDir = new File(fontsDir, "Arial.ttf");
                if (arialDir.exists()) {
                    font = arialDir.getAbsolutePath();
                } else {
                    arialDir = new File(fontsDir, "arial.ttf");
                    if (arialDir.exists()) {
                        font = arialDir.getAbsolutePath();
                    }
                }
            }
            if (font == null) {
                font = CodecUtil.getFont("C:\\Windows\\Fonts", "Arial.ttf");
            }
            if (font == null) {
                font = CodecUtil.getFont("C:\\WINNT\\Fonts", "Arial.ttf");
            }
            if (font == null) {
                font = CodecUtil.getFont("D:\\Windows\\Fonts", "Arial.ttf");
            }
            if (font == null) {
                font = CodecUtil.getFont(".\\win32\\mplayer\\", "subfont.ttf");
            }
            return font;
        }
        if (Platform.isLinux()) {
            font = CodecUtil.getFont("/usr/share/fonts/truetype/msttcorefonts/", "Arial.ttf");
            if (font == null) {
                font = CodecUtil.getFont("/usr/share/fonts/truetype/ttf-bitstream-veras/", "Vera.ttf");
            }
            if (font == null) {
                font = CodecUtil.getFont("/usr/share/fonts/truetype/ttf-dejavu/", "DejaVuSans.ttf");
            }
            return font;
        }
        if (Platform.isMac()) {
            font = CodecUtil.getFont("/System/Library/Frameworks/JavaVM.framework/Versions/1.5.0/Home/lib/fonts/", "LucidaSansRegular.ttf");
            return font;
        }
        return null;
    }

    private static String getFont(String path, String name) {
        File f = new File(path, name);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    static {
        CodecUtil.initCodecs();
    }
}

