/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxy
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Proxy.class);
    private Socket socket;
    private Socket socketToWeb;
    private BufferedReader fromBrowser;
    private OutputStream toBrowser;
    private PrintWriter toWeb;
    private boolean writeCache;

    public Proxy(Socket s, boolean writeCache) throws IOException {
        this.socket = s;
        this.fromBrowser = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.toBrowser = this.socket.getOutputStream();
        this.writeCache = writeCache;
        logger.trace("Got connection from " + this.socket);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int bytes_read;
            String str;
            String getter = null;
            String targetHost = "";
            String httpHeader = "";
            int targetPort = 80;
            do {
                if ((str = this.fromBrowser.readLine()).startsWith("GET") || str.startsWith("DESCRIBE") || str.startsWith("POST") || str.startsWith("HEAD")) {
                    getter = str;
                }
                if (str.startsWith("Accept-Encoding: gzip")) {
                    str = "Accept-Encoding: identity";
                }
                httpHeader = httpHeader + str + "\r\n";
                if (str.startsWith("Host: ")) {
                    targetHost = str.substring(6);
                    continue;
                }
                if (!str.startsWith("DESCRIBE")) continue;
                targetPort = 554;
                targetHost = str.substring(str.indexOf("//") + 2);
                targetHost = targetHost.substring(0, targetHost.indexOf("/"));
            } while (str.length() != 0);
            String target = targetHost;
            if (targetHost.indexOf(":") > -1) {
                try {
                    targetPort = Integer.parseInt(targetHost.substring(targetHost.indexOf(":") + 1));
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse port from \"" + targetHost.substring(targetHost.indexOf(":") + 1) + "\"");
                }
                target = targetHost.substring(0, targetHost.indexOf(":"));
            }
            logger.trace("[PROXY] Connect to: " + target + " and port: " + targetPort);
            this.socketToWeb = new Socket(InetAddress.getByName(target), targetPort);
            InputStream sockWebInputStream = this.socketToWeb.getInputStream();
            this.toWeb = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socketToWeb.getOutputStream())), true);
            this.toWeb.println(httpHeader);
            this.toWeb.flush();
            StringTokenizer st = new StringTokenizer(getter, " ");
            st.nextToken();
            String askedResource = st.nextToken();
            askedResource = askedResource.substring(askedResource.indexOf(targetHost) + targetHost.length());
            logger.trace("[PROXY] Asked resource: " + askedResource);
            String directoryResource = askedResource.substring(0, askedResource.lastIndexOf("/"));
            directoryResource = this.getWritableFileName(directoryResource);
            String fileResource = askedResource.substring(askedResource.lastIndexOf("/") + 1);
            fileResource = this.getWritableFileName(fileResource);
            fileResource = fileResource + ".cached";
            String fileN = "proxycache/" + target + "/" + directoryResource;
            File directoryResourceFile = new File(fileN);
            if (this.writeCache && !directoryResourceFile.mkdirs()) {
                logger.debug("Could not create directory \"" + directoryResourceFile.getAbsolutePath() + "\"");
            }
            File cachedResource = new File(directoryResourceFile, fileResource);
            byte[] buffer = new byte[8192];
            boolean resourceExists = cachedResource.exists() || this.getClass().getResource("/" + fileN) != null;
            boolean inMemory = this.writeCache && !resourceExists;
            FileOutputStream fOUT = null;
            if (resourceExists) {
                logger.trace("[PROXY] File is cached: " + cachedResource.getAbsolutePath());
                sockWebInputStream.close();
                sockWebInputStream = cachedResource.exists() ? new FileInputStream(cachedResource) : this.getClass().getResourceAsStream("/" + fileN);
            } else if (this.writeCache) {
                logger.trace("[PROXY] File is not cached / Writing in it: " + cachedResource.getAbsolutePath());
                fOUT = new FileOutputStream(cachedResource, false);
            }
            OutputStream baos = null;
            baos = inMemory ? new ByteArrayOutputStream() : this.toBrowser;
            long CL = 10000000000L;
            for (long total_read = 0L; total_read < CL && (bytes_read = sockWebInputStream.read(buffer)) != -1; total_read += (long)bytes_read) {
                if (!resourceExists) {
                    String s;
                    int clPos;
                    if (10000000000L == CL && (clPos = (s = new String(buffer, 0, bytes_read)).indexOf("Content-Length: ")) > -1) {
                        CL = Integer.parseInt(s.substring(clPos + 16, s.indexOf("\n", clPos)).trim());
                        logger.trace("Found Content Length: " + CL);
                    }
                    if (bytes_read >= 7) {
                        byte[] end = new byte[7];
                        System.arraycopy(buffer, bytes_read - 7, end, 0, 7);
                        if (new String(end).equals("\r\n0\r\n\r\n")) {
                            logger.trace("end of transfer chunked");
                            CL = -1L;
                        }
                    }
                    if (this.writeCache) {
                        fOUT.write(buffer, 0, bytes_read);
                    }
                }
                baos.write(buffer, 0, bytes_read);
            }
            sockWebInputStream.close();
            if (inMemory) {
                baos.close();
                this.toBrowser.write(((ByteArrayOutputStream)baos).toByteArray());
            }
            if (this.writeCache && fOUT != null) {
                fOUT.close();
            }
            this.socketToWeb.close();
            this.toBrowser.close();
        }
        catch (IOException e) {
            logger.debug("Caught exception", e);
        }
        finally {
            try {
                if (this.toWeb != null) {
                    this.toWeb.close();
                }
                if (this.toBrowser != null) {
                    this.toBrowser.close();
                }
                this.socket.close();
            }
            catch (IOException e) {
                logger.debug("Caught exception", e);
            }
        }
    }

    private String getWritableFileName(String resource) {
        resource = resource.replace('?', '\u00b5');
        resource = resource.replace('|', '\u00b5');
        resource = resource.replace('/', '\u00b5');
        resource = resource.replace('\\', '\u00b5');
        resource = resource.replace('>', '\u00b5');
        resource = resource.replace('<', '\u00b5');
        resource = resource.replace('|', '\u00b5');
        return resource;
    }
}

