/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import net.pms.PMS;
import net.pms.configuration.RendererConfiguration;
import net.pms.network.HTTPResourceAuthenticator;
import net.pms.util.PropertiesUtil;
import net.pms.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPResource {
    private static final Logger logger = LoggerFactory.getLogger(HTTPResource.class);
    public static final String UNKNOWN_VIDEO_TYPEMIME = "video/mpeg";
    public static final String UNKNOWN_IMAGE_TYPEMIME = "image/jpeg";
    public static final String UNKNOWN_AUDIO_TYPEMIME = "audio/mpeg";
    public static final String AUDIO_MP3_TYPEMIME = "audio/mpeg";
    public static final String AUDIO_MP4_TYPEMIME = "audio/x-m4a";
    public static final String AUDIO_WAV_TYPEMIME = "audio/wav";
    public static final String AUDIO_WMA_TYPEMIME = "audio/x-ms-wma";
    public static final String AUDIO_FLAC_TYPEMIME = "audio/x-flac";
    public static final String AUDIO_OGG_TYPEMIME = "audio/x-ogg";
    public static final String AUDIO_LPCM_TYPEMIME = "audio/L16";
    public static final String MPEG_TYPEMIME = "video/mpeg";
    public static final String MP4_TYPEMIME = "video/mp4";
    public static final String AVI_TYPEMIME = "video/avi";
    public static final String WMV_TYPEMIME = "video/x-ms-wmv";
    public static final String ASF_TYPEMIME = "video/x-ms-asf";
    public static final String MATROSKA_TYPEMIME = "video/x-matroska";
    public static final String VIDEO_TRANSCODE = "video/transcode";
    public static final String AUDIO_TRANSCODE = "audio/transcode";
    public static final String PNG_TYPEMIME = "image/png";
    public static final String JPEG_TYPEMIME = "image/jpeg";
    public static final String TIFF_TYPEMIME = "image/tiff";
    public static final String GIF_TYPEMIME = "image/gif";
    public static final String BMP_TYPEMIME = "image/bmp";

    public static String getDefaultMimeType(int type) {
        String mimeType = "video/mpeg";
        if (type == 4) {
            mimeType = "video/mpeg";
        } else if (type == 2) {
            mimeType = "image/jpeg";
        } else if (type == 1) {
            mimeType = "audio/mpeg";
        }
        return mimeType;
    }

    protected InputStream getResourceInputStream(String fileName) {
        fileName = "/resources/" + fileName;
        ClassLoader cll = this.getClass().getClassLoader();
        InputStream is = cll.getResourceAsStream(fileName.substring(1));
        while (is == null && cll.getParent() != null) {
            cll = cll.getParent();
            is = cll.getResourceAsStream(fileName.substring(1));
        }
        return is;
    }

    protected static InputStream downloadAndSend(String u, boolean saveOnDisk) throws IOException {
        URL url = new URL(u);
        File f = null;
        if (saveOnDisk) {
            String host = url.getHost();
            String hostName = StringUtil.convertURLToFileName(host);
            String fileName = url.getFile();
            fileName = StringUtil.convertURLToFileName(fileName);
            File hostDir = new File(PMS.getConfiguration().getTempFolder(), hostName);
            if (!hostDir.isDirectory() && !hostDir.mkdir()) {
                logger.debug("Cannot create directory: {}", (Object)hostDir.getAbsolutePath());
            }
            if ((f = new File(hostDir, fileName)).exists()) {
                return new FileInputStream(f);
            }
        }
        byte[] content = HTTPResource.downloadAndSendBinary(u, saveOnDisk, f);
        return new ByteArrayInputStream(content);
    }

    protected static byte[] downloadAndSendBinary(String u) throws IOException {
        return HTTPResource.downloadAndSendBinary(u, false, null);
    }

    protected static byte[] downloadAndSendBinary(String u, boolean saveOnDisk, File f) throws IOException {
        URL url = new URL(u);
        Authenticator.setDefault(new HTTPResourceAuthenticator());
        HTTPResourceAuthenticator.addURL(url);
        logger.debug("Retrieving " + url.toString());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-agent", PropertiesUtil.getProjectProperties().get("project.name") + " " + PMS.getVersion());
        InputStream in = conn.getInputStream();
        FileOutputStream fOUT = null;
        if (saveOnDisk && f != null) {
            fOUT = new FileOutputStream(f);
        }
        byte[] buf = new byte[4096];
        int n = -1;
        while ((n = in.read(buf)) > -1) {
            bytes.write(buf, 0, n);
            if (fOUT == null) continue;
            fOUT.write(buf, 0, n);
        }
        in.close();
        if (fOUT != null) {
            fOUT.close();
        }
        return bytes.toByteArray();
    }

    public String getRendererMimeType(String mimetype, RendererConfiguration renderer) {
        return renderer.getMimeType(mimetype);
    }

    public int getDLNALocalesCount() {
        return 3;
    }

    public final String getMPEG_PS_PALLocalizedValue(int index) {
        if (index == 1 || index == 2) {
            return "MPEG_PS_NTSC";
        }
        return "MPEG_PS_PAL";
    }

    public final String getMPEG_TS_SD_EU_ISOLocalizedValue(int index) {
        if (index == 1) {
            return "MPEG_TS_SD_NA_ISO";
        }
        if (index == 2) {
            return "MPEG_TS_SD_JP_ISO";
        }
        return "MPEG_TS_SD_EU_ISO";
    }

    public final String getMPEG_TS_SD_EULocalizedValue(int index) {
        if (index == 1) {
            return "MPEG_TS_SD_NA";
        }
        if (index == 2) {
            return "MPEG_TS_SD_JP";
        }
        return "MPEG_TS_SD_EU";
    }
}

