/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DVDISOTitle;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.ProcessUtil;

public class DVDISOFile
extends VirtualFolder {
    private static final String NAME = "[DVD ISO] %s";
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private File file;
    private boolean isVideoTS;

    private static String getName(File file) {
        return String.format(NAME, DVDISOFile.getFilename(file));
    }

    private static String getFilename(File file) {
        return file.isFile() ? file.getName() : "VIDEO_TS";
    }

    public String getFilename() {
        return DVDISOFile.getFilename(this.file);
    }

    public DVDISOFile(File file) {
        super(DVDISOFile.getName(file), null);
        this.file = file;
        this.isVideoTS = file.getName().toUpperCase().equals("VIDEO_TS");
        this.setLastModified(file.lastModified());
    }

    @Override
    protected void finalizeDisplayNameVars(Map<String, Object> vars) {
        if (this.isVideoTS) {
            vars.put("isVTS", true);
            File dvdFolder = this.file.getParentFile();
            if (dvdFolder != null) {
                vars.put("vtsDVD", dvdFolder.getName());
            }
        }
    }

    @Override
    protected void resolveOnce() {
        double[] titles = new double[100];
        String[] cmd = new String[]{configuration.getMplayerPath(), "-identify", "-endpos", "0", "-v", "-ao", "null", "-vc", "null", "-vo", "null", "-dvd-device", ProcessUtil.getShortFileNameIfWideChars(this.file.getAbsolutePath()), "dvd://1"};
        OutputParams params = new OutputParams(configuration);
        params.maxBufferSize = 1.0;
        params.log = true;
        final ProcessWrapperImpl pw = new ProcessWrapperImpl(cmd, params, true, false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pw.stopProcess();
            }
        };
        Thread failsafe = new Thread(r, "DVDISO Failsafe");
        failsafe.start();
        pw.runInSameThread();
        List<String> lines = pw.getOtherResults();
        if (lines != null) {
            for (String line : lines) {
                double duration;
                if (!line.startsWith("ID_DVD_TITLE_") || !line.contains("_LENGTH")) continue;
                int rank = Integer.parseInt(line.substring(13, line.indexOf("_LENGT")));
                titles[rank] = duration = Double.parseDouble(line.substring(line.lastIndexOf("LENGTH=") + 7));
            }
        }
        double oldduration = -1.0;
        for (int i = 1; i < 99; ++i) {
            if (!(titles[i] > 10.0) || titles[i] == oldduration && !(oldduration < 3600.0)) continue;
            DVDISOTitle dvd = new DVDISOTitle(this.file, i);
            this.addChild(dvd);
            oldduration = titles[i];
        }
        if (this.childrenNumber() > 0) {
            PMS.get().storeFileInCache(this.file, 32);
        }
    }
}

