/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib.tools.trackcutter;

import java.io.File;
import java.util.logging.Logger;
import jwbroek.cuelib.Position;
import jwbroek.cuelib.TrackData;
import jwbroek.cuelib.tools.trackcutter.TrackCutterConfiguration;

public class TrackCutterProcessingAction {
    private Position startPosition;
    private Position endPosition;
    private TrackData trackData;
    private boolean isPregap;
    private TrackCutterConfiguration configuration;
    private File cutFile = null;
    private File postProcessFile = null;
    private String postProcessingCommand = null;
    private static final Logger logger = Logger.getLogger(TrackCutterProcessingAction.class.getCanonicalName());

    public TrackCutterProcessingAction(Position position, Position position2, TrackData trackData, boolean bl, TrackCutterConfiguration trackCutterConfiguration) {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "TrackCutterProcessingAction(Position,Position,TrackData,boolean,TrackCutterConfiguration)", new Object[]{position, position2, trackData, bl, trackCutterConfiguration});
        this.startPosition = position;
        this.endPosition = position2;
        this.trackData = trackData;
        this.isPregap = bl;
        this.configuration = trackCutterConfiguration;
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "TrackCutterProcessingAction(Position,Position,TrackData,boolean,TrackCutterConfiguration)");
    }

    public File getCutFile() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getCutFile()");
        if (this.cutFile == null) {
            this.cutFile = this.configuration.getCutFile(this);
        }
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getCutFile()", this.cutFile);
        return this.cutFile;
    }

    public File getPostProcessFile() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getPostProcessFile()");
        if (this.postProcessFile == null) {
            this.postProcessFile = this.configuration.getPostProcessFile(this);
        }
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getPostProcessFile()", this.postProcessFile);
        return this.postProcessFile;
    }

    public String getPostProcessCommand() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getPostProcessCommand()");
        if (this.postProcessingCommand == null) {
            this.postProcessingCommand = this.configuration.getPostProcessCommand(this);
        }
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getPostProcessCommand()", this.postProcessingCommand);
        return this.postProcessingCommand;
    }

    public File getStdOutRedirectFile() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getStdOutRedirectFile()");
        File file = null;
        if (this.configuration.getRedirectStdOut()) {
            file = new File(this.getPostProcessFile().getPath() + ".out");
        }
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getStdOutRedirectFile()", file);
        return file;
    }

    public File getErrRedirectFile() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getErrRedirectFile()");
        File file = null;
        if (this.configuration.getRedirectStdOut()) {
            file = new File(this.getPostProcessFile().getPath() + ".err");
        }
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getErrRedirectFile()", file);
        return file;
    }

    public Position getStartPosition() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getStartPosition()");
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getStartPosition()", this.startPosition);
        return this.startPosition;
    }

    public Position getEndPosition() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getEndPosition()");
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getEndPosition()", this.endPosition);
        return this.endPosition;
    }

    public TrackData getTrackData() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getTrackData()");
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getTrackData()", this.trackData);
        return this.trackData;
    }

    public boolean getIsPregap() {
        logger.entering(TrackCutterProcessingAction.class.getCanonicalName(), "getIsPregap()");
        logger.exiting(TrackCutterProcessingAction.class.getCanonicalName(), "getIsPregap()", this.isPregap);
        return this.isPregap;
    }
}

