/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.ProcessListener;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.ScopedMap;
import com.floreysoft.jmte.token.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TemplateContext {
    public final ScopedMap model;
    public final List<Token> scopes;
    public final String template;
    public final Engine engine;
    public final String sourceName;
    public final ModelAdaptor modelAdaptor;
    public final Locale locale;
    public final ErrorHandler errorHandler;
    final ProcessListener processListener;

    public TemplateContext(String template, Locale locale, String sourceName, ScopedMap model, ModelAdaptor modelAdaptor, Engine engine, ErrorHandler errorHandler, ProcessListener processListener) {
        this.model = model;
        this.template = template;
        this.locale = locale;
        this.engine = engine;
        this.scopes = new ArrayList<Token>();
        this.sourceName = sourceName;
        this.modelAdaptor = modelAdaptor;
        this.errorHandler = errorHandler;
        this.processListener = processListener;
    }

    public void push(Token token) {
        this.scopes.add(token);
    }

    public Token pop() {
        if (this.scopes.isEmpty()) {
            return null;
        }
        Token token = this.scopes.remove(this.scopes.size() - 1);
        return token;
    }

    public Token peek() {
        if (this.scopes.isEmpty()) {
            return null;
        }
        Token token = this.scopes.get(this.scopes.size() - 1);
        return token;
    }

    public <T extends Token> T peek(Class<T> type) {
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            Token token = this.scopes.get(i);
            if (!token.getClass().equals(type)) continue;
            return (T)token;
        }
        return null;
    }

    public void notifyProcessListener(Token token, ProcessListener.Action action) {
        if (this.processListener != null) {
            this.processListener.log(this, token, action);
        }
    }

    public AnnotationProcessor<?> resolveAnnotationProcessor(String type) {
        return this.engine.resolveAnnotationProcessor(type);
    }

    public <C> Renderer<C> resolveRendererForClass(Class<C> clazz) {
        return this.engine.resolveRendererForClass(clazz);
    }

    public NamedRenderer resolveNamedRenderer(String rendererName) {
        return this.engine.resolveNamedRenderer(rendererName);
    }
}

