/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package javax.servlet.jsp.el;

import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.util.Map;

/**
 * <p>The abstract class for a prepared expression.</p>
 *
 * <p>An instance of an Expression can be obtained via from an 
 * ExpressionEvaluator instance.</p>
 *
 * <p>An Expression may or not have done a syntactic parse of the expression.
 * A client invoking the evaluate() method should be ready for the case 
 * where ELParseException exceptions are raised. </p>
 *
 * @since 2.0
 */
public abstract class Expression {

    /** 
     * Evaluates an expression that was previously prepared.  In some 
     * implementations preparing an expression involves full syntactic 
     * validation, but others may not do so.  Evaluating the expression may 
     * raise an ELParseException as well as other ELExceptions due to 
     * run-time evaluation.
     *
     * @param vResolver A VariableResolver instance that can be used at 
     *   runtime to resolve the name of implicit objects into Objects.
     * @return The result of the expression evaluation.
     *
     * @exception ELException Thrown if the expression evaluation failed.
     */ 
    public abstract Object evaluate( VariableResolver vResolver )
        throws ELException;
}

