/***************************************************************************
                          io.h  -  main insaneodyssey header file
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by aaron p. matthews
    email                : aaron@rivalgames.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------DEFINES--------------------------------*/

#define FRAMES_PER_SEC 		20

#define MAXCOLS			200
#define MAXROWS			200
#define MAXLAYERS		4
#define MAXPLAYERS 		8
#define MAXSOUNDS 		16
#define MAXTILES 		400
#define MAXFONTS		2
#define MAXSPRITES 		64
#define MAXLEVELS		32

#define ICONSTART 		65280

#define CM			0   	// Collision Map
#define AM			1	// Actor Map
#define BG			2	// Background Layer
#define FG			3	// Foreground Layer

#define TILED_WIDTH 		20
#define TILED_HEIGHT 		14
#define TILESIZE        	64			

/*--------------------------------TYPES--------------------------------*/

typedef enum {Other, Projectile, Actor, Dodad} objtype;
typedef enum {Left, Right, Up, Down, UpLeft, UpRight, DownLeft, DownRight} direction;

typedef struct {
		char name[32];
		char music[32];
		char bg[32];
		char att[32];
		char tiles[32];
} Level;

typedef struct {
        Uint16 nexttile;
        Uint16 bits;
        Uint8 wait;
} Tile;

typedef struct {
	char name[32];
	Uint16 xoff;
	Uint16 yoff;
	Uint16 wait;
	Uint16 next;
	SDL_Surface *image;
} Sprite;

class obj
{
	public:

	obj  	*next;
	obj  	*owner;
	obj  	*target;

	short 	x;
	short 	y;
	float 	xspeed;
	float 	yspeed;
	short 	maxspeed;
	short  jumpheight;

	short 	width;
	short 	height;

	short 	start_image;
	short   start_imagel;
	short 	image;

	short   health;
	short	ammo;

	bool  	jumping;
	bool	OnObject;

	Uint32	time;
	Uint32	frame;
	objtype kind;
	direction dir;

	short 	alpha;
	bool  	killme;

	bool	Touching ( obj *objp1 );	
	bool  	OnGround ();

	virtual bool Can_Move_Left ();
	virtual bool Can_Move_Right ();
	virtual bool Can_Move_Up ();
	virtual bool Can_Move_Down ();

	virtual void Newtonize ();
	virtual void DrawSprite ();
	void Move ();

	virtual void Go ();

	obj ();
};

class AnimTile
{
      public:
            AnimTile *Next;
            short x, y;
            short Tile;
            Uint32 Wait;
			Uint32 Time;
			
            AnimTile ( short newx, short newy, short newTile );
            void Add ( short newx, short newy, short newTile );
            void Delete ();
            void Go ();
};

/*----------------------------GLOBAL VARIABLES------------------------*/

short screen_width = 640;
short screen_height = 480;
short bpp = 16;

short tile_orgx = 0, tile_orgy = 0;
short realx = 0, realy = 0;
short nextx = TILESIZE, nexty = TILESIZE;
short map_width = 0;
short map_height = 0;
short map_width_pix = 0;
short map_height_pix = 0;

short tiles = 0;
short sprites = 0;
short levels = 0;
short players = 0;

short batt_level = 0;
short curr_level = 0;
short last_level = -1;
short gravity = 24;

short P1_Upkey = SDLK_UP;
short P1_Leftkey = SDLK_LEFT;
short P1_Rightkey = SDLK_RIGHT;
short P1_Jumpkey = SDLK_LCTRL;
short P1_Firekey = SDLK_LALT;

bool hwmem = true;
bool coolwhip = false;
bool battaglia = false;
bool parallax = true;

unsigned short map[MAXLAYERS][MAXCOLS][MAXROWS] = {0};

SDL_Surface *screen;
SDL_Surface *background;
SDL_Surface *tile[MAXTILES];
SDL_Surface *font[MAXFONTS];
	
#ifdef MIXER
Mix_Music *music;
Mix_Chunk *sound[MAXSOUNDS];
#endif

Level level[MAXLEVELS];
Tile tileatt[MAXTILES];
Sprite sprite[MAXSPRITES];
AnimTile *AnimTiles = new AnimTile(0,0,0);

obj *list = NULL;
Uint8 *keys;
obj *player[MAXPLAYERS];

/*----------------------------FUNCTIONS PROTOTYPES------------------------*/

void Scan_Level ();

SDL_Surface *LoadImage(char *datafile, short transparent);
SDL_Surface *LoadImageTile(char *datafile, short transparent);
void LoadImagePalette ( char *datafile );
Uint8 WaitFrame(void);
void ClearKeys ();

char test_bit(unsigned short num, unsigned short bit);
void DrawTile ( short x, short y, short layer );
void DrawMiddleTile ( short x, short y );
void DrawForegroundTile ( short x, short y );
void Draw_Level ();
void Draw_Level_Foreground ();
void DrawChar ( short x, short y, char c, short color );
void Print_Number ( short x, short y, short num, short color );
void Print_Text(short x, short y, char *text, short color);
short Find_Length ( char *text );
void Print_Center ( short y, char *text, short color );
