// <copyright file="IAlert.cs" company="Selenium Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// </copyright>

using System;

namespace OpenQA.Selenium;

/// <summary>
/// Defines the interface through which the user can manipulate JavaScript alerts.
/// </summary>
public interface IAlert
{
    /// <summary>
    /// Gets the text of the alert.
    /// </summary>
    string? Text { get; }

    /// <summary>
    /// Dismisses the alert.
    /// </summary>
    void Dismiss();

    /// <summary>
    /// Accepts the alert.
    /// </summary>
    void Accept();

    /// <summary>
    /// Sends keys to the alert.
    /// </summary>
    /// <param name="keysToSend">The keystrokes to send.</param>
    /// <exception cref="ArgumentNullException">If <paramref name="keysToSend"/> is <see langword="null"/>.</exception>
    void SendKeys(string keysToSend);
}
