/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Method", "UnboundMethod"}, overrides={RubyMethod.class, RubyUnboundMethod.class})
public abstract class AbstractRubyMethod
extends RubyObject
implements DataType {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected CacheEntry entry;
    protected DynamicMethod method;
    protected RubyModule sourceModule;

    protected AbstractRubyMethod(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public DynamicMethod getMethod() {
        return this.method;
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getSignature().arityValue());
    }

    @Deprecated
    public final IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.op_eql(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context, this.equals(other));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public abstract AbstractRubyMethod rbClone();

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        return context.runtime.newSymbol(this.methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    @JRubyMethod(name={"owner"})
    public IRubyObject owner(ThreadContext context) {
        return this.implementationModule.getOrigin();
    }

    @JRubyMethod(name={"source_location"})
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        String filename2 = this.getFilename();
        if (filename2 != null) {
            return runtime2.newArray((IRubyObject)runtime2.newString(filename2), (IRubyObject)runtime2.newFixnum(this.getLine()));
        }
        return context.nil;
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p(ThreadContext context) {
        return context.runtime.newBoolean(this.method.getVisibility().isPublic());
    }

    @JRubyMethod(name={"protected?"})
    public RubyBoolean protected_p(ThreadContext context) {
        return context.runtime.newBoolean(this.method.getVisibility().isProtected());
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p(ThreadContext context) {
        return context.runtime.newBoolean(this.method.getVisibility().isPrivate());
    }

    public String getFilename() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return TraceType.maskInternalFiles(poser.getFile());
        }
        return null;
    }

    public int getLine() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getLine() + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"parameters"})
    public IRubyObject parameters(ThreadContext context) {
        return Helpers.methodToParameters(context.runtime, this);
    }

    protected IRubyObject super_method(ThreadContext context, IRubyObject receiver2, RubyModule superClass) {
        if (superClass == null) {
            return context.nil;
        }
        String searchName = this.method.getRealMethod().getName();
        CacheEntry entry = superClass.searchWithCache(searchName);
        if (entry.method == UndefinedMethod.INSTANCE || entry.method.getDefinedClass().getMethods().get(entry.method.getName()) == UndefinedMethod.INSTANCE) {
            return context.nil;
        }
        if (receiver2 == null) {
            return RubyUnboundMethod.newUnboundMethod(entry.sourceModule, this.methodName, superClass, this.originName, entry);
        }
        return RubyMethod.newMethod(entry.sourceModule, this.methodName, superClass, this.originName, entry, receiver2);
    }

    @JRubyMethod
    public IRubyObject original_name(ThreadContext context) {
        if (this.method instanceof AliasMethod) {
            return context.runtime.newSymbol(((AliasMethod)this.method).getOldName());
        }
        return context.runtime.newSymbol(this.method.getName());
    }
}

