  // This file is autogenerated
  #import "KBRObject.h"
  #import "KBRRequest.h"
  #import "KBRRequestParams.h"

@interface KBRStringKVPair : KBRObject
@property NSString *key;
@property NSString *value;
@end

@interface KBRStatus : KBRObject
@property NSInteger code;
@property NSString *name;
@property NSString *desc;
@property NSArray *fields; /*of KBRStringKVPair*/
@end

@interface KBRText : KBRObject
@property NSString *data;
@property BOOL markup;
@end

@interface KBRPGPIdentity : KBRObject
@property NSString *username;
@property NSString *comment;
@property NSString *email;
@end

@interface KBRPublicKey : KBRObject
@property NSString *KID;
@property NSString *PGPFingerprint;
@property NSArray *PGPIdentities; /*of KBRPGPIdentity*/
@property BOOL isSibkey;
@property BOOL isEldest;
@property NSString *parentID;
@property NSString *deviceID;
@property NSString *deviceDescription;
@property NSString *deviceType;
@property int64_t cTime;
@property int64_t eTime;
@end

@interface KBRKeybaseTime : KBRObject
@property int64_t unix;
@property NSInteger chain;
@end

@interface KBRRevokedKey : KBRObject
@property KBRPublicKey *key;
@property KBRKeybaseTime *time;
@property NSString *by;
@end

@interface KBRUser : KBRObject
@property NSString *uid;
@property NSString *username;
@end

@interface KBRDevice : KBRObject
@property NSString *type;
@property NSString *name;
@property NSString *deviceID;
@property int64_t cTime;
@property int64_t mTime;
@property int64_t lastUsedTime;
@property NSString *encryptKey;
@property NSString *verifyKey;
@property NSInteger status;
@end

typedef NS_ENUM (NSInteger, KBRDeviceType) {
	KBRDeviceTypeDesktop = 0,
	KBRDeviceTypeMobile = 1,
};

@interface KBRStream : KBRObject
@property NSInteger fd;
@end

typedef NS_ENUM (NSInteger, KBRLogLevel) {
	KBRLogLevelNone = 0,
	KBRLogLevelDebug = 1,
	KBRLogLevelInfo = 2,
	KBRLogLevelNotice = 3,
	KBRLogLevelWarn = 4,
	KBRLogLevelError = 5,
	KBRLogLevelCritical = 6,
	KBRLogLevelFatal = 7,
};

typedef NS_ENUM (NSInteger, KBRClientType) {
	KBRClientTypeNone = 0,
	KBRClientTypeCli = 1,
	KBRClientTypeGui = 2,
	KBRClientTypeKbfs = 3,
};

@interface KBRUserVersionVector : KBRObject
@property int64_t id;
@property NSInteger sigHints;
@property int64_t sigChain;
@property int64_t cachedAt;
@property int64_t lastIdentifiedAt;
@end

@interface KBRUserPlusKeys : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSArray *deviceKeys; /*of KBRPublicKey*/
@property NSArray *revokedDeviceKeys; /*of KBRRevokedKey*/
@property NSInteger pgpKeyCount;
@property KBRUserVersionVector *uvv;
@end

@interface KBRRemoteTrack : KBRObject
@property NSString *username;
@property NSString *uid;
@property NSString *linkID;
@end

@interface KBRUserPlusAllKeys : KBRObject
@property KBRUserPlusKeys *base;
@property NSArray *pgpKeys; /*of KBRPublicKey*/
@property NSArray *remoteTracks; /*of KBRRemoteTrack*/
@end

typedef NS_ENUM (NSInteger, KBRMerkleTreeID) {
	KBRMerkleTreeIDMaster = 0,
	KBRMerkleTreeIDKbfsPublic = 1,
	KBRMerkleTreeIDKbfsPrivate = 2,
};

@interface KBRSocialAssertion : KBRObject
@property NSString *user;
@property NSString *service;
@end

@interface KBRUserResolution : KBRObject
@property KBRSocialAssertion *assertion;
@property NSString *userID;
@end

typedef NS_ENUM (NSInteger, KBRProofState) {
	KBRProofStateNone = 0,
	KBRProofStateOk = 1,
	KBRProofStateTempFailure = 2,
	KBRProofStatePermFailure = 3,
	KBRProofStateLooking = 4,
	KBRProofStateSuperseded = 5,
	KBRProofStatePosted = 6,
	KBRProofStateRevoked = 7,
	KBRProofStateDeleted = 8,
};

typedef NS_ENUM (NSInteger, KBRProofStatus) {
	KBRProofStatusNone = 0,
	KBRProofStatusOk = 1,
	KBRProofStatusLocal = 2,
	KBRProofStatusFound = 3,
	KBRProofStatusBaseError = 100,
	KBRProofStatusHostUnreachable = 101,
	KBRProofStatusPermissionDenied = 103,
	KBRProofStatusFailedParse = 106,
	KBRProofStatusDnsError = 107,
	KBRProofStatusAuthFailed = 108,
	KBRProofStatusHttp429 = 129,
	KBRProofStatusHttp500 = 150,
	KBRProofStatusTimeout = 160,
	KBRProofStatusInternalError = 170,
	KBRProofStatusBaseHardError = 200,
	KBRProofStatusNotFound = 201,
	KBRProofStatusContentFailure = 202,
	KBRProofStatusBadUsername = 203,
	KBRProofStatusBadRemoteId = 204,
	KBRProofStatusTextNotFound = 205,
	KBRProofStatusBadArgs = 206,
	KBRProofStatusContentMissing = 207,
	KBRProofStatusTitleNotFound = 208,
	KBRProofStatusServiceError = 209,
	KBRProofStatusTorSkipped = 210,
	KBRProofStatusTorIncompatible = 211,
	KBRProofStatusHttp300 = 230,
	KBRProofStatusHttp400 = 240,
	KBRProofStatusHttpOther = 260,
	KBRProofStatusEmptyJson = 270,
	KBRProofStatusDeleted = 301,
	KBRProofStatusServiceDead = 302,
	KBRProofStatusBadSignature = 303,
	KBRProofStatusBadApiUrl = 304,
	KBRProofStatusUnknownType = 305,
	KBRProofStatusNoHint = 306,
	KBRProofStatusBadHintText = 307,
	KBRProofStatusInvalidPvl = 308,
};

typedef NS_ENUM (NSInteger, KBRProofType) {
	KBRProofTypeNone = 0,
	KBRProofTypeKeybase = 1,
	KBRProofTypeTwitter = 2,
	KBRProofTypeGithub = 3,
	KBRProofTypeReddit = 4,
	KBRProofTypeCoinbase = 5,
	KBRProofTypeHackernews = 6,
	KBRProofTypeFacebook = 8,
	KBRProofTypeGenericWebSite = 1000,
	KBRProofTypeDns = 1001,
	KBRProofTypePgp = 1002,
	KBRProofTypeRooter = 100001,
};

typedef NS_ENUM (NSInteger, KBRTrackDiffType) {
	KBRTrackDiffTypeNone = 0,
	KBRTrackDiffTypeError = 1,
	KBRTrackDiffTypeClash = 2,
	KBRTrackDiffTypeRevoked = 3,
	KBRTrackDiffTypeUpgraded = 4,
	KBRTrackDiffTypeNew = 5,
	KBRTrackDiffTypeRemoteFail = 6,
	KBRTrackDiffTypeRemoteWorking = 7,
	KBRTrackDiffTypeRemoteChanged = 8,
	KBRTrackDiffTypeNewEldest = 9,
	KBRTrackDiffTypeNoneViaTemporary = 10,
};

@interface KBRTrackDiff : KBRObject
@property KBRTrackDiffType type;
@property NSString *displayMarkup;
@end

@interface KBRTrackSummary : KBRObject
@property NSString *username;
@property int64_t time;
@property BOOL isRemote;
@end

typedef NS_ENUM (NSInteger, KBRTrackStatus) {
	KBRTrackStatusNewOk = 1,
	KBRTrackStatusNewZeroProofs = 2,
	KBRTrackStatusNewFailProofs = 3,
	KBRTrackStatusUpdateBrokenFailedProofs = 4,
	KBRTrackStatusUpdateNewProofs = 5,
	KBRTrackStatusUpdateOk = 6,
	KBRTrackStatusUpdateBrokenRevoked = 7,
};

@interface KBRTrackOptions : KBRObject
@property BOOL localOnly;
@property BOOL bypassConfirm;
@property BOOL forceRetrack;
@property BOOL expiringLocal;
@property BOOL forPGPPull;
@end

typedef NS_ENUM (NSInteger, KBRIdentifyReasonType) {
	KBRIdentifyReasonTypeNone = 0,
	KBRIdentifyReasonTypeId = 1,
	KBRIdentifyReasonTypeTrack = 2,
	KBRIdentifyReasonTypeEncrypt = 3,
	KBRIdentifyReasonTypeDecrypt = 4,
	KBRIdentifyReasonTypeVerify = 5,
	KBRIdentifyReasonTypeResource = 6,
	KBRIdentifyReasonTypeBackground = 7,
};

@interface KBRIdentifyReason : KBRObject
@property KBRIdentifyReasonType type;
@property NSString *reason;
@property NSString *resource;
@end

@interface KBRIdentifyOutcome : KBRObject
@property NSString *username;
@property KBRStatus *status;
@property NSArray *warnings; /*of string*/
@property KBRTrackSummary *trackUsed;
@property KBRTrackStatus trackStatus;
@property NSInteger numTrackFailures;
@property NSInteger numTrackChanges;
@property NSInteger numProofFailures;
@property NSInteger numRevoked;
@property NSInteger numProofSuccesses;
@property NSArray *revoked; /*of KBRTrackDiff*/
@property KBRTrackOptions *trackOptions;
@property BOOL forPGPPull;
@property KBRIdentifyReason *reason;
@end

@interface KBRIdentifyRes : KBRObject
@property KBRUser *user;
@property NSArray *publicKeys; /*of KBRPublicKey*/
@property KBRIdentifyOutcome *outcome;
@property NSString *trackToken;
@end

@interface KBRRemoteProof : KBRObject
@property KBRProofType proofType;
@property NSString *key;
@property NSString *value;
@property NSString *displayMarkup;
@property NSString *sigID;
@property int64_t mTime;
@end

@interface KBRProofResult : KBRObject
@property KBRProofState state;
@property KBRProofStatus status;
@property NSString *desc;
@end

@interface KBRIdentifyRow : KBRObject
@property NSInteger rowId;
@property KBRRemoteProof *proof;
@property KBRTrackDiff *trackDiff;
@end

@interface KBRIdentifyKey : KBRObject
@property NSData *pgpFingerprint;
@property NSString *KID;
@property KBRTrackDiff *trackDiff;
@property BOOL breaksTracking;
@end

@interface KBRCryptocurrency : KBRObject
@property NSInteger rowId;
@property NSData *pkhash;
@property NSString *address;
@property NSString *sigID;
@property NSString *type;
@property NSString *family;
@end

@interface KBRRevokedProof : KBRObject
@property KBRRemoteProof *proof;
@property KBRTrackDiff *diff;
@end

@interface KBRIdentity : KBRObject
@property KBRStatus *status;
@property int64_t whenLastTracked;
@property NSArray *proofs; /*of KBRIdentifyRow*/
@property NSArray *cryptocurrency; /*of KBRCryptocurrency*/
@property NSArray *revoked; /*of KBRTrackDiff*/
@property NSArray *revokedDetails; /*of KBRRevokedProof*/
@property BOOL breaksTracking;
@end

@interface KBRSigHint : KBRObject
@property NSString *remoteId;
@property NSString *humanUrl;
@property NSString *apiUrl;
@property NSString *checkText;
@end

typedef NS_ENUM (NSInteger, KBRCheckResultFreshness) {
	KBRCheckResultFreshnessFresh = 0,
	KBRCheckResultFreshnessAged = 1,
	KBRCheckResultFreshnessRancid = 2,
};

@interface KBRCheckResult : KBRObject
@property KBRProofResult *proofResult;
@property int64_t time;
@property KBRCheckResultFreshness freshness;
@end

@interface KBRLinkCheckResult : KBRObject
@property NSInteger proofId;
@property KBRProofResult *proofResult;
@property KBRProofResult *snoozedResult;
@property BOOL torWarning;
@property int64_t tmpTrackExpireTime;
@property KBRCheckResult *cached;
@property KBRTrackDiff *diff;
@property KBRTrackDiff *remoteDiff;
@property KBRSigHint *hint;
@property BOOL breaksTracking;
@end

@interface KBRUserCard : KBRObject
@property NSInteger following;
@property NSInteger followers;
@property NSString *uid;
@property NSString *fullName;
@property NSString *location;
@property NSString *bio;
@property NSString *website;
@property NSString *twitter;
@property BOOL youFollowThem;
@property BOOL theyFollowYou;
@end

@interface KBRConfirmResult : KBRObject
@property BOOL identityConfirmed;
@property BOOL remoteConfirmed;
@property BOOL expiringLocal;
@end

typedef NS_ENUM (NSInteger, KBRDismissReasonType) {
	KBRDismissReasonTypeNone = 0,
	KBRDismissReasonTypeHandledElsewhere = 1,
};

@interface KBRDismissReason : KBRObject
@property KBRDismissReasonType type;
@property NSString *reason;
@property NSString *resource;
@end

typedef NS_ENUM (NSInteger, KBRSaltpackSenderType) {
	KBRSaltpackSenderTypeNotTracked = 0,
	KBRSaltpackSenderTypeUnknown = 1,
	KBRSaltpackSenderTypeAnonymous = 2,
	KBRSaltpackSenderTypeTrackingBroke = 3,
	KBRSaltpackSenderTypeTrackingOk = 4,
	KBRSaltpackSenderTypeSelf = 5,
};

@interface KBRSaltpackSender : KBRObject
@property NSString *uid;
@property NSString *username;
@property KBRSaltpackSenderType senderType;
@end

@interface KBRHasServerKeysRes : KBRObject
@property BOOL hasServerKeys;
@end

@interface KBRAPIRes : KBRObject
@property NSString *status;
@property NSString *body;
@property NSInteger httpStatus;
@property NSString *appStatus;
@end

@interface KBRBlockIdCombo : KBRObject
@property NSString *blockHash;
@property NSString *chargedTo;
@end

@interface KBRChallengeInfo : KBRObject
@property int64_t now;
@property NSString *challenge;
@end

@interface KBRGetBlockRes : KBRObject
@property NSString *blockKey;
@property NSData *buf;
@end

@interface KBRBlockReference : KBRObject
@property KBRBlockIdCombo *bid;
@property NSData *nonce;
@property NSString *chargedTo;
@end

@interface KBRBlockReferenceCount : KBRObject
@property KBRBlockReference *ref;
@property NSInteger liveCount;
@end

@interface KBRDowngradeReferenceRes : KBRObject
@property NSArray *completed; /*of KBRBlockReferenceCount*/
@property KBRBlockReference *failed;
@end

@interface KBRGetCurrentStatusRes : KBRObject
@property BOOL configured;
@property BOOL registered;
@property BOOL loggedIn;
@property BOOL sessionIsValid;
@property KBRUser *user;
@end

@interface KBRSessionStatus : KBRObject
@property NSString *SessionFor;
@property BOOL Loaded;
@property BOOL Cleared;
@property BOOL SaltOnly;
@property BOOL Expired;
@end

@interface KBRClientDetails : KBRObject
@property NSInteger pid;
@property KBRClientType clientType;
@property NSArray *argv; /*of string*/
@property NSString *desc;
@property NSString *version;
@end

@interface KBRPlatformInfo : KBRObject
@property NSString *os;
@property NSString *osVersion;
@property NSString *arch;
@property NSString *goVersion;
@end

@interface KBRLoadDeviceErr : KBRObject
@property NSString *where;
@property NSString *desc;
@end

@interface KBRExtendedStatus : KBRObject
@property BOOL standalone;
@property BOOL passphraseStreamCached;
@property BOOL tsecCached;
@property BOOL deviceSigKeyCached;
@property BOOL deviceEncKeyCached;
@property BOOL paperSigKeyCached;
@property BOOL paperEncKeyCached;
@property BOOL storedSecret;
@property BOOL secretPromptSkip;
@property KBRDevice *device;
@property KBRLoadDeviceErr *deviceErr;
@property NSString *logDir;
@property KBRSessionStatus *session;
@property NSString *defaultUsername;
@property NSArray *provisionedUsernames; /*of string*/
@property NSArray *Clients; /*of KBRClientDetails*/
@property KBRPlatformInfo *platformInfo;
@property NSString *defaultDeviceID;
@end

typedef NS_ENUM (NSInteger, KBRForkType) {
	KBRForkTypeNone = 0,
	KBRForkTypeAuto = 1,
	KBRForkTypeWatchdog = 2,
	KBRForkTypeLaunchd = 3,
};

@interface KBRConfig : KBRObject
@property NSString *serverURI;
@property NSString *socketFile;
@property NSString *label;
@property NSString *runMode;
@property BOOL gpgExists;
@property NSString *gpgPath;
@property NSString *version;
@property NSString *path;
@property NSString *configPath;
@property NSString *versionShort;
@property NSString *versionFull;
@property BOOL isAutoForked;
@property KBRForkType forkType;
@end

@interface KBRConfigValue : KBRObject
@property BOOL isNull;
@property BOOL b;
@property NSInteger i;
@property NSString *s;
@property NSString *o;
@end

@interface KBROutOfDateInfo : KBRObject
@property NSString *upgradeTo;
@property NSString *upgradeURI;
@property NSString *customMessage;
@property int64_t criticalClockSkew;
@end

typedef NS_ENUM (NSInteger, KBRStatusCode) {
	KBRStatusCodeScok = 0,
	KBRStatusCodeScinputerror = 100,
	KBRStatusCodeScloginrequired = 201,
	KBRStatusCodeScbadsession = 202,
	KBRStatusCodeScbadloginusernotfound = 203,
	KBRStatusCodeScbadloginpassword = 204,
	KBRStatusCodeScnotfound = 205,
	KBRStatusCodeScthrottlecontrol = 210,
	KBRStatusCodeScdeleted = 216,
	KBRStatusCodeScgeneric = 218,
	KBRStatusCodeScalreadyloggedin = 235,
	KBRStatusCodeScexists = 230,
	KBRStatusCodeSccanceled = 237,
	KBRStatusCodeScinputcanceled = 239,
	KBRStatusCodeScreloginrequired = 274,
	KBRStatusCodeScresolutionfailed = 275,
	KBRStatusCodeScprofilenotpublic = 276,
	KBRStatusCodeScidentifyfailed = 277,
	KBRStatusCodeSctrackingbroke = 278,
	KBRStatusCodeScwrongcryptoformat = 279,
	KBRStatusCodeScdecryptionerror = 280,
	KBRStatusCodeScinvalidaddress = 281,
	KBRStatusCodeScbademail = 472,
	KBRStatusCodeScbadsignupusernametaken = 701,
	KBRStatusCodeScbadinvitationcode = 707,
	KBRStatusCodeScmissingresult = 801,
	KBRStatusCodeSckeynotfound = 901,
	KBRStatusCodeSckeyinuse = 907,
	KBRStatusCodeSckeybadgen = 913,
	KBRStatusCodeSckeynosecret = 914,
	KBRStatusCodeSckeybaduids = 915,
	KBRStatusCodeSckeynoactive = 916,
	KBRStatusCodeSckeynosig = 917,
	KBRStatusCodeSckeybadsig = 918,
	KBRStatusCodeSckeybadeldest = 919,
	KBRStatusCodeSckeynoeldest = 920,
	KBRStatusCodeSckeyduplicateupdate = 921,
	KBRStatusCodeScsibkeyalreadyexists = 922,
	KBRStatusCodeScdecryptionkeynotfound = 924,
	KBRStatusCodeSckeynopgpencryption = 927,
	KBRStatusCodeSckeynonaclencryption = 928,
	KBRStatusCodeSckeysyncedpgpnotfound = 929,
	KBRStatusCodeSckeynomatchinggpg = 930,
	KBRStatusCodeSckeyrevoked = 931,
	KBRStatusCodeScbadtracksession = 1301,
	KBRStatusCodeScdevicebadname = 1404,
	KBRStatusCodeScdevicenameinuse = 1408,
	KBRStatusCodeScdevicenotfound = 1409,
	KBRStatusCodeScdevicemismatch = 1410,
	KBRStatusCodeScdevicerequired = 1411,
	KBRStatusCodeScdeviceprevprovisioned = 1413,
	KBRStatusCodeScdevicenoprovision = 1414,
	KBRStatusCodeScstreamexists = 1501,
	KBRStatusCodeScstreamnotfound = 1502,
	KBRStatusCodeScstreamwrongkind = 1503,
	KBRStatusCodeScstreameof = 1504,
	KBRStatusCodeScgenericapierror = 1600,
	KBRStatusCodeScapinetworkerror = 1601,
	KBRStatusCodeSctimeout = 1602,
	KBRStatusCodeScprooferror = 1701,
	KBRStatusCodeScidentificationexpired = 1702,
	KBRStatusCodeScselfnotfound = 1703,
	KBRStatusCodeScbadkexphrase = 1704,
	KBRStatusCodeScnouidelegation = 1705,
	KBRStatusCodeScnoui = 1706,
	KBRStatusCodeScgpgunavailable = 1707,
	KBRStatusCodeScinvalidversionerror = 1800,
	KBRStatusCodeScoldversionerror = 1801,
	KBRStatusCodeScinvalidlocationerror = 1802,
	KBRStatusCodeScservicestatuserror = 1803,
	KBRStatusCodeScinstallerror = 1804,
	KBRStatusCodeScchatinternal = 2500,
	KBRStatusCodeScchatratelimit = 2501,
	KBRStatusCodeScchatconvexists = 2502,
	KBRStatusCodeScchatunknowntlfid = 2503,
	KBRStatusCodeScchatnotinconv = 2504,
	KBRStatusCodeScchatbadmsg = 2505,
	KBRStatusCodeScchatbroadcast = 2506,
	KBRStatusCodeScchatalreadysuperseded = 2507,
	KBRStatusCodeScchatalreadydeleted = 2508,
	KBRStatusCodeScchattlffinalized = 2509,
	KBRStatusCodeScchatcollision = 2510,
};

@interface KBRED25519SignatureInfo : KBRObject
@property NSData *sig;
@property NSData *publicKey;
@end

@interface KBRCiphertextBundle : KBRObject
@property NSString *kid;
@property NSData *ciphertext;
@property NSData *nonce;
@property NSData *publicKey;
@end

@interface KBRUnboxAnyRes : KBRObject
@property NSString *kid;
@property NSData *plaintext;
@property NSInteger index;
@end

@interface KBRRegisterAddressRes : KBRObject
@property NSString *type;
@property NSString *family;
@end

typedef NS_ENUM (NSInteger, KBRExitCode) {
	KBRExitCodeOk = 0,
	KBRExitCodeNotok = 2,
	KBRExitCodeRestart = 4,
};

@interface KBRFirstStepResult : KBRObject
@property NSInteger valPlusTwo;
@end

@interface KBRDeviceDetail : KBRObject
@property KBRDevice *device;
@property BOOL eldest;
@property KBRDevice *provisioner;
@property int64_t provisionedAt;
@property int64_t revokedAt;
@property NSString *revokedBy;
@property KBRDevice *revokedByDevice;
@property BOOL currentDevice;
@end

@interface KBRFolder : KBRObject
@property NSString *name;
@property BOOL private;
@property BOOL notificationsOn;
@property BOOL created;
@end

@interface KBRFavoritesResult : KBRObject
@property NSArray *favoriteFolders; /*of KBRFolder*/
@property NSArray *ignoredFolders; /*of KBRFolder*/
@property NSArray *foldersNew; /*of KBRFolder*/
@end

@interface KBRFile : KBRObject
@property NSString *path;
@end

@interface KBRListResult : KBRObject
@property NSArray *files; /*of KBRFile*/
@end

@interface KBRGPGKey : KBRObject
@property NSString *algorithm;
@property NSString *keyID;
@property NSString *creation;
@property NSString *expiration;
@property NSArray *identities; /*of KBRPGPIdentity*/
@end

@interface KBRSelectKeyRes : KBRObject
@property NSString *keyID;
@property BOOL doSecretPush;
@end

@interface KBRIdentifyProofBreak : KBRObject
@property KBRRemoteProof *remoteProof;
@property KBRLinkCheckResult *lcr;
@end

@interface KBRIdentifyTrackBreaks : KBRObject
@property NSArray *keys; /*of KBRIdentifyKey*/
@property NSArray *proofs; /*of KBRIdentifyProofBreak*/
@end

@interface KBRIdentify2Res : KBRObject
@property KBRUserPlusKeys *upk;
@property KBRIdentifyTrackBreaks *trackBreaks;
@end

typedef NS_ENUM (NSInteger, KBRInstallStatus) {
	KBRInstallStatusUnknown = 0,
	KBRInstallStatusError = 1,
	KBRInstallStatusNotInstalled = 2,
	KBRInstallStatusInstalled = 4,
};

typedef NS_ENUM (NSInteger, KBRInstallAction) {
	KBRInstallActionUnknown = 0,
	KBRInstallActionNone = 1,
	KBRInstallActionUpgrade = 2,
	KBRInstallActionReinstall = 3,
	KBRInstallActionInstall = 4,
};

@interface KBRServiceStatus : KBRObject
@property NSString *version;
@property NSString *label;
@property NSString *pid;
@property NSString *lastExitStatus;
@property NSString *bundleVersion;
@property KBRInstallStatus installStatus;
@property KBRInstallAction installAction;
@property KBRStatus *status;
@end

@interface KBRServicesStatus : KBRObject
@property NSArray *service; /*of KBRServiceStatus*/
@property NSArray *kbfs; /*of KBRServiceStatus*/
@property NSArray *updater; /*of KBRServiceStatus*/
@end

@interface KBRFuseMountInfo : KBRObject
@property NSString *path;
@property NSString *fstype;
@property NSString *output;
@end

@interface KBRFuseStatus : KBRObject
@property NSString *version;
@property NSString *bundleVersion;
@property NSString *kextID;
@property NSString *path;
@property BOOL kextStarted;
@property KBRInstallStatus installStatus;
@property KBRInstallAction installAction;
@property NSArray *mountInfos; /*of KBRFuseMountInfo*/
@property KBRStatus *status;
@end

@interface KBRComponentResult : KBRObject
@property NSString *name;
@property KBRStatus *status;
@end

@interface KBRInstallResult : KBRObject
@property NSArray *componentResults; /*of KBRComponentResult*/
@property KBRStatus *status;
@property BOOL fatal;
@end

@interface KBRUninstallResult : KBRObject
@property NSArray *componentResults; /*of KBRComponentResult*/
@property KBRStatus *status;
@end

typedef NS_ENUM (NSInteger, KBRFSStatusCode) {
	KBRFSStatusCodeStart = 0,
	KBRFSStatusCodeFinish = 1,
	KBRFSStatusCodeError = 2,
};

typedef NS_ENUM (NSInteger, KBRFSNotificationType) {
	KBRFSNotificationTypeEncrypting = 0,
	KBRFSNotificationTypeDecrypting = 1,
	KBRFSNotificationTypeSigning = 2,
	KBRFSNotificationTypeVerifying = 3,
	KBRFSNotificationTypeRekeying = 4,
	KBRFSNotificationTypeConnection = 5,
	KBRFSNotificationTypeMdReadSuccess = 6,
	KBRFSNotificationTypeFileCreated = 7,
	KBRFSNotificationTypeFileModified = 8,
	KBRFSNotificationTypeFileDeleted = 9,
	KBRFSNotificationTypeFileRenamed = 10,
};

typedef NS_ENUM (NSInteger, KBRFSErrorType) {
	KBRFSErrorTypeAccessDenied = 0,
	KBRFSErrorTypeUserNotFound = 1,
	KBRFSErrorTypeRevokedDataDetected = 2,
	KBRFSErrorTypeNotLoggedIn = 3,
	KBRFSErrorTypeTimeout = 4,
	KBRFSErrorTypeRekeyNeeded = 5,
	KBRFSErrorTypeBadFolder = 6,
	KBRFSErrorTypeNotImplemented = 7,
	KBRFSErrorTypeOldVersion = 8,
	KBRFSErrorTypeOverQuota = 9,
	KBRFSErrorTypeNoSigChain = 10,
	KBRFSErrorTypeTooManyFolders = 11,
};

@interface KBRFSNotification : KBRObject
@property BOOL publicTopLevelFolder;
@property NSString *filename;
@property NSString *status;
@property KBRFSStatusCode statusCode;
@property KBRFSNotificationType notificationType;
@property KBRFSErrorType errorType;
@property NSString *writerUid;
@property int64_t localTime;
@end

@interface KBRFSEditListRequest : KBRObject
@property KBRFolder *folder;
@property NSInteger requestID;
@end

@interface KBRFSSyncStatusRequest : KBRObject
@property NSInteger requestID;
@end

@interface KBRFSPathSyncStatus : KBRObject
@property BOOL publicTopLevelFolder;
@property NSString *path;
@property int64_t syncingBytes;
@property int64_t syncingOps;
@property int64_t syncedBytes;
@end

@interface KBRFSSyncStatus : KBRObject
@property int64_t totalSyncingBytes;
@property int64_t totalSyncingOps;
@property NSArray *pathStatuses; /*of KBRFSPathSyncStatus*/
@end

@interface KBRPassphraseStream : KBRObject
@property NSData *passphraseStream;
@property NSInteger generation;
@end

@interface KBRHello2Res : KBRObject
@property NSString *encryptionKey;
@property NSString *sigPayload;
@end

@interface KBRConfiguredAccount : KBRObject
@property NSString *username;
@property BOOL hasStoredSecret;
@end

@interface KBRKeyHalf : KBRObject
@property NSString *user;
@property NSString *deviceKID;
@property NSData *key;
@end

@interface KBRMDBlock : KBRObject
@property NSInteger version;
@property int64_t timestamp;
@property NSData *block;
@end

@interface KBRKeyBundle : KBRObject
@property NSInteger version;
@property NSData *bundle;
@end

@interface KBRMetadataResponse : KBRObject
@property NSString *folderID;
@property NSArray *mdBlocks; /*of KBRMDBlock*/
@end

@interface KBRMerkleRoot : KBRObject
@property NSInteger version;
@property NSData *root;
@end

@interface KBRPingResponse : KBRObject
@property int64_t timestamp;
@end

@interface KBRKeyBundleResponse : KBRObject
@property KBRKeyBundle *WriterBundle;
@property KBRKeyBundle *ReaderBundle;
@end

@interface KBRBadgeState : KBRObject
@property NSInteger total;
@property NSInteger tlfsNew;
@property NSInteger rekeysNeeded;
@property NSInteger followersNew;
@property NSInteger unreadChatMessages;
@property NSInteger unreadChatConversations;
@property NSArray *conversations; /*of KBRBadgeConversationInfo*/
@end

@interface KBRBadgeConversationInfo : KBRObject
@property NSData *convID;
@property NSInteger UnreadMessages;
@end

@interface KBRNotificationChannels : KBRObject
@property BOOL session;
@property BOOL users;
@property BOOL kbfs;
@property BOOL tracking;
@property BOOL favorites;
@property BOOL paperkeys;
@property BOOL keyfamily;
@property BOOL service;
@property BOOL app;
@property BOOL chat;
@property BOOL pgp;
@property BOOL kbfsrequest;
@property BOOL badges;
@property BOOL reachability;
@end

@interface KBRFeature : KBRObject
@property BOOL allow;
@property BOOL defaultValue;
@property BOOL readonly;
@property NSString *label;
@end

@interface KBRGUIEntryFeatures : KBRObject
@property KBRFeature *showTyping;
@end

typedef NS_ENUM (NSInteger, KBRPassphraseType) {
	KBRPassphraseTypeNone = 0,
	KBRPassphraseTypePaperKey = 1,
	KBRPassphraseTypePassPhrase = 2,
	KBRPassphraseTypeVerifyPassPhrase = 3,
};

@interface KBRGUIEntryArg : KBRObject
@property NSString *windowTitle;
@property NSString *prompt;
@property NSString *username;
@property NSString *submitLabel;
@property NSString *cancelLabel;
@property NSString *retryLabel;
@property KBRPassphraseType type;
@property KBRGUIEntryFeatures *features;
@end

@interface KBRGetPassphraseRes : KBRObject
@property NSString *passphrase;
@property BOOL storeSecret;
@end

typedef NS_ENUM (NSInteger, KBRSignMode) {
	KBRSignModeAttached = 0,
	KBRSignModeDetached = 1,
	KBRSignModeClear = 2,
};

@interface KBRPGPSignOptions : KBRObject
@property NSString *keyQuery;
@property KBRSignMode mode;
@property BOOL binaryIn;
@property BOOL binaryOut;
@end

@interface KBRPGPEncryptOptions : KBRObject
@property NSArray *recipients; /*of string*/
@property BOOL noSign;
@property BOOL noSelf;
@property BOOL binaryOut;
@property NSString *keyQuery;
@end

@interface KBRPGPSigVerification : KBRObject
@property BOOL isSigned;
@property BOOL verified;
@property KBRUser *signer;
@property KBRPublicKey *signKey;
@end

@interface KBRPGPDecryptOptions : KBRObject
@property BOOL assertSigned;
@property NSString *signedBy;
@end

@interface KBRPGPVerifyOptions : KBRObject
@property NSString *signedBy;
@property NSData *signature;
@end

@interface KBRKeyInfo : KBRObject
@property NSString *fingerprint;
@property NSString *key;
@property NSString *desc;
@end

@interface KBRPGPQuery : KBRObject
@property BOOL secret;
@property NSString *query;
@property BOOL exactMatch;
@end

@interface KBRPGPCreateUids : KBRObject
@property BOOL useDefault;
@property NSArray *ids; /*of KBRPGPIdentity*/
@end

@interface KBRPGPPurgeRes : KBRObject
@property NSArray *filenames; /*of string*/
@end

typedef NS_ENUM (NSInteger, KBRFileType) {
	KBRFileTypeUnknown = 0,
	KBRFileTypeDirectory = 1,
	KBRFileTypeFile = 2,
};

@interface KBRFileDescriptor : KBRObject
@property NSString *name;
@property KBRFileType type;
@end

@interface KBRProcess : KBRObject
@property NSString *pid;
@property NSString *command;
@property NSArray *fileDescriptors; /*of KBRFileDescriptor*/
@end

@interface KBRCheckProofStatus : KBRObject
@property BOOL found;
@property KBRProofStatus status;
@property NSString *proofText;
@property KBRProofState state;
@end

@interface KBRStartProofResult : KBRObject
@property NSString *sigID;
@end

typedef NS_ENUM (NSInteger, KBRPromptOverwriteType) {
	KBRPromptOverwriteTypeSocial = 0,
	KBRPromptOverwriteTypeSite = 1,
};

typedef NS_ENUM (NSInteger, KBRProvisionMethod) {
	KBRProvisionMethodDevice = 0,
	KBRProvisionMethodPaperKey = 1,
	KBRProvisionMethodPassphrase = 2,
	KBRProvisionMethodGpgImport = 3,
	KBRProvisionMethodGpgSign = 4,
};

typedef NS_ENUM (NSInteger, KBRGPGMethod) {
	KBRGPGMethodGpgNone = 0,
	KBRGPGMethodGpgImport = 1,
	KBRGPGMethodGpgSign = 2,
};

typedef NS_ENUM (NSInteger, KBRChooseType) {
	KBRChooseTypeExistingDevice = 0,
	KBRChooseTypeNewDevice = 1,
};

@interface KBRSecretResponse : KBRObject
@property NSData *secret;
@property NSString *phrase;
@end

@interface KBRVerifySessionRes : KBRObject
@property NSString *uid;
@property NSString *sid;
@property NSInteger generated;
@property NSInteger lifetime;
@end

typedef NS_ENUM (NSInteger, KBRReachable) {
	KBRReachableUnknown = 0,
	KBRReachableYes = 1,
	KBRReachableNo = 2,
};

@interface KBRReachability : KBRObject
@property KBRReachable reachable;
@end

@interface KBRTLF : KBRObject
@property NSString *id;
@property NSString *name;
@property NSArray *writers; /*of string*/
@property NSArray *readers; /*of string*/
@property BOOL isPrivate;
@end

@interface KBRProblemTLF : KBRObject
@property KBRTLF *tlf;
@property NSInteger score;
@property NSArray *solution_kids; /*of NSString*/
@end

@interface KBRProblemSet : KBRObject
@property KBRUser *user;
@property NSString *kid;
@property NSArray *tlfs; /*of KBRProblemTLF*/
@end

@interface KBRProblemSetDevices : KBRObject
@property KBRProblemSet *problemSet;
@property NSArray *devices; /*of KBRDevice*/
@end

typedef NS_ENUM (NSInteger, KBROutcome) {
	KBROutcomeNone = 0,
	KBROutcomeFixed = 1,
	KBROutcomeIgnored = 2,
};

@interface KBRRevokeWarning : KBRObject
@property NSArray *endangeredTLFs; /*of KBRTLF*/
@end

typedef NS_ENUM (NSInteger, KBRRekeyEventType) {
	KBRRekeyEventTypeNone = 0,
	KBRRekeyEventTypeNotLoggedIn = 1,
	KBRRekeyEventTypeApiError = 2,
	KBRRekeyEventTypeNoProblems = 3,
	KBRRekeyEventTypeLoadMeError = 4,
	KBRRekeyEventTypeCurrentDeviceCanRekey = 5,
	KBRRekeyEventTypeDeviceLoadError = 6,
	KBRRekeyEventTypeHarass = 7,
	KBRRekeyEventTypeNoGregorMessages = 8,
};

@interface KBRRekeyEvent : KBRObject
@property KBRRekeyEventType eventType;
@property NSInteger interruptType;
@end

@interface KBRSaltpackEncryptOptions : KBRObject
@property NSArray *recipients; /*of string*/
@property BOOL hideSelf;
@property BOOL noSelfEncrypt;
@property BOOL binary;
@property BOOL hideRecipients;
@end

@interface KBRSaltpackDecryptOptions : KBRObject
@property BOOL interactive;
@property BOOL forceRemoteCheck;
@property BOOL usePaperKey;
@end

@interface KBRSaltpackSignOptions : KBRObject
@property BOOL detached;
@property BOOL binary;
@end

@interface KBRSaltpackVerifyOptions : KBRObject
@property NSString *signedBy;
@property NSData *signature;
@end

@interface KBRSaltpackEncryptedMessageInfo : KBRObject
@property NSArray *devices; /*of KBRDevice*/
@property NSInteger numAnonReceivers;
@property BOOL receiverIsAnon;
@property KBRSaltpackSender *sender;
@end

@interface KBRSecretEntryArg : KBRObject
@property NSString *desc;
@property NSString *prompt;
@property NSString *err;
@property NSString *cancel;
@property NSString *ok;
@property NSString *reason;
@property BOOL showTyping;
@end

@interface KBRSecretEntryRes : KBRObject
@property NSString *text;
@property BOOL canceled;
@property BOOL storeSecret;
@end

@interface KBRSecretKeys : KBRObject
@property NSData *signing;
@property NSData *encryption;
@end

@interface KBRSession : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSString *token;
@property NSString *deviceSubkeyKid;
@property NSString *deviceSibkeyKid;
@end

@interface KBRSignupRes : KBRObject
@property BOOL passphraseOk;
@property BOOL postOk;
@property BOOL writeOk;
@end

@interface KBRSig : KBRObject
@property NSInteger seqno;
@property NSString *sigID;
@property NSString *sigIDDisplay;
@property NSString *type;
@property int64_t cTime;
@property BOOL revoked;
@property BOOL active;
@property NSString *key;
@property NSString *body;
@end

@interface KBRSigTypes : KBRObject
@property BOOL track;
@property BOOL proof;
@property BOOL cryptocurrency;
@property BOOL isSelf;
@end

@interface KBRSigListArgs : KBRObject
@property NSInteger sessionID;
@property NSString *username;
@property BOOL allKeys;
@property KBRSigTypes *types;
@property NSString *filterx;
@property BOOL verbose;
@property BOOL revoked;
@end

@interface KBRTest : KBRObject
@property NSString *reply;
@end

typedef NS_ENUM (NSInteger, KBRTLFIdentifyBehavior) {
	KBRTLFIdentifyBehaviorDefaultKbfs = 0,
	KBRTLFIdentifyBehaviorChatCli = 1,
	KBRTLFIdentifyBehaviorChatGui = 2,
	KBRTLFIdentifyBehaviorChatGuiStrict = 3,
};

@interface KBRCryptKey : KBRObject
@property NSInteger KeyGeneration;
@property NSData *Key;
@end

@interface KBRTLFBreak : KBRObject
@property NSArray *breaks; /*of KBRTLFIdentifyFailure*/
@end

@interface KBRTLFIdentifyFailure : KBRObject
@property KBRUser *user;
@property KBRIdentifyTrackBreaks *breaks;
@end

@interface KBRCanonicalTLFNameAndIDWithBreaks : KBRObject
@property NSString *tlfID;
@property NSString *CanonicalName;
@property KBRTLFBreak *breaks;
@end

@interface KBRGetTLFCryptKeysRes : KBRObject
@property KBRCanonicalTLFNameAndIDWithBreaks *nameIDBreaks;
@property NSArray *CryptKeys; /*of KBRCryptKey*/
@end

@interface KBRTLFQuery : KBRObject
@property NSString *tlfName;
@property KBRTLFIdentifyBehavior identifyBehavior;
@end

typedef NS_ENUM (NSInteger, KBRPromptDefault) {
	KBRPromptDefaultNone = 0,
	KBRPromptDefaultYes = 1,
	KBRPromptDefaultNo = 2,
};

@interface KBRTracker : KBRObject
@property NSString *tracker;
@property NSInteger status;
@property int64_t mTime;
@end

@interface KBRTrackProof : KBRObject
@property NSString *proofType;
@property NSString *proofName;
@property NSString *idString;
@end

@interface KBRWebProof : KBRObject
@property NSString *hostname;
@property NSArray *protocols; /*of string*/
@end

@interface KBRProofs : KBRObject
@property NSArray *social; /*of KBRTrackProof*/
@property NSArray *web; /*of KBRWebProof*/
@property NSArray *publicKeys; /*of KBRPublicKey*/
@end

@interface KBRUserSummary : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSString *thumbnail;
@property NSInteger idVersion;
@property NSString *fullName;
@property NSString *bio;
@property KBRProofs *proofs;
@property NSString *sigIDDisplay;
@property int64_t trackTime;
@end

@interface KBREmail : KBRObject
@property NSString *email;
@property BOOL isVerified;
@end

@interface KBRUserSettings : KBRObject
@property NSArray *emails; /*of KBREmail*/
@end

@interface KBRSearchComponent : KBRObject
@property NSString *key;
@property NSString *value;
@property double score;
@end

@interface KBRSearchResult : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSArray *components; /*of KBRSearchComponent*/
@property double score;
@end

@interface KBRUserSummary2 : KBRObject
@property NSString *uid;
@property NSString *username;
@property NSString *thumbnail;
@property NSString *fullName;
@property BOOL isFollower;
@property BOOL isFollowee;
@end

@interface KBRUserSummary2Set : KBRObject
@property NSArray *users; /*of KBRUserSummary2*/
@property int64_t time;
@property NSInteger version;
@end
@interface KBRDisplayTLFCreateWithInviteRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *folderName;
@property BOOL isPrivate;
@property NSString *assertion;
@property KBRSocialAssertion *socialAssertion;
@property NSString *inviteLink;
@property BOOL throttled;
@end
@interface KBRStartRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property KBRIdentifyReason *reason;
@property BOOL forceDisplay;
@end
@interface KBRDisplayKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRIdentifyKey *key;
@end
@interface KBRReportLastTrackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRTrackSummary *track;
@end
@interface KBRLaunchNetworkChecksRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRIdentity *identity;
@property KBRUser *user;
@end
@interface KBRDisplayTrackStatementRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *stmt;
@end
@interface KBRFinishWebProofCheckRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRRemoteProof *rp;
@property KBRLinkCheckResult *lcr;
@end
@interface KBRFinishSocialProofCheckRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRRemoteProof *rp;
@property KBRLinkCheckResult *lcr;
@end
@interface KBRDisplayCryptocurrencyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRCryptocurrency *c;
@end
@interface KBRReportTrackTokenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *trackToken;
@end
@interface KBRDisplayUserCardRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRUserCard *card;
@end
@interface KBRConfirmRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRIdentifyOutcome *outcome;
@end
@interface KBRCancelRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFinishRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDismissRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property KBRDismissReason *reason;
@end
@interface KBRSaltpackPromptForDecryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRSaltpackSender *sender;
@property BOOL usedDelegateUI;
@end
@interface KBRSaltpackVerifySuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *signingKID;
@property KBRSaltpackSender *sender;
@end
@interface KBRPassphraseChangeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *oldPassphrase;
@property NSString *passphrase;
@property BOOL force;
@end
@interface KBRPassphrasePromptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRGUIEntryArg *guiArg;
@end
@interface KBREmailChangeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *emailNew;
@end
@interface KBRHasServerKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRGetRequestParams : KBRRequestParams
@property NSString *endpoint;
@property NSArray *args;
@property NSArray *httpStatus;
@property NSArray *appStatusCode;
@end
@interface KBRPostRequestParams : KBRRequestParams
@property NSString *endpoint;
@property NSArray *args;
@property NSArray *httpStatus;
@property NSArray *appStatusCode;
@end
@interface KBRPostJSONRequestParams : KBRRequestParams
@property NSString *endpoint;
@property NSArray *args;
@property NSArray *JSONPayload;
@property NSArray *httpStatus;
@property NSArray *appStatusCode;
@end
@interface KBRAuthenticateSessionRequestParams : KBRRequestParams
@property NSString *signature;
@end
@interface KBRPutBlockRequestParams : KBRRequestParams
@property KBRBlockIdCombo *bid;
@property NSString *folder;
@property NSString *blockKey;
@property NSData *buf;
@end
@interface KBRGetBlockRequestParams : KBRRequestParams
@property KBRBlockIdCombo *bid;
@property NSString *folder;
@end
@interface KBRAddReferenceRequestParams : KBRRequestParams
@property NSString *folder;
@property KBRBlockReference *ref;
@end
@interface KBRDelReferenceRequestParams : KBRRequestParams
@property NSString *folder;
@property KBRBlockReference *ref;
@end
@interface KBRArchiveReferenceRequestParams : KBRRequestParams
@property NSString *folder;
@property NSArray *refs;
@end
@interface KBRDelReferenceWithCountRequestParams : KBRRequestParams
@property NSString *folder;
@property NSArray *refs;
@end
@interface KBRArchiveReferenceWithCountRequestParams : KBRRequestParams
@property NSString *folder;
@property NSArray *refs;
@end
@interface KBRRegisterBTCRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *address;
@property BOOL force;
@end
@interface KBRGetCurrentStatusRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRGetExtendedStatusRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRGetConfigRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRSetUserConfigRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property NSString *key;
@property NSString *value;
@end
@interface KBRSetPathRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *path;
@end
@interface KBRHelloIAmRequestParams : KBRRequestParams
@property KBRClientDetails *details;
@end
@interface KBRSetValueRequestParams : KBRRequestParams
@property NSString *path;
@property KBRConfigValue *value;
@end
@interface KBRClearValueRequestParams : KBRRequestParams
@property NSString *path;
@end
@interface KBRGetValueRequestParams : KBRRequestParams
@property NSString *path;
@end
@interface KBRWaitForClientRequestParams : KBRRequestParams
@property KBRClientType clientType;
@property double timeout;
@end
@interface KBRSignED25519RequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *msg;
@property NSString *reason;
@end
@interface KBRSignED25519ForKBFSRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *msg;
@property NSString *reason;
@end
@interface KBRSignToStringRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *msg;
@property NSString *reason;
@end
@interface KBRUnboxBytes32RequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *encryptedBytes32;
@property NSData *nonce;
@property NSData *peersPublicKey;
@property NSString *reason;
@end
@interface KBRUnboxBytes32AnyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *bundles;
@property NSString *reason;
@property BOOL promptPaper;
@end
@interface KBRRegisterAddressRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *address;
@property BOOL force;
@property NSString *wantedFamily;
@end
@interface KBRStopRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRExitCode exitCode;
@end
@interface KBRLogRotateRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRReloadRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDbNukeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRAppExitRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFirstStepRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger val;
@end
@interface KBRSecondStepRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger val;
@end
@interface KBRIncrementRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger val;
@end
@interface KBRDeviceListRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDeviceHistoryListRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDeviceAddRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRCheckDeviceNameFormatRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@end
@interface KBRCheckDeviceNameForUserRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property NSString *devicename;
@end
@interface KBRFavoriteAddRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRFolder *folder;
@end
@interface KBRFavoriteIgnoreRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRFolder *folder;
@end
@interface KBRGetFavoritesRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRListRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *path;
@end
@interface KBRWantToAddGPGKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRConfirmDuplicateKeyChosenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRSelectKeyAndPushOptionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *keys;
@end
@interface KBRSelectKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *keys;
@end
@interface KBRSignRequestParams : KBRRequestParams
@property NSData *msg;
@property NSData *fingerprint;
@end
@interface KBRResolveRequestParams : KBRRequestParams
@property NSString *assertion;
@end
@interface KBRResolve2RequestParams : KBRRequestParams
@property NSString *assertion;
@end
@interface KBRIdentifyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *userAssertion;
@property BOOL forceRemoteCheck;
@property BOOL useDelegateUI;
@property KBRIdentifyReason *reason;
@property KBRClientType source;
@end
@interface KBRIdentify2RequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@property NSString *userAssertion;
@property KBRIdentifyReason *reason;
@property BOOL useDelegateUI;
@property BOOL alwaysBlock;
@property BOOL noErrorOnTrackFailure;
@property BOOL forceRemoteCheck;
@property BOOL needProofSet;
@property BOOL allowEmptySelfID;
@property BOOL noSkipSelf;
@property BOOL canSuppressUI;
@property BOOL chatGUIMode;
@property BOOL forceDisplay;
@end
@interface KBRFSEventRequestParams : KBRRequestParams
@property KBRFSNotification *event;
@end
@interface KBRFSEditListRequestParams : KBRRequestParams
@property NSArray *edits;
@property NSInteger requestID;
@end
@interface KBRFSSyncStatusRequestParams : KBRRequestParams
@property KBRFSSyncStatus *status;
@property NSInteger requestID;
@end
@interface KBRFSSyncEventRequestParams : KBRRequestParams
@property KBRFSPathSyncStatus *event;
@end
@interface KBRSetCurrentMountDirRequestParams : KBRRequestParams
@property NSString *dir;
@end
@interface KBRHelloRequestParams : KBRRequestParams
@property NSString *uid;
@property NSString *token;
@property NSString *csrf;
@property KBRPassphraseStream *pps;
@property NSString *sigBody;
@end
@interface KBRDidCounterSignRequestParams : KBRRequestParams
@property NSData *sig;
@end
@interface KBRHello2RequestParams : KBRRequestParams
@property NSString *uid;
@property NSString *token;
@property NSString *csrf;
@property NSString *sigBody;
@end
@interface KBRDidCounterSign2RequestParams : KBRRequestParams
@property NSData *sig;
@property NSString *ppsEncrypted;
@end
@interface KBRRegisterLoggerRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@property KBRLogLevel level;
@end
@interface KBRLogRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRLogLevel level;
@property KBRText *text;
@end
@interface KBRGetConfiguredAccountsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRLoginRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *deviceType;
@property NSString *usernameOrEmail;
@property KBRClientType clientType;
@end
@interface KBRClearStoredSecretRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRLogoutRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDeprovisionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property BOOL doRevoke;
@end
@interface KBRRecoverAccountFromEmailAddressRequestParams : KBRRequestParams
@property NSString *email;
@end
@interface KBRPaperKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRPaperKeySubmitRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *paperPhrase;
@end
@interface KBRUnlockRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRUnlockWithPassphraseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *passphrase;
@end
@interface KBRPgpProvisionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property NSString *passphrase;
@property NSString *deviceName;
@end
@interface KBRAccountDeleteRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRGetEmailOrUsernameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRPromptRevokePaperKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRDevice *device;
@property NSInteger index;
@end
@interface KBRDisplayPaperKeyPhraseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *phrase;
@end
@interface KBRDisplayPrimaryPaperKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *phrase;
@end
@interface KBRAuthenticateRequestParams : KBRRequestParams
@property NSString *signature;
@end
@interface KBRPutMetadataRequestParams : KBRRequestParams
@property KBRMDBlock *mdBlock;
@property KBRKeyBundle *readerKeyBundle;
@property KBRKeyBundle *writerKeyBundle;
@property NSDictionary *logTags;
@end
@interface KBRGetMetadataRequestParams : KBRRequestParams
@property NSString *folderID;
@property NSData *folderHandle;
@property NSString *branchID;
@property BOOL unmerged;
@property int64_t startRevision;
@property int64_t stopRevision;
@property NSDictionary *logTags;
@end
@interface KBRRegisterForUpdatesRequestParams : KBRRequestParams
@property NSString *folderID;
@property int64_t currRevision;
@property NSDictionary *logTags;
@end
@interface KBRPruneBranchRequestParams : KBRRequestParams
@property NSString *folderID;
@property NSString *branchID;
@property NSDictionary *logTags;
@end
@interface KBRPutKeysRequestParams : KBRRequestParams
@property NSArray *keyHalves;
@property NSDictionary *logTags;
@end
@interface KBRGetKeyRequestParams : KBRRequestParams
@property NSData *keyHalfID;
@property NSString *deviceKID;
@property NSDictionary *logTags;
@end
@interface KBRDeleteKeyRequestParams : KBRRequestParams
@property NSString *uid;
@property NSString *deviceKID;
@property NSData *keyHalfID;
@property NSDictionary *logTags;
@end
@interface KBRTruncateLockRequestParams : KBRRequestParams
@property NSString *folderID;
@end
@interface KBRTruncateUnlockRequestParams : KBRRequestParams
@property NSString *folderID;
@end
@interface KBRGetFolderHandleRequestParams : KBRRequestParams
@property NSString *folderID;
@property NSString *signature;
@property NSString *challenge;
@end
@interface KBRGetFoldersForRekeyRequestParams : KBRRequestParams
@property NSString *deviceKID;
@end
@interface KBRGetLatestFolderHandleRequestParams : KBRRequestParams
@property NSString *folderID;
@end
@interface KBRGetKeyBundlesRequestParams : KBRRequestParams
@property NSString *folderID;
@property NSString *writerBundleID;
@property NSString *readerBundleID;
@end
@interface KBRGetMerkleRootRequestParams : KBRRequestParams
@property KBRMerkleTreeID treeID;
@property int64_t seqNo;
@end
@interface KBRGetMerkleRootLatestRequestParams : KBRRequestParams
@property KBRMerkleTreeID treeID;
@end
@interface KBRGetMerkleRootSinceRequestParams : KBRRequestParams
@property KBRMerkleTreeID treeID;
@property int64_t when;
@end
@interface KBRGetMerkleNodeRequestParams : KBRRequestParams
@property NSString *hash;
@end
@interface KBRMetadataUpdateRequestParams : KBRRequestParams
@property NSString *folderID;
@property int64_t revision;
@end
@interface KBRFolderNeedsRekeyRequestParams : KBRRequestParams
@property NSString *folderID;
@property int64_t revision;
@end
@interface KBRBadgeStateRequestParams : KBRRequestParams
@property KBRBadgeState *badgeState;
@end
@interface KBRSetNotificationsRequestParams : KBRRequestParams
@property KBRNotificationChannels *channels;
@end
@interface KBRFavoritesChangedRequestParams : KBRRequestParams
@property NSString *uid;
@end
@interface KBRFSActivityRequestParams : KBRRequestParams
@property KBRFSNotification *notification;
@end
@interface KBRFSSyncActivityRequestParams : KBRRequestParams
@property KBRFSPathSyncStatus *status;
@end
@interface KBRFSEditListResponseRequestParams : KBRRequestParams
@property NSArray *edits;
@property NSInteger requestID;
@end
@interface KBRFSSyncStatusResponseRequestParams : KBRRequestParams
@property KBRFSSyncStatus *status;
@property NSInteger requestID;
@end
@interface KBRFSEditListRequestRequestParams : KBRRequestParams
@property KBRFSEditListRequest *req;
@end
@interface KBRFSSyncStatusRequestRequestParams : KBRRequestParams
@property KBRFSSyncStatusRequest *req;
@end
@interface KBRKeyfamilyChangedRequestParams : KBRRequestParams
@property NSString *uid;
@end
@interface KBRPaperKeyCachedRequestParams : KBRRequestParams
@property NSString *uid;
@property NSString *encKID;
@property NSString *sigKID;
@end
@interface KBRLoggedInRequestParams : KBRRequestParams
@property NSString *username;
@end
@interface KBRClientOutOfDateRequestParams : KBRRequestParams
@property NSString *upgradeTo;
@property NSString *upgradeURI;
@property NSString *upgradeMsg;
@end
@interface KBRTrackingChangedRequestParams : KBRRequestParams
@property NSString *uid;
@property NSString *username;
@end
@interface KBRUserChangedRequestParams : KBRRequestParams
@property NSString *uid;
@end
@interface KBRPaperProvisionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property NSString *deviceName;
@property NSString *paperKey;
@end
@interface KBRPgpSignRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRPGPSignOptions *opts;
@end
@interface KBRPgpPullRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *userAsserts;
@end
@interface KBRPgpEncryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRPGPEncryptOptions *opts;
@end
@interface KBRPgpDecryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRPGPDecryptOptions *opts;
@end
@interface KBRPgpVerifyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRPGPVerifyOptions *opts;
@end
@interface KBRPgpImportRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *key;
@property BOOL pushSecret;
@end
@interface KBRPgpExportRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRPGPQuery *options;
@end
@interface KBRPgpExportByFingerprintRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRPGPQuery *options;
@end
@interface KBRPgpExportByKIDRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRPGPQuery *options;
@end
@interface KBRPgpKeyGenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSInteger primaryBits;
@property NSInteger subkeyBits;
@property KBRPGPCreateUids *createUids;
@property BOOL allowMulti;
@property BOOL doExport;
@property BOOL pushSecret;
@end
@interface KBRPgpKeyGenDefaultRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRPGPCreateUids *createUids;
@end
@interface KBRPgpDeletePrimaryRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRPgpSelectRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *fingerprintQuery;
@property BOOL allowMulti;
@property BOOL skipImport;
@property BOOL onlyImport;
@end
@interface KBRPgpUpdateRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property BOOL all;
@property NSArray *fingerprints;
@end
@interface KBRPgpPurgeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property BOOL doPurge;
@end
@interface KBRPgpStorageDismissRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBROutputSignatureSuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *fingerprint;
@property NSString *username;
@property int64_t signedAt;
@end
@interface KBROutputSignatureSuccessNonKeybaseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *keyID;
@property int64_t signedAt;
@end
@interface KBRKeyGeneratedRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *kid;
@property KBRKeyInfo *key;
@end
@interface KBRShouldPushPrivateRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFinishedRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRStartProofRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *service;
@property NSString *username;
@property BOOL force;
@property BOOL promptPosted;
@property BOOL automatic;
@end
@interface KBRCheckProofRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *sigID;
@end
@interface KBRPromptOverwriteRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *account;
@property KBRPromptOverwriteType typ;
@end
@interface KBRPromptUsernameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *prompt;
@property KBRStatus *prevError;
@end
@interface KBROutputPrechecksRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@end
@interface KBRPreProofWarningRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@end
@interface KBROutputInstructionsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *instructions;
@property NSString *proof;
@end
@interface KBROkToCheckRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@property NSInteger attempt;
@end
@interface KBRDisplayRecheckWarningRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@end
@interface KBRChooseProvisioningMethodRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property BOOL gpgOption;
@end
@interface KBRChooseGPGMethodRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *keys;
@end
@interface KBRSwitchToGPGSignOKRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRGPGKey *key;
@property NSString *importError;
@end
@interface KBRChooseDeviceRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *devices;
@end
@interface KBRChooseDeviceTypeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRChooseType kind;
@end
@interface KBRDisplayAndPromptSecretRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSData *secret;
@property NSString *phrase;
@property KBRDeviceType otherDeviceType;
@end
@interface KBRDisplaySecretExchangedRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRPromptNewDeviceNameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *existingDevices;
@property NSString *errorMessage;
@end
@interface KBRProvisioneeSuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@property NSString *deviceName;
@end
@interface KBRProvisionerSuccessRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *deviceName;
@property NSString *deviceType;
@end
@interface KBRVerifySessionRequestParams : KBRRequestParams
@property NSString *session;
@end
@interface KBRReachabilityChangedRequestParams : KBRRequestParams
@property KBRReachability *reachability;
@end
@interface KBRShowPendingRekeyStatusRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRGetPendingRekeyStatusRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRDebugShowRekeyStatusRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRRekeyStatusFinishRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRRekeySyncRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property BOOL force;
@end
@interface KBRGetRevokeWarningRequestParams : KBRRequestParams
@property NSInteger session;
@property NSString *actingDevice;
@property NSString *targetDevice;
@end
@interface KBRRefreshRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRProblemSetDevices *problemSetDevices;
@end
@interface KBRRekeySendEventRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRRekeyEvent *event;
@end
@interface KBRRevokeKeyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *keyID;
@end
@interface KBRRevokeDeviceRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *deviceID;
@property BOOL force;
@end
@interface KBRRevokeSigsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *sigIDQueries;
@end
@interface KBRSaltpackEncryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltpackEncryptOptions *opts;
@end
@interface KBRSaltpackDecryptRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltpackDecryptOptions *opts;
@end
@interface KBRSaltpackSignRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltpackSignOptions *opts;
@end
@interface KBRSaltpackVerifyRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *source;
@property KBRStream *sink;
@property KBRSaltpackVerifyOptions *opts;
@end
@interface KBRScanProofsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *infile;
@property NSString *indices;
@property NSString *sigid;
@property NSInteger ratelimit;
@property NSString *cachefile;
@property NSString *ignorefile;
@end
@interface KBRGetPassphraseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRGUIEntryArg *pinentry;
@property KBRSecretEntryArg *terminal;
@end
@interface KBRGetSecretKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRCurrentSessionRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRCheckUsernameAvailableRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRSignupRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *email;
@property NSString *inviteCode;
@property NSString *passphrase;
@property NSString *username;
@property NSString *deviceName;
@property KBRDeviceType deviceType;
@property BOOL storeSecret;
@property BOOL skipMail;
@property BOOL genPGPBatch;
@end
@interface KBRInviteRequestRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *email;
@property NSString *fullname;
@property NSString *notes;
@end
@interface KBRCheckInvitationCodeRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *invitationCode;
@end
@interface KBRSigListRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRSigListArgs *arg;
@end
@interface KBRSigListJSONRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRSigListArgs *arg;
@end
@interface KBRCloseRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *s;
@end
@interface KBRReadRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *s;
@property NSInteger sz;
@end
@interface KBRResetRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *s;
@end
@interface KBRWriteRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRStream *s;
@property NSData *buf;
@end
@interface KBRTestRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@end
@interface KBRTestCallbackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *name;
@end
@interface KBRPanicRequestParams : KBRRequestParams
@property NSString *message;
@end
@interface KBRCryptKeysRequestParams : KBRRequestParams
@property KBRTLFQuery *query;
@end
@interface KBRPublicCanonicalTLFNameAndIDRequestParams : KBRRequestParams
@property KBRTLFQuery *query;
@end
@interface KBRCompleteAndCanonicalizePrivateTlfNameRequestParams : KBRRequestParams
@property KBRTLFQuery *query;
@end
@interface KBRGetTLFCryptKeysRequestParams : KBRRequestParams
@property KBRTLFQuery *query;
@end
@interface KBRGetPublicCanonicalTLFNameAndIDRequestParams : KBRRequestParams
@property KBRTLFQuery *query;
@end
@interface KBRTrackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *userAssertion;
@property KBRTrackOptions *options;
@property BOOL forceRemoteCheck;
@end
@interface KBRTrackWithTokenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *trackToken;
@property KBRTrackOptions *options;
@end
@interface KBRDismissWithTokenRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *trackToken;
@end
@interface KBRUntrackRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRCheckTrackingRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRFakeTrackingChangedRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRPromptYesNoRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property KBRText *text;
@property KBRPromptDefault promptDefault;
@end
@interface KBRListTrackersRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRListTrackersByNameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRListTrackersSelfRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRLoadUncheckedUserSummariesRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSArray *uids;
@end
@interface KBRLoadUserRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRLoadUserByNameRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *username;
@end
@interface KBRLoadUserPlusKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRLoadPublicKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRLoadMyPublicKeysRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRLoadMySettingsRequestParams : KBRRequestParams
@property NSInteger sessionID;
@end
@interface KBRListTrackingRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *filter;
@property NSString *assertion;
@end
@interface KBRListTrackingJSONRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *filter;
@property BOOL verbose;
@property NSString *assertion;
@end
@interface KBRSearchRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *query;
@end
@interface KBRLoadAllPublicKeysUnverifiedRequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *uid;
@end
@interface KBRListTrackers2RequestParams : KBRRequestParams
@property NSInteger sessionID;
@property NSString *assertion;
@property BOOL reverse;
@end@interface KBRCommonRequest : KBRRequest

@end

@interface KBRProveCommonRequest : KBRRequest

@end

@interface KBRIdentifyCommonRequest : KBRRequest

@end

@interface KBRIdentifyUiRequest : KBRRequest

- (void)displayTLFCreateWithInvite:(KBRDisplayTLFCreateWithInviteRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayTLFCreateWithInviteWithFolderName:(NSString *)folderName isPrivate:(BOOL)isPrivate assertion:(NSString *)assertion socialAssertion:(KBRSocialAssertion *)socialAssertion inviteLink:(NSString *)inviteLink throttled:(BOOL)throttled completion:(void (^)(NSError *error))completion;

- (void)delegateIdentifyUI:(void (^)(NSError *error, NSInteger n))completion;

- (void)start:(KBRStartRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)startWithUsername:(NSString *)username reason:(KBRIdentifyReason *)reason forceDisplay:(BOOL)forceDisplay completion:(void (^)(NSError *error))completion;

- (void)displayKey:(KBRDisplayKeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayKeyWithKey:(KBRIdentifyKey *)key completion:(void (^)(NSError *error))completion;

- (void)reportLastTrack:(KBRReportLastTrackRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)reportLastTrackWithTrack:(KBRTrackSummary *)track completion:(void (^)(NSError *error))completion;

- (void)launchNetworkChecks:(KBRLaunchNetworkChecksRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)launchNetworkChecksWithIdentity:(KBRIdentity *)identity user:(KBRUser *)user completion:(void (^)(NSError *error))completion;

- (void)displayTrackStatement:(KBRDisplayTrackStatementRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayTrackStatementWithStmt:(NSString *)stmt completion:(void (^)(NSError *error))completion;

- (void)finishWebProofCheck:(KBRFinishWebProofCheckRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)finishWebProofCheckWithRp:(KBRRemoteProof *)rp lcr:(KBRLinkCheckResult *)lcr completion:(void (^)(NSError *error))completion;

- (void)finishSocialProofCheck:(KBRFinishSocialProofCheckRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)finishSocialProofCheckWithRp:(KBRRemoteProof *)rp lcr:(KBRLinkCheckResult *)lcr completion:(void (^)(NSError *error))completion;

- (void)displayCryptocurrency:(KBRDisplayCryptocurrencyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayCryptocurrencyWithC:(KBRCryptocurrency *)c completion:(void (^)(NSError *error))completion;

- (void)reportTrackToken:(KBRReportTrackTokenRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)reportTrackTokenWithTrackToken:(NSString *)trackToken completion:(void (^)(NSError *error))completion;

- (void)displayUserCard:(KBRDisplayUserCardRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayUserCardWithCard:(KBRUserCard *)card completion:(void (^)(NSError *error))completion;

- (void)confirm:(KBRConfirmRequestParams *)params completion:(void (^)(NSError *error, KBRConfirmResult *confirmResult))completion;

- (void)confirmWithOutcome:(KBRIdentifyOutcome *)outcome completion:(void (^)(NSError *error, KBRConfirmResult *confirmResult))completion;

- (void)cancel:(void (^)(NSError *error))completion;

- (void)finish:(void (^)(NSError *error))completion;

- (void)dismiss:(KBRDismissRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)dismissWithUsername:(NSString *)username reason:(KBRDismissReason *)reason completion:(void (^)(NSError *error))completion;

@end

@interface KBRSaltpackUiRequest : KBRRequest

- (void)saltpackPromptForDecrypt:(KBRSaltpackPromptForDecryptRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltpackPromptForDecryptWithSender:(KBRSaltpackSender *)sender usedDelegateUI:(BOOL)usedDelegateUI completion:(void (^)(NSError *error))completion;

- (void)saltpackVerifySuccess:(KBRSaltpackVerifySuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltpackVerifySuccessWithSigningKID:(NSString *)signingKID sender:(KBRSaltpackSender *)sender completion:(void (^)(NSError *error))completion;

@end

@interface KBRAccountRequest : KBRRequest

/*!
 Change the passphrase from old to new. If old isn't set, and force is false,
 then prompt at the UI for it. If old isn't set and force is true, then we'll
 try to force a passphrase change.
 */
- (void)passphraseChange:(KBRPassphraseChangeRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)passphraseChangeWithOldPassphrase:(NSString *)oldPassphrase passphrase:(NSString *)passphrase force:(BOOL)force completion:(void (^)(NSError *error))completion;

- (void)passphrasePrompt:(KBRPassphrasePromptRequestParams *)params completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

- (void)passphrasePromptWithGuiArg:(KBRGUIEntryArg *)guiArg completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

/*!
 * change email to the new given email by signing a statement.
 */
- (void)emailChange:(KBREmailChangeRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)emailChangeWithEmailNew:(NSString *)emailNew completion:(void (^)(NSError *error))completion;

/*!
 * Whether the logged-in user has uploaded private keys
 * Will error if not logged in.
 */
- (void)hasServerKeys:(void (^)(NSError *error, KBRHasServerKeysRes *hasServerKeysRes))completion;

@end

@interface KBRApiserverRequest : KBRRequest

- (void)get:(KBRGetRequestParams *)params completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion;

- (void)getWithEndpoint:(NSString *)endpoint args:(NSArray *)args httpStatus:(NSArray *)httpStatus appStatusCode:(NSArray *)appStatusCode completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion;

- (void)post:(KBRPostRequestParams *)params completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion;

- (void)postWithEndpoint:(NSString *)endpoint args:(NSArray *)args httpStatus:(NSArray *)httpStatus appStatusCode:(NSArray *)appStatusCode completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion;

- (void)postJSON:(KBRPostJSONRequestParams *)params completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion;

- (void)postJSONWithEndpoint:(NSString *)endpoint args:(NSArray *)args JSONPayload:(NSArray *)JSONPayload httpStatus:(NSArray *)httpStatus appStatusCode:(NSArray *)appStatusCode completion:(void (^)(NSError *error, KBRAPIRes *aPIRes))completion;

@end

@interface KBRBackendCommonRequest : KBRRequest

@end

@interface KBRBlockRequest : KBRRequest

- (void)getSessionChallenge:(void (^)(NSError *error, KBRChallengeInfo *challengeInfo))completion;

- (void)authenticateSession:(KBRAuthenticateSessionRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)authenticateSessionWithSignature:(NSString *)signature completion:(void (^)(NSError *error))completion;

- (void)putBlock:(KBRPutBlockRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)putBlockWithBid:(KBRBlockIdCombo *)bid folder:(NSString *)folder blockKey:(NSString *)blockKey buf:(NSData *)buf completion:(void (^)(NSError *error))completion;

- (void)getBlock:(KBRGetBlockRequestParams *)params completion:(void (^)(NSError *error, KBRGetBlockRes *getBlockRes))completion;

- (void)getBlockWithBid:(KBRBlockIdCombo *)bid folder:(NSString *)folder completion:(void (^)(NSError *error, KBRGetBlockRes *getBlockRes))completion;

- (void)addReference:(KBRAddReferenceRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)addReferenceWithFolder:(NSString *)folder ref:(KBRBlockReference *)ref completion:(void (^)(NSError *error))completion;

- (void)delReference:(KBRDelReferenceRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)delReferenceWithFolder:(NSString *)folder ref:(KBRBlockReference *)ref completion:(void (^)(NSError *error))completion;

- (void)archiveReference:(KBRArchiveReferenceRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)archiveReferenceWithFolder:(NSString *)folder refs:(NSArray *)refs completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)delReferenceWithCount:(KBRDelReferenceWithCountRequestParams *)params completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion;

- (void)delReferenceWithCountWithFolder:(NSString *)folder refs:(NSArray *)refs completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion;

- (void)archiveReferenceWithCount:(KBRArchiveReferenceWithCountRequestParams *)params completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion;

- (void)archiveReferenceWithCountWithFolder:(NSString *)folder refs:(NSArray *)refs completion:(void (^)(NSError *error, KBRDowngradeReferenceRes *downgradeReferenceRes))completion;

- (void)getUserQuotaInfo:(void (^)(NSError *error, NSData *bytes))completion;

@end

@interface KBRBTCRequest : KBRRequest

- (void)registerBTC:(KBRRegisterBTCRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)registerBTCWithAddress:(NSString *)address force:(BOOL)force completion:(void (^)(NSError *error))completion;

@end

@interface KBRConfigRequest : KBRRequest

- (void)getCurrentStatus:(void (^)(NSError *error, KBRGetCurrentStatusRes *getCurrentStatusRes))completion;

- (void)getExtendedStatus:(void (^)(NSError *error, KBRExtendedStatus *extendedStatus))completion;

- (void)getConfig:(void (^)(NSError *error, KBRConfig *config))completion;

/*!
 Change user config.
 For example, to update primary picture source:
 key=picture.source, value=twitter (or github)
 */
- (void)setUserConfig:(KBRSetUserConfigRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setUserConfigWithUsername:(NSString *)username key:(NSString *)key value:(NSString *)value completion:(void (^)(NSError *error))completion;

- (void)setPath:(KBRSetPathRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setPathWithPath:(NSString *)path completion:(void (^)(NSError *error))completion;

- (void)helloIAm:(KBRHelloIAmRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)helloIAmWithDetails:(KBRClientDetails *)details completion:(void (^)(NSError *error))completion;

- (void)setValue:(KBRSetValueRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setValueWithPath:(NSString *)path value:(KBRConfigValue *)value completion:(void (^)(NSError *error))completion;

- (void)clearValue:(KBRClearValueRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)clearValueWithPath:(NSString *)path completion:(void (^)(NSError *error))completion;

- (void)getValue:(KBRGetValueRequestParams *)params completion:(void (^)(NSError *error, KBRConfigValue *configValue))completion;

- (void)getValueWithPath:(NSString *)path completion:(void (^)(NSError *error, KBRConfigValue *configValue))completion;

/*!
 Check whether the API server has told us we're out of date.
 */
- (void)checkAPIServerOutOfDateWarning:(void (^)(NSError *error, KBROutOfDateInfo *outOfDateInfo))completion;

/*!
 Wait for client type to connect to service.
 */
- (void)waitForClient:(KBRWaitForClientRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)waitForClientWithClientType:(KBRClientType)clientType timeout:(double)timeout completion:(void (^)(NSError *error, BOOL b))completion;

@end

@interface KBRConstantsRequest : KBRRequest

@end

@interface KBRCryptoRequest : KBRRequest

/*!
 Sign the given message (which should be small) using the device's private
 signing ED25519 key, and return the signature as well as the corresponding
 public key that can be used to verify the signature. The 'reason' parameter
 is used as part of the SecretEntryArg object passed into
 secretUi.getSecret().
 */
- (void)signED25519:(KBRSignED25519RequestParams *)params completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion;

- (void)signED25519WithMsg:(NSData *)msg reason:(NSString *)reason completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion;

/*!
 Same as the above except a KBFS-specific prefix is added to the payload to be signed.
 */
- (void)signED25519ForKBFS:(KBRSignED25519ForKBFSRequestParams *)params completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion;

- (void)signED25519ForKBFSWithMsg:(NSData *)msg reason:(NSString *)reason completion:(void (^)(NSError *error, KBRED25519SignatureInfo *eD25519SignatureInfo))completion;

/*!
 Same as the above except the full marsheled and encoded NaclSigInfo.
 */
- (void)signToString:(KBRSignToStringRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)signToStringWithMsg:(NSData *)msg reason:(NSString *)reason completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 Decrypt exactly 32 bytes using nacl/box with the given nonce, the given
 peer's public key, and the device's private encryption key, and return the
 decrypted data. The 'reason' parameter is used as part of the
 SecretEntryArg object passed into secretUi.getSecret().
 */
- (void)unboxBytes32:(KBRUnboxBytes32RequestParams *)params completion:(void (^)(NSError *error, NSData *bytes32))completion;

- (void)unboxBytes32WithEncryptedBytes32:(NSData *)encryptedBytes32 nonce:(NSData *)nonce peersPublicKey:(NSData *)peersPublicKey reason:(NSString *)reason completion:(void (^)(NSError *error, NSData *bytes32))completion;

- (void)unboxBytes32Any:(KBRUnboxBytes32AnyRequestParams *)params completion:(void (^)(NSError *error, KBRUnboxAnyRes *unboxAnyRes))completion;

- (void)unboxBytes32AnyWithBundles:(NSArray *)bundles reason:(NSString *)reason promptPaper:(BOOL)promptPaper completion:(void (^)(NSError *error, KBRUnboxAnyRes *unboxAnyRes))completion;

@end

@interface KBRCryptocurrencyRequest : KBRRequest

- (void)registerAddress:(KBRRegisterAddressRequestParams *)params completion:(void (^)(NSError *error, KBRRegisterAddressRes *registerAddressRes))completion;

- (void)registerAddressWithAddress:(NSString *)address force:(BOOL)force wantedFamily:(NSString *)wantedFamily completion:(void (^)(NSError *error, KBRRegisterAddressRes *registerAddressRes))completion;

@end

@interface KBRCtlRequest : KBRRequest

- (void)stop:(KBRStopRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)stopWithExitCode:(KBRExitCode)exitCode completion:(void (^)(NSError *error))completion;

- (void)logRotate:(void (^)(NSError *error))completion;

- (void)reload:(void (^)(NSError *error))completion;

- (void)dbNuke:(void (^)(NSError *error))completion;

- (void)appExit:(void (^)(NSError *error))completion;

@end

@interface KBRDebuggingRequest : KBRRequest

- (void)firstStep:(KBRFirstStepRequestParams *)params completion:(void (^)(NSError *error, KBRFirstStepResult *firstStepResult))completion;

- (void)firstStepWithVal:(NSInteger)val completion:(void (^)(NSError *error, KBRFirstStepResult *firstStepResult))completion;

- (void)secondStep:(KBRSecondStepRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)secondStepWithVal:(NSInteger)val completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)increment:(KBRIncrementRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)incrementWithVal:(NSInteger)val completion:(void (^)(NSError *error, NSInteger n))completion;

@end

@interface KBRDelegateUiCtlRequest : KBRRequest

- (void)registerIdentifyUI:(void (^)(NSError *error))completion;

- (void)registerSecretUI:(void (^)(NSError *error))completion;

- (void)registerUpdateUI:(void (^)(NSError *error))completion;

- (void)registerRekeyUI:(void (^)(NSError *error))completion;

- (void)registerGregorFirehose:(void (^)(NSError *error))completion;

@end

@interface KBRDeviceRequest : KBRRequest

/*!
 List devices for the user.
 */
- (void)deviceList:(void (^)(NSError *error, NSArray *items))completion;

/*!
 List all devices with detailed history and status information.
 */
- (void)deviceHistoryList:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Starts the process of adding a new device using an existing
 device. It is called on the existing device.
 This is for kex2.
 */
- (void)deviceAdd:(void (^)(NSError *error))completion;

/*!
 Checks the device name format.
 */
- (void)checkDeviceNameFormat:(KBRCheckDeviceNameFormatRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)checkDeviceNameFormatWithName:(NSString *)name completion:(void (^)(NSError *error, BOOL b))completion;

/*!
 Checks a given device against all of user's past devices,
 including those that predate a reset. It will also check a device name
 for proper formatting. Return null error on success, and a non-null
 error otherwise.
 */
- (void)checkDeviceNameForUser:(KBRCheckDeviceNameForUserRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)checkDeviceNameForUserWithUsername:(NSString *)username devicename:(NSString *)devicename completion:(void (^)(NSError *error))completion;

@end

@interface KBRFavoriteRequest : KBRRequest

/*!
 Adds a folder to a user's list of favorite folders.
 */
- (void)favoriteAdd:(KBRFavoriteAddRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)favoriteAddWithFolder:(KBRFolder *)folder completion:(void (^)(NSError *error))completion;

/*!
 Removes a folder from a user's list of favorite folders.
 */
- (void)favoriteIgnore:(KBRFavoriteIgnoreRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)favoriteIgnoreWithFolder:(KBRFolder *)folder completion:(void (^)(NSError *error))completion;

/*!
 Returns all of a user's favorite folders.
 */
- (void)getFavorites:(void (^)(NSError *error, KBRFavoritesResult *favoritesResult))completion;

@end

@interface KBRFsRequest : KBRRequest

/*!
 List files in a path. Implemented by KBFS service.
 */
- (void)list:(KBRListRequestParams *)params completion:(void (^)(NSError *error, KBRListResult *listResult))completion;

- (void)listWithPath:(NSString *)path completion:(void (^)(NSError *error, KBRListResult *listResult))completion;

@end

@interface KBRGpgCommonRequest : KBRRequest

@end

@interface KBRGpgUiRequest : KBRRequest

- (void)wantToAddGPGKey:(void (^)(NSError *error, BOOL b))completion;

- (void)confirmDuplicateKeyChosen:(void (^)(NSError *error, BOOL b))completion;

- (void)selectKeyAndPushOption:(KBRSelectKeyAndPushOptionRequestParams *)params completion:(void (^)(NSError *error, KBRSelectKeyRes *selectKeyRes))completion;

- (void)selectKeyAndPushOptionWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, KBRSelectKeyRes *selectKeyRes))completion;

- (void)selectKey:(KBRSelectKeyRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)selectKeyWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, NSString *str))completion;

- (void)sign:(KBRSignRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)signWithMsg:(NSData *)msg fingerprint:(NSData *)fingerprint completion:(void (^)(NSError *error, NSString *str))completion;

- (void)getTTY:(void (^)(NSError *error, NSString *str))completion;

@end

@interface KBRIdentifyRequest : KBRRequest

/*!
 Resolve an assertion to a UID. On failure, resolves to an empty UID and returns
 an error.
 */
- (void)resolve:(KBRResolveRequestParams *)params completion:(void (^)(NSError *error, NSString *uID))completion;

- (void)resolveWithAssertion:(NSString *)assertion completion:(void (^)(NSError *error, NSString *uID))completion;

/*!
 Resolve an assertion to a (UID,username). On failure, returns an error.
 */
- (void)resolve2:(KBRResolve2RequestParams *)params completion:(void (^)(NSError *error, KBRUser *user))completion;

- (void)resolve2WithAssertion:(NSString *)assertion completion:(void (^)(NSError *error, KBRUser *user))completion;

/*!
 DEPRECATED: use identify2

 Identify a user from a username or assertion (e.g. kbuser, twuser@twitter).
 If forceRemoteCheck is true, we force all remote proofs to be checked (otherwise a cache is used).
 */
- (void)identify:(KBRIdentifyRequestParams *)params completion:(void (^)(NSError *error, KBRIdentifyRes *identifyRes))completion;

- (void)identifyWithUserAssertion:(NSString *)userAssertion forceRemoteCheck:(BOOL)forceRemoteCheck useDelegateUI:(BOOL)useDelegateUI reason:(KBRIdentifyReason *)reason source:(KBRClientType)source completion:(void (^)(NSError *error, KBRIdentifyRes *identifyRes))completion;

- (void)identify2:(KBRIdentify2RequestParams *)params completion:(void (^)(NSError *error, KBRIdentify2Res *identify2Res))completion;

- (void)identify2WithUid:(NSString *)uid userAssertion:(NSString *)userAssertion reason:(KBRIdentifyReason *)reason useDelegateUI:(BOOL)useDelegateUI alwaysBlock:(BOOL)alwaysBlock noErrorOnTrackFailure:(BOOL)noErrorOnTrackFailure forceRemoteCheck:(BOOL)forceRemoteCheck needProofSet:(BOOL)needProofSet allowEmptySelfID:(BOOL)allowEmptySelfID noSkipSelf:(BOOL)noSkipSelf canSuppressUI:(BOOL)canSuppressUI chatGUIMode:(BOOL)chatGUIMode forceDisplay:(BOOL)forceDisplay completion:(void (^)(NSError *error, KBRIdentify2Res *identify2Res))completion;

@end

@interface KBRInstallRequest : KBRRequest

@end

@interface KBRKbfsRequest : KBRRequest

/*!
 Idea is that kbfs would call the function below whenever these actions are
 performed on a file.

 Note that this list/interface is very temporary and highly likely to change
 significantly.

 It is just a starting point to get kbfs notifications through the daemon to
 the clients.
 */
- (void)fSEvent:(KBRFSEventRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSEventWithEvent:(KBRFSNotification *)event completion:(void (^)(NSError *error))completion;

/*!
 kbfs calls this as a response to receiving an FSEditListRequest with a
 given requestID.
 */
- (void)fSEditList:(KBRFSEditListRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSEditListWithEdits:(NSArray *)edits requestID:(NSInteger)requestID completion:(void (^)(NSError *error))completion;

/*!
 FSSyncStatus is called by KBFS as a response to receiving an
 FSSyncStatusRequest with a given requestID.
 */
- (void)fSSyncStatus:(KBRFSSyncStatusRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSSyncStatusWithStatus:(KBRFSSyncStatus *)status requestID:(NSInteger)requestID completion:(void (^)(NSError *error))completion;

/*!
 FSSyncEvent is called by KBFS when the sync status of an individual path
 changes.
 */
- (void)fSSyncEvent:(KBRFSSyncEventRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSSyncEventWithEvent:(KBRFSPathSyncStatus *)event completion:(void (^)(NSError *error))completion;

@end

@interface KBRKbfsCommonRequest : KBRRequest

@end

@interface KBRKbfsMountRequest : KBRRequest

- (void)getCurrentMountDir:(void (^)(NSError *error, NSString *str))completion;

- (void)getAllAvailableMountDirs:(void (^)(NSError *error, NSArray *items))completion;

- (void)setCurrentMountDir:(KBRSetCurrentMountDirRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setCurrentMountDirWithDir:(NSString *)dir completion:(void (^)(NSError *error))completion;

@end

@interface KBRKex2ProvisioneeRequest : KBRRequest

- (void)hello:(KBRHelloRequestParams *)params completion:(void (^)(NSError *error, NSString *helloRes))completion;

- (void)helloWithUid:(NSString *)uid token:(NSString *)token csrf:(NSString *)csrf pps:(KBRPassphraseStream *)pps sigBody:(NSString *)sigBody completion:(void (^)(NSError *error, NSString *helloRes))completion;

- (void)didCounterSign:(KBRDidCounterSignRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)didCounterSignWithSig:(NSData *)sig completion:(void (^)(NSError *error))completion;

@end

@interface KBRKex2Provisionee2Request : KBRRequest

- (void)hello2:(KBRHello2RequestParams *)params completion:(void (^)(NSError *error, KBRHello2Res *hello2Res))completion;

- (void)hello2WithUid:(NSString *)uid token:(NSString *)token csrf:(NSString *)csrf sigBody:(NSString *)sigBody completion:(void (^)(NSError *error, KBRHello2Res *hello2Res))completion;

- (void)didCounterSign2:(KBRDidCounterSign2RequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)didCounterSign2WithSig:(NSData *)sig ppsEncrypted:(NSString *)ppsEncrypted completion:(void (^)(NSError *error))completion;

@end

@interface KBRKex2ProvisionerRequest : KBRRequest

- (void)kexStart:(void (^)(NSError *error))completion;

@end

@interface KBRLogRequest : KBRRequest

- (void)registerLogger:(KBRRegisterLoggerRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)registerLoggerWithName:(NSString *)name level:(KBRLogLevel)level completion:(void (^)(NSError *error))completion;

@end

@interface KBRLogUiRequest : KBRRequest

- (void)log:(KBRLogRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)logWithLevel:(KBRLogLevel)level text:(KBRText *)text completion:(void (^)(NSError *error))completion;

@end

@interface KBRLoginRequest : KBRRequest

/*!
 Returns an array of information about accounts configured on the local
 machine. Currently configured accounts are defined as those that have stored
 secrets, but this definition may be expanded in the future.
 */
- (void)getConfiguredAccounts:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Performs login. deviceType should be keybase1.DeviceTypeV2_DESKTOP
 or keybase1.DeviceTypeV2_MOBILE. usernameOrEmail is optional.
 If the current device isn't provisioned, this function will
 provision it.

 Note that if usernameOrEmail is an email address, only provisioning
 will be attempted. If the device is already provisioned, login
 via email address does not work.
 */
- (void)login:(KBRLoginRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)loginWithDeviceType:(NSString *)deviceType usernameOrEmail:(NSString *)usernameOrEmail clientType:(KBRClientType)clientType completion:(void (^)(NSError *error))completion;

/*!
 Removes any existing stored secret for the given username.
 loginWithStoredSecret(_, username) will fail after this is called.
 */
- (void)clearStoredSecret:(KBRClearStoredSecretRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)clearStoredSecretWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)logout:(void (^)(NSError *error))completion;

- (void)deprovision:(KBRDeprovisionRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)deprovisionWithUsername:(NSString *)username doRevoke:(BOOL)doRevoke completion:(void (^)(NSError *error))completion;

- (void)recoverAccountFromEmailAddress:(KBRRecoverAccountFromEmailAddressRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)recoverAccountFromEmailAddressWithEmail:(NSString *)email completion:(void (^)(NSError *error))completion;

/*!
 PaperKey generates paper backup keys for restoring an account.
 It calls login_ui.displayPaperKeyPhrase with the phrase.
 */
- (void)paperKey:(void (^)(NSError *error))completion;

/*!
 paperKeySubmit checks that paperPhrase is a valid paper key
 for the logged in user, caches the keys, and sends a notification.
 */
- (void)paperKeySubmit:(KBRPaperKeySubmitRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)paperKeySubmitWithPaperPhrase:(NSString *)paperPhrase completion:(void (^)(NSError *error))completion;

/*!
 Unlock restores access to local key store by priming passphrase stream cache.
 */
- (void)unlock:(void (^)(NSError *error))completion;

- (void)unlockWithPassphrase:(KBRUnlockWithPassphraseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)unlockWithPassphraseWithPassphrase:(NSString *)passphrase completion:(void (^)(NSError *error))completion;

/*!
 pgpProvision is for devel/testing to provision a device via pgp using CLI
 with no user interaction.
 */
- (void)pgpProvision:(KBRPgpProvisionRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpProvisionWithUsername:(NSString *)username passphrase:(NSString *)passphrase deviceName:(NSString *)deviceName completion:(void (^)(NSError *error))completion;

/*!
 accountDelete is for devel/testing to delete the current user's account.
 */
- (void)accountDelete:(void (^)(NSError *error))completion;

@end

@interface KBRLoginUiRequest : KBRRequest

- (void)getEmailOrUsername:(void (^)(NSError *error, NSString *str))completion;

- (void)promptRevokePaperKeys:(KBRPromptRevokePaperKeysRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptRevokePaperKeysWithDevice:(KBRDevice *)device index:(NSInteger)index completion:(void (^)(NSError *error, BOOL b))completion;

- (void)displayPaperKeyPhrase:(KBRDisplayPaperKeyPhraseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayPaperKeyPhraseWithPhrase:(NSString *)phrase completion:(void (^)(NSError *error))completion;

- (void)displayPrimaryPaperKey:(KBRDisplayPrimaryPaperKeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayPrimaryPaperKeyWithPhrase:(NSString *)phrase completion:(void (^)(NSError *error))completion;

@end

@interface KBRMetadataRequest : KBRRequest

- (void)getChallenge:(void (^)(NSError *error, KBRChallengeInfo *challengeInfo))completion;

- (void)authenticate:(KBRAuthenticateRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)authenticateWithSignature:(NSString *)signature completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)putMetadata:(KBRPutMetadataRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)putMetadataWithMdBlock:(KBRMDBlock *)mdBlock readerKeyBundle:(KBRKeyBundle *)readerKeyBundle writerKeyBundle:(KBRKeyBundle *)writerKeyBundle logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)getMetadata:(KBRGetMetadataRequestParams *)params completion:(void (^)(NSError *error, KBRMetadataResponse *metadataResponse))completion;

- (void)getMetadataWithFolderID:(NSString *)folderID folderHandle:(NSData *)folderHandle branchID:(NSString *)branchID unmerged:(BOOL)unmerged startRevision:(int64_t)startRevision stopRevision:(int64_t)stopRevision logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error, KBRMetadataResponse *metadataResponse))completion;

- (void)registerForUpdates:(KBRRegisterForUpdatesRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)registerForUpdatesWithFolderID:(NSString *)folderID currRevision:(int64_t)currRevision logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)pruneBranch:(KBRPruneBranchRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pruneBranchWithFolderID:(NSString *)folderID branchID:(NSString *)branchID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)putKeys:(KBRPutKeysRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)putKeysWithKeyHalves:(NSArray *)keyHalves logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)getKey:(KBRGetKeyRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getKeyWithKeyHalfID:(NSData *)keyHalfID deviceKID:(NSString *)deviceKID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)deleteKey:(KBRDeleteKeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)deleteKeyWithUid:(NSString *)uid deviceKID:(NSString *)deviceKID keyHalfID:(NSData *)keyHalfID logTags:(NSDictionary *)logTags completion:(void (^)(NSError *error))completion;

- (void)truncateLock:(KBRTruncateLockRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)truncateLockWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, BOOL b))completion;

- (void)truncateUnlock:(KBRTruncateUnlockRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)truncateUnlockWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, BOOL b))completion;

- (void)getFolderHandle:(KBRGetFolderHandleRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getFolderHandleWithFolderID:(NSString *)folderID signature:(NSString *)signature challenge:(NSString *)challenge completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getFoldersForRekey:(KBRGetFoldersForRekeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)getFoldersForRekeyWithDeviceKID:(NSString *)deviceKID completion:(void (^)(NSError *error))completion;

- (void)ping:(void (^)(NSError *error))completion;

- (void)ping2:(void (^)(NSError *error, KBRPingResponse *pingResponse))completion;

- (void)getLatestFolderHandle:(KBRGetLatestFolderHandleRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getLatestFolderHandleWithFolderID:(NSString *)folderID completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getKeyBundles:(KBRGetKeyBundlesRequestParams *)params completion:(void (^)(NSError *error, KBRKeyBundleResponse *keyBundleResponse))completion;

- (void)getKeyBundlesWithFolderID:(NSString *)folderID writerBundleID:(NSString *)writerBundleID readerBundleID:(NSString *)readerBundleID completion:(void (^)(NSError *error, KBRKeyBundleResponse *keyBundleResponse))completion;

- (void)getMerkleRoot:(KBRGetMerkleRootRequestParams *)params completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion;

- (void)getMerkleRootWithTreeID:(KBRMerkleTreeID)treeID seqNo:(int64_t)seqNo completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion;

- (void)getMerkleRootLatest:(KBRGetMerkleRootLatestRequestParams *)params completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion;

- (void)getMerkleRootLatestWithTreeID:(KBRMerkleTreeID)treeID completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion;

- (void)getMerkleRootSince:(KBRGetMerkleRootSinceRequestParams *)params completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion;

- (void)getMerkleRootSinceWithTreeID:(KBRMerkleTreeID)treeID when:(int64_t)when completion:(void (^)(NSError *error, KBRMerkleRoot *merkleRoot))completion;

- (void)getMerkleNode:(KBRGetMerkleNodeRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)getMerkleNodeWithHash:(NSString *)hash completion:(void (^)(NSError *error, NSData *bytes))completion;

@end

@interface KBRMetadataUpdateRequest : KBRRequest

- (void)metadataUpdate:(KBRMetadataUpdateRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)metadataUpdateWithFolderID:(NSString *)folderID revision:(int64_t)revision completion:(void (^)(NSError *error))completion;

- (void)folderNeedsRekey:(KBRFolderNeedsRekeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)folderNeedsRekeyWithFolderID:(NSString *)folderID revision:(int64_t)revision completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyAppRequest : KBRRequest

- (void)exit:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyBadgesRequest : KBRRequest

- (void)badgeState:(KBRBadgeStateRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)badgeStateWithBadgeState:(KBRBadgeState *)badgeState completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyCtlRequest : KBRRequest

- (void)setNotifications:(KBRSetNotificationsRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)setNotificationsWithChannels:(KBRNotificationChannels *)channels completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyFavoritesRequest : KBRRequest

- (void)favoritesChanged:(KBRFavoritesChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)favoritesChangedWithUid:(NSString *)uid completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyFSRequest : KBRRequest

- (void)fSActivity:(KBRFSActivityRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSActivityWithNotification:(KBRFSNotification *)notification completion:(void (^)(NSError *error))completion;

- (void)fSSyncActivity:(KBRFSSyncActivityRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSSyncActivityWithStatus:(KBRFSPathSyncStatus *)status completion:(void (^)(NSError *error))completion;

- (void)fSEditListResponse:(KBRFSEditListResponseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSEditListResponseWithEdits:(NSArray *)edits requestID:(NSInteger)requestID completion:(void (^)(NSError *error))completion;

- (void)fSSyncStatusResponse:(KBRFSSyncStatusResponseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSSyncStatusResponseWithStatus:(KBRFSSyncStatus *)status requestID:(NSInteger)requestID completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyFSRequestRequest : KBRRequest

- (void)fSEditListRequest:(KBRFSEditListRequestRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSEditListRequestWithReq:(KBRFSEditListRequest *)req completion:(void (^)(NSError *error))completion;

- (void)fSSyncStatusRequest:(KBRFSSyncStatusRequestRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fSSyncStatusRequestWithReq:(KBRFSSyncStatusRequest *)req completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyKeyfamilyRequest : KBRRequest

- (void)keyfamilyChanged:(KBRKeyfamilyChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)keyfamilyChangedWithUid:(NSString *)uid completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyPaperKeyRequest : KBRRequest

- (void)paperKeyCached:(KBRPaperKeyCachedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)paperKeyCachedWithUid:(NSString *)uid encKID:(NSString *)encKID sigKID:(NSString *)sigKID completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyPGPRequest : KBRRequest

- (void)pgpKeyInSecretStoreFile:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyServiceRequest : KBRRequest

- (void)shutdown:(void (^)(NSError *error))completion;

@end

@interface KBRNotifySessionRequest : KBRRequest

- (void)loggedOut:(void (^)(NSError *error))completion;

- (void)loggedIn:(KBRLoggedInRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)loggedInWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)clientOutOfDate:(KBRClientOutOfDateRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)clientOutOfDateWithUpgradeTo:(NSString *)upgradeTo upgradeURI:(NSString *)upgradeURI upgradeMsg:(NSString *)upgradeMsg completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyTrackingRequest : KBRRequest

- (void)trackingChanged:(KBRTrackingChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)trackingChangedWithUid:(NSString *)uid username:(NSString *)username completion:(void (^)(NSError *error))completion;

@end

@interface KBRNotifyUsersRequest : KBRRequest

- (void)userChanged:(KBRUserChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)userChangedWithUid:(NSString *)uid completion:(void (^)(NSError *error))completion;

@end

@interface KBRPaperprovisionRequest : KBRRequest

/*!
 Performs paper provision.
 If the current device isn't provisioned, this function will
 provision it.
 */
- (void)paperProvision:(KBRPaperProvisionRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)paperProvisionWithUsername:(NSString *)username deviceName:(NSString *)deviceName paperKey:(NSString *)paperKey completion:(void (^)(NSError *error))completion;

@end

@interface KBRPassphraseCommonRequest : KBRRequest

@end

@interface KBRPgpRequest : KBRRequest

- (void)pgpSign:(KBRPgpSignRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpSignWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPSignOptions *)opts completion:(void (^)(NSError *error))completion;

/*!
 Download PGP keys for tracked users and update the local GPG keyring.
 If usernames is nonempty, update only those users.
 */
- (void)pgpPull:(KBRPgpPullRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpPullWithUserAsserts:(NSArray *)userAsserts completion:(void (^)(NSError *error))completion;

- (void)pgpEncrypt:(KBRPgpEncryptRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpEncryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPEncryptOptions *)opts completion:(void (^)(NSError *error))completion;

- (void)pgpDecrypt:(KBRPgpDecryptRequestParams *)params completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpDecryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRPGPDecryptOptions *)opts completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpVerify:(KBRPgpVerifyRequestParams *)params completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpVerifyWithSource:(KBRStream *)source opts:(KBRPGPVerifyOptions *)opts completion:(void (^)(NSError *error, KBRPGPSigVerification *pGPSigVerification))completion;

- (void)pgpImport:(KBRPgpImportRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpImportWithKey:(NSData *)key pushSecret:(BOOL)pushSecret completion:(void (^)(NSError *error))completion;

/*!
 Exports active PGP keys. Only allows armored export.
 */
- (void)pgpExport:(KBRPgpExportRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByFingerprint:(KBRPgpExportByFingerprintRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByFingerprintWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByKID:(KBRPgpExportByKIDRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpExportByKIDWithOptions:(KBRPGPQuery *)options completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)pgpKeyGen:(KBRPgpKeyGenRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpKeyGenWithPrimaryBits:(NSInteger)primaryBits subkeyBits:(NSInteger)subkeyBits createUids:(KBRPGPCreateUids *)createUids allowMulti:(BOOL)allowMulti doExport:(BOOL)doExport pushSecret:(BOOL)pushSecret completion:(void (^)(NSError *error))completion;

- (void)pgpKeyGenDefault:(KBRPgpKeyGenDefaultRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpKeyGenDefaultWithCreateUids:(KBRPGPCreateUids *)createUids completion:(void (^)(NSError *error))completion;

- (void)pgpDeletePrimary:(void (^)(NSError *error))completion;

/*!
 Select an existing key and add to Keybase.
 */
- (void)pgpSelect:(KBRPgpSelectRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpSelectWithFingerprintQuery:(NSString *)fingerprintQuery allowMulti:(BOOL)allowMulti skipImport:(BOOL)skipImport onlyImport:(BOOL)onlyImport completion:(void (^)(NSError *error))completion;

/*!
 Push updated key(s) to the server.
 */
- (void)pgpUpdate:(KBRPgpUpdateRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)pgpUpdateWithAll:(BOOL)all fingerprints:(NSArray *)fingerprints completion:(void (^)(NSError *error))completion;

- (void)pgpPurge:(KBRPgpPurgeRequestParams *)params completion:(void (^)(NSError *error, KBRPGPPurgeRes *pGPPurgeRes))completion;

- (void)pgpPurgeWithDoPurge:(BOOL)doPurge completion:(void (^)(NSError *error, KBRPGPPurgeRes *pGPPurgeRes))completion;

/*!
 Dismiss the PGP unlock via secret_store_file notification.
 */
- (void)pgpStorageDismiss:(void (^)(NSError *error))completion;

@end

@interface KBRPgpUiRequest : KBRRequest

- (void)outputSignatureSuccess:(KBROutputSignatureSuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)outputSignatureSuccessWithFingerprint:(NSString *)fingerprint username:(NSString *)username signedAt:(int64_t)signedAt completion:(void (^)(NSError *error))completion;

- (void)outputSignatureSuccessNonKeybase:(KBROutputSignatureSuccessNonKeybaseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)outputSignatureSuccessNonKeybaseWithKeyID:(NSString *)keyID signedAt:(int64_t)signedAt completion:(void (^)(NSError *error))completion;

- (void)keyGenerated:(KBRKeyGeneratedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)keyGeneratedWithKid:(NSString *)kid key:(KBRKeyInfo *)key completion:(void (^)(NSError *error))completion;

- (void)shouldPushPrivate:(void (^)(NSError *error, BOOL b))completion;

- (void)finished:(void (^)(NSError *error))completion;

@end

@interface KBRProcessRequest : KBRRequest

@end

@interface KBRProveRequest : KBRRequest

- (void)startProof:(KBRStartProofRequestParams *)params completion:(void (^)(NSError *error, KBRStartProofResult *startProofResult))completion;

- (void)startProofWithService:(NSString *)service username:(NSString *)username force:(BOOL)force promptPosted:(BOOL)promptPosted automatic:(BOOL)automatic completion:(void (^)(NSError *error, KBRStartProofResult *startProofResult))completion;

- (void)checkProof:(KBRCheckProofRequestParams *)params completion:(void (^)(NSError *error, KBRCheckProofStatus *checkProofStatus))completion;

- (void)checkProofWithSigID:(NSString *)sigID completion:(void (^)(NSError *error, KBRCheckProofStatus *checkProofStatus))completion;

@end

@interface KBRProveUiRequest : KBRRequest

- (void)promptOverwrite:(KBRPromptOverwriteRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptOverwriteWithAccount:(NSString *)account typ:(KBRPromptOverwriteType)typ completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptUsername:(KBRPromptUsernameRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)promptUsernameWithPrompt:(NSString *)prompt prevError:(KBRStatus *)prevError completion:(void (^)(NSError *error, NSString *str))completion;

- (void)outputPrechecks:(KBROutputPrechecksRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)outputPrechecksWithText:(KBRText *)text completion:(void (^)(NSError *error))completion;

- (void)preProofWarning:(KBRPreProofWarningRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)preProofWarningWithText:(KBRText *)text completion:(void (^)(NSError *error, BOOL b))completion;

- (void)outputInstructions:(KBROutputInstructionsRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)outputInstructionsWithInstructions:(KBRText *)instructions proof:(NSString *)proof completion:(void (^)(NSError *error))completion;

- (void)okToCheck:(KBROkToCheckRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)okToCheckWithName:(NSString *)name attempt:(NSInteger)attempt completion:(void (^)(NSError *error, BOOL b))completion;

- (void)displayRecheckWarning:(KBRDisplayRecheckWarningRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)displayRecheckWarningWithText:(KBRText *)text completion:(void (^)(NSError *error))completion;

@end

@interface KBRProvisionUiRequest : KBRRequest

/*!
 DEPRECATED:
 Called during device provisioning for the user to select a
 method for provisioning. gpgOption will be true if GPG
 should be offered as an option.
 */
- (void)chooseProvisioningMethod:(KBRChooseProvisioningMethodRequestParams *)params completion:(void (^)(NSError *error, KBRProvisionMethod provisionMethod))completion;

- (void)chooseProvisioningMethodWithGpgOption:(BOOL)gpgOption completion:(void (^)(NSError *error, KBRProvisionMethod provisionMethod))completion;

/*!
 Called during device provisioning for the user to select a
 GPG method, either import the key into keybase's local keyring
 or use GPG to sign a provisioning statement.

 The keys are provided for display purposes, so the UI can
 do something like "We found the following GPG keys on this
 machine. How would you like to use one of them to provision
 this device?"

 After this, gpg_ui.selectKey will be called (if there are
 multiple keys available).
 */
- (void)chooseGPGMethod:(KBRChooseGPGMethodRequestParams *)params completion:(void (^)(NSError *error, KBRGPGMethod gPGMethod))completion;

- (void)chooseGPGMethodWithKeys:(NSArray *)keys completion:(void (^)(NSError *error, KBRGPGMethod gPGMethod))completion;

/*!
 If there was an error importing a gpg key into the local
 keyring, tell the user and offer to switch to GPG signing
 with this key. Return true to switch to GPG signing,
 false to abort provisioning.
 */
- (void)switchToGPGSignOK:(KBRSwitchToGPGSignOKRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)switchToGPGSignOKWithKey:(KBRGPGKey *)key importError:(NSString *)importError completion:(void (^)(NSError *error, BOOL b))completion;

- (void)chooseDevice:(KBRChooseDeviceRequestParams *)params completion:(void (^)(NSError *error, NSString *deviceID))completion;

- (void)chooseDeviceWithDevices:(NSArray *)devices completion:(void (^)(NSError *error, NSString *deviceID))completion;

/*!
 If provisioning via device, this will be called so user can select the provisioner/provisionee device type: desktop or mobile.
 If selecting the existing device type, set kind to EXISTING_DEVICE_0.
 If selecting the new device type, set kind to NEW_DEVICE_1.
 */
- (void)chooseDeviceType:(KBRChooseDeviceTypeRequestParams *)params completion:(void (^)(NSError *error, KBRDeviceType deviceType))completion;

- (void)chooseDeviceTypeWithKind:(KBRChooseType)kind completion:(void (^)(NSError *error, KBRDeviceType deviceType))completion;

/*!
 DisplayAndPromptSecret displays a secret that the user can enter into the other device.
 It also can return a secret that the user enters into this device (from the other device).
 If it does not return a secret, it will be canceled when this device receives the secret via kex2.
 */
- (void)displayAndPromptSecret:(KBRDisplayAndPromptSecretRequestParams *)params completion:(void (^)(NSError *error, KBRSecretResponse *secretResponse))completion;

- (void)displayAndPromptSecretWithSecret:(NSData *)secret phrase:(NSString *)phrase otherDeviceType:(KBRDeviceType)otherDeviceType completion:(void (^)(NSError *error, KBRSecretResponse *secretResponse))completion;

/*!
 DisplaySecretExchanged is called when the kex2 secret has successfully been exchanged by the two
 devices.
 */
- (void)displaySecretExchanged:(void (^)(NSError *error))completion;

/*!
 PromptNewDeviceName is called when the device provisioning process needs a name for the new device.
 To help the clients not send a duplicate name, existingDevices is populated with the current device
 names for the user. If the device name returned to the service is invalid or already
 taken, it will call this again with an error message in errorMessage.
 */
- (void)promptNewDeviceName:(KBRPromptNewDeviceNameRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)promptNewDeviceNameWithExistingDevices:(NSArray *)existingDevices errorMessage:(NSString *)errorMessage completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 ProvisioneeSuccess is called on provisionee when it is successfully provisioned.
 */
- (void)provisioneeSuccess:(KBRProvisioneeSuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)provisioneeSuccessWithUsername:(NSString *)username deviceName:(NSString *)deviceName completion:(void (^)(NSError *error))completion;

/*!
 ProvisionerSuccess is called on provisioner when it successfully provisions another device.
 */
- (void)provisionerSuccess:(KBRProvisionerSuccessRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)provisionerSuccessWithDeviceName:(NSString *)deviceName deviceType:(NSString *)deviceType completion:(void (^)(NSError *error))completion;

@end

@interface KBRQuotaRequest : KBRRequest

- (void)verifySession:(KBRVerifySessionRequestParams *)params completion:(void (^)(NSError *error, KBRVerifySessionRes *verifySessionRes))completion;

- (void)verifySessionWithSession:(NSString *)session completion:(void (^)(NSError *error, KBRVerifySessionRes *verifySessionRes))completion;

@end

@interface KBRReachabilityRequest : KBRRequest

- (void)reachabilityChanged:(KBRReachabilityChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)reachabilityChangedWithReachability:(KBRReachability *)reachability completion:(void (^)(NSError *error))completion;

/*!
 Start reachability checks and return current status, which
 may be cached.
 */
- (void)startReachability:(void (^)(NSError *error, KBRReachability *reachability))completion;

/*!
 Performs a reachability check. This is not a cached response.
 */
- (void)checkReachability:(void (^)(NSError *error, KBRReachability *reachability))completion;

@end

@interface KBRRekeyRequest : KBRRequest

/*!
 ShowPendingRekeyStatus shows either pending gregor-initiated rekey harassments
 or nothing if none were pending.
 */
- (void)showPendingRekeyStatus:(void (^)(NSError *error))completion;

/*!
 GetPendingRekeyStatus returns the pending ProblemSetDevices.
 */
- (void)getPendingRekeyStatus:(void (^)(NSError *error, KBRProblemSetDevices *problemSetDevices))completion;

/*!
 DebugShowRekeyStatus is used by the CLI to kick off a "ShowRekeyStatus" window for
 the current user.
 */
- (void)debugShowRekeyStatus:(void (^)(NSError *error))completion;

/*!
 RekeyStatusFinish is called when work is completed on a given RekeyStatus window. The Outcome
 can be Fixed or Ignored.
 */
- (void)rekeyStatusFinish:(void (^)(NSError *error, KBROutcome outcome))completion;

/*!
 RekeySync flushes the current rekey loop and gets to a good stopping point
 to assert state. Good for race-free testing, not very useful in production.
 Force overrides a long-snooze.
 */
- (void)rekeySync:(KBRRekeySyncRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)rekeySyncWithForce:(BOOL)force completion:(void (^)(NSError *error))completion;

/*!
 GetRevokeWarning computes the TLFs that will be endangered if actingDevice
 revokes targetDevice.
 */
- (void)getRevokeWarning:(KBRGetRevokeWarningRequestParams *)params completion:(void (^)(NSError *error, KBRRevokeWarning *revokeWarning))completion;

- (void)getRevokeWarningWithSession:(NSInteger)session actingDevice:(NSString *)actingDevice targetDevice:(NSString *)targetDevice completion:(void (^)(NSError *error, KBRRevokeWarning *revokeWarning))completion;

@end

@interface KBRRekeyUIRequest : KBRRequest

- (void)delegateRekeyUI:(void (^)(NSError *error, NSInteger n))completion;

/*!
 Refresh is called whenever Electron should refresh the UI, either
 because a change came in, or because there was a timeout poll.
 */
- (void)refresh:(KBRRefreshRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)refreshWithProblemSetDevices:(KBRProblemSetDevices *)problemSetDevices completion:(void (^)(NSError *error))completion;

/*!
 RekeySendEvent sends updates as to what's going on in the rekey
 thread. This is mainly useful in testing.
 */
- (void)rekeySendEvent:(KBRRekeySendEventRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)rekeySendEventWithEvent:(KBRRekeyEvent *)event completion:(void (^)(NSError *error))completion;

@end

@interface KBRRevokeRequest : KBRRequest

- (void)revokeKey:(KBRRevokeKeyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)revokeKeyWithKeyID:(NSString *)keyID completion:(void (^)(NSError *error))completion;

- (void)revokeDevice:(KBRRevokeDeviceRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)revokeDeviceWithDeviceID:(NSString *)deviceID force:(BOOL)force completion:(void (^)(NSError *error))completion;

- (void)revokeSigs:(KBRRevokeSigsRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)revokeSigsWithSigIDQueries:(NSArray *)sigIDQueries completion:(void (^)(NSError *error))completion;

@end

@interface KBRSaltpackRequest : KBRRequest

- (void)saltpackEncrypt:(KBRSaltpackEncryptRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltpackEncryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackEncryptOptions *)opts completion:(void (^)(NSError *error))completion;

- (void)saltpackDecrypt:(KBRSaltpackDecryptRequestParams *)params completion:(void (^)(NSError *error, KBRSaltpackEncryptedMessageInfo *saltpackEncryptedMessageInfo))completion;

- (void)saltpackDecryptWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackDecryptOptions *)opts completion:(void (^)(NSError *error, KBRSaltpackEncryptedMessageInfo *saltpackEncryptedMessageInfo))completion;

- (void)saltpackSign:(KBRSaltpackSignRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltpackSignWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackSignOptions *)opts completion:(void (^)(NSError *error))completion;

- (void)saltpackVerify:(KBRSaltpackVerifyRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)saltpackVerifyWithSource:(KBRStream *)source sink:(KBRStream *)sink opts:(KBRSaltpackVerifyOptions *)opts completion:(void (^)(NSError *error))completion;

@end

@interface KBRScanProofsRequest : KBRRequest

- (void)scanProofs:(KBRScanProofsRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)scanProofsWithInfile:(NSString *)infile indices:(NSString *)indices sigid:(NSString *)sigid ratelimit:(NSInteger)ratelimit cachefile:(NSString *)cachefile ignorefile:(NSString *)ignorefile completion:(void (^)(NSError *error))completion;

@end

@interface KBRSecretUiRequest : KBRRequest

- (void)getPassphrase:(KBRGetPassphraseRequestParams *)params completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

- (void)getPassphraseWithPinentry:(KBRGUIEntryArg *)pinentry terminal:(KBRSecretEntryArg *)terminal completion:(void (^)(NSError *error, KBRGetPassphraseRes *getPassphraseRes))completion;

@end

@interface KBRSecretKeysRequest : KBRRequest

- (void)getSecretKeys:(void (^)(NSError *error, KBRSecretKeys *secretKeys))completion;

@end

@interface KBRSessionRequest : KBRRequest

- (void)currentSession:(void (^)(NSError *error, KBRSession *session))completion;

- (void)sessionPing:(void (^)(NSError *error))completion;

@end

@interface KBRSignupRequest : KBRRequest

- (void)checkUsernameAvailable:(KBRCheckUsernameAvailableRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)checkUsernameAvailableWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)signup:(KBRSignupRequestParams *)params completion:(void (^)(NSError *error, KBRSignupRes *signupRes))completion;

- (void)signupWithEmail:(NSString *)email inviteCode:(NSString *)inviteCode passphrase:(NSString *)passphrase username:(NSString *)username deviceName:(NSString *)deviceName deviceType:(KBRDeviceType)deviceType storeSecret:(BOOL)storeSecret skipMail:(BOOL)skipMail genPGPBatch:(BOOL)genPGPBatch completion:(void (^)(NSError *error, KBRSignupRes *signupRes))completion;

- (void)inviteRequest:(KBRInviteRequestRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)inviteRequestWithEmail:(NSString *)email fullname:(NSString *)fullname notes:(NSString *)notes completion:(void (^)(NSError *error))completion;

- (void)checkInvitationCode:(KBRCheckInvitationCodeRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)checkInvitationCodeWithInvitationCode:(NSString *)invitationCode completion:(void (^)(NSError *error))completion;

@end

@interface KBRSigsRequest : KBRRequest

- (void)sigList:(KBRSigListRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)sigListWithArg:(KBRSigListArgs *)arg completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)sigListJSON:(KBRSigListJSONRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)sigListJSONWithArg:(KBRSigListArgs *)arg completion:(void (^)(NSError *error, NSString *str))completion;

@end

@interface KBRStreamUiRequest : KBRRequest

- (void)close:(KBRCloseRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)closeWithS:(KBRStream *)s completion:(void (^)(NSError *error))completion;

- (void)read:(KBRReadRequestParams *)params completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)readWithS:(KBRStream *)s sz:(NSInteger)sz completion:(void (^)(NSError *error, NSData *bytes))completion;

- (void)reset:(KBRResetRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)resetWithS:(KBRStream *)s completion:(void (^)(NSError *error))completion;

- (void)write:(KBRWriteRequestParams *)params completion:(void (^)(NSError *error, NSInteger n))completion;

- (void)writeWithS:(KBRStream *)s buf:(NSData *)buf completion:(void (^)(NSError *error, NSInteger n))completion;

@end

@interface KBRTestRequest : KBRRequest

/*!
 Call test method.
 Will trigger the testCallback method, whose result will be set in the
 returned Test object, reply property.
 */
- (void)test:(KBRTestRequestParams *)params completion:(void (^)(NSError *error, KBRTest *test))completion;

- (void)testWithName:(NSString *)name completion:(void (^)(NSError *error, KBRTest *test))completion;

/*!
 This is a service callback triggered from test(..).
 The name param is what was passed into test.
 */
- (void)testCallback:(KBRTestCallbackRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)testCallbackWithName:(NSString *)name completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 For testing crashes.
 */
- (void)panic:(KBRPanicRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)panicWithMessage:(NSString *)message completion:(void (^)(NSError *error))completion;

@end

@interface KBRTlfRequest : KBRRequest

/*!
 CryptKeys returns TLF crypt keys from all generations.
 */
- (void)cryptKeys:(KBRCryptKeysRequestParams *)params completion:(void (^)(NSError *error, KBRGetTLFCryptKeysRes *getTLFCryptKeysRes))completion;

- (void)cryptKeysWithQuery:(KBRTLFQuery *)query completion:(void (^)(NSError *error, KBRGetTLFCryptKeysRes *getTLFCryptKeysRes))completion;

/*!
 * tlfCanonicalID returns the canonical name and TLFID for tlfName.
 * TLFID should not be cached or stored persistently.
 */
- (void)publicCanonicalTLFNameAndID:(KBRPublicCanonicalTLFNameAndIDRequestParams *)params completion:(void (^)(NSError *error, KBRCanonicalTLFNameAndIDWithBreaks *canonicalTLFNameAndIDWithBreaks))completion;

- (void)publicCanonicalTLFNameAndIDWithQuery:(KBRTLFQuery *)query completion:(void (^)(NSError *error, KBRCanonicalTLFNameAndIDWithBreaks *canonicalTLFNameAndIDWithBreaks))completion;

- (void)completeAndCanonicalizePrivateTlfName:(KBRCompleteAndCanonicalizePrivateTlfNameRequestParams *)params completion:(void (^)(NSError *error, KBRCanonicalTLFNameAndIDWithBreaks *canonicalTLFNameAndIDWithBreaks))completion;

- (void)completeAndCanonicalizePrivateTlfNameWithQuery:(KBRTLFQuery *)query completion:(void (^)(NSError *error, KBRCanonicalTLFNameAndIDWithBreaks *canonicalTLFNameAndIDWithBreaks))completion;

@end

@interface KBRTlfKeysRequest : KBRRequest

/*!
 getTLFCryptKeys returns TLF crypt keys from all generations and the TLF ID.
 TLF ID should not be cached or stored persistently.
 */
- (void)getTLFCryptKeys:(KBRGetTLFCryptKeysRequestParams *)params completion:(void (^)(NSError *error, KBRGetTLFCryptKeysRes *getTLFCryptKeysRes))completion;

- (void)getTLFCryptKeysWithQuery:(KBRTLFQuery *)query completion:(void (^)(NSError *error, KBRGetTLFCryptKeysRes *getTLFCryptKeysRes))completion;

/*!
 getPublicCanonicalTLFNameAndID return the canonical name and TLFID for tlfName.
 TLF ID should not be cached or stored persistently.
 */
- (void)getPublicCanonicalTLFNameAndID:(KBRGetPublicCanonicalTLFNameAndIDRequestParams *)params completion:(void (^)(NSError *error, KBRCanonicalTLFNameAndIDWithBreaks *canonicalTLFNameAndIDWithBreaks))completion;

- (void)getPublicCanonicalTLFNameAndIDWithQuery:(KBRTLFQuery *)query completion:(void (^)(NSError *error, KBRCanonicalTLFNameAndIDWithBreaks *canonicalTLFNameAndIDWithBreaks))completion;

@end

@interface KBRTrackRequest : KBRRequest

/*!
 This will perform identify and track.
 If forceRemoteCheck is true, we force all remote proofs to be checked
 (otherwise a cache is used).
 */
- (void)track:(KBRTrackRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)trackWithUserAssertion:(NSString *)userAssertion options:(KBRTrackOptions *)options forceRemoteCheck:(BOOL)forceRemoteCheck completion:(void (^)(NSError *error))completion;

/*!
 Track with token returned from identify.
 */
- (void)trackWithToken:(KBRTrackWithTokenRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)trackWithTokenWithTrackToken:(NSString *)trackToken options:(KBRTrackOptions *)options completion:(void (^)(NSError *error))completion;

/*!
 Called by the UI when the user decides *not* to track, to e.g. dismiss gregor items.
 */
- (void)dismissWithToken:(KBRDismissWithTokenRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)dismissWithTokenWithTrackToken:(NSString *)trackToken completion:(void (^)(NSError *error))completion;

- (void)untrack:(KBRUntrackRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)untrackWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

- (void)checkTracking:(void (^)(NSError *error))completion;

- (void)fakeTrackingChanged:(KBRFakeTrackingChangedRequestParams *)params completion:(void (^)(NSError *error))completion;

- (void)fakeTrackingChangedWithUsername:(NSString *)username completion:(void (^)(NSError *error))completion;

@end

@interface KBRUiRequest : KBRRequest

- (void)promptYesNo:(KBRPromptYesNoRequestParams *)params completion:(void (^)(NSError *error, BOOL b))completion;

- (void)promptYesNoWithText:(KBRText *)text promptDefault:(KBRPromptDefault)promptDefault completion:(void (^)(NSError *error, BOOL b))completion;

@end

@interface KBRUserRequest : KBRRequest

- (void)listTrackers:(KBRListTrackersRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersByName:(KBRListTrackersByNameRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersByNameWithUsername:(NSString *)username completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackersSelf:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Load user summaries for the supplied uids.
 They are "unchecked" in that the client is not verifying the info from the server.
 If len(uids) > 500, the first 500 will be returned.
 */
- (void)loadUncheckedUserSummaries:(KBRLoadUncheckedUserSummariesRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)loadUncheckedUserSummariesWithUids:(NSArray *)uids completion:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Load a user from the server.
 */
- (void)loadUser:(KBRLoadUserRequestParams *)params completion:(void (^)(NSError *error, KBRUser *user))completion;

- (void)loadUserWithUid:(NSString *)uid completion:(void (^)(NSError *error, KBRUser *user))completion;

- (void)loadUserByName:(KBRLoadUserByNameRequestParams *)params completion:(void (^)(NSError *error, KBRUser *user))completion;

- (void)loadUserByNameWithUsername:(NSString *)username completion:(void (^)(NSError *error, KBRUser *user))completion;

/*!
 Load a user + device keys from the server.
 */
- (void)loadUserPlusKeys:(KBRLoadUserPlusKeysRequestParams *)params completion:(void (^)(NSError *error, KBRUserPlusKeys *userPlusKeys))completion;

- (void)loadUserPlusKeysWithUid:(NSString *)uid completion:(void (^)(NSError *error, KBRUserPlusKeys *userPlusKeys))completion;

/*!
 Load public keys for a user.
 */
- (void)loadPublicKeys:(KBRLoadPublicKeysRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)loadPublicKeysWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Load my public keys (for logged in user).
 */
- (void)loadMyPublicKeys:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Load user settings (for logged in user).
 */
- (void)loadMySettings:(void (^)(NSError *error, KBRUserSettings *userSettings))completion;

/*!
 The list-tracking functions get verified data from the tracking statements
 in the user's sigchain.

 If assertion is empty, it will use the current logged in user.
 */
- (void)listTracking:(KBRListTrackingRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackingWithFilter:(NSString *)filter assertion:(NSString *)assertion completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackingJSON:(KBRListTrackingJSONRequestParams *)params completion:(void (^)(NSError *error, NSString *str))completion;

- (void)listTrackingJSONWithFilter:(NSString *)filter verbose:(BOOL)verbose assertion:(NSString *)assertion completion:(void (^)(NSError *error, NSString *str))completion;

/*!
 Search for users who match a given query.
 */
- (void)search:(KBRSearchRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)searchWithQuery:(NSString *)query completion:(void (^)(NSError *error, NSArray *items))completion;

/*!
 Load all the user's public keys (even those in reset key families)
 from the server with no verification
 */
- (void)loadAllPublicKeysUnverified:(KBRLoadAllPublicKeysUnverifiedRequestParams *)params completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)loadAllPublicKeysUnverifiedWithUid:(NSString *)uid completion:(void (^)(NSError *error, NSArray *items))completion;

- (void)listTrackers2:(KBRListTrackers2RequestParams *)params completion:(void (^)(NSError *error, KBRUserSummary2Set *userSummary2Set))completion;

- (void)listTrackers2WithAssertion:(NSString *)assertion reverse:(BOOL)reverse completion:(void (^)(NSError *error, KBRUserSummary2Set *userSummary2Set))completion;

@end
