/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.plugin.management.PluginRequest;
import org.gradle.plugin.management.internal.PluginCoordinates;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginHandler;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;

public class DefaultAutoAppliedPluginHandler
implements AutoAppliedPluginHandler {
    private final AutoAppliedPluginRegistry registry;

    public DefaultAutoAppliedPluginHandler(AutoAppliedPluginRegistry registry) {
        this.registry = registry;
    }

    public PluginRequests getAutoAppliedPlugins(PluginRequests initialRequests, Object pluginTarget) {
        if (pluginTarget instanceof Project) {
            Project project = (Project)pluginTarget;
            PluginRequests autoAppliedPlugins = this.registry.getAutoAppliedPlugins(project);
            if (autoAppliedPlugins.isEmpty()) {
                return PluginRequests.EMPTY;
            }
            return DefaultAutoAppliedPluginHandler.filterAlreadyAppliedOrRequested(autoAppliedPlugins, initialRequests, project.getPlugins(), project.getBuildscript());
        }
        if (pluginTarget instanceof Settings) {
            Settings settings = (Settings)pluginTarget;
            PluginRequests autoAppliedPlugins = this.registry.getAutoAppliedPlugins(settings);
            if (autoAppliedPlugins.isEmpty()) {
                return PluginRequests.EMPTY;
            }
            return DefaultAutoAppliedPluginHandler.filterAlreadyAppliedOrRequested(autoAppliedPlugins, initialRequests, settings.getPlugins(), settings.getBuildscript());
        }
        return PluginRequests.EMPTY;
    }

    private static PluginRequests filterAlreadyAppliedOrRequested(PluginRequests autoAppliedPlugins, PluginRequests initialRequests, PluginContainer pluginContainer, ScriptHandler scriptHandler) {
        return PluginRequests.of((List)ImmutableList.copyOf((Collection)StreamSupport.stream(autoAppliedPlugins.spliterator(), false).filter(autoAppliedPlugin -> !DefaultAutoAppliedPluginHandler.isAlreadyAppliedOrRequested(PluginCoordinates.from((PluginRequest)autoAppliedPlugin), initialRequests, pluginContainer, scriptHandler)).filter(autoAppliedPlugin -> autoAppliedPlugin.getAlternativeCoordinates().map(it -> !DefaultAutoAppliedPluginHandler.isAlreadyAppliedOrRequested(it, initialRequests, pluginContainer, scriptHandler)).orElse(true)).collect(Collectors.toList())));
    }

    private static boolean isAlreadyAppliedOrRequested(PluginCoordinates autoAppliedPlugin, PluginRequests requests, PluginContainer pluginContainer, ScriptHandler scriptHandler) {
        return DefaultAutoAppliedPluginHandler.isAlreadyApplied(autoAppliedPlugin, pluginContainer) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInPluginsBlock(autoAppliedPlugin, requests) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInBuildScriptBlock(autoAppliedPlugin, scriptHandler);
    }

    private static boolean isAlreadyApplied(PluginCoordinates autoAppliedPlugin, PluginContainer pluginContainer) {
        return pluginContainer.hasPlugin(autoAppliedPlugin.getId().getId());
    }

    private static boolean isAlreadyRequestedInPluginsBlock(PluginCoordinates autoAppliedPlugin, PluginRequests requests) {
        for (PluginRequestInternal request : requests) {
            if (!autoAppliedPlugin.getId().equals(request.getId())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlreadyRequestedInBuildScriptBlock(PluginCoordinates autoAppliedPlugin, ScriptHandler scriptHandler) {
        String pluginId = autoAppliedPlugin.getId().getId();
        ModuleIdentifier pluginMarker = DefaultModuleIdentifier.newId((String)pluginId, (String)(pluginId + ".gradle.plugin"));
        Predicate<Dependency> predicate = dependency -> DefaultAutoAppliedPluginHandler.hasMatchingCoordinates(dependency, pluginMarker);
        ModuleVersionSelector moduleSelector = autoAppliedPlugin.getModule();
        if (moduleSelector != null) {
            predicate = predicate.or(dependency -> DefaultAutoAppliedPluginHandler.hasMatchingCoordinates(dependency, moduleSelector.getModule()));
        }
        Configuration classpathConfiguration = scriptHandler.getConfigurations().getByName("classpath");
        return classpathConfiguration.getDependencies().stream().anyMatch(predicate);
    }

    private static boolean hasMatchingCoordinates(Dependency dependency, ModuleIdentifier module) {
        return module.getGroup().equals(dependency.getGroup()) && module.getName().equals(dependency.getName());
    }
}

