/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableList;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeVisitor;

class MessageCollectingChangeVisitor
implements ChangeVisitor {
    private final ImmutableList.Builder<String> messagesBuilder = ImmutableList.builder();
    private final int maxNumMessages;
    private int count;

    MessageCollectingChangeVisitor(int maxNumMessages) {
        this.maxNumMessages = maxNumMessages;
    }

    @Override
    public boolean visitChange(Change change) {
        ++this.count;
        if (this.count > this.maxNumMessages) {
            this.messagesBuilder.add((Object)"and more...");
            return false;
        }
        this.messagesBuilder.add((Object)change.getMessage());
        return true;
    }

    public ImmutableList<String> getMessages() {
        return this.messagesBuilder.build();
    }
}

