/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.SystemPropertiesHandler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;

public class GradleWrapperMain {
    public static final String GRADLE_USER_HOME_OPTION = "g";
    public static final String GRADLE_USER_HOME_DETAILED_OPTION = "gradle-user-home";
    public static final String GRADLE_QUIET_OPTION = "q";
    public static final String GRADLE_QUIET_DETAILED_OPTION = "quiet";

    public static void main(String[] args) throws Exception {
        File wrapperJar = GradleWrapperMain.wrapperJar();
        File propertiesFile = GradleWrapperMain.wrapperProperties(wrapperJar);
        File rootDir = GradleWrapperMain.rootDir(wrapperJar);
        CommandLineParser parser = new CommandLineParser();
        parser.allowUnknownOptions();
        parser.option(new String[]{GRADLE_USER_HOME_OPTION, GRADLE_USER_HOME_DETAILED_OPTION}).hasArgument();
        parser.option(new String[]{GRADLE_QUIET_OPTION, GRADLE_QUIET_DETAILED_OPTION});
        SystemPropertiesCommandLineConverter converter = new SystemPropertiesCommandLineConverter();
        converter.configure(parser);
        ParsedCommandLine options = parser.parse(args);
        Properties systemProperties = System.getProperties();
        systemProperties.putAll((Map<?, ?>)converter.convert(options, new HashMap()));
        File gradleUserHome = GradleWrapperMain.gradleUserHome(options);
        GradleWrapperMain.addSystemProperties(systemProperties, gradleUserHome, rootDir);
        Logger logger = GradleWrapperMain.logger(options);
        WrapperExecutor wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile);
        WrapperConfiguration configuration = wrapperExecutor.getConfiguration();
        Download download = new Download(logger, "gradlew", "0", configuration.getNetworkTimeout());
        wrapperExecutor.execute(args, new Install(logger, (IDownload)download, new PathAssembler(gradleUserHome, rootDir)), new BootstrapMainStarter());
    }

    private static void addSystemProperties(Properties systemProperties, File gradleUserHome, File rootDir) {
        systemProperties.putAll((Map<?, ?>)SystemPropertiesHandler.getSystemProperties((File)new File(rootDir, "gradle.properties")));
        systemProperties.putAll((Map<?, ?>)SystemPropertiesHandler.getSystemProperties((File)new File(gradleUserHome, "gradle.properties")));
    }

    private static File rootDir(File wrapperJar) {
        return wrapperJar.getParentFile().getParentFile().getParentFile();
    }

    private static File wrapperProperties(File wrapperJar) {
        return new File(wrapperJar.getParent(), wrapperJar.getName().replaceFirst("\\.jar$", ".properties"));
    }

    private static File wrapperJar() {
        URI location;
        try {
            location = GradleWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new RuntimeException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        try {
            return Paths.get(location).toFile();
        }
        catch (NoClassDefFoundError e) {
            return new File(location.getPath());
        }
    }

    private static File gradleUserHome(ParsedCommandLine options) {
        if (options.hasOption(GRADLE_USER_HOME_OPTION)) {
            return new File(options.option(GRADLE_USER_HOME_OPTION).getValue());
        }
        return GradleUserHomeLookup.gradleUserHome();
    }

    private static Logger logger(ParsedCommandLine options) {
        return new Logger(options.hasOption(GRADLE_QUIET_OPTION));
    }
}

