#ifndef BOOL
#define BOOL unsigned char
#endif
#ifndef TRUE
#define TRUE (1==1)
#endif
#ifndef FALSE
#define FALSE (1==0)
#endif

typedef struct _field_select_typ {
  char *field;
  char *dest;
  char *information;
  struct _field_select_typ *next;
  struct _field_select_typ *prev;
} field_select_typ;

typedef struct _song_typ {
  BOOL convert;           /* Convert to mp3 */
  char *artist;           /* Artist of Song */
  char *title;            /* Title of Song  */
  char *album;            /* Albumname      */
  char *comment;          /* Comment        */
  int year;               /* year           */
  int genre;              /* mp3 - genre    */
  char *filename;         /* Filename       */
  char *dirname;          /* Dirname        */
  BOOL on_fly;            /* Convert on fly */
  char toc;               /* Tracknumber    */
  BOOL fn_auto;           /* generate fname */
  long int cddb_id;       /* ID of CDDB     */
  char *tmp_wav_file;     /* ripped wavefile*/
  long int frame_len;     /* length of file */
  BOOL sampler;           /* is sampler?    */
  struct _song_typ *next; /* Pointer        */
  struct _song_typ *prev;
} song_typ;


#define PRG_VERSION VERSION

/* Default values */
#define MP3C_RCFILE     "mp3crc"
#define DEF_ETC_PATH    "/usr/local/etc"
#define TOT_GENRES      147
#define MP3C_BACKSPACE	''
#define MP3C_LOCKFILE   "~/.mp3c.lock"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_TIME_H
#include <time.h>
#endif

/* Hmm, there seems to be two definitions ;-) */
#ifdef ENABLE_NLS
#ifndef HAVE_NLS
#define HAVE_NLS 1
#endif
#endif

#ifdef HAVE_NLS
#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#else
#include "../intl/libintl.h"
#endif
#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif
#define _(str) gettext(str)
#else
#define _(str) str
#endif

/* --- selectable presets ------------------------------------------- */
#define PRE1_PATTERN	"%7-%8.ogg"	/* pattern: %1:artist,%2:title,
					 * %3:album,%4:genre,%5:year,
					 * %6:track,%7:track (leading 0s),
					 * %8:cddb-id */
#define PRE1_PATTERN_M	"%3/%1-%2.ogg"
#define PRE1_ENC_INFO	"0"
#define PRE1_ENC_NF	"oggenc -b 192 -l \"%3\" -d \"%5\" -c \"comment=%6\" -N \"%a\" -a \"%c\" -t \"%d\" -o \"%2\" \"%1\""
#define PRE1_ENC_OF	"oggenc -b 192 -l \"%3\" -d \"%5\" -c \"comment=%6\" -N \"%a\" -a \"%c\" -t \"%d\" -o \"%1\" -"

#define PRE2_PATTERN	"%7-%8.mp3"
#define PRE2_PATTERN_M	"%3/%1-%2.mp3"
#define PRE2_ENC_INFO	"0"
#define PRE2_ENC_NF	"lame --preset standard --tt \"%d\" --ta \"%c\" --tl \"%3\" --ty \"%5\" --tc \"%6\" --tn \"%a\" --tg \"%4\" \"%1\" \"%2\""
#define PRE2_ENC_OF	"lame --preset standard --tt \"%d\" --ta \"%c\" --tl \"%3\" --ty \"%5\" --tc \"%6\" --tn \"%a\" --tg \"%4\" - \"%1\""
/* ------------------------------------------------------------------ */

