/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.ImageUtil;
import net.yura.mobile.util.Properties;
import net.yura.mobile.util.StringUtil;

public class Font {
    private static Vector integers;
    private Hashtable characters;
    private int height;
    private int characterSpacing;
    private int[] startX;
    private int[] startY;
    private byte[] characterWidth;
    private byte[] characterHeight;
    private int[] offsetX;
    private int[] offsetY;
    private int[] advance;
    private int spaceWidth;
    private int[] colors = new int[1];
    private Image[] characterImage;
    private Hashtable imageTable;
    private boolean numbermode;
    private Hashtable kerning = new Hashtable();
    private javax.microedition.lcdui.Font systemFont = null;
    Random r = new Random();
    private static int POSITION_DOT;
    private static int POSITION_CURRENCY;
    private static int POSITION_MINUS;
    private static int POSITION_TIME;

    private Font() {
    }

    public Font(int fname, int fstyle, int fsize) {
        this.setSystemFont(javax.microedition.lcdui.Font.getFont((int)fname, (int)fstyle, (int)fsize));
    }

    private void setSystemFont(javax.microedition.lcdui.Font systemFont) {
        this.systemFont = systemFont;
        this.height = this.getHeight();
    }

    public static Font getDefaultSystemFont() {
        Font f = new Font();
        f.setSystemFont(javax.microedition.lcdui.Font.getDefaultFont());
        return f;
    }

    public static Font getFont(String descriptor, String[] imagePaths, int[] colors) {
        try {
            InputStream is = Midlet.getResourceAsStream(descriptor);
            Image[] characterImage = new Image[imagePaths.length];
            for (int c = 0; c < imagePaths.length; ++c) {
                Image image;
                characterImage[c] = image = Midlet.createImage(imagePaths[c]);
            }
            return Font.getFont(is, characterImage, colors);
        }
        catch (IOException ex) {
            Logger.warn("cant get font " + descriptor, ex);
            throw new RuntimeException("cant get font " + descriptor);
        }
    }

    public static Font getFont(InputStream is, Image[] imagesArray, int[] colorsArray) throws IOException {
        Font f = new Font();
        f.characterImage = imagesArray;
        f.colors = colorsArray;
        DataInputStream dis = new DataInputStream(is);
        dis.skipBytes(4);
        dis.skipBytes(1);
        int size = Font.getLong(dis);
        dis.skipBytes(size);
        dis.skipBytes(1);
        size = Font.getLong(dis);
        f.height = Font.getShortUnsigned(dis);
        dis.skipBytes(size - 2);
        dis.skipBytes(1);
        size = Font.getLong(dis);
        dis.skipBytes(size);
        f.characters = new Hashtable();
        dis.skipBytes(1);
        int chars = Font.getLong(dis) / 20;
        f.startX = new int[chars];
        f.startY = new int[chars];
        f.characterWidth = new byte[chars];
        f.characterHeight = new byte[chars];
        f.offsetX = new int[chars];
        f.offsetY = new int[chars];
        f.advance = new int[chars];
        Image[] glyphs = new Image[chars];
        for (int i = 0; i < chars; ++i) {
            int id = Font.getLong(dis);
            Character key = new Character((char)id);
            f.characters.put(key, new Integer(i));
            f.startX[i] = Font.getShortUnsigned(dis);
            f.startY[i] = Font.getShortUnsigned(dis);
            f.characterWidth[i] = (byte)Font.getShortUnsigned(dis);
            f.characterHeight[i] = (byte)Font.getShortUnsigned(dis);
            f.offsetX[i] = Font.getShortSigned(dis);
            f.offsetY[i] = Font.getShortSigned(dis);
            f.advance[i] = Font.getShortSigned(dis);
            glyphs[i] = null;
            byte page = dis.readByte();
            byte channel = dis.readByte();
        }
        f.imageTable = new Hashtable();
        f.imageTable.put(new Integer(0), glyphs);
        if (dis.available() > 0) {
            dis.skipBytes(1);
            dis.skipBytes(4);
            while (dis.available() > 0) {
                try {
                    char first = (char)Font.getLong(dis);
                    char second = (char)Font.getLong(dis);
                    Integer charPairIdentifier = Font.getCharPairId(first, second);
                    int amount = Font.getShortSigned(dis);
                    Integer kerningValue = Font.getInteger(amount);
                    f.kerning.put(charPairIdentifier, kerningValue);
                }
                catch (EOFException e) {
                    Logger.debug(null, e);
                }
            }
        }
        integers = null;
        return f;
    }

    public static int getShortUnsigned(DataInputStream dis) throws IOException {
        byte b0 = dis.readByte();
        byte b1 = dis.readByte();
        return (b1 << 8 & 0xFF00 | b0 & 0xFF) & 0xFFFF;
    }

    public static int getShortSigned(DataInputStream dis) throws IOException {
        byte b0 = dis.readByte();
        byte b1 = dis.readByte();
        return b1 << 8 | b0;
    }

    public static int getLong(DataInputStream dis) throws IOException {
        int short0 = Font.getShortUnsigned(dis);
        int short1 = Font.getShortUnsigned(dis);
        return short0 | short1 << 16;
    }

    private static Integer getInteger(int integer) {
        Integer lookup;
        int index;
        if (integers == null) {
            integers = new Vector(1, 1);
        }
        if ((index = integers.indexOf(lookup = new Integer(integer))) > -1) {
            return (Integer)integers.elementAt(index);
        }
        integers.addElement(lookup);
        return lookup;
    }

    private static Integer getCharPairId(char first, char second) {
        return new Integer(first | second << 16);
    }

    public static Font getFont(String name) {
        try {
            int i;
            int c;
            Font f = new Font();
            Properties newfont = new Properties();
            newfont.load(Midlet.getResourceAsStream(name));
            String baseDir = name.substring(0, name.lastIndexOf(47) + 1);
            String[] offsetsText = StringUtil.split(newfont.getProperty("offsets"), ',');
            byte[] offsetsint = new byte[offsetsText.length];
            f.characters = new Hashtable();
            int numCharacters = 0;
            int charCode = 32;
            for (c = 0; c < offsetsText.length; ++c) {
                byte size = Byte.parseByte(offsetsText[c]);
                Character key = new Character((char)charCode);
                if (size > 0) {
                    f.characters.put(key, new Integer(numCharacters));
                    offsetsint[numCharacters] = size;
                    ++numCharacters;
                }
                ++charCode;
            }
            String[] colorsText = StringUtil.split(newfont.getProperty("colors"), ',');
            f.colors = new int[colorsText.length];
            f.imageTable = new Hashtable();
            f.characterImage = new Image[f.colors.length];
            for (c = 0; c < colorsText.length; ++c) {
                String imageName = baseDir + newfont.getProperty("image." + colorsText[c]);
                if (name.charAt(0) == '/' && imageName.charAt(0) != '/') {
                    imageName = "/" + imageName;
                }
                Image fontimage = Midlet.createImage(imageName);
                f.colors[c] = Integer.parseInt(colorsText[c], 16) | 0xFF000000;
                f.characterImage[c] = fontimage;
            }
            String numbermodeString = newfont.getProperty("numbermode");
            f.numbermode = "T".equals(numbermodeString);
            Image image = f.characterImage[0];
            f.characterWidth = new byte[numCharacters];
            System.arraycopy(offsetsint, 0, f.characterWidth, 0, numCharacters);
            f.startX = new int[numCharacters];
            f.startY = new int[numCharacters];
            f.advance = new int[numCharacters];
            f.offsetX = new int[numCharacters];
            f.offsetY = new int[numCharacters];
            int y = 0;
            int x = 0;
            int cutoff = image.getWidth();
            for (i = 0; i < numCharacters; ++i) {
                if (x + f.characterWidth[i] > cutoff) {
                    x = 0;
                }
                f.startX[i] = x;
                f.startY[i] = ++y;
                f.advance[i] = f.characterWidth[i];
                f.offsetX[i] = 0;
                f.offsetY[i] = 0;
                x += f.characterWidth[i];
            }
            f.height = image.getHeight() / (y + 1);
            f.characterHeight = new byte[numCharacters];
            for (i = 0; i < numCharacters; ++i) {
                f.characterHeight[i] = (byte)f.height;
            }
            i = 0;
            while (i < numCharacters) {
                int n = i++;
                f.startY[n] = f.startY[n] * f.height;
            }
            f.characterSpacing = 1;
            if (f.numbermode) {
                f.startY = null;
            } else {
                Integer id = (Integer)f.characters.get(new Character(' '));
                if (id != null) {
                    f.spaceWidth = f.characterWidth[id];
                }
            }
            f.setSpaceWidth(Integer.parseInt(newfont.getProperty("space")));
            f.setCharacterSpacing(Integer.parseInt(newfont.getProperty("spacing")));
            return f;
        }
        catch (IOException ex) {
            Logger.warn("unable to load font: " + name, ex);
            throw new RuntimeException("unable to load font: " + name);
        }
    }

    public void setCharacterSpacing(int spacing) {
        this.characterSpacing = spacing;
    }

    public void setSpaceWidth(int width) {
        this.spaceWidth = width;
    }

    public int getWidth(char c) {
        if (this.systemFont != null) {
            return this.systemFont.charWidth(c);
        }
        if (this.numbermode) {
            if (c == '-') {
                return this.characterWidth[POSITION_MINUS];
            }
            if (c == ':') {
                return this.characterWidth[POSITION_TIME];
            }
            if (c == '.') {
                return this.characterWidth[POSITION_DOT];
            }
            return this.characterWidth[Integer.parseInt(String.valueOf(c))];
        }
        int p = this.getCharIndex(c);
        if (p > -1) {
            return this.characterWidth[this.getCharIndex(c)];
        }
        return 0;
    }

    private int getCharIndex(char ch) {
        Character key = new Character(ch);
        Object index = this.characters.get(key);
        if (index != null) {
            return (Integer)index;
        }
        return -1;
    }

    public int getHeight() {
        if (this.systemFont != null) {
            return this.systemFont.getHeight();
        }
        return this.height;
    }

    public int getWidth(String s) {
        if (this.systemFont != null) {
            return this.systemFont.stringWidth(s);
        }
        if (this.numbermode) {
            int width = this.characterSpacing;
            if (s.indexOf(58) == -1 && this.characterWidth.length > POSITION_CURRENCY) {
                width += this.characterWidth[POSITION_CURRENCY] + this.characterSpacing;
            }
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                width += this.getWidth(ch) + this.characterSpacing;
            }
            return width;
        }
        int width = 0;
        int prevCharacter = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            char character = s.charAt(i);
            int charIndex = this.getCharIndex(character);
            int w = 0;
            if (charIndex > -1) {
                Integer kerningModifier = (Integer)this.kerning.get(Font.getCharPairId((char)prevCharacter, (char)charIndex));
                if (kerningModifier != null) {
                    w = kerningModifier;
                }
                w = character == ' ' && i == s.length() - 1 ? this.getWidth(character) + this.advance[charIndex] : (i == s.length() - 1 ? this.getWidth(character) + this.offsetX[charIndex] : (i == 0 ? this.advance[charIndex] + this.characterSpacing - this.offsetX[charIndex] : this.advance[charIndex] + this.characterSpacing));
            } else {
                w = javax.microedition.lcdui.Font.getDefaultFont().charWidth(character);
            }
            prevCharacter = charIndex;
            width += w;
        }
        return width;
    }

    private Image getGlyph(int index, int color) {
        Image[] glyphs = (Image[])this.imageTable.get(new Integer(color));
        if (glyphs == null) {
            glyphs = new Image[this.characters.size()];
            this.imageTable.put(new Integer(color), glyphs);
        }
        if (glyphs[index] == null) {
            for (int c = 0; c < this.colors.length; ++c) {
                if (color != this.colors[c]) continue;
                glyphs[index] = Image.createImage((Image)this.characterImage[c], (int)this.startX[index], (int)this.startY[index], (int)this.characterWidth[index], (int)this.characterHeight[index], (int)0);
                return glyphs[index];
            }
            int defaultColor = this.colors[0];
            Image glyph = this.getGlyph(index, defaultColor);
            Image coloured = defaultColor == -16777216 ? ImageUtil.colorize(glyph, color) : ImageUtil.imageColor(glyph, color);
            glyphs[index] = coloured;
        }
        return glyphs[index];
    }

    public javax.microedition.lcdui.Font getFont() {
        return this.systemFont;
    }

    public int drawString(Graphics g, String s, int x, int y, int alignment) {
        if (this.systemFont != null) {
            javax.microedition.lcdui.Font f = g.getFont();
            g.setFont(this.systemFont);
            g.drawString(s, x, y, alignment);
            g.setFont(f);
            return this.getWidth(s);
        }
        int color = g.getColor() | 0xFF000000;
        if (this.numbermode) {
            int x2 = x;
            if (s.indexOf(58) == -1 && this.characterWidth.length > POSITION_CURRENCY) {
                x2 = this.drawDigit(g, x2, y, POSITION_CURRENCY);
            }
            if (s.indexOf(46) == -1 && s.indexOf(58) == -1) {
                int thenum = Integer.parseInt(s);
                x2 += this.renderNumber(g, x2, y, thenum, s.length());
            } else {
                int code;
                int sep;
                if (s.indexOf(58) == -1) {
                    sep = 46;
                    code = POSITION_DOT;
                } else {
                    sep = 58;
                    code = POSITION_TIME;
                }
                String firstnum = s.substring(0, s.indexOf(sep));
                String secondnum = s.substring(s.indexOf(sep) + 1, s.length());
                int thenum1 = Integer.parseInt(firstnum);
                int thenum2 = Integer.parseInt(secondnum);
                x2 += this.renderNumber(g, x2, y, thenum1, firstnum.length());
                x2 = this.drawDigit(g, x2, y, code);
                x2 += this.renderNumber(g, x2, y, thenum2, secondnum.length());
            }
            return x2 - x;
        }
        int length = s.length();
        int width = this.getWidth(s);
        if ((alignment & 1) != 0) {
            x -= width >> 1;
        } else if ((alignment & 8) != 0) {
            x -= width;
        }
        if ((alignment & 2) != 0) {
            y -= this.height >> 1;
        } else if ((alignment & 0x20) != 0) {
            y -= this.height - 1;
        }
        int prevCharacter = 0;
        for (int i = 0; i < length; ++i) {
            char character = s.charAt(i);
            int charIndex = this.getCharIndex(character);
            if (charIndex > -1) {
                int thisx;
                Integer kerningModifier = (Integer)this.kerning.get(Font.getCharPairId((char)prevCharacter, (char)charIndex));
                if (kerningModifier != null) {
                    x += kerningModifier.intValue();
                }
                Image glyph = this.getGlyph(charIndex, color);
                if (i > 0) {
                    thisx = x + this.offsetX[charIndex];
                } else {
                    thisx = x;
                    x -= this.offsetX[charIndex];
                }
                g.drawImage(glyph, thisx, y + this.offsetY[charIndex], 20);
                x += this.advance[charIndex] + this.characterSpacing;
            } else {
                this.systemFont = javax.microedition.lcdui.Font.getDefaultFont();
                javax.microedition.lcdui.Font savedFont = g.getFont();
                g.setFont(this.systemFont);
                g.drawChar(character, x, y, alignment);
                x += this.getWidth(character);
                this.systemFont = null;
                g.setFont(savedFont);
            }
            prevCharacter = charIndex;
        }
        return width;
    }

    private int renderNumber(Graphics g, int x, int y, int number, int digits) {
        int digit;
        int sX = x;
        int column = 1;
        for (digit = 0; digit < digits; ++digit) {
            column *= 10;
        }
        if (number < 0) {
            number = -number;
            x = this.drawDigit(g, x, y, POSITION_MINUS);
        }
        number %= column;
        while (column > 1) {
            digit = number / (column /= 10);
            number -= digit * column;
            x = this.drawDigit(g, x, y, digit);
        }
        return x - sX - this.characterSpacing;
    }

    private int drawDigit(Graphics g, int x, int y, int a) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.setClip(clipX, clipY, clipW, clipH);
        return x += this.characterWidth[a] + this.characterSpacing;
    }

    static {
        POSITION_DOT = 10;
        POSITION_CURRENCY = 11;
        POSITION_MINUS = 12;
        POSITION_TIME = 13;
    }
}

