//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

const (
	moduleName    = "armmonitor"
	moduleVersion = "v0.4.1"
)

// AggregationType - the aggregation type of the metric.
type AggregationType string

const (
	AggregationTypeNone    AggregationType = "None"
	AggregationTypeAverage AggregationType = "Average"
	AggregationTypeCount   AggregationType = "Count"
	AggregationTypeMinimum AggregationType = "Minimum"
	AggregationTypeMaximum AggregationType = "Maximum"
	AggregationTypeTotal   AggregationType = "Total"
)

// PossibleAggregationTypeValues returns the possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{
		AggregationTypeNone,
		AggregationTypeAverage,
		AggregationTypeCount,
		AggregationTypeMinimum,
		AggregationTypeMaximum,
		AggregationTypeTotal,
	}
}

// ToPtr returns a *AggregationType pointing to the current value.
func (c AggregationType) ToPtr() *AggregationType {
	return &c
}

// AggregationTypeEnum - the criteria time aggregation types.
type AggregationTypeEnum string

const (
	AggregationTypeEnumAverage AggregationTypeEnum = "Average"
	AggregationTypeEnumCount   AggregationTypeEnum = "Count"
	AggregationTypeEnumMaximum AggregationTypeEnum = "Maximum"
	AggregationTypeEnumMinimum AggregationTypeEnum = "Minimum"
	AggregationTypeEnumTotal   AggregationTypeEnum = "Total"
)

// PossibleAggregationTypeEnumValues returns the possible values for the AggregationTypeEnum const type.
func PossibleAggregationTypeEnumValues() []AggregationTypeEnum {
	return []AggregationTypeEnum{
		AggregationTypeEnumAverage,
		AggregationTypeEnumCount,
		AggregationTypeEnumMaximum,
		AggregationTypeEnumMinimum,
		AggregationTypeEnumTotal,
	}
}

// ToPtr returns a *AggregationTypeEnum pointing to the current value.
func (c AggregationTypeEnum) ToPtr() *AggregationTypeEnum {
	return &c
}

// AlertSeverity - Severity Level of Alert
type AlertSeverity string

const (
	AlertSeverityFour  AlertSeverity = "4"
	AlertSeverityOne   AlertSeverity = "1"
	AlertSeverityThree AlertSeverity = "3"
	AlertSeverityTwo   AlertSeverity = "2"
	AlertSeverityZero  AlertSeverity = "0"
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityFour,
		AlertSeverityOne,
		AlertSeverityThree,
		AlertSeverityTwo,
		AlertSeverityZero,
	}
}

// ToPtr returns a *AlertSeverity pointing to the current value.
func (c AlertSeverity) ToPtr() *AlertSeverity {
	return &c
}

// BaselineSensitivity - the sensitivity of the baseline.
type BaselineSensitivity string

const (
	BaselineSensitivityHigh   BaselineSensitivity = "High"
	BaselineSensitivityLow    BaselineSensitivity = "Low"
	BaselineSensitivityMedium BaselineSensitivity = "Medium"
)

// PossibleBaselineSensitivityValues returns the possible values for the BaselineSensitivity const type.
func PossibleBaselineSensitivityValues() []BaselineSensitivity {
	return []BaselineSensitivity{
		BaselineSensitivityHigh,
		BaselineSensitivityLow,
		BaselineSensitivityMedium,
	}
}

// ToPtr returns a *BaselineSensitivity pointing to the current value.
func (c BaselineSensitivity) ToPtr() *BaselineSensitivity {
	return &c
}

// CategoryType - The type of the diagnostic settings category.
type CategoryType string

const (
	CategoryTypeMetrics CategoryType = "Metrics"
	CategoryTypeLogs    CategoryType = "Logs"
)

// PossibleCategoryTypeValues returns the possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{
		CategoryTypeMetrics,
		CategoryTypeLogs,
	}
}

// ToPtr returns a *CategoryType pointing to the current value.
func (c CategoryType) ToPtr() *CategoryType {
	return &c
}

// ComparisonOperationType - the operator that is used to compare the metric data and the threshold.
type ComparisonOperationType string

const (
	ComparisonOperationTypeEquals             ComparisonOperationType = "Equals"
	ComparisonOperationTypeNotEquals          ComparisonOperationType = "NotEquals"
	ComparisonOperationTypeGreaterThan        ComparisonOperationType = "GreaterThan"
	ComparisonOperationTypeGreaterThanOrEqual ComparisonOperationType = "GreaterThanOrEqual"
	ComparisonOperationTypeLessThan           ComparisonOperationType = "LessThan"
	ComparisonOperationTypeLessThanOrEqual    ComparisonOperationType = "LessThanOrEqual"
)

// PossibleComparisonOperationTypeValues returns the possible values for the ComparisonOperationType const type.
func PossibleComparisonOperationTypeValues() []ComparisonOperationType {
	return []ComparisonOperationType{
		ComparisonOperationTypeEquals,
		ComparisonOperationTypeNotEquals,
		ComparisonOperationTypeGreaterThan,
		ComparisonOperationTypeGreaterThanOrEqual,
		ComparisonOperationTypeLessThan,
		ComparisonOperationTypeLessThanOrEqual,
	}
}

// ToPtr returns a *ComparisonOperationType pointing to the current value.
func (c ComparisonOperationType) ToPtr() *ComparisonOperationType {
	return &c
}

// ConditionOperator - Operators allowed in the rule condition.
type ConditionOperator string

const (
	ConditionOperatorGreaterThan        ConditionOperator = "GreaterThan"
	ConditionOperatorGreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	ConditionOperatorLessThan           ConditionOperator = "LessThan"
	ConditionOperatorLessThanOrEqual    ConditionOperator = "LessThanOrEqual"
)

// PossibleConditionOperatorValues returns the possible values for the ConditionOperator const type.
func PossibleConditionOperatorValues() []ConditionOperator {
	return []ConditionOperator{
		ConditionOperatorGreaterThan,
		ConditionOperatorGreaterThanOrEqual,
		ConditionOperatorLessThan,
		ConditionOperatorLessThanOrEqual,
	}
}

// ToPtr returns a *ConditionOperator pointing to the current value.
func (c ConditionOperator) ToPtr() *ConditionOperator {
	return &c
}

// ConditionalOperator - Result Condition Evaluation criteria.
type ConditionalOperator string

const (
	ConditionalOperatorEqual              ConditionalOperator = "Equal"
	ConditionalOperatorGreaterThan        ConditionalOperator = "GreaterThan"
	ConditionalOperatorGreaterThanOrEqual ConditionalOperator = "GreaterThanOrEqual"
	ConditionalOperatorLessThan           ConditionalOperator = "LessThan"
	ConditionalOperatorLessThanOrEqual    ConditionalOperator = "LessThanOrEqual"
)

// PossibleConditionalOperatorValues returns the possible values for the ConditionalOperator const type.
func PossibleConditionalOperatorValues() []ConditionalOperator {
	return []ConditionalOperator{
		ConditionalOperatorEqual,
		ConditionalOperatorGreaterThan,
		ConditionalOperatorGreaterThanOrEqual,
		ConditionalOperatorLessThan,
		ConditionalOperatorLessThanOrEqual,
	}
}

// ToPtr returns a *ConditionalOperator pointing to the current value.
func (c ConditionalOperator) ToPtr() *ConditionalOperator {
	return &c
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// ToPtr returns a *CreatedByType pointing to the current value.
func (c CreatedByType) ToPtr() *CreatedByType {
	return &c
}

// CriterionType - Specifies the type of threshold criteria
type CriterionType string

const (
	CriterionTypeDynamicThresholdCriterion CriterionType = "DynamicThresholdCriterion"
	CriterionTypeStaticThresholdCriterion  CriterionType = "StaticThresholdCriterion"
)

// PossibleCriterionTypeValues returns the possible values for the CriterionType const type.
func PossibleCriterionTypeValues() []CriterionType {
	return []CriterionType{
		CriterionTypeDynamicThresholdCriterion,
		CriterionTypeStaticThresholdCriterion,
	}
}

// ToPtr returns a *CriterionType pointing to the current value.
func (c CriterionType) ToPtr() *CriterionType {
	return &c
}

// DataStatus - The status of VM Insights data from the resource. When reported as present the data array will contain information
// about the data containers to which data for the specified resource is being routed.
type DataStatus string

const (
	DataStatusNotPresent DataStatus = "notPresent"
	DataStatusPresent    DataStatus = "present"
)

// PossibleDataStatusValues returns the possible values for the DataStatus const type.
func PossibleDataStatusValues() []DataStatus {
	return []DataStatus{
		DataStatusNotPresent,
		DataStatusPresent,
	}
}

// ToPtr returns a *DataStatus pointing to the current value.
func (c DataStatus) ToPtr() *DataStatus {
	return &c
}

// DynamicThresholdOperator - The operator used to compare the metric value against the threshold.
type DynamicThresholdOperator string

const (
	DynamicThresholdOperatorGreaterOrLessThan DynamicThresholdOperator = "GreaterOrLessThan"
	DynamicThresholdOperatorGreaterThan       DynamicThresholdOperator = "GreaterThan"
	DynamicThresholdOperatorLessThan          DynamicThresholdOperator = "LessThan"
)

// PossibleDynamicThresholdOperatorValues returns the possible values for the DynamicThresholdOperator const type.
func PossibleDynamicThresholdOperatorValues() []DynamicThresholdOperator {
	return []DynamicThresholdOperator{
		DynamicThresholdOperatorGreaterOrLessThan,
		DynamicThresholdOperatorGreaterThan,
		DynamicThresholdOperatorLessThan,
	}
}

// ToPtr returns a *DynamicThresholdOperator pointing to the current value.
func (c DynamicThresholdOperator) ToPtr() *DynamicThresholdOperator {
	return &c
}

// DynamicThresholdSensitivity - The extent of deviation required to trigger an alert. This will affect how tight the threshold
// is to the metric series pattern.
type DynamicThresholdSensitivity string

const (
	DynamicThresholdSensitivityHigh   DynamicThresholdSensitivity = "High"
	DynamicThresholdSensitivityLow    DynamicThresholdSensitivity = "Low"
	DynamicThresholdSensitivityMedium DynamicThresholdSensitivity = "Medium"
)

// PossibleDynamicThresholdSensitivityValues returns the possible values for the DynamicThresholdSensitivity const type.
func PossibleDynamicThresholdSensitivityValues() []DynamicThresholdSensitivity {
	return []DynamicThresholdSensitivity{
		DynamicThresholdSensitivityHigh,
		DynamicThresholdSensitivityLow,
		DynamicThresholdSensitivityMedium,
	}
}

// ToPtr returns a *DynamicThresholdSensitivity pointing to the current value.
func (c DynamicThresholdSensitivity) ToPtr() *DynamicThresholdSensitivity {
	return &c
}

// Enabled - The flag which indicates whether the Log Search rule is enabled. Value should be true or false
type Enabled string

const (
	EnabledFalse Enabled = "false"
	EnabledTrue  Enabled = "true"
)

// PossibleEnabledValues returns the possible values for the Enabled const type.
func PossibleEnabledValues() []Enabled {
	return []Enabled{
		EnabledFalse,
		EnabledTrue,
	}
}

// ToPtr returns a *Enabled pointing to the current value.
func (c Enabled) ToPtr() *Enabled {
	return &c
}

// EventLevel - the event level
type EventLevel string

const (
	EventLevelCritical      EventLevel = "Critical"
	EventLevelError         EventLevel = "Error"
	EventLevelWarning       EventLevel = "Warning"
	EventLevelInformational EventLevel = "Informational"
	EventLevelVerbose       EventLevel = "Verbose"
)

// PossibleEventLevelValues returns the possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{
		EventLevelCritical,
		EventLevelError,
		EventLevelWarning,
		EventLevelInformational,
		EventLevelVerbose,
	}
}

// ToPtr returns a *EventLevel pointing to the current value.
func (c EventLevel) ToPtr() *EventLevel {
	return &c
}

// KnownDataCollectionEndpointProvisioningState - The resource provisioning state. This property is READ-ONLY.
type KnownDataCollectionEndpointProvisioningState string

const (
	KnownDataCollectionEndpointProvisioningStateCreating  KnownDataCollectionEndpointProvisioningState = "Creating"
	KnownDataCollectionEndpointProvisioningStateDeleting  KnownDataCollectionEndpointProvisioningState = "Deleting"
	KnownDataCollectionEndpointProvisioningStateFailed    KnownDataCollectionEndpointProvisioningState = "Failed"
	KnownDataCollectionEndpointProvisioningStateSucceeded KnownDataCollectionEndpointProvisioningState = "Succeeded"
	KnownDataCollectionEndpointProvisioningStateUpdating  KnownDataCollectionEndpointProvisioningState = "Updating"
)

// PossibleKnownDataCollectionEndpointProvisioningStateValues returns the possible values for the KnownDataCollectionEndpointProvisioningState const type.
func PossibleKnownDataCollectionEndpointProvisioningStateValues() []KnownDataCollectionEndpointProvisioningState {
	return []KnownDataCollectionEndpointProvisioningState{
		KnownDataCollectionEndpointProvisioningStateCreating,
		KnownDataCollectionEndpointProvisioningStateDeleting,
		KnownDataCollectionEndpointProvisioningStateFailed,
		KnownDataCollectionEndpointProvisioningStateSucceeded,
		KnownDataCollectionEndpointProvisioningStateUpdating,
	}
}

// ToPtr returns a *KnownDataCollectionEndpointProvisioningState pointing to the current value.
func (c KnownDataCollectionEndpointProvisioningState) ToPtr() *KnownDataCollectionEndpointProvisioningState {
	return &c
}

// KnownDataCollectionEndpointResourceKind - The kind of the resource.
type KnownDataCollectionEndpointResourceKind string

const (
	KnownDataCollectionEndpointResourceKindLinux   KnownDataCollectionEndpointResourceKind = "Linux"
	KnownDataCollectionEndpointResourceKindWindows KnownDataCollectionEndpointResourceKind = "Windows"
)

// PossibleKnownDataCollectionEndpointResourceKindValues returns the possible values for the KnownDataCollectionEndpointResourceKind const type.
func PossibleKnownDataCollectionEndpointResourceKindValues() []KnownDataCollectionEndpointResourceKind {
	return []KnownDataCollectionEndpointResourceKind{
		KnownDataCollectionEndpointResourceKindLinux,
		KnownDataCollectionEndpointResourceKindWindows,
	}
}

// ToPtr returns a *KnownDataCollectionEndpointResourceKind pointing to the current value.
func (c KnownDataCollectionEndpointResourceKind) ToPtr() *KnownDataCollectionEndpointResourceKind {
	return &c
}

// KnownDataCollectionRuleAssociationProvisioningState - The resource provisioning state.
type KnownDataCollectionRuleAssociationProvisioningState string

const (
	KnownDataCollectionRuleAssociationProvisioningStateCreating  KnownDataCollectionRuleAssociationProvisioningState = "Creating"
	KnownDataCollectionRuleAssociationProvisioningStateDeleting  KnownDataCollectionRuleAssociationProvisioningState = "Deleting"
	KnownDataCollectionRuleAssociationProvisioningStateFailed    KnownDataCollectionRuleAssociationProvisioningState = "Failed"
	KnownDataCollectionRuleAssociationProvisioningStateSucceeded KnownDataCollectionRuleAssociationProvisioningState = "Succeeded"
	KnownDataCollectionRuleAssociationProvisioningStateUpdating  KnownDataCollectionRuleAssociationProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleAssociationProvisioningStateValues returns the possible values for the KnownDataCollectionRuleAssociationProvisioningState const type.
func PossibleKnownDataCollectionRuleAssociationProvisioningStateValues() []KnownDataCollectionRuleAssociationProvisioningState {
	return []KnownDataCollectionRuleAssociationProvisioningState{
		KnownDataCollectionRuleAssociationProvisioningStateCreating,
		KnownDataCollectionRuleAssociationProvisioningStateDeleting,
		KnownDataCollectionRuleAssociationProvisioningStateFailed,
		KnownDataCollectionRuleAssociationProvisioningStateSucceeded,
		KnownDataCollectionRuleAssociationProvisioningStateUpdating,
	}
}

// ToPtr returns a *KnownDataCollectionRuleAssociationProvisioningState pointing to the current value.
func (c KnownDataCollectionRuleAssociationProvisioningState) ToPtr() *KnownDataCollectionRuleAssociationProvisioningState {
	return &c
}

// KnownDataCollectionRuleProvisioningState - The resource provisioning state.
type KnownDataCollectionRuleProvisioningState string

const (
	KnownDataCollectionRuleProvisioningStateCreating  KnownDataCollectionRuleProvisioningState = "Creating"
	KnownDataCollectionRuleProvisioningStateDeleting  KnownDataCollectionRuleProvisioningState = "Deleting"
	KnownDataCollectionRuleProvisioningStateFailed    KnownDataCollectionRuleProvisioningState = "Failed"
	KnownDataCollectionRuleProvisioningStateSucceeded KnownDataCollectionRuleProvisioningState = "Succeeded"
	KnownDataCollectionRuleProvisioningStateUpdating  KnownDataCollectionRuleProvisioningState = "Updating"
)

// PossibleKnownDataCollectionRuleProvisioningStateValues returns the possible values for the KnownDataCollectionRuleProvisioningState const type.
func PossibleKnownDataCollectionRuleProvisioningStateValues() []KnownDataCollectionRuleProvisioningState {
	return []KnownDataCollectionRuleProvisioningState{
		KnownDataCollectionRuleProvisioningStateCreating,
		KnownDataCollectionRuleProvisioningStateDeleting,
		KnownDataCollectionRuleProvisioningStateFailed,
		KnownDataCollectionRuleProvisioningStateSucceeded,
		KnownDataCollectionRuleProvisioningStateUpdating,
	}
}

// ToPtr returns a *KnownDataCollectionRuleProvisioningState pointing to the current value.
func (c KnownDataCollectionRuleProvisioningState) ToPtr() *KnownDataCollectionRuleProvisioningState {
	return &c
}

// KnownDataCollectionRuleResourceKind - The kind of the resource.
type KnownDataCollectionRuleResourceKind string

const (
	KnownDataCollectionRuleResourceKindLinux   KnownDataCollectionRuleResourceKind = "Linux"
	KnownDataCollectionRuleResourceKindWindows KnownDataCollectionRuleResourceKind = "Windows"
)

// PossibleKnownDataCollectionRuleResourceKindValues returns the possible values for the KnownDataCollectionRuleResourceKind const type.
func PossibleKnownDataCollectionRuleResourceKindValues() []KnownDataCollectionRuleResourceKind {
	return []KnownDataCollectionRuleResourceKind{
		KnownDataCollectionRuleResourceKindLinux,
		KnownDataCollectionRuleResourceKindWindows,
	}
}

// ToPtr returns a *KnownDataCollectionRuleResourceKind pointing to the current value.
func (c KnownDataCollectionRuleResourceKind) ToPtr() *KnownDataCollectionRuleResourceKind {
	return &c
}

type KnownDataFlowStreams string

const (
	KnownDataFlowStreamsMicrosoftEvent           KnownDataFlowStreams = "Microsoft-Event"
	KnownDataFlowStreamsMicrosoftInsightsMetrics KnownDataFlowStreams = "Microsoft-InsightsMetrics"
	KnownDataFlowStreamsMicrosoftPerf            KnownDataFlowStreams = "Microsoft-Perf"
	KnownDataFlowStreamsMicrosoftSyslog          KnownDataFlowStreams = "Microsoft-Syslog"
	KnownDataFlowStreamsMicrosoftWindowsEvent    KnownDataFlowStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownDataFlowStreamsValues returns the possible values for the KnownDataFlowStreams const type.
func PossibleKnownDataFlowStreamsValues() []KnownDataFlowStreams {
	return []KnownDataFlowStreams{
		KnownDataFlowStreamsMicrosoftEvent,
		KnownDataFlowStreamsMicrosoftInsightsMetrics,
		KnownDataFlowStreamsMicrosoftPerf,
		KnownDataFlowStreamsMicrosoftSyslog,
		KnownDataFlowStreamsMicrosoftWindowsEvent,
	}
}

// ToPtr returns a *KnownDataFlowStreams pointing to the current value.
func (c KnownDataFlowStreams) ToPtr() *KnownDataFlowStreams {
	return &c
}

type KnownExtensionDataSourceStreams string

const (
	KnownExtensionDataSourceStreamsMicrosoftEvent           KnownExtensionDataSourceStreams = "Microsoft-Event"
	KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics KnownExtensionDataSourceStreams = "Microsoft-InsightsMetrics"
	KnownExtensionDataSourceStreamsMicrosoftPerf            KnownExtensionDataSourceStreams = "Microsoft-Perf"
	KnownExtensionDataSourceStreamsMicrosoftSyslog          KnownExtensionDataSourceStreams = "Microsoft-Syslog"
	KnownExtensionDataSourceStreamsMicrosoftWindowsEvent    KnownExtensionDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownExtensionDataSourceStreamsValues returns the possible values for the KnownExtensionDataSourceStreams const type.
func PossibleKnownExtensionDataSourceStreamsValues() []KnownExtensionDataSourceStreams {
	return []KnownExtensionDataSourceStreams{
		KnownExtensionDataSourceStreamsMicrosoftEvent,
		KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics,
		KnownExtensionDataSourceStreamsMicrosoftPerf,
		KnownExtensionDataSourceStreamsMicrosoftSyslog,
		KnownExtensionDataSourceStreamsMicrosoftWindowsEvent,
	}
}

// ToPtr returns a *KnownExtensionDataSourceStreams pointing to the current value.
func (c KnownExtensionDataSourceStreams) ToPtr() *KnownExtensionDataSourceStreams {
	return &c
}

type KnownPerfCounterDataSourceStreams string

const (
	KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics KnownPerfCounterDataSourceStreams = "Microsoft-InsightsMetrics"
	KnownPerfCounterDataSourceStreamsMicrosoftPerf            KnownPerfCounterDataSourceStreams = "Microsoft-Perf"
)

// PossibleKnownPerfCounterDataSourceStreamsValues returns the possible values for the KnownPerfCounterDataSourceStreams const type.
func PossibleKnownPerfCounterDataSourceStreamsValues() []KnownPerfCounterDataSourceStreams {
	return []KnownPerfCounterDataSourceStreams{
		KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics,
		KnownPerfCounterDataSourceStreamsMicrosoftPerf,
	}
}

// ToPtr returns a *KnownPerfCounterDataSourceStreams pointing to the current value.
func (c KnownPerfCounterDataSourceStreams) ToPtr() *KnownPerfCounterDataSourceStreams {
	return &c
}

// KnownPublicNetworkAccessOptions - The configuration to set whether network access from public internet to the endpoints
// are allowed.
type KnownPublicNetworkAccessOptions string

const (
	KnownPublicNetworkAccessOptionsDisabled KnownPublicNetworkAccessOptions = "Disabled"
	KnownPublicNetworkAccessOptionsEnabled  KnownPublicNetworkAccessOptions = "Enabled"
)

// PossibleKnownPublicNetworkAccessOptionsValues returns the possible values for the KnownPublicNetworkAccessOptions const type.
func PossibleKnownPublicNetworkAccessOptionsValues() []KnownPublicNetworkAccessOptions {
	return []KnownPublicNetworkAccessOptions{
		KnownPublicNetworkAccessOptionsDisabled,
		KnownPublicNetworkAccessOptionsEnabled,
	}
}

// ToPtr returns a *KnownPublicNetworkAccessOptions pointing to the current value.
func (c KnownPublicNetworkAccessOptions) ToPtr() *KnownPublicNetworkAccessOptions {
	return &c
}

type KnownSyslogDataSourceFacilityNames string

const (
	KnownSyslogDataSourceFacilityNamesAsterisk KnownSyslogDataSourceFacilityNames = "*"
	KnownSyslogDataSourceFacilityNamesAuth     KnownSyslogDataSourceFacilityNames = "auth"
	KnownSyslogDataSourceFacilityNamesAuthpriv KnownSyslogDataSourceFacilityNames = "authpriv"
	KnownSyslogDataSourceFacilityNamesCron     KnownSyslogDataSourceFacilityNames = "cron"
	KnownSyslogDataSourceFacilityNamesDaemon   KnownSyslogDataSourceFacilityNames = "daemon"
	KnownSyslogDataSourceFacilityNamesKern     KnownSyslogDataSourceFacilityNames = "kern"
	KnownSyslogDataSourceFacilityNamesLocal0   KnownSyslogDataSourceFacilityNames = "local0"
	KnownSyslogDataSourceFacilityNamesLocal1   KnownSyslogDataSourceFacilityNames = "local1"
	KnownSyslogDataSourceFacilityNamesLocal2   KnownSyslogDataSourceFacilityNames = "local2"
	KnownSyslogDataSourceFacilityNamesLocal3   KnownSyslogDataSourceFacilityNames = "local3"
	KnownSyslogDataSourceFacilityNamesLocal4   KnownSyslogDataSourceFacilityNames = "local4"
	KnownSyslogDataSourceFacilityNamesLocal5   KnownSyslogDataSourceFacilityNames = "local5"
	KnownSyslogDataSourceFacilityNamesLocal6   KnownSyslogDataSourceFacilityNames = "local6"
	KnownSyslogDataSourceFacilityNamesLocal7   KnownSyslogDataSourceFacilityNames = "local7"
	KnownSyslogDataSourceFacilityNamesLpr      KnownSyslogDataSourceFacilityNames = "lpr"
	KnownSyslogDataSourceFacilityNamesMail     KnownSyslogDataSourceFacilityNames = "mail"
	KnownSyslogDataSourceFacilityNamesMark     KnownSyslogDataSourceFacilityNames = "mark"
	KnownSyslogDataSourceFacilityNamesNews     KnownSyslogDataSourceFacilityNames = "news"
	KnownSyslogDataSourceFacilityNamesSyslog   KnownSyslogDataSourceFacilityNames = "syslog"
	KnownSyslogDataSourceFacilityNamesUser     KnownSyslogDataSourceFacilityNames = "user"
	KnownSyslogDataSourceFacilityNamesUucp     KnownSyslogDataSourceFacilityNames = "uucp"
)

// PossibleKnownSyslogDataSourceFacilityNamesValues returns the possible values for the KnownSyslogDataSourceFacilityNames const type.
func PossibleKnownSyslogDataSourceFacilityNamesValues() []KnownSyslogDataSourceFacilityNames {
	return []KnownSyslogDataSourceFacilityNames{
		KnownSyslogDataSourceFacilityNamesAsterisk,
		KnownSyslogDataSourceFacilityNamesAuth,
		KnownSyslogDataSourceFacilityNamesAuthpriv,
		KnownSyslogDataSourceFacilityNamesCron,
		KnownSyslogDataSourceFacilityNamesDaemon,
		KnownSyslogDataSourceFacilityNamesKern,
		KnownSyslogDataSourceFacilityNamesLocal0,
		KnownSyslogDataSourceFacilityNamesLocal1,
		KnownSyslogDataSourceFacilityNamesLocal2,
		KnownSyslogDataSourceFacilityNamesLocal3,
		KnownSyslogDataSourceFacilityNamesLocal4,
		KnownSyslogDataSourceFacilityNamesLocal5,
		KnownSyslogDataSourceFacilityNamesLocal6,
		KnownSyslogDataSourceFacilityNamesLocal7,
		KnownSyslogDataSourceFacilityNamesLpr,
		KnownSyslogDataSourceFacilityNamesMail,
		KnownSyslogDataSourceFacilityNamesMark,
		KnownSyslogDataSourceFacilityNamesNews,
		KnownSyslogDataSourceFacilityNamesSyslog,
		KnownSyslogDataSourceFacilityNamesUser,
		KnownSyslogDataSourceFacilityNamesUucp,
	}
}

// ToPtr returns a *KnownSyslogDataSourceFacilityNames pointing to the current value.
func (c KnownSyslogDataSourceFacilityNames) ToPtr() *KnownSyslogDataSourceFacilityNames {
	return &c
}

type KnownSyslogDataSourceLogLevels string

const (
	KnownSyslogDataSourceLogLevelsAlert     KnownSyslogDataSourceLogLevels = "Alert"
	KnownSyslogDataSourceLogLevelsAsterisk  KnownSyslogDataSourceLogLevels = "*"
	KnownSyslogDataSourceLogLevelsCritical  KnownSyslogDataSourceLogLevels = "Critical"
	KnownSyslogDataSourceLogLevelsDebug     KnownSyslogDataSourceLogLevels = "Debug"
	KnownSyslogDataSourceLogLevelsEmergency KnownSyslogDataSourceLogLevels = "Emergency"
	KnownSyslogDataSourceLogLevelsError     KnownSyslogDataSourceLogLevels = "Error"
	KnownSyslogDataSourceLogLevelsInfo      KnownSyslogDataSourceLogLevels = "Info"
	KnownSyslogDataSourceLogLevelsNotice    KnownSyslogDataSourceLogLevels = "Notice"
	KnownSyslogDataSourceLogLevelsWarning   KnownSyslogDataSourceLogLevels = "Warning"
)

// PossibleKnownSyslogDataSourceLogLevelsValues returns the possible values for the KnownSyslogDataSourceLogLevels const type.
func PossibleKnownSyslogDataSourceLogLevelsValues() []KnownSyslogDataSourceLogLevels {
	return []KnownSyslogDataSourceLogLevels{
		KnownSyslogDataSourceLogLevelsAlert,
		KnownSyslogDataSourceLogLevelsAsterisk,
		KnownSyslogDataSourceLogLevelsCritical,
		KnownSyslogDataSourceLogLevelsDebug,
		KnownSyslogDataSourceLogLevelsEmergency,
		KnownSyslogDataSourceLogLevelsError,
		KnownSyslogDataSourceLogLevelsInfo,
		KnownSyslogDataSourceLogLevelsNotice,
		KnownSyslogDataSourceLogLevelsWarning,
	}
}

// ToPtr returns a *KnownSyslogDataSourceLogLevels pointing to the current value.
func (c KnownSyslogDataSourceLogLevels) ToPtr() *KnownSyslogDataSourceLogLevels {
	return &c
}

type KnownSyslogDataSourceStreams string

const (
	KnownSyslogDataSourceStreamsMicrosoftSyslog KnownSyslogDataSourceStreams = "Microsoft-Syslog"
)

// PossibleKnownSyslogDataSourceStreamsValues returns the possible values for the KnownSyslogDataSourceStreams const type.
func PossibleKnownSyslogDataSourceStreamsValues() []KnownSyslogDataSourceStreams {
	return []KnownSyslogDataSourceStreams{
		KnownSyslogDataSourceStreamsMicrosoftSyslog,
	}
}

// ToPtr returns a *KnownSyslogDataSourceStreams pointing to the current value.
func (c KnownSyslogDataSourceStreams) ToPtr() *KnownSyslogDataSourceStreams {
	return &c
}

type KnownWindowsEventLogDataSourceStreams string

const (
	KnownWindowsEventLogDataSourceStreamsMicrosoftEvent        KnownWindowsEventLogDataSourceStreams = "Microsoft-Event"
	KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent KnownWindowsEventLogDataSourceStreams = "Microsoft-WindowsEvent"
)

// PossibleKnownWindowsEventLogDataSourceStreamsValues returns the possible values for the KnownWindowsEventLogDataSourceStreams const type.
func PossibleKnownWindowsEventLogDataSourceStreamsValues() []KnownWindowsEventLogDataSourceStreams {
	return []KnownWindowsEventLogDataSourceStreams{
		KnownWindowsEventLogDataSourceStreamsMicrosoftEvent,
		KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent,
	}
}

// ToPtr returns a *KnownWindowsEventLogDataSourceStreams pointing to the current value.
func (c KnownWindowsEventLogDataSourceStreams) ToPtr() *KnownWindowsEventLogDataSourceStreams {
	return &c
}

// MetricClass - The class of the metric.
type MetricClass string

const (
	MetricClassAvailability MetricClass = "Availability"
	MetricClassErrors       MetricClass = "Errors"
	MetricClassLatency      MetricClass = "Latency"
	MetricClassSaturation   MetricClass = "Saturation"
	MetricClassTransactions MetricClass = "Transactions"
)

// PossibleMetricClassValues returns the possible values for the MetricClass const type.
func PossibleMetricClassValues() []MetricClass {
	return []MetricClass{
		MetricClassAvailability,
		MetricClassErrors,
		MetricClassLatency,
		MetricClassSaturation,
		MetricClassTransactions,
	}
}

// ToPtr returns a *MetricClass pointing to the current value.
func (c MetricClass) ToPtr() *MetricClass {
	return &c
}

// MetricStatisticType - the metric statistic type. How the metrics from multiple instances are combined.
type MetricStatisticType string

const (
	MetricStatisticTypeAverage MetricStatisticType = "Average"
	MetricStatisticTypeMin     MetricStatisticType = "Min"
	MetricStatisticTypeMax     MetricStatisticType = "Max"
	MetricStatisticTypeSum     MetricStatisticType = "Sum"
	MetricStatisticTypeCount   MetricStatisticType = "Count"
)

// PossibleMetricStatisticTypeValues returns the possible values for the MetricStatisticType const type.
func PossibleMetricStatisticTypeValues() []MetricStatisticType {
	return []MetricStatisticType{
		MetricStatisticTypeAverage,
		MetricStatisticTypeMin,
		MetricStatisticTypeMax,
		MetricStatisticTypeSum,
		MetricStatisticTypeCount,
	}
}

// ToPtr returns a *MetricStatisticType pointing to the current value.
func (c MetricStatisticType) ToPtr() *MetricStatisticType {
	return &c
}

// MetricTriggerType - Metric Trigger Evaluation Type
type MetricTriggerType string

const (
	MetricTriggerTypeConsecutive MetricTriggerType = "Consecutive"
	MetricTriggerTypeTotal       MetricTriggerType = "Total"
)

// PossibleMetricTriggerTypeValues returns the possible values for the MetricTriggerType const type.
func PossibleMetricTriggerTypeValues() []MetricTriggerType {
	return []MetricTriggerType{
		MetricTriggerTypeConsecutive,
		MetricTriggerTypeTotal,
	}
}

// ToPtr returns a *MetricTriggerType pointing to the current value.
func (c MetricTriggerType) ToPtr() *MetricTriggerType {
	return &c
}

// MetricUnit - The unit of the metric.
type MetricUnit string

const (
	MetricUnitBitsPerSecond  MetricUnit = "BitsPerSecond"
	MetricUnitByteSeconds    MetricUnit = "ByteSeconds"
	MetricUnitBytes          MetricUnit = "Bytes"
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	MetricUnitCores          MetricUnit = "Cores"
	MetricUnitCount          MetricUnit = "Count"
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	MetricUnitMilliCores     MetricUnit = "MilliCores"
	MetricUnitMilliSeconds   MetricUnit = "MilliSeconds"
	MetricUnitNanoCores      MetricUnit = "NanoCores"
	MetricUnitPercent        MetricUnit = "Percent"
	MetricUnitSeconds        MetricUnit = "Seconds"
	MetricUnitUnspecified    MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBitsPerSecond,
		MetricUnitByteSeconds,
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCores,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitMilliCores,
		MetricUnitMilliSeconds,
		MetricUnitNanoCores,
		MetricUnitPercent,
		MetricUnitSeconds,
		MetricUnitUnspecified,
	}
}

// ToPtr returns a *MetricUnit pointing to the current value.
func (c MetricUnit) ToPtr() *MetricUnit {
	return &c
}

// NamespaceClassification - Kind of namespace
type NamespaceClassification string

const (
	NamespaceClassificationCustom   NamespaceClassification = "Custom"
	NamespaceClassificationPlatform NamespaceClassification = "Platform"
	NamespaceClassificationQos      NamespaceClassification = "Qos"
)

// PossibleNamespaceClassificationValues returns the possible values for the NamespaceClassification const type.
func PossibleNamespaceClassificationValues() []NamespaceClassification {
	return []NamespaceClassification{
		NamespaceClassificationCustom,
		NamespaceClassificationPlatform,
		NamespaceClassificationQos,
	}
}

// ToPtr returns a *NamespaceClassification pointing to the current value.
func (c NamespaceClassification) ToPtr() *NamespaceClassification {
	return &c
}

// Odatatype - specifies the type of the alert criteria.
type Odatatype string

const (
	OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria Odatatype = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria"
	OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria   Odatatype = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria"
	OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria    Odatatype = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"
)

// PossibleOdatatypeValues returns the possible values for the Odatatype const type.
func PossibleOdatatypeValues() []Odatatype {
	return []Odatatype{
		OdatatypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria,
		OdatatypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria,
		OdatatypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria,
	}
}

// ToPtr returns a *Odatatype pointing to the current value.
func (c Odatatype) ToPtr() *Odatatype {
	return &c
}

// OnboardingStatus - The onboarding status for the resource. Note that, a higher level scope, e.g., resource group or subscription,
// is considered onboarded if at least one resource under it is onboarded.
type OnboardingStatus string

const (
	OnboardingStatusNotOnboarded OnboardingStatus = "notOnboarded"
	OnboardingStatusOnboarded    OnboardingStatus = "onboarded"
	OnboardingStatusUnknown      OnboardingStatus = "unknown"
)

// PossibleOnboardingStatusValues returns the possible values for the OnboardingStatus const type.
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return []OnboardingStatus{
		OnboardingStatusNotOnboarded,
		OnboardingStatusOnboarded,
		OnboardingStatusUnknown,
	}
}

// ToPtr returns a *OnboardingStatus pointing to the current value.
func (c OnboardingStatus) ToPtr() *OnboardingStatus {
	return &c
}

// Operator - the criteria operator.
type Operator string

const (
	OperatorEquals             Operator = "Equals"
	OperatorGreaterThan        Operator = "GreaterThan"
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	OperatorInclude            Operator = "Include"
	OperatorLessThan           Operator = "LessThan"
	OperatorLessThanOrEqual    Operator = "LessThanOrEqual"
)

// PossibleOperatorValues returns the possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{
		OperatorEquals,
		OperatorGreaterThan,
		OperatorGreaterThanOrEqual,
		OperatorInclude,
		OperatorLessThan,
		OperatorLessThanOrEqual,
	}
}

// ToPtr returns a *Operator pointing to the current value.
func (c Operator) ToPtr() *Operator {
	return &c
}

// ProvisioningState - Provisioning state of the scheduled query rule
type ProvisioningState string

const (
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateDeploying ProvisioningState = "Deploying"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateDeploying,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
	}
}

// ToPtr returns a *ProvisioningState pointing to the current value.
func (c ProvisioningState) ToPtr() *ProvisioningState {
	return &c
}

// QueryType - Set value to 'ResultAccount'
type QueryType string

const (
	QueryTypeResultCount QueryType = "ResultCount"
)

// PossibleQueryTypeValues returns the possible values for the QueryType const type.
func PossibleQueryTypeValues() []QueryType {
	return []QueryType{
		QueryTypeResultCount,
	}
}

// ToPtr returns a *QueryType pointing to the current value.
func (c QueryType) ToPtr() *QueryType {
	return &c
}

// ReceiverStatus - Indicates the status of the receiver. Receivers that are not Enabled will not receive any communications.
type ReceiverStatus string

const (
	ReceiverStatusNotSpecified ReceiverStatus = "NotSpecified"
	ReceiverStatusEnabled      ReceiverStatus = "Enabled"
	ReceiverStatusDisabled     ReceiverStatus = "Disabled"
)

// PossibleReceiverStatusValues returns the possible values for the ReceiverStatus const type.
func PossibleReceiverStatusValues() []ReceiverStatus {
	return []ReceiverStatus{
		ReceiverStatusNotSpecified,
		ReceiverStatusEnabled,
		ReceiverStatusDisabled,
	}
}

// ToPtr returns a *ReceiverStatus pointing to the current value.
func (c ReceiverStatus) ToPtr() *ReceiverStatus {
	return &c
}

// RecurrenceFrequency - the recurrence frequency. How often the schedule profile should take effect. This value must be Week,
// meaning each week will have the same set of profiles. For example, to set a daily schedule, set
// schedule to every day of the week. The frequency property specifies that the schedule is repeated weekly.
type RecurrenceFrequency string

const (
	RecurrenceFrequencyNone   RecurrenceFrequency = "None"
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	RecurrenceFrequencyHour   RecurrenceFrequency = "Hour"
	RecurrenceFrequencyDay    RecurrenceFrequency = "Day"
	RecurrenceFrequencyWeek   RecurrenceFrequency = "Week"
	RecurrenceFrequencyMonth  RecurrenceFrequency = "Month"
	RecurrenceFrequencyYear   RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns the possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{
		RecurrenceFrequencyNone,
		RecurrenceFrequencySecond,
		RecurrenceFrequencyMinute,
		RecurrenceFrequencyHour,
		RecurrenceFrequencyDay,
		RecurrenceFrequencyWeek,
		RecurrenceFrequencyMonth,
		RecurrenceFrequencyYear,
	}
}

// ToPtr returns a *RecurrenceFrequency pointing to the current value.
func (c RecurrenceFrequency) ToPtr() *RecurrenceFrequency {
	return &c
}

type ResultType string

const (
	ResultTypeData     ResultType = "Data"
	ResultTypeMetadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns the possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{
		ResultTypeData,
		ResultTypeMetadata,
	}
}

// ToPtr returns a *ResultType pointing to the current value.
func (c ResultType) ToPtr() *ResultType {
	return &c
}

// ScaleDirection - the scale direction. Whether the scaling action increases or decreases the number of instances.
type ScaleDirection string

const (
	ScaleDirectionNone     ScaleDirection = "None"
	ScaleDirectionIncrease ScaleDirection = "Increase"
	ScaleDirectionDecrease ScaleDirection = "Decrease"
)

// PossibleScaleDirectionValues returns the possible values for the ScaleDirection const type.
func PossibleScaleDirectionValues() []ScaleDirection {
	return []ScaleDirection{
		ScaleDirectionNone,
		ScaleDirectionIncrease,
		ScaleDirectionDecrease,
	}
}

// ToPtr returns a *ScaleDirection pointing to the current value.
func (c ScaleDirection) ToPtr() *ScaleDirection {
	return &c
}

// ScaleRuleMetricDimensionOperationType - the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being
// equal to any of the values. 'NotEquals' being not equal to all of the values
type ScaleRuleMetricDimensionOperationType string

const (
	ScaleRuleMetricDimensionOperationTypeEquals    ScaleRuleMetricDimensionOperationType = "Equals"
	ScaleRuleMetricDimensionOperationTypeNotEquals ScaleRuleMetricDimensionOperationType = "NotEquals"
)

// PossibleScaleRuleMetricDimensionOperationTypeValues returns the possible values for the ScaleRuleMetricDimensionOperationType const type.
func PossibleScaleRuleMetricDimensionOperationTypeValues() []ScaleRuleMetricDimensionOperationType {
	return []ScaleRuleMetricDimensionOperationType{
		ScaleRuleMetricDimensionOperationTypeEquals,
		ScaleRuleMetricDimensionOperationTypeNotEquals,
	}
}

// ToPtr returns a *ScaleRuleMetricDimensionOperationType pointing to the current value.
func (c ScaleRuleMetricDimensionOperationType) ToPtr() *ScaleRuleMetricDimensionOperationType {
	return &c
}

// ScaleType - the type of action that should occur when the scale rule fires.
type ScaleType string

const (
	ScaleTypeChangeCount             ScaleType = "ChangeCount"
	ScaleTypePercentChangeCount      ScaleType = "PercentChangeCount"
	ScaleTypeExactCount              ScaleType = "ExactCount"
	ScaleTypeServiceAllowedNextValue ScaleType = "ServiceAllowedNextValue"
)

// PossibleScaleTypeValues returns the possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{
		ScaleTypeChangeCount,
		ScaleTypePercentChangeCount,
		ScaleTypeExactCount,
		ScaleTypeServiceAllowedNextValue,
	}
}

// ToPtr returns a *ScaleType pointing to the current value.
func (c ScaleType) ToPtr() *ScaleType {
	return &c
}

// TimeAggregationOperator - Aggregation operators allowed in a rule.
type TimeAggregationOperator string

const (
	TimeAggregationOperatorAverage TimeAggregationOperator = "Average"
	TimeAggregationOperatorMinimum TimeAggregationOperator = "Minimum"
	TimeAggregationOperatorMaximum TimeAggregationOperator = "Maximum"
	TimeAggregationOperatorTotal   TimeAggregationOperator = "Total"
	TimeAggregationOperatorLast    TimeAggregationOperator = "Last"
)

// PossibleTimeAggregationOperatorValues returns the possible values for the TimeAggregationOperator const type.
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return []TimeAggregationOperator{
		TimeAggregationOperatorAverage,
		TimeAggregationOperatorMinimum,
		TimeAggregationOperatorMaximum,
		TimeAggregationOperatorTotal,
		TimeAggregationOperatorLast,
	}
}

// ToPtr returns a *TimeAggregationOperator pointing to the current value.
func (c TimeAggregationOperator) ToPtr() *TimeAggregationOperator {
	return &c
}

// TimeAggregationType - time aggregation type. How the data that is collected should be combined over time. The default value
// is Average.
type TimeAggregationType string

const (
	TimeAggregationTypeAverage TimeAggregationType = "Average"
	TimeAggregationTypeMinimum TimeAggregationType = "Minimum"
	TimeAggregationTypeMaximum TimeAggregationType = "Maximum"
	TimeAggregationTypeTotal   TimeAggregationType = "Total"
	TimeAggregationTypeCount   TimeAggregationType = "Count"
	TimeAggregationTypeLast    TimeAggregationType = "Last"
)

// PossibleTimeAggregationTypeValues returns the possible values for the TimeAggregationType const type.
func PossibleTimeAggregationTypeValues() []TimeAggregationType {
	return []TimeAggregationType{
		TimeAggregationTypeAverage,
		TimeAggregationTypeMinimum,
		TimeAggregationTypeMaximum,
		TimeAggregationTypeTotal,
		TimeAggregationTypeCount,
		TimeAggregationTypeLast,
	}
}

// ToPtr returns a *TimeAggregationType pointing to the current value.
func (c TimeAggregationType) ToPtr() *TimeAggregationType {
	return &c
}
