# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_platform_software(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-software - based on the path /openconfig-platform-software. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines data related to software components in
 the openconfig-platform model
  """
  _pyangbind_elements = {}

  

class openconfig_platform_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-types - based on the path /openconfig-platform-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines data types (e.g., YANG identities)
to support the OpenConfig component inventory model.
  """
  _pyangbind_elements = {}

  

class openconfig_platform_fan(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-fan - based on the path /openconfig-platform-fan. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines data related to FAN components in the
OpenConfig platform model.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_platform__components_component_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each component
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/config/name (string)

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_last_switchover_reason_openconfig_platform__components_component_state_last_switchover_reason(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/last-switchover-reason. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
  """
  __slots__ = ('_path_helper', '_extmethods', '__trigger','__details',)

  _yang_name = 'last-switchover-reason'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__trigger = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)
    self.__details = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'last-switchover-reason']

  def _get_trigger(self):
    """
    Getter method for trigger, mapped from YANG variable /components/component/state/last_switchover_reason/trigger (component-redundant-role-switchover-reason-trigger)

    YANG Description: Records the generic triggers, e.g. user or system
initiated the switchover.
    """
    return self.__trigger
      
  def _set_trigger(self, v, load=False):
    """
    Setter method for trigger, mapped from YANG variable /components/component/state/last_switchover_reason/trigger (component-redundant-role-switchover-reason-trigger)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_trigger is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_trigger() directly.

    YANG Description: Records the generic triggers, e.g. user or system
initiated the switchover.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """trigger must be of a type compatible with component-redundant-role-switchover-reason-trigger""",
          'defined-type': "openconfig-platform:component-redundant-role-switchover-reason-trigger",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)""",
        })

    self.__trigger = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_trigger(self):
    self.__trigger = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)


  def _get_details(self):
    """
    Getter method for details, mapped from YANG variable /components/component/state/last_switchover_reason/details (string)

    YANG Description: Records detailed description of why the switchover happens.
For example, when system initiated the switchover, this leaf
can be used to record the specific reason, e.g. due to critical
errors of the routing daemon in the primary role.
    """
    return self.__details
      
  def _set_details(self, v, load=False):
    """
    Setter method for details, mapped from YANG variable /components/component/state/last_switchover_reason/details (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_details is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_details() directly.

    YANG Description: Records detailed description of why the switchover happens.
For example, when system initiated the switchover, this leaf
can be used to record the specific reason, e.g. due to critical
errors of the routing daemon in the primary role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """details must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__details = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_details(self):
    self.__details = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)

  trigger = __builtin__.property(_get_trigger)
  details = __builtin__.property(_get_details)


  _pyangbind_elements = OrderedDict([('trigger', trigger), ('details', details), ])


class yc_temperature_openconfig_platform__components_component_state_temperature(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/temperature. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Temperature in degrees Celsius of the component. Values include
the instantaneous, average, minimum, and maximum statistics. If
avg/min/max statistics are not supported, the target is expected
to just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time','__alarm_status','__alarm_threshold','__alarm_severity',)

  _yang_name = 'temperature'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__alarm_status = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="alarm-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__alarm_threshold = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="alarm-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    self.__alarm_severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="alarm-severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'temperature']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /components/component/state/temperature/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /components/component/state/temperature/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /components/component/state/temperature/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
sampling period.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /components/component/state/temperature/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
sampling period.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /components/component/state/temperature/min (decimal64)

    YANG Description: The minimum value of the statistic over the sampling
period
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /components/component/state/temperature/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the sampling
period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /components/component/state/temperature/max (decimal64)

    YANG Description: The maximum value of the statistic over the sampling
period
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /components/component/state/temperature/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the sampling
period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=1), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /components/component/state/temperature/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /components/component/state/temperature/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /components/component/state/temperature/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /components/component/state/temperature/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /components/component/state/temperature/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /components/component/state/temperature/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_alarm_status(self):
    """
    Getter method for alarm_status, mapped from YANG variable /components/component/state/temperature/alarm_status (boolean)

    YANG Description: A value of true indicates the alarm has been raised or
asserted.  The value should be false when the alarm is
cleared.
    """
    return self.__alarm_status
      
  def _set_alarm_status(self, v, load=False):
    """
    Setter method for alarm_status, mapped from YANG variable /components/component/state/temperature/alarm_status (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_alarm_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_alarm_status() directly.

    YANG Description: A value of true indicates the alarm has been raised or
asserted.  The value should be false when the alarm is
cleared.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="alarm-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """alarm_status must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="alarm-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__alarm_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_alarm_status(self):
    self.__alarm_status = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="alarm-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_alarm_threshold(self):
    """
    Getter method for alarm_threshold, mapped from YANG variable /components/component/state/temperature/alarm_threshold (uint32)

    YANG Description: The threshold value that was crossed for this alarm.
    """
    return self.__alarm_threshold
      
  def _set_alarm_threshold(self, v, load=False):
    """
    Setter method for alarm_threshold, mapped from YANG variable /components/component/state/temperature/alarm_threshold (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_alarm_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_alarm_threshold() directly.

    YANG Description: The threshold value that was crossed for this alarm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="alarm-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """alarm_threshold must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="alarm-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)""",
        })

    self.__alarm_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_alarm_threshold(self):
    self.__alarm_threshold = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="alarm-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)


  def _get_alarm_severity(self):
    """
    Getter method for alarm_severity, mapped from YANG variable /components/component/state/temperature/alarm_severity (identityref)

    YANG Description: The severity of the current alarm.
    """
    return self.__alarm_severity
      
  def _set_alarm_severity(self, v, load=False):
    """
    Setter method for alarm_severity, mapped from YANG variable /components/component/state/temperature/alarm_severity (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_alarm_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_alarm_severity() directly.

    YANG Description: The severity of the current alarm.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="alarm-severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """alarm_severity must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="alarm-severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)""",
        })

    self.__alarm_severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_alarm_severity(self):
    self.__alarm_severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="alarm-severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)
  alarm_status = __builtin__.property(_get_alarm_status)
  alarm_threshold = __builtin__.property(_get_alarm_threshold)
  alarm_severity = __builtin__.property(_get_alarm_severity)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ('alarm_status', alarm_status), ('alarm_threshold', alarm_threshold), ('alarm_severity', alarm_severity), ])


class yc_memory_openconfig_platform__components_component_state_memory(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/memory. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
  """
  __slots__ = ('_path_helper', '_extmethods', '__available','__utilized',)

  _yang_name = 'memory'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'memory']

  def _get_available(self):
    """
    Getter method for available, mapped from YANG variable /components/component/state/memory/available (uint64)

    YANG Description: The available memory physically installed, or logically
allocated to the component.
    """
    return self.__available
      
  def _set_available(self, v, load=False):
    """
    Setter method for available, mapped from YANG variable /components/component/state/memory/available (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_available is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_available() directly.

    YANG Description: The available memory physically installed, or logically
allocated to the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """available must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__available = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_available(self):
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_utilized(self):
    """
    Getter method for utilized, mapped from YANG variable /components/component/state/memory/utilized (uint64)

    YANG Description: The memory currently in use by processes running on
the component, not considering reserved memory that is
not available for use.
    """
    return self.__utilized
      
  def _set_utilized(self, v, load=False):
    """
    Setter method for utilized, mapped from YANG variable /components/component/state/memory/utilized (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilized is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilized() directly.

    YANG Description: The memory currently in use by processes running on
the component, not considering reserved memory that is
not available for use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilized must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__utilized = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilized(self):
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)

  available = __builtin__.property(_get_available)
  utilized = __builtin__.property(_get_utilized)


  _pyangbind_elements = OrderedDict([('available', available), ('utilized', utilized), ])


class yc_fatal_errors_openconfig_platform__components_component_state_pcie_fatal_errors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/pcie/fatal-errors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The count of the fatal PCIe errors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_errors','__undefined_errors','__data_link_errors','__surprise_down_errors','__poisoned_tlp_errors','__flow_control_protocol_errors','__completion_timeout_errors','__completion_abort_errors','__unexpected_completion_errors','__receiver_overflow_errors','__malformed_tlp_errors','__ecrc_errors','__unsupported_request_errors','__acs_violation_errors','__internal_errors','__blocked_tlp_errors','__atomic_op_blocked_errors','__tlp_prefix_blocked_errors',)

  _yang_name = 'fatal-errors'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie', 'fatal-errors']

  def _get_total_errors(self):
    """
    Getter method for total_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/total_errors (oc-yang:counter64)

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__total_errors
      
  def _set_total_errors(self, v, load=False):
    """
    Setter method for total_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/total_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_errors() directly.

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__total_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_errors(self):
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_undefined_errors(self):
    """
    Getter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/undefined_errors (oc-yang:counter64)

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__undefined_errors
      
  def _set_undefined_errors(self, v, load=False):
    """
    Setter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/undefined_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_undefined_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_undefined_errors() directly.

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """undefined_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__undefined_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_undefined_errors(self):
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_data_link_errors(self):
    """
    Getter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/data_link_errors (oc-yang:counter64)

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__data_link_errors
      
  def _set_data_link_errors(self, v, load=False):
    """
    Setter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/data_link_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_errors() directly.

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__data_link_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_errors(self):
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_surprise_down_errors(self):
    """
    Getter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/surprise_down_errors (oc-yang:counter64)

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__surprise_down_errors
      
  def _set_surprise_down_errors(self, v, load=False):
    """
    Setter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/surprise_down_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_surprise_down_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_surprise_down_errors() directly.

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """surprise_down_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__surprise_down_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_surprise_down_errors(self):
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_poisoned_tlp_errors(self):
    """
    Getter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/poisoned_tlp_errors (oc-yang:counter64)

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__poisoned_tlp_errors
      
  def _set_poisoned_tlp_errors(self, v, load=False):
    """
    Setter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/poisoned_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_poisoned_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_poisoned_tlp_errors() directly.

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """poisoned_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__poisoned_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_poisoned_tlp_errors(self):
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_flow_control_protocol_errors(self):
    """
    Getter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/flow_control_protocol_errors (oc-yang:counter64)

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__flow_control_protocol_errors
      
  def _set_flow_control_protocol_errors(self, v, load=False):
    """
    Setter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/flow_control_protocol_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flow_control_protocol_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flow_control_protocol_errors() directly.

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flow_control_protocol_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__flow_control_protocol_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flow_control_protocol_errors(self):
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_timeout_errors(self):
    """
    Getter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_timeout_errors (oc-yang:counter64)

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_timeout_errors
      
  def _set_completion_timeout_errors(self, v, load=False):
    """
    Setter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_timeout_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_timeout_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_timeout_errors() directly.

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_timeout_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_timeout_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_timeout_errors(self):
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_abort_errors(self):
    """
    Getter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_abort_errors (oc-yang:counter64)

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_abort_errors
      
  def _set_completion_abort_errors(self, v, load=False):
    """
    Setter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_abort_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_abort_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_abort_errors() directly.

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_abort_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_abort_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_abort_errors(self):
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unexpected_completion_errors(self):
    """
    Getter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unexpected_completion_errors (oc-yang:counter64)

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unexpected_completion_errors
      
  def _set_unexpected_completion_errors(self, v, load=False):
    """
    Setter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unexpected_completion_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unexpected_completion_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unexpected_completion_errors() directly.

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unexpected_completion_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unexpected_completion_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unexpected_completion_errors(self):
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_receiver_overflow_errors(self):
    """
    Getter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/receiver_overflow_errors (oc-yang:counter64)

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__receiver_overflow_errors
      
  def _set_receiver_overflow_errors(self, v, load=False):
    """
    Setter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/receiver_overflow_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receiver_overflow_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receiver_overflow_errors() directly.

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receiver_overflow_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__receiver_overflow_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receiver_overflow_errors(self):
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_malformed_tlp_errors(self):
    """
    Getter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/malformed_tlp_errors (oc-yang:counter64)

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__malformed_tlp_errors
      
  def _set_malformed_tlp_errors(self, v, load=False):
    """
    Setter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/malformed_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_malformed_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_malformed_tlp_errors() directly.

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """malformed_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__malformed_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_malformed_tlp_errors(self):
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_ecrc_errors(self):
    """
    Getter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/ecrc_errors (oc-yang:counter64)

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    return self.__ecrc_errors
      
  def _set_ecrc_errors(self, v, load=False):
    """
    Setter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/ecrc_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ecrc_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ecrc_errors() directly.

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ecrc_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__ecrc_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ecrc_errors(self):
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unsupported_request_errors(self):
    """
    Getter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unsupported_request_errors (oc-yang:counter64)

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unsupported_request_errors
      
  def _set_unsupported_request_errors(self, v, load=False):
    """
    Setter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unsupported_request_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unsupported_request_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unsupported_request_errors() directly.

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unsupported_request_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unsupported_request_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unsupported_request_errors(self):
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_acs_violation_errors(self):
    """
    Getter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/acs_violation_errors (oc-yang:counter64)

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__acs_violation_errors
      
  def _set_acs_violation_errors(self, v, load=False):
    """
    Setter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/acs_violation_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acs_violation_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acs_violation_errors() directly.

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acs_violation_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__acs_violation_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acs_violation_errors(self):
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_internal_errors(self):
    """
    Getter method for internal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/internal_errors (oc-yang:counter64)

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__internal_errors
      
  def _set_internal_errors(self, v, load=False):
    """
    Setter method for internal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/internal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_internal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_internal_errors() directly.

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """internal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__internal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_internal_errors(self):
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_blocked_tlp_errors(self):
    """
    Getter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/blocked_tlp_errors (oc-yang:counter64)

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__blocked_tlp_errors
      
  def _set_blocked_tlp_errors(self, v, load=False):
    """
    Setter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/blocked_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_blocked_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_blocked_tlp_errors() directly.

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """blocked_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__blocked_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_blocked_tlp_errors(self):
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_atomic_op_blocked_errors(self):
    """
    Getter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    return self.__atomic_op_blocked_errors
      
  def _set_atomic_op_blocked_errors(self, v, load=False):
    """
    Setter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_atomic_op_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_atomic_op_blocked_errors() directly.

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """atomic_op_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__atomic_op_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_atomic_op_blocked_errors(self):
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_tlp_prefix_blocked_errors(self):
    """
    Getter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__tlp_prefix_blocked_errors
      
  def _set_tlp_prefix_blocked_errors(self, v, load=False):
    """
    Setter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlp_prefix_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlp_prefix_blocked_errors() directly.

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlp_prefix_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tlp_prefix_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlp_prefix_blocked_errors(self):
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

  total_errors = __builtin__.property(_get_total_errors)
  undefined_errors = __builtin__.property(_get_undefined_errors)
  data_link_errors = __builtin__.property(_get_data_link_errors)
  surprise_down_errors = __builtin__.property(_get_surprise_down_errors)
  poisoned_tlp_errors = __builtin__.property(_get_poisoned_tlp_errors)
  flow_control_protocol_errors = __builtin__.property(_get_flow_control_protocol_errors)
  completion_timeout_errors = __builtin__.property(_get_completion_timeout_errors)
  completion_abort_errors = __builtin__.property(_get_completion_abort_errors)
  unexpected_completion_errors = __builtin__.property(_get_unexpected_completion_errors)
  receiver_overflow_errors = __builtin__.property(_get_receiver_overflow_errors)
  malformed_tlp_errors = __builtin__.property(_get_malformed_tlp_errors)
  ecrc_errors = __builtin__.property(_get_ecrc_errors)
  unsupported_request_errors = __builtin__.property(_get_unsupported_request_errors)
  acs_violation_errors = __builtin__.property(_get_acs_violation_errors)
  internal_errors = __builtin__.property(_get_internal_errors)
  blocked_tlp_errors = __builtin__.property(_get_blocked_tlp_errors)
  atomic_op_blocked_errors = __builtin__.property(_get_atomic_op_blocked_errors)
  tlp_prefix_blocked_errors = __builtin__.property(_get_tlp_prefix_blocked_errors)


  _pyangbind_elements = OrderedDict([('total_errors', total_errors), ('undefined_errors', undefined_errors), ('data_link_errors', data_link_errors), ('surprise_down_errors', surprise_down_errors), ('poisoned_tlp_errors', poisoned_tlp_errors), ('flow_control_protocol_errors', flow_control_protocol_errors), ('completion_timeout_errors', completion_timeout_errors), ('completion_abort_errors', completion_abort_errors), ('unexpected_completion_errors', unexpected_completion_errors), ('receiver_overflow_errors', receiver_overflow_errors), ('malformed_tlp_errors', malformed_tlp_errors), ('ecrc_errors', ecrc_errors), ('unsupported_request_errors', unsupported_request_errors), ('acs_violation_errors', acs_violation_errors), ('internal_errors', internal_errors), ('blocked_tlp_errors', blocked_tlp_errors), ('atomic_op_blocked_errors', atomic_op_blocked_errors), ('tlp_prefix_blocked_errors', tlp_prefix_blocked_errors), ])


class yc_non_fatal_errors_openconfig_platform__components_component_state_pcie_non_fatal_errors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/pcie/non-fatal-errors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The count of the non-fatal PCIe errors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_errors','__undefined_errors','__data_link_errors','__surprise_down_errors','__poisoned_tlp_errors','__flow_control_protocol_errors','__completion_timeout_errors','__completion_abort_errors','__unexpected_completion_errors','__receiver_overflow_errors','__malformed_tlp_errors','__ecrc_errors','__unsupported_request_errors','__acs_violation_errors','__internal_errors','__blocked_tlp_errors','__atomic_op_blocked_errors','__tlp_prefix_blocked_errors',)

  _yang_name = 'non-fatal-errors'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie', 'non-fatal-errors']

  def _get_total_errors(self):
    """
    Getter method for total_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/total_errors (oc-yang:counter64)

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__total_errors
      
  def _set_total_errors(self, v, load=False):
    """
    Setter method for total_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/total_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_errors() directly.

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__total_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_errors(self):
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_undefined_errors(self):
    """
    Getter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/undefined_errors (oc-yang:counter64)

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__undefined_errors
      
  def _set_undefined_errors(self, v, load=False):
    """
    Setter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/undefined_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_undefined_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_undefined_errors() directly.

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """undefined_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__undefined_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_undefined_errors(self):
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_data_link_errors(self):
    """
    Getter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/data_link_errors (oc-yang:counter64)

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__data_link_errors
      
  def _set_data_link_errors(self, v, load=False):
    """
    Setter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/data_link_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_errors() directly.

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__data_link_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_errors(self):
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_surprise_down_errors(self):
    """
    Getter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/surprise_down_errors (oc-yang:counter64)

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__surprise_down_errors
      
  def _set_surprise_down_errors(self, v, load=False):
    """
    Setter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/surprise_down_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_surprise_down_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_surprise_down_errors() directly.

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """surprise_down_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__surprise_down_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_surprise_down_errors(self):
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_poisoned_tlp_errors(self):
    """
    Getter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/poisoned_tlp_errors (oc-yang:counter64)

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__poisoned_tlp_errors
      
  def _set_poisoned_tlp_errors(self, v, load=False):
    """
    Setter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/poisoned_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_poisoned_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_poisoned_tlp_errors() directly.

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """poisoned_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__poisoned_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_poisoned_tlp_errors(self):
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_flow_control_protocol_errors(self):
    """
    Getter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/flow_control_protocol_errors (oc-yang:counter64)

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__flow_control_protocol_errors
      
  def _set_flow_control_protocol_errors(self, v, load=False):
    """
    Setter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/flow_control_protocol_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flow_control_protocol_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flow_control_protocol_errors() directly.

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flow_control_protocol_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__flow_control_protocol_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flow_control_protocol_errors(self):
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_timeout_errors(self):
    """
    Getter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/completion_timeout_errors (oc-yang:counter64)

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_timeout_errors
      
  def _set_completion_timeout_errors(self, v, load=False):
    """
    Setter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/completion_timeout_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_timeout_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_timeout_errors() directly.

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_timeout_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_timeout_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_timeout_errors(self):
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_abort_errors(self):
    """
    Getter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/completion_abort_errors (oc-yang:counter64)

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_abort_errors
      
  def _set_completion_abort_errors(self, v, load=False):
    """
    Setter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/completion_abort_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_abort_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_abort_errors() directly.

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_abort_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_abort_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_abort_errors(self):
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unexpected_completion_errors(self):
    """
    Getter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/unexpected_completion_errors (oc-yang:counter64)

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unexpected_completion_errors
      
  def _set_unexpected_completion_errors(self, v, load=False):
    """
    Setter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/unexpected_completion_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unexpected_completion_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unexpected_completion_errors() directly.

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unexpected_completion_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unexpected_completion_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unexpected_completion_errors(self):
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_receiver_overflow_errors(self):
    """
    Getter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/receiver_overflow_errors (oc-yang:counter64)

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__receiver_overflow_errors
      
  def _set_receiver_overflow_errors(self, v, load=False):
    """
    Setter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/receiver_overflow_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receiver_overflow_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receiver_overflow_errors() directly.

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receiver_overflow_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__receiver_overflow_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receiver_overflow_errors(self):
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_malformed_tlp_errors(self):
    """
    Getter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/malformed_tlp_errors (oc-yang:counter64)

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__malformed_tlp_errors
      
  def _set_malformed_tlp_errors(self, v, load=False):
    """
    Setter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/malformed_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_malformed_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_malformed_tlp_errors() directly.

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """malformed_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__malformed_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_malformed_tlp_errors(self):
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_ecrc_errors(self):
    """
    Getter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/ecrc_errors (oc-yang:counter64)

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    return self.__ecrc_errors
      
  def _set_ecrc_errors(self, v, load=False):
    """
    Setter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/ecrc_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ecrc_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ecrc_errors() directly.

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ecrc_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__ecrc_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ecrc_errors(self):
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unsupported_request_errors(self):
    """
    Getter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/unsupported_request_errors (oc-yang:counter64)

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unsupported_request_errors
      
  def _set_unsupported_request_errors(self, v, load=False):
    """
    Setter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/unsupported_request_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unsupported_request_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unsupported_request_errors() directly.

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unsupported_request_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unsupported_request_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unsupported_request_errors(self):
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_acs_violation_errors(self):
    """
    Getter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/acs_violation_errors (oc-yang:counter64)

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__acs_violation_errors
      
  def _set_acs_violation_errors(self, v, load=False):
    """
    Setter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/acs_violation_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acs_violation_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acs_violation_errors() directly.

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acs_violation_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__acs_violation_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acs_violation_errors(self):
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_internal_errors(self):
    """
    Getter method for internal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/internal_errors (oc-yang:counter64)

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__internal_errors
      
  def _set_internal_errors(self, v, load=False):
    """
    Setter method for internal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/internal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_internal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_internal_errors() directly.

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """internal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__internal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_internal_errors(self):
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_blocked_tlp_errors(self):
    """
    Getter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/blocked_tlp_errors (oc-yang:counter64)

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__blocked_tlp_errors
      
  def _set_blocked_tlp_errors(self, v, load=False):
    """
    Setter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/blocked_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_blocked_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_blocked_tlp_errors() directly.

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """blocked_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__blocked_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_blocked_tlp_errors(self):
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_atomic_op_blocked_errors(self):
    """
    Getter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    return self.__atomic_op_blocked_errors
      
  def _set_atomic_op_blocked_errors(self, v, load=False):
    """
    Setter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_atomic_op_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_atomic_op_blocked_errors() directly.

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """atomic_op_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__atomic_op_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_atomic_op_blocked_errors(self):
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_tlp_prefix_blocked_errors(self):
    """
    Getter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__tlp_prefix_blocked_errors
      
  def _set_tlp_prefix_blocked_errors(self, v, load=False):
    """
    Setter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlp_prefix_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlp_prefix_blocked_errors() directly.

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlp_prefix_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tlp_prefix_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlp_prefix_blocked_errors(self):
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

  total_errors = __builtin__.property(_get_total_errors)
  undefined_errors = __builtin__.property(_get_undefined_errors)
  data_link_errors = __builtin__.property(_get_data_link_errors)
  surprise_down_errors = __builtin__.property(_get_surprise_down_errors)
  poisoned_tlp_errors = __builtin__.property(_get_poisoned_tlp_errors)
  flow_control_protocol_errors = __builtin__.property(_get_flow_control_protocol_errors)
  completion_timeout_errors = __builtin__.property(_get_completion_timeout_errors)
  completion_abort_errors = __builtin__.property(_get_completion_abort_errors)
  unexpected_completion_errors = __builtin__.property(_get_unexpected_completion_errors)
  receiver_overflow_errors = __builtin__.property(_get_receiver_overflow_errors)
  malformed_tlp_errors = __builtin__.property(_get_malformed_tlp_errors)
  ecrc_errors = __builtin__.property(_get_ecrc_errors)
  unsupported_request_errors = __builtin__.property(_get_unsupported_request_errors)
  acs_violation_errors = __builtin__.property(_get_acs_violation_errors)
  internal_errors = __builtin__.property(_get_internal_errors)
  blocked_tlp_errors = __builtin__.property(_get_blocked_tlp_errors)
  atomic_op_blocked_errors = __builtin__.property(_get_atomic_op_blocked_errors)
  tlp_prefix_blocked_errors = __builtin__.property(_get_tlp_prefix_blocked_errors)


  _pyangbind_elements = OrderedDict([('total_errors', total_errors), ('undefined_errors', undefined_errors), ('data_link_errors', data_link_errors), ('surprise_down_errors', surprise_down_errors), ('poisoned_tlp_errors', poisoned_tlp_errors), ('flow_control_protocol_errors', flow_control_protocol_errors), ('completion_timeout_errors', completion_timeout_errors), ('completion_abort_errors', completion_abort_errors), ('unexpected_completion_errors', unexpected_completion_errors), ('receiver_overflow_errors', receiver_overflow_errors), ('malformed_tlp_errors', malformed_tlp_errors), ('ecrc_errors', ecrc_errors), ('unsupported_request_errors', unsupported_request_errors), ('acs_violation_errors', acs_violation_errors), ('internal_errors', internal_errors), ('blocked_tlp_errors', blocked_tlp_errors), ('atomic_op_blocked_errors', atomic_op_blocked_errors), ('tlp_prefix_blocked_errors', tlp_prefix_blocked_errors), ])


class yc_correctable_errors_openconfig_platform__components_component_state_pcie_correctable_errors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/pcie/correctable-errors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The count of the correctable PCIe errors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_errors','__receiver_errors','__bad_tlp_errors','__bad_dllp_errors','__relay_rollover_errors','__replay_timeout_errors','__advisory_non_fatal_errors','__internal_errors','__hdr_log_overflow_errors',)

  _yang_name = 'correctable-errors'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__receiver_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__bad_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__bad_dllp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__relay_rollover_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__replay_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__advisory_non_fatal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__hdr_log_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie', 'correctable-errors']

  def _get_total_errors(self):
    """
    Getter method for total_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/total_errors (oc-yang:counter64)

    YANG Description: Total number of correctable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__total_errors
      
  def _set_total_errors(self, v, load=False):
    """
    Setter method for total_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/total_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_errors() directly.

    YANG Description: Total number of correctable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__total_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_errors(self):
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_receiver_errors(self):
    """
    Getter method for receiver_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/receiver_errors (oc-yang:counter64)

    YANG Description: Number of receiver errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__receiver_errors
      
  def _set_receiver_errors(self, v, load=False):
    """
    Setter method for receiver_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/receiver_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receiver_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receiver_errors() directly.

    YANG Description: Number of receiver errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receiver_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__receiver_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receiver_errors(self):
    self.__receiver_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_bad_tlp_errors(self):
    """
    Getter method for bad_tlp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_tlp_errors (oc-yang:counter64)

    YANG Description: Number of TLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__bad_tlp_errors
      
  def _set_bad_tlp_errors(self, v, load=False):
    """
    Setter method for bad_tlp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bad_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bad_tlp_errors() directly.

    YANG Description: Number of TLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bad_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bad_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bad_tlp_errors(self):
    self.__bad_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_bad_dllp_errors(self):
    """
    Getter method for bad_dllp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_dllp_errors (oc-yang:counter64)

    YANG Description: Number of DLLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__bad_dllp_errors
      
  def _set_bad_dllp_errors(self, v, load=False):
    """
    Setter method for bad_dllp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_dllp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bad_dllp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bad_dllp_errors() directly.

    YANG Description: Number of DLLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bad_dllp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bad_dllp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bad_dllp_errors(self):
    self.__bad_dllp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_relay_rollover_errors(self):
    """
    Getter method for relay_rollover_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/relay_rollover_errors (oc-yang:counter64)

    YANG Description: Number of relay rollover errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__relay_rollover_errors
      
  def _set_relay_rollover_errors(self, v, load=False):
    """
    Setter method for relay_rollover_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/relay_rollover_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relay_rollover_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relay_rollover_errors() directly.

    YANG Description: Number of relay rollover errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relay_rollover_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__relay_rollover_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relay_rollover_errors(self):
    self.__relay_rollover_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_replay_timeout_errors(self):
    """
    Getter method for replay_timeout_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/replay_timeout_errors (oc-yang:counter64)

    YANG Description: Number of replay timeout errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__replay_timeout_errors
      
  def _set_replay_timeout_errors(self, v, load=False):
    """
    Setter method for replay_timeout_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/replay_timeout_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_replay_timeout_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_replay_timeout_errors() directly.

    YANG Description: Number of replay timeout errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """replay_timeout_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__replay_timeout_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_replay_timeout_errors(self):
    self.__replay_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_advisory_non_fatal_errors(self):
    """
    Getter method for advisory_non_fatal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/advisory_non_fatal_errors (oc-yang:counter64)

    YANG Description: Number of advisory non fatal errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__advisory_non_fatal_errors
      
  def _set_advisory_non_fatal_errors(self, v, load=False):
    """
    Setter method for advisory_non_fatal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/advisory_non_fatal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_advisory_non_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_advisory_non_fatal_errors() directly.

    YANG Description: Number of advisory non fatal errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """advisory_non_fatal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__advisory_non_fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_advisory_non_fatal_errors(self):
    self.__advisory_non_fatal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_internal_errors(self):
    """
    Getter method for internal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/internal_errors (oc-yang:counter64)

    YANG Description: Number of internal errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    return self.__internal_errors
      
  def _set_internal_errors(self, v, load=False):
    """
    Setter method for internal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/internal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_internal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_internal_errors() directly.

    YANG Description: Number of internal errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """internal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__internal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_internal_errors(self):
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_hdr_log_overflow_errors(self):
    """
    Getter method for hdr_log_overflow_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/hdr_log_overflow_errors (oc-yang:counter64)

    YANG Description: Number of header log overflow errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__hdr_log_overflow_errors
      
  def _set_hdr_log_overflow_errors(self, v, load=False):
    """
    Setter method for hdr_log_overflow_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/hdr_log_overflow_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hdr_log_overflow_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hdr_log_overflow_errors() directly.

    YANG Description: Number of header log overflow errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hdr_log_overflow_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__hdr_log_overflow_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hdr_log_overflow_errors(self):
    self.__hdr_log_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

  total_errors = __builtin__.property(_get_total_errors)
  receiver_errors = __builtin__.property(_get_receiver_errors)
  bad_tlp_errors = __builtin__.property(_get_bad_tlp_errors)
  bad_dllp_errors = __builtin__.property(_get_bad_dllp_errors)
  relay_rollover_errors = __builtin__.property(_get_relay_rollover_errors)
  replay_timeout_errors = __builtin__.property(_get_replay_timeout_errors)
  advisory_non_fatal_errors = __builtin__.property(_get_advisory_non_fatal_errors)
  internal_errors = __builtin__.property(_get_internal_errors)
  hdr_log_overflow_errors = __builtin__.property(_get_hdr_log_overflow_errors)


  _pyangbind_elements = OrderedDict([('total_errors', total_errors), ('receiver_errors', receiver_errors), ('bad_tlp_errors', bad_tlp_errors), ('bad_dllp_errors', bad_dllp_errors), ('relay_rollover_errors', relay_rollover_errors), ('replay_timeout_errors', replay_timeout_errors), ('advisory_non_fatal_errors', advisory_non_fatal_errors), ('internal_errors', internal_errors), ('hdr_log_overflow_errors', hdr_log_overflow_errors), ])


class yc_pcie_openconfig_platform__components_component_state_pcie(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/pcie. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
  """
  __slots__ = ('_path_helper', '_extmethods', '__fatal_errors','__non_fatal_errors','__correctable_errors',)

  _yang_name = 'pcie'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__fatal_errors = YANGDynClass(base=yc_fatal_errors_openconfig_platform__components_component_state_pcie_fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__non_fatal_errors = YANGDynClass(base=yc_non_fatal_errors_openconfig_platform__components_component_state_pcie_non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__correctable_errors = YANGDynClass(base=yc_correctable_errors_openconfig_platform__components_component_state_pcie_correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie']

  def _get_fatal_errors(self):
    """
    Getter method for fatal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors (container)

    YANG Description: The count of the fatal PCIe errors.
    """
    return self.__fatal_errors
      
  def _set_fatal_errors(self, v, load=False):
    """
    Setter method for fatal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fatal_errors() directly.

    YANG Description: The count of the fatal PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_fatal_errors_openconfig_platform__components_component_state_pcie_fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fatal_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_fatal_errors_openconfig_platform__components_component_state_pcie_fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fatal_errors(self):
    self.__fatal_errors = YANGDynClass(base=yc_fatal_errors_openconfig_platform__components_component_state_pcie_fatal_errors, is_container='container', yang_name="fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_non_fatal_errors(self):
    """
    Getter method for non_fatal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors (container)

    YANG Description: The count of the non-fatal PCIe errors.
    """
    return self.__non_fatal_errors
      
  def _set_non_fatal_errors(self, v, load=False):
    """
    Setter method for non_fatal_errors, mapped from YANG variable /components/component/state/pcie/non_fatal_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_non_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_non_fatal_errors() directly.

    YANG Description: The count of the non-fatal PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_non_fatal_errors_openconfig_platform__components_component_state_pcie_non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """non_fatal_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_non_fatal_errors_openconfig_platform__components_component_state_pcie_non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__non_fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_non_fatal_errors(self):
    self.__non_fatal_errors = YANGDynClass(base=yc_non_fatal_errors_openconfig_platform__components_component_state_pcie_non_fatal_errors, is_container='container', yang_name="non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_correctable_errors(self):
    """
    Getter method for correctable_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors (container)

    YANG Description: The count of the correctable PCIe errors.
    """
    return self.__correctable_errors
      
  def _set_correctable_errors(self, v, load=False):
    """
    Setter method for correctable_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_correctable_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_correctable_errors() directly.

    YANG Description: The count of the correctable PCIe errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_correctable_errors_openconfig_platform__components_component_state_pcie_correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """correctable_errors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_correctable_errors_openconfig_platform__components_component_state_pcie_correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__correctable_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_correctable_errors(self):
    self.__correctable_errors = YANGDynClass(base=yc_correctable_errors_openconfig_platform__components_component_state_pcie_correctable_errors, is_container='container', yang_name="correctable-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

  fatal_errors = __builtin__.property(_get_fatal_errors)
  non_fatal_errors = __builtin__.property(_get_non_fatal_errors)
  correctable_errors = __builtin__.property(_get_correctable_errors)


  _pyangbind_elements = OrderedDict([('fatal_errors', fatal_errors), ('non_fatal_errors', non_fatal_errors), ('correctable_errors', correctable_errors), ])


class yc_state_openconfig_platform__components_component_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each component
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__id','__location','__description','__mfg_name','__mfg_date','__hardware_version','__firmware_version','__software_version','__serial_no','__part_no','__removable','__oper_status','__empty','__parent','__redundant_role','__last_switchover_reason','__last_switchover_time','__last_reboot_reason','__last_reboot_time','__temperature','__memory','__allocated_power','__used_power','__pcie','__entity_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__location = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__mfg_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__mfg_date = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)
    self.__hardware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__firmware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__serial_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__part_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__removable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    self.__empty = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__parent = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)
    self.__redundant_role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)
    self.__last_switchover_reason = YANGDynClass(base=yc_last_switchover_reason_openconfig_platform__components_component_state_last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__last_switchover_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__last_reboot_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    self.__last_reboot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__temperature = YANGDynClass(base=yc_temperature_openconfig_platform__components_component_state_temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__memory = YANGDynClass(base=yc_memory_openconfig_platform__components_component_state_memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__allocated_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    self.__used_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    self.__pcie = YANGDynClass(base=yc_pcie_openconfig_platform__components_component_state_pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__entity_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="entity-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/extension', defining_module='openconfig-platform-ext', yang_type='uint32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/state/name (string)

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /components/component/state/type (union)

    YANG Description: Type of component as identified by the system
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /components/component/state/type (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of component as identified by the system
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with union""",
          'defined-type': "openconfig-platform:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:OPTICAL_CHANNEL': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /components/component/state/id (string)

    YANG Description: Unique identifier assigned by the system for the
component
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /components/component/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Unique identifier assigned by the system for the
component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_location(self):
    """
    Getter method for location, mapped from YANG variable /components/component/state/location (string)

    YANG Description: System-supplied description of the location of the
component within the system. This could be a bay position,
slot number, socket location, etc. For component types that
have an explicit slot-id attribute, such as linecards, the
system should populate the more specific slot-id.
    """
    return self.__location
      
  def _set_location(self, v, load=False):
    """
    Setter method for location, mapped from YANG variable /components/component/state/location (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_location is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_location() directly.

    YANG Description: System-supplied description of the location of the
component within the system. This could be a bay position,
slot number, socket location, etc. For component types that
have an explicit slot-id attribute, such as linecards, the
system should populate the more specific slot-id.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """location must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__location = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_location(self):
    self.__location = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /components/component/state/description (string)

    YANG Description: System-supplied description of the component
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /components/component/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: System-supplied description of the component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_mfg_name(self):
    """
    Getter method for mfg_name, mapped from YANG variable /components/component/state/mfg_name (string)

    YANG Description: System-supplied identifier for the manufacturer of the
component.  This data is particularly useful when a
component manufacturer is different than the overall
device vendor.
    """
    return self.__mfg_name
      
  def _set_mfg_name(self, v, load=False):
    """
    Setter method for mfg_name, mapped from YANG variable /components/component/state/mfg_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfg_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfg_name() directly.

    YANG Description: System-supplied identifier for the manufacturer of the
component.  This data is particularly useful when a
component manufacturer is different than the overall
device vendor.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfg_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__mfg_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfg_name(self):
    self.__mfg_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_mfg_date(self):
    """
    Getter method for mfg_date, mapped from YANG variable /components/component/state/mfg_date (oc-yang:date)

    YANG Description: System-supplied representation of the component's
manufacturing date.
    """
    return self.__mfg_date
      
  def _set_mfg_date(self, v, load=False):
    """
    Setter method for mfg_date, mapped from YANG variable /components/component/state/mfg_date (oc-yang:date)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfg_date is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfg_date() directly.

    YANG Description: System-supplied representation of the component's
manufacturing date.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfg_date must be of a type compatible with oc-yang:date""",
          'defined-type': "oc-yang:date",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)""",
        })

    self.__mfg_date = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfg_date(self):
    self.__mfg_date = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)


  def _get_hardware_version(self):
    """
    Getter method for hardware_version, mapped from YANG variable /components/component/state/hardware_version (string)

    YANG Description: For hardware components, this is the hardware revision of
the component.
    """
    return self.__hardware_version
      
  def _set_hardware_version(self, v, load=False):
    """
    Setter method for hardware_version, mapped from YANG variable /components/component/state/hardware_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hardware_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hardware_version() directly.

    YANG Description: For hardware components, this is the hardware revision of
the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hardware_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__hardware_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hardware_version(self):
    self.__hardware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_firmware_version(self):
    """
    Getter method for firmware_version, mapped from YANG variable /components/component/state/firmware_version (string)

    YANG Description: For hardware components, this is the version of associated
firmware that is running on the component, if applicable.
    """
    return self.__firmware_version
      
  def _set_firmware_version(self, v, load=False):
    """
    Setter method for firmware_version, mapped from YANG variable /components/component/state/firmware_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_firmware_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_firmware_version() directly.

    YANG Description: For hardware components, this is the version of associated
firmware that is running on the component, if applicable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """firmware_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__firmware_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_firmware_version(self):
    self.__firmware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_software_version(self):
    """
    Getter method for software_version, mapped from YANG variable /components/component/state/software_version (string)

    YANG Description: For software components such as operating system or other
software module, this is the version of the currently
running software.
    """
    return self.__software_version
      
  def _set_software_version(self, v, load=False):
    """
    Setter method for software_version, mapped from YANG variable /components/component/state/software_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_version() directly.

    YANG Description: For software components such as operating system or other
software module, this is the version of the currently
running software.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__software_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_version(self):
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_serial_no(self):
    """
    Getter method for serial_no, mapped from YANG variable /components/component/state/serial_no (string)

    YANG Description: System-assigned serial number of the component.
    """
    return self.__serial_no
      
  def _set_serial_no(self, v, load=False):
    """
    Setter method for serial_no, mapped from YANG variable /components/component/state/serial_no (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_serial_no is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_serial_no() directly.

    YANG Description: System-assigned serial number of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """serial_no must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__serial_no = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_serial_no(self):
    self.__serial_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_part_no(self):
    """
    Getter method for part_no, mapped from YANG variable /components/component/state/part_no (string)

    YANG Description: System-assigned part number for the component.  This should
be present in particular if the component is also an FRU
(field replaceable unit)
    """
    return self.__part_no
      
  def _set_part_no(self, v, load=False):
    """
    Setter method for part_no, mapped from YANG variable /components/component/state/part_no (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_part_no is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_part_no() directly.

    YANG Description: System-assigned part number for the component.  This should
be present in particular if the component is also an FRU
(field replaceable unit)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """part_no must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__part_no = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_part_no(self):
    self.__part_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_removable(self):
    """
    Getter method for removable, mapped from YANG variable /components/component/state/removable (boolean)

    YANG Description: If true, this component is removable or is a field
replaceable unit
    """
    return self.__removable
      
  def _set_removable(self, v, load=False):
    """
    Setter method for removable, mapped from YANG variable /components/component/state/removable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_removable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_removable() directly.

    YANG Description: If true, this component is removable or is a field
replaceable unit
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """removable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__removable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_removable(self):
    self.__removable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /components/component/state/oper_status (identityref)

    YANG Description: If applicable, this reports the current operational status
of the component.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /components/component/state/oper_status (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: If applicable, this reports the current operational status
of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)


  def _get_empty(self):
    """
    Getter method for empty, mapped from YANG variable /components/component/state/empty (boolean)

    YANG Description: The empty leaf may be used by the device to indicate that a
component position exists but is not populated.  Using this
flag, it is possible for the management system to learn how
many positions are available (e.g., occupied vs. empty
linecard slots in a chassis).
    """
    return self.__empty
      
  def _set_empty(self, v, load=False):
    """
    Setter method for empty, mapped from YANG variable /components/component/state/empty (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_empty is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_empty() directly.

    YANG Description: The empty leaf may be used by the device to indicate that a
component position exists but is not populated.  Using this
flag, it is possible for the management system to learn how
many positions are available (e.g., occupied vs. empty
linecard slots in a chassis).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """empty must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__empty = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_empty(self):
    self.__empty = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_parent(self):
    """
    Getter method for parent, mapped from YANG variable /components/component/state/parent (leafref)

    YANG Description: Reference to the name of the parent component.  Note that
this reference must be kept synchronized with the
corresponding subcomponent reference from the parent
component.
    """
    return self.__parent
      
  def _set_parent(self, v, load=False):
    """
    Setter method for parent, mapped from YANG variable /components/component/state/parent (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_parent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_parent() directly.

    YANG Description: Reference to the name of the parent component.  Note that
this reference must be kept synchronized with the
corresponding subcomponent reference from the parent
component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """parent must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)""",
        })

    self.__parent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_parent(self):
    self.__parent = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)


  def _get_redundant_role(self):
    """
    Getter method for redundant_role, mapped from YANG variable /components/component/state/redundant_role (oc-platform-types:component-redundant-role)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the role of the component.
    """
    return self.__redundant_role
      
  def _set_redundant_role(self, v, load=False):
    """
    Setter method for redundant_role, mapped from YANG variable /components/component/state/redundant_role (oc-platform-types:component-redundant-role)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_redundant_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_redundant_role() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the role of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """redundant_role must be of a type compatible with oc-platform-types:component-redundant-role""",
          'defined-type': "oc-platform-types:component-redundant-role",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)""",
        })

    self.__redundant_role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_redundant_role(self):
    self.__redundant_role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)


  def _get_last_switchover_reason(self):
    """
    Getter method for last_switchover_reason, mapped from YANG variable /components/component/state/last_switchover_reason (container)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
    """
    return self.__last_switchover_reason
      
  def _set_last_switchover_reason(self, v, load=False):
    """
    Setter method for last_switchover_reason, mapped from YANG variable /components/component/state/last_switchover_reason (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_switchover_reason is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_switchover_reason() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_last_switchover_reason_openconfig_platform__components_component_state_last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_switchover_reason must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_last_switchover_reason_openconfig_platform__components_component_state_last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__last_switchover_reason = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_switchover_reason(self):
    self.__last_switchover_reason = YANGDynClass(base=yc_last_switchover_reason_openconfig_platform__components_component_state_last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_last_switchover_time(self):
    """
    Getter method for last_switchover_time, mapped from YANG variable /components/component/state/last_switchover_time (oc-types:timeticks64)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as
secondary), this reports the time of the last change of
the component's role. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_switchover_time
      
  def _set_last_switchover_time(self, v, load=False):
    """
    Setter method for last_switchover_time, mapped from YANG variable /components/component/state/last_switchover_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_switchover_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_switchover_time() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as
secondary), this reports the time of the last change of
the component's role. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_switchover_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_switchover_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_switchover_time(self):
    self.__last_switchover_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_last_reboot_reason(self):
    """
    Getter method for last_reboot_reason, mapped from YANG variable /components/component/state/last_reboot_reason (identityref)

    YANG Description: This reports the reason of the last reboot of the component.
    """
    return self.__last_reboot_reason
      
  def _set_last_reboot_reason(self, v, load=False):
    """
    Setter method for last_reboot_reason, mapped from YANG variable /components/component/state/last_reboot_reason (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_reboot_reason is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_reboot_reason() directly.

    YANG Description: This reports the reason of the last reboot of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_reboot_reason must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)""",
        })

    self.__last_reboot_reason = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_reboot_reason(self):
    self.__last_reboot_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)


  def _get_last_reboot_time(self):
    """
    Getter method for last_reboot_time, mapped from YANG variable /components/component/state/last_reboot_time (oc-types:timeticks64)

    YANG Description: This reports the time of the last reboot of the component. The
value is the timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_reboot_time
      
  def _set_last_reboot_time(self, v, load=False):
    """
    Setter method for last_reboot_time, mapped from YANG variable /components/component/state/last_reboot_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_reboot_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_reboot_time() directly.

    YANG Description: This reports the time of the last reboot of the component. The
value is the timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_reboot_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_reboot_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_reboot_time(self):
    self.__last_reboot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_temperature(self):
    """
    Getter method for temperature, mapped from YANG variable /components/component/state/temperature (container)

    YANG Description: Temperature in degrees Celsius of the component. Values include
the instantaneous, average, minimum, and maximum statistics. If
avg/min/max statistics are not supported, the target is expected
to just supply the instant value
    """
    return self.__temperature
      
  def _set_temperature(self, v, load=False):
    """
    Setter method for temperature, mapped from YANG variable /components/component/state/temperature (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_temperature is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_temperature() directly.

    YANG Description: Temperature in degrees Celsius of the component. Values include
the instantaneous, average, minimum, and maximum statistics. If
avg/min/max statistics are not supported, the target is expected
to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_temperature_openconfig_platform__components_component_state_temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """temperature must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_temperature_openconfig_platform__components_component_state_temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__temperature = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_temperature(self):
    self.__temperature = YANGDynClass(base=yc_temperature_openconfig_platform__components_component_state_temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_memory(self):
    """
    Getter method for memory, mapped from YANG variable /components/component/state/memory (container)

    YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
    """
    return self.__memory
      
  def _set_memory(self, v, load=False):
    """
    Setter method for memory, mapped from YANG variable /components/component/state/memory (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_memory is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_memory() directly.

    YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_memory_openconfig_platform__components_component_state_memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """memory must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_memory_openconfig_platform__components_component_state_memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__memory = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_memory(self):
    self.__memory = YANGDynClass(base=yc_memory_openconfig_platform__components_component_state_memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_allocated_power(self):
    """
    Getter method for allocated_power, mapped from YANG variable /components/component/state/allocated_power (uint32)

    YANG Description: Power allocated by the system for the component.
    """
    return self.__allocated_power
      
  def _set_allocated_power(self, v, load=False):
    """
    Setter method for allocated_power, mapped from YANG variable /components/component/state/allocated_power (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allocated_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allocated_power() directly.

    YANG Description: Power allocated by the system for the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allocated_power must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)""",
        })

    self.__allocated_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allocated_power(self):
    self.__allocated_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)


  def _get_used_power(self):
    """
    Getter method for used_power, mapped from YANG variable /components/component/state/used_power (uint32)

    YANG Description: Actual power used by the component.
    """
    return self.__used_power
      
  def _set_used_power(self, v, load=False):
    """
    Setter method for used_power, mapped from YANG variable /components/component/state/used_power (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_used_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_used_power() directly.

    YANG Description: Actual power used by the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """used_power must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)""",
        })

    self.__used_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_used_power(self):
    self.__used_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)


  def _get_pcie(self):
    """
    Getter method for pcie, mapped from YANG variable /components/component/state/pcie (container)

    YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
    """
    return self.__pcie
      
  def _set_pcie(self, v, load=False):
    """
    Setter method for pcie, mapped from YANG variable /components/component/state/pcie (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pcie is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pcie() directly.

    YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_pcie_openconfig_platform__components_component_state_pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pcie must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_pcie_openconfig_platform__components_component_state_pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__pcie = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pcie(self):
    self.__pcie = YANGDynClass(base=yc_pcie_openconfig_platform__components_component_state_pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_entity_id(self):
    """
    Getter method for entity_id, mapped from YANG variable /components/component/state/entity_id (uint32)

    YANG Description: A unique numeric identifier assigned by the system to the
component. This identifier may be used to represent the
corresponding SNMP Entity MIB identifier.
    """
    return self.__entity_id
      
  def _set_entity_id(self, v, load=False):
    """
    Setter method for entity_id, mapped from YANG variable /components/component/state/entity_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entity_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entity_id() directly.

    YANG Description: A unique numeric identifier assigned by the system to the
component. This identifier may be used to represent the
corresponding SNMP Entity MIB identifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="entity-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/extension', defining_module='openconfig-platform-ext', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entity_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="entity-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/extension', defining_module='openconfig-platform-ext', yang_type='uint32', is_config=False)""",
        })

    self.__entity_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entity_id(self):
    self.__entity_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="entity-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/extension', defining_module='openconfig-platform-ext', yang_type='uint32', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  id = __builtin__.property(_get_id)
  location = __builtin__.property(_get_location)
  description = __builtin__.property(_get_description)
  mfg_name = __builtin__.property(_get_mfg_name)
  mfg_date = __builtin__.property(_get_mfg_date)
  hardware_version = __builtin__.property(_get_hardware_version)
  firmware_version = __builtin__.property(_get_firmware_version)
  software_version = __builtin__.property(_get_software_version)
  serial_no = __builtin__.property(_get_serial_no)
  part_no = __builtin__.property(_get_part_no)
  removable = __builtin__.property(_get_removable)
  oper_status = __builtin__.property(_get_oper_status)
  empty = __builtin__.property(_get_empty)
  parent = __builtin__.property(_get_parent)
  redundant_role = __builtin__.property(_get_redundant_role)
  last_switchover_reason = __builtin__.property(_get_last_switchover_reason)
  last_switchover_time = __builtin__.property(_get_last_switchover_time)
  last_reboot_reason = __builtin__.property(_get_last_reboot_reason)
  last_reboot_time = __builtin__.property(_get_last_reboot_time)
  temperature = __builtin__.property(_get_temperature)
  memory = __builtin__.property(_get_memory)
  allocated_power = __builtin__.property(_get_allocated_power)
  used_power = __builtin__.property(_get_used_power)
  pcie = __builtin__.property(_get_pcie)
  entity_id = __builtin__.property(_get_entity_id)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('id', id), ('location', location), ('description', description), ('mfg_name', mfg_name), ('mfg_date', mfg_date), ('hardware_version', hardware_version), ('firmware_version', firmware_version), ('software_version', software_version), ('serial_no', serial_no), ('part_no', part_no), ('removable', removable), ('oper_status', oper_status), ('empty', empty), ('parent', parent), ('redundant_role', redundant_role), ('last_switchover_reason', last_switchover_reason), ('last_switchover_time', last_switchover_time), ('last_reboot_reason', last_reboot_reason), ('last_reboot_time', last_reboot_time), ('temperature', temperature), ('memory', memory), ('allocated_power', allocated_power), ('used_power', used_power), ('pcie', pcie), ('entity_id', entity_id), ])


class yc_config_openconfig_platform__components_component_properties_property_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/properties/property/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each property
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__value',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)
    self.__value = YANGDynClass(base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'properties', 'property', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/properties/property/config/name (string)

    YANG Description: System-supplied name of the property -- this is typically
non-configurable
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/properties/property/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: System-supplied name of the property -- this is typically
non-configurable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)


  def _get_value(self):
    """
    Getter method for value, mapped from YANG variable /components/component/properties/property/config/value (union)

    YANG Description: Property values can take on a variety of types.  Signed and
unsigned integer types may be provided in smaller sizes,
e.g., int8, uint16, etc.
    """
    return self.__value
      
  def _set_value(self, v, load=False):
    """
    Setter method for value, mapped from YANG variable /components/component/properties/property/config/value (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_value() directly.

    YANG Description: Property values can take on a variety of types.  Signed and
unsigned integer types may be provided in smaller sizes,
e.g., int8, uint16, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """value must be of a type compatible with union""",
          'defined-type': "openconfig-platform:union",
          'generated-type': """YANGDynClass(base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=True)""",
        })

    self.__value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_value(self):
    self.__value = YANGDynClass(base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  value = __builtin__.property(_get_value, _set_value)


  _pyangbind_elements = OrderedDict([('name', name), ('value', value), ])


class yc_state_openconfig_platform__components_component_properties_property_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/properties/property/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each property
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__value','__configurable',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__value = YANGDynClass(base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    self.__configurable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="configurable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'properties', 'property', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/properties/property/state/name (string)

    YANG Description: System-supplied name of the property -- this is typically
non-configurable
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/properties/property/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: System-supplied name of the property -- this is typically
non-configurable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_value(self):
    """
    Getter method for value, mapped from YANG variable /components/component/properties/property/state/value (union)

    YANG Description: Property values can take on a variety of types.  Signed and
unsigned integer types may be provided in smaller sizes,
e.g., int8, uint16, etc.
    """
    return self.__value
      
  def _set_value(self, v, load=False):
    """
    Setter method for value, mapped from YANG variable /components/component/properties/property/state/value (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_value() directly.

    YANG Description: Property values can take on a variety of types.  Signed and
unsigned integer types may be provided in smaller sizes,
e.g., int8, uint16, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """value must be of a type compatible with union""",
          'defined-type': "openconfig-platform:union",
          'generated-type': """YANGDynClass(base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)""",
        })

    self.__value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_value(self):
    self.__value = YANGDynClass(base=[six.text_type,YANGBool,RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64),RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64),RestrictedPrecisionDecimalType(precision=2),], is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)


  def _get_configurable(self):
    """
    Getter method for configurable, mapped from YANG variable /components/component/properties/property/state/configurable (boolean)

    YANG Description: Indication whether the property is user-configurable
    """
    return self.__configurable
      
  def _set_configurable(self, v, load=False):
    """
    Setter method for configurable, mapped from YANG variable /components/component/properties/property/state/configurable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_configurable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_configurable() directly.

    YANG Description: Indication whether the property is user-configurable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="configurable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """configurable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="configurable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__configurable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_configurable(self):
    self.__configurable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="configurable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)

  name = __builtin__.property(_get_name)
  value = __builtin__.property(_get_value)
  configurable = __builtin__.property(_get_configurable)


  _pyangbind_elements = OrderedDict([('name', name), ('value', value), ('configurable', configurable), ])


class yc_property__openconfig_platform__components_component_properties_property(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/properties/property. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of system properties for the component
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'property'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_properties_property_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_properties_property_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'properties', 'property']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/properties/property/name (leafref)

    YANG Description: Reference to the property name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/properties/property/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the property name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/properties/property/config (container)

    YANG Description: Configuration data for each property
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/properties/property/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each property
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_platform__components_component_properties_property_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_platform__components_component_properties_property_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_properties_property_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/properties/property/state (container)

    YANG Description: Operational state data for each property
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/properties/property/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each property
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_properties_property_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_properties_property_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_properties_property_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_properties_openconfig_platform__components_component_properties(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/properties. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container 
  """
  __slots__ = ('_path_helper', '_extmethods', '__property_',)

  _yang_name = 'properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__property_ = YANGDynClass(base=YANGListType("name",yc_property__openconfig_platform__components_component_properties_property, yang_name="property", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="property", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'properties']

  def _get_property_(self):
    """
    Getter method for property_, mapped from YANG variable /components/component/properties/property (list)

    YANG Description: List of system properties for the component
    """
    return self.__property_
      
  def _set_property_(self, v, load=False):
    """
    Setter method for property_, mapped from YANG variable /components/component/properties/property (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_property_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_property_() directly.

    YANG Description: List of system properties for the component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_property__openconfig_platform__components_component_properties_property, yang_name="property", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="property", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """property_ must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_property__openconfig_platform__components_component_properties_property, yang_name="property", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="property", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)""",
        })

    self.__property_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_property_(self):
    self.__property_ = YANGDynClass(base=YANGListType("name",yc_property__openconfig_platform__components_component_properties_property, yang_name="property", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="property", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

  property_ = __builtin__.property(_get_property_, _set_property_)


  _pyangbind_elements = OrderedDict([('property_', property_), ])


class yc_config_openconfig_platform__components_component_subcomponents_subcomponent_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/subcomponents/subcomponent/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the subcomponent
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'subcomponents', 'subcomponent', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/subcomponents/subcomponent/config/name (leafref)

    YANG Description: Reference to the name of the subcomponent
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/subcomponents/subcomponent/config/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the subcomponent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_platform__components_component_subcomponents_subcomponent_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/subcomponents/subcomponent/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the subcomponent
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'subcomponents', 'subcomponent', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/subcomponents/subcomponent/state/name (leafref)

    YANG Description: Reference to the name of the subcomponent
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/subcomponents/subcomponent/state/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the subcomponent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)

  name = __builtin__.property(_get_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_subcomponent_openconfig_platform__components_component_subcomponents_subcomponent(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/subcomponents/subcomponent. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of subcomponent references
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'subcomponent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_subcomponents_subcomponent_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_subcomponents_subcomponent_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'subcomponents', 'subcomponent']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/subcomponents/subcomponent/name (leafref)

    YANG Description: Reference to the name list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/subcomponents/subcomponent/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/subcomponents/subcomponent/config (container)

    YANG Description: Configuration data for the subcomponent
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/subcomponents/subcomponent/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the subcomponent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_platform__components_component_subcomponents_subcomponent_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_platform__components_component_subcomponents_subcomponent_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_subcomponents_subcomponent_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/subcomponents/subcomponent/state (container)

    YANG Description: Operational state data for the subcomponent
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/subcomponents/subcomponent/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the subcomponent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_subcomponents_subcomponent_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_subcomponents_subcomponent_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_subcomponents_subcomponent_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_subcomponents_openconfig_platform__components_component_subcomponents(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/subcomponents. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for subcomponent references
  """
  __slots__ = ('_path_helper', '_extmethods', '__subcomponent',)

  _yang_name = 'subcomponents'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__subcomponent = YANGDynClass(base=YANGListType("name",yc_subcomponent_openconfig_platform__components_component_subcomponents_subcomponent, yang_name="subcomponent", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="subcomponent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'subcomponents']

  def _get_subcomponent(self):
    """
    Getter method for subcomponent, mapped from YANG variable /components/component/subcomponents/subcomponent (list)

    YANG Description: List of subcomponent references
    """
    return self.__subcomponent
      
  def _set_subcomponent(self, v, load=False):
    """
    Setter method for subcomponent, mapped from YANG variable /components/component/subcomponents/subcomponent (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subcomponent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subcomponent() directly.

    YANG Description: List of subcomponent references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_subcomponent_openconfig_platform__components_component_subcomponents_subcomponent, yang_name="subcomponent", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="subcomponent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subcomponent must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_subcomponent_openconfig_platform__components_component_subcomponents_subcomponent, yang_name="subcomponent", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="subcomponent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)""",
        })

    self.__subcomponent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subcomponent(self):
    self.__subcomponent = YANGDynClass(base=YANGListType("name",yc_subcomponent_openconfig_platform__components_component_subcomponents_subcomponent, yang_name="subcomponent", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="subcomponent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

  subcomponent = __builtin__.property(_get_subcomponent, _set_subcomponent)


  _pyangbind_elements = OrderedDict([('subcomponent', subcomponent), ])


class yc_config_openconfig_platform__components_component_chassis_utilization_resources_resource_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis/utilization/resources/resource/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each resource.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis', 'utilization', 'resources', 'resource', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/config/name (string)

    YANG Description: Resource name within the component.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Resource name within the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_platform__components_component_chassis_utilization_resources_resource_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis/utilization/resources/resource/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each resource.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__used','__committed','__free','__max_limit','__high_watermark','__last_high_watermark',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis', 'utilization', 'resources', 'resource', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/name (string)

    YANG Description: Resource name within the component.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Resource name within the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_used(self):
    """
    Getter method for used, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/used (uint64)

    YANG Description: Number of entries currently in use for the resource.
    """
    return self.__used
      
  def _set_used(self, v, load=False):
    """
    Setter method for used, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/used (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_used is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_used() directly.

    YANG Description: Number of entries currently in use for the resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """used must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__used = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_used(self):
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_committed(self):
    """
    Getter method for committed, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/committed (uint64)

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    return self.__committed
      
  def _set_committed(self, v, load=False):
    """
    Setter method for committed, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/committed (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_committed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_committed() directly.

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """committed must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__committed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_committed(self):
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_free(self):
    """
    Getter method for free, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/free (uint64)

    YANG Description: Number of entries available to use.
    """
    return self.__free
      
  def _set_free(self, v, load=False):
    """
    Setter method for free, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/free (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_free is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_free() directly.

    YANG Description: Number of entries available to use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """free must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__free = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_free(self):
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_max_limit(self):
    """
    Getter method for max_limit, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/max_limit (uint64)

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    return self.__max_limit
      
  def _set_max_limit(self, v, load=False):
    """
    Setter method for max_limit, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/max_limit (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_limit() directly.

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_limit must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__max_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_limit(self):
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_high_watermark(self):
    """
    Getter method for high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/high_watermark (uint64)

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    return self.__high_watermark
      
  def _set_high_watermark(self, v, load=False):
    """
    Setter method for high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/high_watermark (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_high_watermark() directly.

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """high_watermark must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_high_watermark(self):
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_last_high_watermark(self):
    """
    Getter method for last_high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)

    YANG Description: The time when the high-watermark was last updated
    """
    return self.__last_high_watermark
      
  def _set_last_high_watermark(self, v, load=False):
    """
    Setter method for last_high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_high_watermark() directly.

    YANG Description: The time when the high-watermark was last updated
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_high_watermark must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_high_watermark(self):
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

  name = __builtin__.property(_get_name)
  used = __builtin__.property(_get_used)
  committed = __builtin__.property(_get_committed)
  free = __builtin__.property(_get_free)
  max_limit = __builtin__.property(_get_max_limit)
  high_watermark = __builtin__.property(_get_high_watermark)
  last_high_watermark = __builtin__.property(_get_last_high_watermark)


  _pyangbind_elements = OrderedDict([('name', name), ('used', used), ('committed', committed), ('free', free), ('max_limit', max_limit), ('high_watermark', high_watermark), ('last_high_watermark', last_high_watermark), ])


class yc_resource_openconfig_platform__components_component_chassis_utilization_resources_resource(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis/utilization/resources/resource. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of resources, keyed by resource name.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'resource'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_chassis_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_chassis_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis', 'utilization', 'resources', 'resource']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/name (leafref)

    YANG Description: References the resource name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: References the resource name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/chassis/utilization/resources/resource/config (container)

    YANG Description: Configuration data for each resource.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/chassis/utilization/resources/resource/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_platform__components_component_chassis_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_platform__components_component_chassis_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_chassis_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state (container)

    YANG Description: Operational state data for each resource.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_chassis_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_chassis_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_chassis_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_resources_openconfig_platform__components_component_chassis_utilization_resources(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis/utilization/resources. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the resources in this component.
  """
  __slots__ = ('_path_helper', '_extmethods', '__resource',)

  _yang_name = 'resources'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__resource = YANGDynClass(base=YANGListType("name",yc_resource_openconfig_platform__components_component_chassis_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis', 'utilization', 'resources']

  def _get_resource(self):
    """
    Getter method for resource, mapped from YANG variable /components/component/chassis/utilization/resources/resource (list)

    YANG Description: List of resources, keyed by resource name.
    """
    return self.__resource
      
  def _set_resource(self, v, load=False):
    """
    Setter method for resource, mapped from YANG variable /components/component/chassis/utilization/resources/resource (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_resource is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_resource() directly.

    YANG Description: List of resources, keyed by resource name.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_resource_openconfig_platform__components_component_chassis_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """resource must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_resource_openconfig_platform__components_component_chassis_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)""",
        })

    self.__resource = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_resource(self):
    self.__resource = YANGDynClass(base=YANGListType("name",yc_resource_openconfig_platform__components_component_chassis_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

  resource = __builtin__.property(_get_resource, _set_resource)


  _pyangbind_elements = OrderedDict([('resource', resource), ])


class yc_utilization_openconfig_platform__components_component_chassis_utilization(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis/utilization. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Utilization of the component.
  """
  __slots__ = ('_path_helper', '_extmethods', '__resources',)

  _yang_name = 'utilization'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__resources = YANGDynClass(base=yc_resources_openconfig_platform__components_component_chassis_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis', 'utilization']

  def _get_resources(self):
    """
    Getter method for resources, mapped from YANG variable /components/component/chassis/utilization/resources (container)

    YANG Description: Enclosing container for the resources in this component.
    """
    return self.__resources
      
  def _set_resources(self, v, load=False):
    """
    Setter method for resources, mapped from YANG variable /components/component/chassis/utilization/resources (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_resources is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_resources() directly.

    YANG Description: Enclosing container for the resources in this component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_resources_openconfig_platform__components_component_chassis_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """resources must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_resources_openconfig_platform__components_component_chassis_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__resources = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_resources(self):
    self.__resources = YANGDynClass(base=yc_resources_openconfig_platform__components_component_chassis_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  resources = __builtin__.property(_get_resources, _set_resources)


  _pyangbind_elements = OrderedDict([('resources', resources), ])


class yc_chassis_openconfig_platform__components_component_chassis(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for chassis components
  """
  __slots__ = ('_path_helper', '_extmethods', '__utilization',)

  _yang_name = 'chassis'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__utilization = YANGDynClass(base=yc_utilization_openconfig_platform__components_component_chassis_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis']

  def _get_utilization(self):
    """
    Getter method for utilization, mapped from YANG variable /components/component/chassis/utilization (container)

    YANG Description: Utilization of the component.
    """
    return self.__utilization
      
  def _set_utilization(self, v, load=False):
    """
    Setter method for utilization, mapped from YANG variable /components/component/chassis/utilization (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilization() directly.

    YANG Description: Utilization of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_utilization_openconfig_platform__components_component_chassis_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilization must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_utilization_openconfig_platform__components_component_chassis_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilization(self):
    self.__utilization = YANGDynClass(base=yc_utilization_openconfig_platform__components_component_chassis_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  utilization = __builtin__.property(_get_utilization, _set_utilization)


  _pyangbind_elements = OrderedDict([('utilization', utilization), ])


class yc_config_openconfig_platform__components_component_port_breakout_mode_groups_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/port/breakout-mode/groups/group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for breakout group.
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__num_breakouts','__breakout_speed','__num_physical_channels',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port', 'breakout-mode', 'groups', 'group', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/index (uint8)

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/index (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)


  def _get_num_breakouts(self):
    """
    Getter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_breakouts (uint8)

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    return self.__num_breakouts
      
  def _set_num_breakouts(self, v, load=False):
    """
    Setter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_breakouts (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_breakouts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_breakouts() directly.

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_breakouts must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__num_breakouts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_breakouts(self):
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)


  def _get_breakout_speed(self):
    """
    Getter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/breakout_speed (identityref)

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    return self.__breakout_speed
      
  def _set_breakout_speed(self, v, load=False):
    """
    Setter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/breakout_speed (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_breakout_speed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_breakout_speed() directly.

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """breakout_speed must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform-port:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)""",
        })

    self.__breakout_speed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_breakout_speed(self):
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)


  def _get_num_physical_channels(self):
    """
    Getter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_physical_channels (uint8)

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    return self.__num_physical_channels
      
  def _set_num_physical_channels(self, v, load=False):
    """
    Setter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_physical_channels (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_physical_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_physical_channels() directly.

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_physical_channels must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__num_physical_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_physical_channels(self):
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  num_breakouts = __builtin__.property(_get_num_breakouts, _set_num_breakouts)
  breakout_speed = __builtin__.property(_get_breakout_speed, _set_breakout_speed)
  num_physical_channels = __builtin__.property(_get_num_physical_channels, _set_num_physical_channels)


  _pyangbind_elements = OrderedDict([('index', index), ('num_breakouts', num_breakouts), ('breakout_speed', breakout_speed), ('num_physical_channels', num_physical_channels), ])


class yc_state_openconfig_platform__components_component_port_breakout_mode_groups_group_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/port/breakout-mode/groups/group/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for breakout group.
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__num_breakouts','__breakout_speed','__num_physical_channels',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=False)
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port', 'breakout-mode', 'groups', 'group', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/index (uint8)

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/index (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)


  def _get_num_breakouts(self):
    """
    Getter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/num_breakouts (uint8)

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    return self.__num_breakouts
      
  def _set_num_breakouts(self, v, load=False):
    """
    Setter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/num_breakouts (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_breakouts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_breakouts() directly.

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_breakouts must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)""",
        })

    self.__num_breakouts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_breakouts(self):
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)


  def _get_breakout_speed(self):
    """
    Getter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/breakout_speed (identityref)

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    return self.__breakout_speed
      
  def _set_breakout_speed(self, v, load=False):
    """
    Setter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/breakout_speed (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_breakout_speed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_breakout_speed() directly.

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """breakout_speed must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform-port:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=False)""",
        })

    self.__breakout_speed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_breakout_speed(self):
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=False)


  def _get_num_physical_channels(self):
    """
    Getter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/num_physical_channels (uint8)

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    return self.__num_physical_channels
      
  def _set_num_physical_channels(self, v, load=False):
    """
    Setter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state/num_physical_channels (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_physical_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_physical_channels() directly.

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_physical_channels must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)""",
        })

    self.__num_physical_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_physical_channels(self):
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=False)

  index = __builtin__.property(_get_index)
  num_breakouts = __builtin__.property(_get_num_breakouts)
  breakout_speed = __builtin__.property(_get_breakout_speed)
  num_physical_channels = __builtin__.property(_get_num_physical_channels)


  _pyangbind_elements = OrderedDict([('index', index), ('num_breakouts', num_breakouts), ('breakout_speed', breakout_speed), ('num_physical_channels', num_physical_channels), ])


class yc_group_openconfig_platform__components_component_port_breakout_mode_groups_group(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/port/breakout-mode/groups/group. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of breakout groups.
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__config','__state',)

  _yang_name = 'group'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_port_breakout_mode_groups_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_port_breakout_mode_groups_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port', 'breakout-mode', 'groups', 'group']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/index (leafref)

    YANG Description: Index of the breakout group entry in the breakout groups list.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/index (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index of the breakout group entry in the breakout groups list.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='leafref', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config (container)

    YANG Description: Configuration data for breakout group.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for breakout group.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_platform__components_component_port_breakout_mode_groups_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_platform__components_component_port_breakout_mode_groups_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_port_breakout_mode_groups_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state (container)

    YANG Description: Operational state data for breakout group.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/port/breakout_mode/groups/group/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for breakout group.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_port_breakout_mode_groups_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_port_breakout_mode_groups_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_port_breakout_mode_groups_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('index', index), ('config', config), ('state', state), ])


class yc_groups_openconfig_platform__components_component_port_breakout_mode_groups(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/port/breakout-mode/groups. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for breakout groups data.

When a device has the capability to break a port into
interfaces of different speeds and different number of
physical channels, it can breakout a 400G OSFP port with
8 physical channels (with support for 25G NRZ, 50G PAM4
and 100G PAM4) in the following configuration:

100G + 100G + 200G -> 1 interface with 2 physical channels
and 1 interface with 4 physical channels and 1 interface with
2 physical channels. With this configuration the interface in
1st breakout group would use 50G PAM4 modulation, interface
in 2nd breakout group would use 25G NRZ modulation and the
interface in 3rd breakout group would use 100G PAM4 modulation
This configuration would result in 3 entries in the breakout
groups list.

When a device does not have the capability to break a port
into interfaces of different speeds and different number of
physical channels, it would breakout a 400G OSFP port with
8 physical channels in the following configuration:

50G -> 8 interfaces with 1 physical channel each, this would
result in 1 entry in the breakout groups list.
  """
  __slots__ = ('_path_helper', '_extmethods', '__group',)

  _yang_name = 'groups'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__group = YANGDynClass(base=YANGListType("index",yc_group_openconfig_platform__components_component_port_breakout_mode_groups_group, yang_name="group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port', 'breakout-mode', 'groups']

  def _get_group(self):
    """
    Getter method for group, mapped from YANG variable /components/component/port/breakout_mode/groups/group (list)

    YANG Description: List of breakout groups.
    """
    return self.__group
      
  def _set_group(self, v, load=False):
    """
    Setter method for group, mapped from YANG variable /components/component/port/breakout_mode/groups/group (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group() directly.

    YANG Description: List of breakout groups.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",yc_group_openconfig_platform__components_component_port_breakout_mode_groups_group, yang_name="group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",yc_group_openconfig_platform__components_component_port_breakout_mode_groups_group, yang_name="group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='list', is_config=True)""",
        })

    self.__group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group(self):
    self.__group = YANGDynClass(base=YANGListType("index",yc_group_openconfig_platform__components_component_port_breakout_mode_groups_group, yang_name="group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='list', is_config=True)

  group = __builtin__.property(_get_group, _set_group)


  _pyangbind_elements = OrderedDict([('group', group), ])


class yc_breakout_mode_openconfig_platform__components_component_port_breakout_mode(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/port/breakout-mode. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for port breakout-mode data.
  """
  __slots__ = ('_path_helper', '_extmethods', '__groups',)

  _yang_name = 'breakout-mode'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__groups = YANGDynClass(base=yc_groups_openconfig_platform__components_component_port_breakout_mode_groups, is_container='container', yang_name="groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port', 'breakout-mode']

  def _get_groups(self):
    """
    Getter method for groups, mapped from YANG variable /components/component/port/breakout_mode/groups (container)

    YANG Description: Top level container for breakout groups data.

When a device has the capability to break a port into
interfaces of different speeds and different number of
physical channels, it can breakout a 400G OSFP port with
8 physical channels (with support for 25G NRZ, 50G PAM4
and 100G PAM4) in the following configuration:

100G + 100G + 200G -> 1 interface with 2 physical channels
and 1 interface with 4 physical channels and 1 interface with
2 physical channels. With this configuration the interface in
1st breakout group would use 50G PAM4 modulation, interface
in 2nd breakout group would use 25G NRZ modulation and the
interface in 3rd breakout group would use 100G PAM4 modulation
This configuration would result in 3 entries in the breakout
groups list.

When a device does not have the capability to break a port
into interfaces of different speeds and different number of
physical channels, it would breakout a 400G OSFP port with
8 physical channels in the following configuration:

50G -> 8 interfaces with 1 physical channel each, this would
result in 1 entry in the breakout groups list.
    """
    return self.__groups
      
  def _set_groups(self, v, load=False):
    """
    Setter method for groups, mapped from YANG variable /components/component/port/breakout_mode/groups (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_groups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_groups() directly.

    YANG Description: Top level container for breakout groups data.

When a device has the capability to break a port into
interfaces of different speeds and different number of
physical channels, it can breakout a 400G OSFP port with
8 physical channels (with support for 25G NRZ, 50G PAM4
and 100G PAM4) in the following configuration:

100G + 100G + 200G -> 1 interface with 2 physical channels
and 1 interface with 4 physical channels and 1 interface with
2 physical channels. With this configuration the interface in
1st breakout group would use 50G PAM4 modulation, interface
in 2nd breakout group would use 25G NRZ modulation and the
interface in 3rd breakout group would use 100G PAM4 modulation
This configuration would result in 3 entries in the breakout
groups list.

When a device does not have the capability to break a port
into interfaces of different speeds and different number of
physical channels, it would breakout a 400G OSFP port with
8 physical channels in the following configuration:

50G -> 8 interfaces with 1 physical channel each, this would
result in 1 entry in the breakout groups list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_groups_openconfig_platform__components_component_port_breakout_mode_groups, is_container='container', yang_name="groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """groups must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_groups_openconfig_platform__components_component_port_breakout_mode_groups, is_container='container', yang_name="groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)""",
        })

    self.__groups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_groups(self):
    self.__groups = YANGDynClass(base=yc_groups_openconfig_platform__components_component_port_breakout_mode_groups, is_container='container', yang_name="groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)

  groups = __builtin__.property(_get_groups, _set_groups)


  _pyangbind_elements = OrderedDict([('groups', groups), ])


class yc_port_openconfig_platform__components_component_port(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/port. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for physical port components
  """
  __slots__ = ('_path_helper', '_extmethods', '__breakout_mode',)

  _yang_name = 'port'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__breakout_mode = YANGDynClass(base=yc_breakout_mode_openconfig_platform__components_component_port_breakout_mode, is_container='container', yang_name="breakout-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port']

  def _get_breakout_mode(self):
    """
    Getter method for breakout_mode, mapped from YANG variable /components/component/port/breakout_mode (container)

    YANG Description: Top-level container for port breakout-mode data.
    """
    return self.__breakout_mode
      
  def _set_breakout_mode(self, v, load=False):
    """
    Setter method for breakout_mode, mapped from YANG variable /components/component/port/breakout_mode (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_breakout_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_breakout_mode() directly.

    YANG Description: Top-level container for port breakout-mode data.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_breakout_mode_openconfig_platform__components_component_port_breakout_mode, is_container='container', yang_name="breakout-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """breakout_mode must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_breakout_mode_openconfig_platform__components_component_port_breakout_mode, is_container='container', yang_name="breakout-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)""",
        })

    self.__breakout_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_breakout_mode(self):
    self.__breakout_mode = YANGDynClass(base=yc_breakout_mode_openconfig_platform__components_component_port_breakout_mode, is_container='container', yang_name="breakout-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='container', is_config=True)

  breakout_mode = __builtin__.property(_get_breakout_mode, _set_breakout_mode)


  _pyangbind_elements = OrderedDict([('breakout_mode', breakout_mode), ])


class yc_config_openconfig_platform__components_component_power_supply_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/power-supply/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for power supply components
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'power-supply', 'config']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /components/component/power_supply/config/enabled (boolean)

    YANG Description: Adminsitrative control on the on/off state of the power
supply unit.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /components/component/power_supply/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Adminsitrative control on the on/off state of the power
supply unit.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=True)

  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ])


class yc_state_openconfig_platform__components_component_power_supply_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/power-supply/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for power supply components
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__capacity','__input_current','__input_voltage','__output_current','__output_voltage','__output_power',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=False)
    self.__capacity = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__input_current = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__input_voltage = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__output_current = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__output_voltage = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__output_power = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'power-supply', 'state']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /components/component/power_supply/state/enabled (boolean)

    YANG Description: Adminsitrative control on the on/off state of the power
supply unit.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /components/component/power_supply/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Adminsitrative control on the on/off state of the power
supply unit.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='boolean', is_config=False)


  def _get_capacity(self):
    """
    Getter method for capacity, mapped from YANG variable /components/component/power_supply/state/capacity (oc-types:ieeefloat32)

    YANG Description: Maximum power capacity of the power supply.
    """
    return self.__capacity
      
  def _set_capacity(self, v, load=False):
    """
    Setter method for capacity, mapped from YANG variable /components/component/power_supply/state/capacity (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_capacity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_capacity() directly.

    YANG Description: Maximum power capacity of the power supply.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """capacity must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__capacity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_capacity(self):
    self.__capacity = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_input_current(self):
    """
    Getter method for input_current, mapped from YANG variable /components/component/power_supply/state/input_current (oc-types:ieeefloat32)

    YANG Description: The input current draw of the power supply.
    """
    return self.__input_current
      
  def _set_input_current(self, v, load=False):
    """
    Setter method for input_current, mapped from YANG variable /components/component/power_supply/state/input_current (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input_current is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input_current() directly.

    YANG Description: The input current draw of the power supply.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input_current must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__input_current = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input_current(self):
    self.__input_current = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_input_voltage(self):
    """
    Getter method for input_voltage, mapped from YANG variable /components/component/power_supply/state/input_voltage (oc-types:ieeefloat32)

    YANG Description: Input voltage to the power supply.
    """
    return self.__input_voltage
      
  def _set_input_voltage(self, v, load=False):
    """
    Setter method for input_voltage, mapped from YANG variable /components/component/power_supply/state/input_voltage (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_input_voltage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_input_voltage() directly.

    YANG Description: Input voltage to the power supply.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """input_voltage must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__input_voltage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_input_voltage(self):
    self.__input_voltage = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="input-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_output_current(self):
    """
    Getter method for output_current, mapped from YANG variable /components/component/power_supply/state/output_current (oc-types:ieeefloat32)

    YANG Description: The output current supplied by the power supply.
    """
    return self.__output_current
      
  def _set_output_current(self, v, load=False):
    """
    Setter method for output_current, mapped from YANG variable /components/component/power_supply/state/output_current (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_current is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_current() directly.

    YANG Description: The output current supplied by the power supply.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_current must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__output_current = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_current(self):
    self.__output_current = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-current", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_output_voltage(self):
    """
    Getter method for output_voltage, mapped from YANG variable /components/component/power_supply/state/output_voltage (oc-types:ieeefloat32)

    YANG Description: Output voltage supplied by the power supply.
    """
    return self.__output_voltage
      
  def _set_output_voltage(self, v, load=False):
    """
    Setter method for output_voltage, mapped from YANG variable /components/component/power_supply/state/output_voltage (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_voltage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_voltage() directly.

    YANG Description: Output voltage supplied by the power supply.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_voltage must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__output_voltage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_voltage(self):
    self.__output_voltage = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-voltage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_output_power(self):
    """
    Getter method for output_power, mapped from YANG variable /components/component/power_supply/state/output_power (oc-types:ieeefloat32)

    YANG Description: Output power supplied by the power supply.
    """
    return self.__output_power
      
  def _set_output_power(self, v, load=False):
    """
    Setter method for output_power, mapped from YANG variable /components/component/power_supply/state/output_power (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_output_power() directly.

    YANG Description: Output power supplied by the power supply.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """output_power must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_output_power(self):
    self.__output_power = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/psu', defining_module='openconfig-platform-psu', yang_type='oc-types:ieeefloat32', is_config=False)

  enabled = __builtin__.property(_get_enabled)
  capacity = __builtin__.property(_get_capacity)
  input_current = __builtin__.property(_get_input_current)
  input_voltage = __builtin__.property(_get_input_voltage)
  output_current = __builtin__.property(_get_output_current)
  output_voltage = __builtin__.property(_get_output_voltage)
  output_power = __builtin__.property(_get_output_power)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('capacity', capacity), ('input_current', input_current), ('input_voltage', input_voltage), ('output_current', output_current), ('output_voltage', output_voltage), ('output_power', output_power), ])


class yc_power_supply_openconfig_platform__components_component_power_supply(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/power-supply. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for power supply components
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'power-supply'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_power_supply_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_power_supply_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'power-supply']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/power_supply/config (container)

    YANG Description: Configuration data for power supply components
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/power_supply/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for power supply components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_platform__components_component_power_supply_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_platform__components_component_power_supply_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_power_supply_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/power_supply/state (container)

    YANG Description: Operational state data for power supply components
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/power_supply/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for power supply components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_power_supply_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_power_supply_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_power_supply_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_state_openconfig_platform__components_component_fan_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/fan/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for fan components
  """
  __slots__ = ('_path_helper', '_extmethods', '__speed',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__speed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/fan', defining_module='openconfig-platform-fan', yang_type='uint32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'fan', 'state']

  def _get_speed(self):
    """
    Getter method for speed, mapped from YANG variable /components/component/fan/state/speed (uint32)

    YANG Description: Current (instantaneous) fan speed
    """
    return self.__speed
      
  def _set_speed(self, v, load=False):
    """
    Setter method for speed, mapped from YANG variable /components/component/fan/state/speed (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_speed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_speed() directly.

    YANG Description: Current (instantaneous) fan speed
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/fan', defining_module='openconfig-platform-fan', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """speed must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/fan', defining_module='openconfig-platform-fan', yang_type='uint32', is_config=False)""",
        })

    self.__speed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_speed(self):
    self.__speed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/fan', defining_module='openconfig-platform-fan', yang_type='uint32', is_config=False)

  speed = __builtin__.property(_get_speed)


  _pyangbind_elements = OrderedDict([('speed', speed), ])


class yc_fan_openconfig_platform__components_component_fan(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/fan. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for fan components
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'fan'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_fan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'fan']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/fan/state (container)

    YANG Description: Operational state data for fan components
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/fan/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for fan components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_fan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_fan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_fan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_fabric_openconfig_platform__components_component_fabric(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/fabric. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for fabric components
  """
  _pyangbind_elements = {}

  

class yc_storage_openconfig_platform__components_component_storage(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/storage. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for storage components
  """
  _pyangbind_elements = {}

  

class yc_state_openconfig_platform__components_component_cpu_utilization_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/cpu/utilization/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state variables relating to the utilization
of the CPU.
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'cpu', 'utilization', 'state']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /components/component/cpu/utilization/state/instant (oc-types:percentage)

    YANG Description: The instantaneous percentage value.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /components/component/cpu/utilization/state/instant (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous percentage value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /components/component/cpu/utilization/state/avg (oc-types:percentage)

    YANG Description: The arithmetic mean value of the percentage measure of the
statistic over the time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /components/component/cpu/utilization/state/avg (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the percentage measure of the
statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /components/component/cpu/utilization/state/min (oc-types:percentage)

    YANG Description: The minimum value of the percentage measure of the
statistic over the time interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /components/component/cpu/utilization/state/min (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the percentage measure of the
statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /components/component/cpu/utilization/state/max (oc-types:percentage)

    YANG Description: The maximum value of the percentage measure of the
statistic over the time interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /components/component/cpu/utilization/state/max (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the percentage measure of the
statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:percentage', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /components/component/cpu/utilization/state/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /components/component/cpu/utilization/state/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /components/component/cpu/utilization/state/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /components/component/cpu/utilization/state/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /components/component/cpu/utilization/state/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /components/component/cpu/utilization/state/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_utilization_openconfig_platform__components_component_cpu_utilization(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/cpu/utilization. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Statistics representing CPU utilization of the
component.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'utilization'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_cpu_utilization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'cpu', 'utilization']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/cpu/utilization/state (container)

    YANG Description: Operational state variables relating to the utilization
of the CPU.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/cpu/utilization/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state variables relating to the utilization
of the CPU.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_cpu_utilization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_cpu_utilization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_cpu_utilization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)

  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_cpu_openconfig_platform__components_component_cpu(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/cpu. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for cpu components
  """
  __slots__ = ('_path_helper', '_extmethods', '__utilization',)

  _yang_name = 'cpu'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__utilization = YANGDynClass(base=yc_utilization_openconfig_platform__components_component_cpu_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'cpu']

  def _get_utilization(self):
    """
    Getter method for utilization, mapped from YANG variable /components/component/cpu/utilization (container)

    YANG Description: Statistics representing CPU utilization of the
component.
    """
    return self.__utilization
      
  def _set_utilization(self, v, load=False):
    """
    Setter method for utilization, mapped from YANG variable /components/component/cpu/utilization (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilization() directly.

    YANG Description: Statistics representing CPU utilization of the
component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_utilization_openconfig_platform__components_component_cpu_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilization must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_utilization_openconfig_platform__components_component_cpu_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)""",
        })

    self.__utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilization(self):
    self.__utilization = YANGDynClass(base=yc_utilization_openconfig_platform__components_component_cpu_utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/cpu', defining_module='openconfig-platform-cpu', yang_type='container', is_config=True)

  utilization = __builtin__.property(_get_utilization, _set_utilization)


  _pyangbind_elements = OrderedDict([('utilization', utilization), ])


class yc_config_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/utilization/resources/resource/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each resource.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'utilization', 'resources', 'resource', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/config/name (string)

    YANG Description: Resource name within the component.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Resource name within the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)


  _pyangbind_elements = OrderedDict([('name', name), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/utilization/resources/resource/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each resource.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__used','__committed','__free','__max_limit','__high_watermark','__last_high_watermark',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'utilization', 'resources', 'resource', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/name (string)

    YANG Description: Resource name within the component.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Resource name within the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_used(self):
    """
    Getter method for used, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/used (uint64)

    YANG Description: Number of entries currently in use for the resource.
    """
    return self.__used
      
  def _set_used(self, v, load=False):
    """
    Setter method for used, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/used (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_used is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_used() directly.

    YANG Description: Number of entries currently in use for the resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """used must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__used = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_used(self):
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_committed(self):
    """
    Getter method for committed, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/committed (uint64)

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    return self.__committed
      
  def _set_committed(self, v, load=False):
    """
    Setter method for committed, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/committed (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_committed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_committed() directly.

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """committed must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__committed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_committed(self):
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_free(self):
    """
    Getter method for free, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/free (uint64)

    YANG Description: Number of entries available to use.
    """
    return self.__free
      
  def _set_free(self, v, load=False):
    """
    Setter method for free, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/free (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_free is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_free() directly.

    YANG Description: Number of entries available to use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """free must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__free = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_free(self):
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_max_limit(self):
    """
    Getter method for max_limit, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/max_limit (uint64)

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    return self.__max_limit
      
  def _set_max_limit(self, v, load=False):
    """
    Setter method for max_limit, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/max_limit (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_limit() directly.

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_limit must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__max_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_limit(self):
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_high_watermark(self):
    """
    Getter method for high_watermark, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/high_watermark (uint64)

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    return self.__high_watermark
      
  def _set_high_watermark(self, v, load=False):
    """
    Setter method for high_watermark, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/high_watermark (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_high_watermark() directly.

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """high_watermark must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_high_watermark(self):
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_last_high_watermark(self):
    """
    Getter method for last_high_watermark, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)

    YANG Description: The time when the high-watermark was last updated
    """
    return self.__last_high_watermark
      
  def _set_last_high_watermark(self, v, load=False):
    """
    Setter method for last_high_watermark, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_high_watermark() directly.

    YANG Description: The time when the high-watermark was last updated
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_high_watermark must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_high_watermark(self):
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

  name = __builtin__.property(_get_name)
  used = __builtin__.property(_get_used)
  committed = __builtin__.property(_get_committed)
  free = __builtin__.property(_get_free)
  max_limit = __builtin__.property(_get_max_limit)
  high_watermark = __builtin__.property(_get_high_watermark)
  last_high_watermark = __builtin__.property(_get_last_high_watermark)


  _pyangbind_elements = OrderedDict([('name', name), ('used', used), ('committed', committed), ('free', free), ('max_limit', max_limit), ('high_watermark', high_watermark), ('last_high_watermark', last_high_watermark), ])


class yc_resource_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/utilization/resources/resource. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of resources, keyed by resource name.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'resource'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'utilization', 'resources', 'resource']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/name (leafref)

    YANG Description: References the resource name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: References the resource name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/config (container)

    YANG Description: Configuration data for each resource.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state (container)

    YANG Description: Operational state data for each resource.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_resources_openconfig_platform__components_component_integrated_circuit_utilization_resources(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/utilization/resources. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the resources in this component.
  """
  __slots__ = ('_path_helper', '_extmethods', '__resource',)

  _yang_name = 'resources'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__resource = YANGDynClass(base=YANGListType("name",yc_resource_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'utilization', 'resources']

  def _get_resource(self):
    """
    Getter method for resource, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource (list)

    YANG Description: List of resources, keyed by resource name.
    """
    return self.__resource
      
  def _set_resource(self, v, load=False):
    """
    Setter method for resource, mapped from YANG variable /components/component/integrated_circuit/utilization/resources/resource (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_resource is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_resource() directly.

    YANG Description: List of resources, keyed by resource name.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_resource_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """resource must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_resource_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)""",
        })

    self.__resource = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_resource(self):
    self.__resource = YANGDynClass(base=YANGListType("name",yc_resource_openconfig_platform__components_component_integrated_circuit_utilization_resources_resource, yang_name="resource", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='list', is_config=True)

  resource = __builtin__.property(_get_resource, _set_resource)


  _pyangbind_elements = OrderedDict([('resource', resource), ])


class yc_utilization_openconfig_platform__components_component_integrated_circuit_utilization(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/utilization. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Utilization of the component.
  """
  __slots__ = ('_path_helper', '_extmethods', '__resources',)

  _yang_name = 'utilization'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__resources = YANGDynClass(base=yc_resources_openconfig_platform__components_component_integrated_circuit_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'utilization']

  def _get_resources(self):
    """
    Getter method for resources, mapped from YANG variable /components/component/integrated_circuit/utilization/resources (container)

    YANG Description: Enclosing container for the resources in this component.
    """
    return self.__resources
      
  def _set_resources(self, v, load=False):
    """
    Setter method for resources, mapped from YANG variable /components/component/integrated_circuit/utilization/resources (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_resources is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_resources() directly.

    YANG Description: Enclosing container for the resources in this component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_resources_openconfig_platform__components_component_integrated_circuit_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """resources must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_resources_openconfig_platform__components_component_integrated_circuit_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__resources = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_resources(self):
    self.__resources = YANGDynClass(base=yc_resources_openconfig_platform__components_component_integrated_circuit_utilization_resources, is_container='container', yang_name="resources", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  resources = __builtin__.property(_get_resources, _set_resources)


  _pyangbind_elements = OrderedDict([('resources', resources), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_backplane_facing_capacity_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/backplane-facing-capacity/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to backplane capacity.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total','__total_operational_capacity','__consumed_capacity','__available_pct',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    self.__total_operational_capacity = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-operational-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    self.__consumed_capacity = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="consumed-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    self.__available_pct = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="available-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'backplane-facing-capacity', 'state']

  def _get_total(self):
    """
    Getter method for total, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/total (uint64)

    YANG Description: Total backplane-facing capacity that is available in the presence
of no link failures or degradation.
    """
    return self.__total
      
  def _set_total(self, v, load=False):
    """
    Setter method for total, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/total (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total() directly.

    YANG Description: Total backplane-facing capacity that is available in the presence
of no link failures or degradation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)""",
        })

    self.__total = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total(self):
    self.__total = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)


  def _get_total_operational_capacity(self):
    """
    Getter method for total_operational_capacity, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/total_operational_capacity (uint64)

    YANG Description: Total backplane-facing capacity that is currently available based
on the active links.
    """
    return self.__total_operational_capacity
      
  def _set_total_operational_capacity(self, v, load=False):
    """
    Setter method for total_operational_capacity, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/total_operational_capacity (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_operational_capacity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_operational_capacity() directly.

    YANG Description: Total backplane-facing capacity that is currently available based
on the active links.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-operational-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_operational_capacity must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-operational-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)""",
        })

    self.__total_operational_capacity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_operational_capacity(self):
    self.__total_operational_capacity = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-operational-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)


  def _get_consumed_capacity(self):
    """
    Getter method for consumed_capacity, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/consumed_capacity (uint64)

    YANG Description: Backplane-facing capacity that is consumed by front-panel ports that are connected
to the integrated circuit and are operationally up.
    """
    return self.__consumed_capacity
      
  def _set_consumed_capacity(self, v, load=False):
    """
    Setter method for consumed_capacity, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/consumed_capacity (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_consumed_capacity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_consumed_capacity() directly.

    YANG Description: Backplane-facing capacity that is consumed by front-panel ports that are connected
to the integrated circuit and are operationally up.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="consumed-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """consumed_capacity must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="consumed-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)""",
        })

    self.__consumed_capacity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_consumed_capacity(self):
    self.__consumed_capacity = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="consumed-capacity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)


  def _get_available_pct(self):
    """
    Getter method for available_pct, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/available_pct (uint16)

    YANG Description: Percentage of the total backplane-facing capacity that is currently available to the front
panel ports taking into account failures and/or degradation within the system.

In the case that there is more backplane-facing capacity available than the front-panel
ports consume, this value may be greater than 100%.
    """
    return self.__available_pct
      
  def _set_available_pct(self, v, load=False):
    """
    Setter method for available_pct, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state/available_pct (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_available_pct is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_available_pct() directly.

    YANG Description: Percentage of the total backplane-facing capacity that is currently available to the front
panel ports taking into account failures and/or degradation within the system.

In the case that there is more backplane-facing capacity available than the front-panel
ports consume, this value may be greater than 100%.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="available-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """available_pct must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="available-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint16', is_config=False)""",
        })

    self.__available_pct = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_available_pct(self):
    self.__available_pct = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="available-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint16', is_config=False)

  total = __builtin__.property(_get_total)
  total_operational_capacity = __builtin__.property(_get_total_operational_capacity)
  consumed_capacity = __builtin__.property(_get_consumed_capacity)
  available_pct = __builtin__.property(_get_available_pct)


  _pyangbind_elements = OrderedDict([('total', total), ('total_operational_capacity', total_operational_capacity), ('consumed_capacity', consumed_capacity), ('available_pct', available_pct), ])


class yc_backplane_facing_capacity_openconfig_platform__components_component_integrated_circuit_backplane_facing_capacity(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/backplane-facing-capacity. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container allows a particular INTEGRATED_CIRCUIT to report its
available backplane-facing bandwidth. Where an integrated circuit is connected
by one or more links to the system's backplane, the capacity is the total cross-
sectional bandwidth available from the input ports of the integrated circuit
across the fabric. The capacity should also reflect the operational status of
the links.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'backplane-facing-capacity'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_backplane_facing_capacity_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'backplane-facing-capacity']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state (container)

    YANG Description: Operational state parameters relating to backplane capacity.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/backplane_facing_capacity/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to backplane capacity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_backplane_facing_capacity_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_backplane_facing_capacity_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_backplane_facing_capacity_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)

  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_memory_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/memory/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to integrated circuit memory.
  """
  __slots__ = ('_path_helper', '_extmethods', '__corrected_parity_errors','__uncorrected_parity_errors','__total_parity_errors',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__corrected_parity_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="corrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    self.__uncorrected_parity_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="uncorrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    self.__total_parity_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'memory', 'state']

  def _get_corrected_parity_errors(self):
    """
    Getter method for corrected_parity_errors, mapped from YANG variable /components/component/integrated_circuit/memory/state/corrected_parity_errors (uint64)

    YANG Description: Number of corrected parity errors. Single bit ECC errors can be
detected and corrected by most integrated circuits.
    """
    return self.__corrected_parity_errors
      
  def _set_corrected_parity_errors(self, v, load=False):
    """
    Setter method for corrected_parity_errors, mapped from YANG variable /components/component/integrated_circuit/memory/state/corrected_parity_errors (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_corrected_parity_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_corrected_parity_errors() directly.

    YANG Description: Number of corrected parity errors. Single bit ECC errors can be
detected and corrected by most integrated circuits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="corrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """corrected_parity_errors must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="corrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)""",
        })

    self.__corrected_parity_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_corrected_parity_errors(self):
    self.__corrected_parity_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="corrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)


  def _get_uncorrected_parity_errors(self):
    """
    Getter method for uncorrected_parity_errors, mapped from YANG variable /components/component/integrated_circuit/memory/state/uncorrected_parity_errors (uint64)

    YANG Description: Number of uncorrected parity errors. Multi-bit ECC errors can be
detected but cannot be corrected by most integrated circuits.
    """
    return self.__uncorrected_parity_errors
      
  def _set_uncorrected_parity_errors(self, v, load=False):
    """
    Setter method for uncorrected_parity_errors, mapped from YANG variable /components/component/integrated_circuit/memory/state/uncorrected_parity_errors (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_uncorrected_parity_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_uncorrected_parity_errors() directly.

    YANG Description: Number of uncorrected parity errors. Multi-bit ECC errors can be
detected but cannot be corrected by most integrated circuits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="uncorrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """uncorrected_parity_errors must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="uncorrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)""",
        })

    self.__uncorrected_parity_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_uncorrected_parity_errors(self):
    self.__uncorrected_parity_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="uncorrected-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)


  def _get_total_parity_errors(self):
    """
    Getter method for total_parity_errors, mapped from YANG variable /components/component/integrated_circuit/memory/state/total_parity_errors (uint64)

    YANG Description: Total number of parity errors. This includes both the corrected and
uncorrected parity errors.
    """
    return self.__total_parity_errors
      
  def _set_total_parity_errors(self, v, load=False):
    """
    Setter method for total_parity_errors, mapped from YANG variable /components/component/integrated_circuit/memory/state/total_parity_errors (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_parity_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_parity_errors() directly.

    YANG Description: Total number of parity errors. This includes both the corrected and
uncorrected parity errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_parity_errors must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)""",
        })

    self.__total_parity_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_parity_errors(self):
    self.__total_parity_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-parity-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='uint64', is_config=False)

  corrected_parity_errors = __builtin__.property(_get_corrected_parity_errors)
  uncorrected_parity_errors = __builtin__.property(_get_uncorrected_parity_errors)
  total_parity_errors = __builtin__.property(_get_total_parity_errors)


  _pyangbind_elements = OrderedDict([('corrected_parity_errors', corrected_parity_errors), ('uncorrected_parity_errors', uncorrected_parity_errors), ('total_parity_errors', total_parity_errors), ])


class yc_memory_openconfig_platform__components_component_integrated_circuit_memory(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/memory. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for integrated circuit memory.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'memory'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_memory_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'memory']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/memory/state (container)

    YANG Description: Operational state parameters relating to integrated circuit memory.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/memory/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to integrated circuit memory.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_memory_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_memory_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_memory_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform/integrated-circuit', defining_module='openconfig-platform-integrated-circuit', yang_type='container', is_config=True)

  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/interface-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State and counters corresponding to the interface subsystem of
the IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_packets','__out_packets','__in_bytes','__out_bytes',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'interface-block', 'state']

  def _get_in_packets(self):
    """
    Getter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/in_packets (oc-yang:counter64)

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_packets
      
  def _set_in_packets(self, v, load=False):
    """
    Setter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/in_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_packets() directly.

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_packets(self):
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_packets(self):
    """
    Getter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/out_packets (oc-yang:counter64)

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_packets
      
  def _set_out_packets(self, v, load=False):
    """
    Setter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/out_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_packets() directly.

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_packets(self):
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_bytes(self):
    """
    Getter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/in_bytes (oc-yang:counter64)

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_bytes
      
  def _set_in_bytes(self, v, load=False):
    """
    Setter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/in_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_bytes() directly.

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_bytes(self):
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_bytes(self):
    """
    Getter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/out_bytes (oc-yang:counter64)

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_bytes
      
  def _set_out_bytes(self, v, load=False):
    """
    Setter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state/out_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_bytes() directly.

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_bytes(self):
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  in_packets = __builtin__.property(_get_in_packets)
  out_packets = __builtin__.property(_get_out_packets)
  in_bytes = __builtin__.property(_get_in_bytes)
  out_bytes = __builtin__.property(_get_out_bytes)


  _pyangbind_elements = OrderedDict([('in_packets', in_packets), ('out_packets', out_packets), ('in_bytes', in_bytes), ('out_bytes', out_bytes), ])


class yc_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/interface-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC interface subsystem connects the IC to the external PHY or
MAC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'interface-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'interface-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state (container)

    YANG Description: State and counters corresponding to the interface subsystem of
the IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State and counters corresponding to the interface subsystem of
the IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/lookup-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State and counters corresponding to the lookup subsystem of the
IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__lookup_utilization','__in_packets','__out_packets','__in_bytes','__out_bytes','__lookup_memory','__lookup_memory_used','__nexthop_memory','__nexthop_memory_used','__acl_memory_total_entries','__acl_memory_used_entries','__acl_memory_total_bytes','__acl_memory_used_bytes','__fragment_total_pkts',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__lookup_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="lookup-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-types:percentage', is_config=False)
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__lookup_memory = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__lookup_memory_used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__nexthop_memory = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__nexthop_memory_used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__acl_memory_total_entries = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__acl_memory_used_entries = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__acl_memory_total_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__acl_memory_used_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__fragment_total_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'lookup-block', 'state']

  def _get_lookup_utilization(self):
    """
    Getter method for lookup_utilization, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/lookup_utilization (oc-types:percentage)

    YANG Description: The integrated-circuit lookup subsystem block utilization percentage.
    """
    return self.__lookup_utilization
      
  def _set_lookup_utilization(self, v, load=False):
    """
    Setter method for lookup_utilization, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/lookup_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lookup_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lookup_utilization() directly.

    YANG Description: The integrated-circuit lookup subsystem block utilization percentage.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="lookup-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lookup_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="lookup-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__lookup_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lookup_utilization(self):
    self.__lookup_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="lookup-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-types:percentage', is_config=False)


  def _get_in_packets(self):
    """
    Getter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/in_packets (oc-yang:counter64)

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_packets
      
  def _set_in_packets(self, v, load=False):
    """
    Setter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/in_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_packets() directly.

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_packets(self):
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_packets(self):
    """
    Getter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/out_packets (oc-yang:counter64)

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_packets
      
  def _set_out_packets(self, v, load=False):
    """
    Setter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/out_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_packets() directly.

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_packets(self):
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_bytes(self):
    """
    Getter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/in_bytes (oc-yang:counter64)

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_bytes
      
  def _set_in_bytes(self, v, load=False):
    """
    Setter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/in_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_bytes() directly.

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_bytes(self):
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_bytes(self):
    """
    Getter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/out_bytes (oc-yang:counter64)

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_bytes
      
  def _set_out_bytes(self, v, load=False):
    """
    Setter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/out_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_bytes() directly.

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_bytes(self):
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_lookup_memory(self):
    """
    Getter method for lookup_memory, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/lookup_memory (uint64)

    YANG Description: The total amount of memory available in the lookup subsystem.
    """
    return self.__lookup_memory
      
  def _set_lookup_memory(self, v, load=False):
    """
    Setter method for lookup_memory, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/lookup_memory (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lookup_memory is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lookup_memory() directly.

    YANG Description: The total amount of memory available in the lookup subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lookup_memory must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__lookup_memory = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lookup_memory(self):
    self.__lookup_memory = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_lookup_memory_used(self):
    """
    Getter method for lookup_memory_used, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/lookup_memory_used (uint64)

    YANG Description: The amount of memory used in the lookup subsystem.
    """
    return self.__lookup_memory_used
      
  def _set_lookup_memory_used(self, v, load=False):
    """
    Setter method for lookup_memory_used, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/lookup_memory_used (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lookup_memory_used is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lookup_memory_used() directly.

    YANG Description: The amount of memory used in the lookup subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lookup_memory_used must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__lookup_memory_used = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lookup_memory_used(self):
    self.__lookup_memory_used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_nexthop_memory(self):
    """
    Getter method for nexthop_memory, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/nexthop_memory (uint64)

    YANG Description: The total amount of nexthop memory available in the lookup subsystem.
    """
    return self.__nexthop_memory
      
  def _set_nexthop_memory(self, v, load=False):
    """
    Setter method for nexthop_memory, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/nexthop_memory (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_nexthop_memory is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_nexthop_memory() directly.

    YANG Description: The total amount of nexthop memory available in the lookup subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """nexthop_memory must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__nexthop_memory = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_nexthop_memory(self):
    self.__nexthop_memory = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_nexthop_memory_used(self):
    """
    Getter method for nexthop_memory_used, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/nexthop_memory_used (uint64)

    YANG Description: The amount of nexthops memory used in the lookup subsystem.
    """
    return self.__nexthop_memory_used
      
  def _set_nexthop_memory_used(self, v, load=False):
    """
    Setter method for nexthop_memory_used, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/nexthop_memory_used (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_nexthop_memory_used is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_nexthop_memory_used() directly.

    YANG Description: The amount of nexthops memory used in the lookup subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """nexthop_memory_used must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__nexthop_memory_used = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_nexthop_memory_used(self):
    self.__nexthop_memory_used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="nexthop-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_acl_memory_total_entries(self):
    """
    Getter method for acl_memory_total_entries, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_total_entries (uint64)

    YANG Description: Total firewall or ACL memory counter measured in entries.
    """
    return self.__acl_memory_total_entries
      
  def _set_acl_memory_total_entries(self, v, load=False):
    """
    Setter method for acl_memory_total_entries, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_total_entries (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_memory_total_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_memory_total_entries() directly.

    YANG Description: Total firewall or ACL memory counter measured in entries.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_memory_total_entries must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__acl_memory_total_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_memory_total_entries(self):
    self.__acl_memory_total_entries = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_acl_memory_used_entries(self):
    """
    Getter method for acl_memory_used_entries, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_used_entries (uint64)

    YANG Description: Amount of used firewall or ACL memory counter measured in entries.
The number of used entries must include the entries
that are 'allocated but free' if the memory reaping algorithm makes
these entries practically unusable.
    """
    return self.__acl_memory_used_entries
      
  def _set_acl_memory_used_entries(self, v, load=False):
    """
    Setter method for acl_memory_used_entries, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_used_entries (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_memory_used_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_memory_used_entries() directly.

    YANG Description: Amount of used firewall or ACL memory counter measured in entries.
The number of used entries must include the entries
that are 'allocated but free' if the memory reaping algorithm makes
these entries practically unusable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_memory_used_entries must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__acl_memory_used_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_memory_used_entries(self):
    self.__acl_memory_used_entries = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_acl_memory_total_bytes(self):
    """
    Getter method for acl_memory_total_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_total_bytes (uint64)

    YANG Description: Total firewall or ACL memory counter measured in bytes.
    """
    return self.__acl_memory_total_bytes
      
  def _set_acl_memory_total_bytes(self, v, load=False):
    """
    Setter method for acl_memory_total_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_total_bytes (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_memory_total_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_memory_total_bytes() directly.

    YANG Description: Total firewall or ACL memory counter measured in bytes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_memory_total_bytes must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__acl_memory_total_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_memory_total_bytes(self):
    self.__acl_memory_total_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-total-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_acl_memory_used_bytes(self):
    """
    Getter method for acl_memory_used_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_used_bytes (uint64)

    YANG Description: Amount of used firewall or ACL memory counter measured in bytes.
The number of used bytes must include the bytes
that are 'allocated but free' if the memory reaping algorithm makes
these bytes practically unusable
    """
    return self.__acl_memory_used_bytes
      
  def _set_acl_memory_used_bytes(self, v, load=False):
    """
    Setter method for acl_memory_used_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/acl_memory_used_bytes (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_memory_used_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_memory_used_bytes() directly.

    YANG Description: Amount of used firewall or ACL memory counter measured in bytes.
The number of used bytes must include the bytes
that are 'allocated but free' if the memory reaping algorithm makes
these bytes practically unusable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_memory_used_bytes must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__acl_memory_used_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_memory_used_bytes(self):
    self.__acl_memory_used_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-memory-used-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_fragment_total_pkts(self):
    """
    Getter method for fragment_total_pkts, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/fragment_total_pkts (oc-yang:counter64)

    YANG Description: Total number of fragments generated by the CPU.
    """
    return self.__fragment_total_pkts
      
  def _set_fragment_total_pkts(self, v, load=False):
    """
    Setter method for fragment_total_pkts, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state/fragment_total_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fragment_total_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fragment_total_pkts() directly.

    YANG Description: Total number of fragments generated by the CPU.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fragment_total_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__fragment_total_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fragment_total_pkts(self):
    self.__fragment_total_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  lookup_utilization = __builtin__.property(_get_lookup_utilization)
  in_packets = __builtin__.property(_get_in_packets)
  out_packets = __builtin__.property(_get_out_packets)
  in_bytes = __builtin__.property(_get_in_bytes)
  out_bytes = __builtin__.property(_get_out_bytes)
  lookup_memory = __builtin__.property(_get_lookup_memory)
  lookup_memory_used = __builtin__.property(_get_lookup_memory_used)
  nexthop_memory = __builtin__.property(_get_nexthop_memory)
  nexthop_memory_used = __builtin__.property(_get_nexthop_memory_used)
  acl_memory_total_entries = __builtin__.property(_get_acl_memory_total_entries)
  acl_memory_used_entries = __builtin__.property(_get_acl_memory_used_entries)
  acl_memory_total_bytes = __builtin__.property(_get_acl_memory_total_bytes)
  acl_memory_used_bytes = __builtin__.property(_get_acl_memory_used_bytes)
  fragment_total_pkts = __builtin__.property(_get_fragment_total_pkts)


  _pyangbind_elements = OrderedDict([('lookup_utilization', lookup_utilization), ('in_packets', in_packets), ('out_packets', out_packets), ('in_bytes', in_bytes), ('out_bytes', out_bytes), ('lookup_memory', lookup_memory), ('lookup_memory_used', lookup_memory_used), ('nexthop_memory', nexthop_memory), ('nexthop_memory_used', nexthop_memory_used), ('acl_memory_total_entries', acl_memory_total_entries), ('acl_memory_used_entries', acl_memory_used_entries), ('acl_memory_total_bytes', acl_memory_total_bytes), ('acl_memory_used_bytes', acl_memory_used_bytes), ('fragment_total_pkts', fragment_total_pkts), ])


class yc_lookup_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/lookup-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC lookup subsystem perform the next hop lookup of the packet
and other forwarding features such as firewall filters.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'lookup-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'lookup-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state (container)

    YANG Description: State and counters corresponding to the lookup subsystem of the
IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State and counters corresponding to the lookup subsystem of the
IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/queueing-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State and counters corresponding to the queueing subsystem of
the IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_packets','__out_packets','__in_bytes','__out_bytes','__queue_memory','__queue_memory_used','__loopback_packets','__loopback_bytes',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__queue_memory = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__queue_memory_used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    self.__loopback_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__loopback_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'queueing-block', 'state']

  def _get_in_packets(self):
    """
    Getter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/in_packets (oc-yang:counter64)

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_packets
      
  def _set_in_packets(self, v, load=False):
    """
    Setter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/in_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_packets() directly.

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_packets(self):
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_packets(self):
    """
    Getter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/out_packets (oc-yang:counter64)

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_packets
      
  def _set_out_packets(self, v, load=False):
    """
    Setter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/out_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_packets() directly.

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_packets(self):
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_bytes(self):
    """
    Getter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/in_bytes (oc-yang:counter64)

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_bytes
      
  def _set_in_bytes(self, v, load=False):
    """
    Setter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/in_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_bytes() directly.

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_bytes(self):
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_bytes(self):
    """
    Getter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/out_bytes (oc-yang:counter64)

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_bytes
      
  def _set_out_bytes(self, v, load=False):
    """
    Setter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/out_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_bytes() directly.

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_bytes(self):
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_queue_memory(self):
    """
    Getter method for queue_memory, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/queue_memory (uint64)

    YANG Description: The total amount of memory available in the queue subsystem.
    """
    return self.__queue_memory
      
  def _set_queue_memory(self, v, load=False):
    """
    Setter method for queue_memory, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/queue_memory (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_memory is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_memory() directly.

    YANG Description: The total amount of memory available in the queue subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_memory must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__queue_memory = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_memory(self):
    self.__queue_memory = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_queue_memory_used(self):
    """
    Getter method for queue_memory_used, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/queue_memory_used (uint64)

    YANG Description: The amount of memory used in the queue subsystem.
    """
    return self.__queue_memory_used
      
  def _set_queue_memory_used(self, v, load=False):
    """
    Setter method for queue_memory_used, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/queue_memory_used (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queue_memory_used is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queue_memory_used() directly.

    YANG Description: The amount of memory used in the queue subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queue_memory_used must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__queue_memory_used = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queue_memory_used(self):
    self.__queue_memory_used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="queue-memory-used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)


  def _get_loopback_packets(self):
    """
    Getter method for loopback_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/loopback_packets (oc-yang:counter64)

    YANG Description: The number of packets in the loopback or re-circulate subsystem.
    """
    return self.__loopback_packets
      
  def _set_loopback_packets(self, v, load=False):
    """
    Setter method for loopback_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/loopback_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_packets() directly.

    YANG Description: The number of packets in the loopback or re-circulate subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__loopback_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_packets(self):
    self.__loopback_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_loopback_bytes(self):
    """
    Getter method for loopback_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/loopback_bytes (uint64)

    YANG Description: The number of bytes in the loopback or re-circulate subsystem.
    """
    return self.__loopback_bytes
      
  def _set_loopback_bytes(self, v, load=False):
    """
    Setter method for loopback_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state/loopback_bytes (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_bytes() directly.

    YANG Description: The number of bytes in the loopback or re-circulate subsystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_bytes must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)""",
        })

    self.__loopback_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_bytes(self):
    self.__loopback_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="loopback-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='uint64', is_config=False)

  in_packets = __builtin__.property(_get_in_packets)
  out_packets = __builtin__.property(_get_out_packets)
  in_bytes = __builtin__.property(_get_in_bytes)
  out_bytes = __builtin__.property(_get_out_bytes)
  queue_memory = __builtin__.property(_get_queue_memory)
  queue_memory_used = __builtin__.property(_get_queue_memory_used)
  loopback_packets = __builtin__.property(_get_loopback_packets)
  loopback_bytes = __builtin__.property(_get_loopback_bytes)


  _pyangbind_elements = OrderedDict([('in_packets', in_packets), ('out_packets', out_packets), ('in_bytes', in_bytes), ('out_bytes', out_bytes), ('queue_memory', queue_memory), ('queue_memory_used', queue_memory_used), ('loopback_packets', loopback_packets), ('loopback_bytes', loopback_bytes), ])


class yc_queueing_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/queueing-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC queueing subsystem buffers the packet while processing it
and queues the packet for delivery to the next stage
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'queueing-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'queueing-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state (container)

    YANG Description: State and counters corresponding to the queueing subsystem of
the IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State and counters corresponding to the queueing subsystem of
the IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/fabric-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State and counters corresponding to the fabric subsystem of the
IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_cells','__out_cells','__in_packets','__out_packets','__in_bytes','__out_bytes','__in_high_priority_cells','__out_high_priority_cells','__in_low_priority_cells','__out_low_priority_cells','__in_high_priority_packets','__out_high_priority_packets','__in_low_priority_packets','__out_low_priority_packets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_high_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_high_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_low_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_low_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'fabric-block', 'state']

  def _get_in_cells(self):
    """
    Getter method for in_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_cells (oc-yang:counter64)

    YANG Description: Incoming cells towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    return self.__in_cells
      
  def _set_in_cells(self, v, load=False):
    """
    Setter method for in_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_cells (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_cells is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_cells() directly.

    YANG Description: Incoming cells towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_cells must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_cells = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_cells(self):
    self.__in_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_cells(self):
    """
    Getter method for out_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_cells (oc-yang:counter64)

    YANG Description: Outgoing cells towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    return self.__out_cells
      
  def _set_out_cells(self, v, load=False):
    """
    Setter method for out_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_cells (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_cells is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_cells() directly.

    YANG Description: Outgoing cells towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_cells must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_cells = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_cells(self):
    self.__out_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_packets(self):
    """
    Getter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_packets (oc-yang:counter64)

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_packets
      
  def _set_in_packets(self, v, load=False):
    """
    Setter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_packets() directly.

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_packets(self):
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_packets(self):
    """
    Getter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_packets (oc-yang:counter64)

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_packets
      
  def _set_out_packets(self, v, load=False):
    """
    Setter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_packets() directly.

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_packets(self):
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_bytes(self):
    """
    Getter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_bytes (oc-yang:counter64)

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_bytes
      
  def _set_in_bytes(self, v, load=False):
    """
    Setter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_bytes() directly.

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_bytes(self):
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_bytes(self):
    """
    Getter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_bytes (oc-yang:counter64)

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_bytes
      
  def _set_out_bytes(self, v, load=False):
    """
    Setter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_bytes() directly.

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_bytes(self):
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_high_priority_cells(self):
    """
    Getter method for in_high_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_high_priority_cells (oc-yang:counter64)

    YANG Description: Incoming high priority cells towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    return self.__in_high_priority_cells
      
  def _set_in_high_priority_cells(self, v, load=False):
    """
    Setter method for in_high_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_high_priority_cells (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_high_priority_cells is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_high_priority_cells() directly.

    YANG Description: Incoming high priority cells towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_high_priority_cells must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_high_priority_cells = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_high_priority_cells(self):
    self.__in_high_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_high_priority_cells(self):
    """
    Getter method for out_high_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_high_priority_cells (oc-yang:counter64)

    YANG Description: Outgoing high priority cells towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    return self.__out_high_priority_cells
      
  def _set_out_high_priority_cells(self, v, load=False):
    """
    Setter method for out_high_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_high_priority_cells (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_high_priority_cells is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_high_priority_cells() directly.

    YANG Description: Outgoing high priority cells towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_high_priority_cells must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_high_priority_cells = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_high_priority_cells(self):
    self.__out_high_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_low_priority_cells(self):
    """
    Getter method for in_low_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_low_priority_cells (oc-yang:counter64)

    YANG Description: Incoming low priority cells towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    return self.__in_low_priority_cells
      
  def _set_in_low_priority_cells(self, v, load=False):
    """
    Setter method for in_low_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_low_priority_cells (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_low_priority_cells is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_low_priority_cells() directly.

    YANG Description: Incoming low priority cells towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_low_priority_cells must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_low_priority_cells = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_low_priority_cells(self):
    self.__in_low_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_low_priority_cells(self):
    """
    Getter method for out_low_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_low_priority_cells (oc-yang:counter64)

    YANG Description: Outgoing low priority cells towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    return self.__out_low_priority_cells
      
  def _set_out_low_priority_cells(self, v, load=False):
    """
    Setter method for out_low_priority_cells, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_low_priority_cells (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_low_priority_cells is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_low_priority_cells() directly.

    YANG Description: Outgoing low priority cells towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_low_priority_cells must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_low_priority_cells = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_low_priority_cells(self):
    self.__out_low_priority_cells = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-cells", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_high_priority_packets(self):
    """
    Getter method for in_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_high_priority_packets (oc-yang:counter64)

    YANG Description: Incoming high priority packets towards the integrated-circuit
fabric subsystem block from the previous NPU sub block.
    """
    return self.__in_high_priority_packets
      
  def _set_in_high_priority_packets(self, v, load=False):
    """
    Setter method for in_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_high_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_high_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_high_priority_packets() directly.

    YANG Description: Incoming high priority packets towards the integrated-circuit
fabric subsystem block from the previous NPU sub block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_high_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_high_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_high_priority_packets(self):
    self.__in_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_high_priority_packets(self):
    """
    Getter method for out_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_high_priority_packets (oc-yang:counter64)

    YANG Description: Outgoing high priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    return self.__out_high_priority_packets
      
  def _set_out_high_priority_packets(self, v, load=False):
    """
    Setter method for out_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_high_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_high_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_high_priority_packets() directly.

    YANG Description: Outgoing high priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_high_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_high_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_high_priority_packets(self):
    self.__out_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_low_priority_packets(self):
    """
    Getter method for in_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_low_priority_packets (oc-yang:counter64)

    YANG Description: Incoming low priority packets towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    return self.__in_low_priority_packets
      
  def _set_in_low_priority_packets(self, v, load=False):
    """
    Setter method for in_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/in_low_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_low_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_low_priority_packets() directly.

    YANG Description: Incoming low priority packets towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_low_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_low_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_low_priority_packets(self):
    self.__in_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_low_priority_packets(self):
    """
    Getter method for out_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_low_priority_packets (oc-yang:counter64)

    YANG Description: Outgoing low priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    return self.__out_low_priority_packets
      
  def _set_out_low_priority_packets(self, v, load=False):
    """
    Setter method for out_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state/out_low_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_low_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_low_priority_packets() directly.

    YANG Description: Outgoing low priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_low_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_low_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_low_priority_packets(self):
    self.__out_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  in_cells = __builtin__.property(_get_in_cells)
  out_cells = __builtin__.property(_get_out_cells)
  in_packets = __builtin__.property(_get_in_packets)
  out_packets = __builtin__.property(_get_out_packets)
  in_bytes = __builtin__.property(_get_in_bytes)
  out_bytes = __builtin__.property(_get_out_bytes)
  in_high_priority_cells = __builtin__.property(_get_in_high_priority_cells)
  out_high_priority_cells = __builtin__.property(_get_out_high_priority_cells)
  in_low_priority_cells = __builtin__.property(_get_in_low_priority_cells)
  out_low_priority_cells = __builtin__.property(_get_out_low_priority_cells)
  in_high_priority_packets = __builtin__.property(_get_in_high_priority_packets)
  out_high_priority_packets = __builtin__.property(_get_out_high_priority_packets)
  in_low_priority_packets = __builtin__.property(_get_in_low_priority_packets)
  out_low_priority_packets = __builtin__.property(_get_out_low_priority_packets)


  _pyangbind_elements = OrderedDict([('in_cells', in_cells), ('out_cells', out_cells), ('in_packets', in_packets), ('out_packets', out_packets), ('in_bytes', in_bytes), ('out_bytes', out_bytes), ('in_high_priority_cells', in_high_priority_cells), ('out_high_priority_cells', out_high_priority_cells), ('in_low_priority_cells', in_low_priority_cells), ('out_low_priority_cells', out_low_priority_cells), ('in_high_priority_packets', in_high_priority_packets), ('out_high_priority_packets', out_high_priority_packets), ('in_low_priority_packets', in_low_priority_packets), ('out_low_priority_packets', out_low_priority_packets), ])


class yc_fabric_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/fabric-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC fabric block subsystem connects the IC to the external
systems fabric subsystem
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'fabric-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'fabric-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state (container)

    YANG Description: State and counters corresponding to the fabric subsystem of the
IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State and counters corresponding to the fabric subsystem of the
IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/host-interface-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State and counters corresponding to the host interface subsystem
of the IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_packets','__out_packets','__in_bytes','__out_bytes','__fragment_punt_pkts','__in_high_priority_packets','__out_high_priority_packets','__in_low_priority_packets','__out_low_priority_packets',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__fragment_punt_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-punt-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'host-interface-block', 'state']

  def _get_in_packets(self):
    """
    Getter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_packets (oc-yang:counter64)

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_packets
      
  def _set_in_packets(self, v, load=False):
    """
    Setter method for in_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_packets() directly.

    YANG Description: Incoming packets towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_packets(self):
    self.__in_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_packets(self):
    """
    Getter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_packets (oc-yang:counter64)

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_packets
      
  def _set_out_packets(self, v, load=False):
    """
    Setter method for out_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_packets() directly.

    YANG Description: Outgoing packets towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_packets(self):
    self.__out_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_bytes(self):
    """
    Getter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_bytes (oc-yang:counter64)

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    return self.__in_bytes
      
  def _set_in_bytes(self, v, load=False):
    """
    Setter method for in_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_bytes() directly.

    YANG Description: Incoming bytes towards the integrated-circuit interface
subsystem block from the line interfaces or fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_bytes(self):
    self.__in_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_bytes(self):
    """
    Getter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_bytes (oc-yang:counter64)

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    return self.__out_bytes
      
  def _set_out_bytes(self, v, load=False):
    """
    Setter method for out_bytes, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_bytes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_bytes() directly.

    YANG Description: Outgoing bytes towards the line interfaces or fabric from the
integrated-circuit interface subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_bytes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_bytes(self):
    self.__out_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_fragment_punt_pkts(self):
    """
    Getter method for fragment_punt_pkts, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/fragment_punt_pkts (oc-yang:counter64)

    YANG Description: The packets that were successfully punted to CPU due to egress MTU
exceeded.
    """
    return self.__fragment_punt_pkts
      
  def _set_fragment_punt_pkts(self, v, load=False):
    """
    Setter method for fragment_punt_pkts, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/fragment_punt_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fragment_punt_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fragment_punt_pkts() directly.

    YANG Description: The packets that were successfully punted to CPU due to egress MTU
exceeded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-punt-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fragment_punt_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-punt-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__fragment_punt_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fragment_punt_pkts(self):
    self.__fragment_punt_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-punt-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_high_priority_packets(self):
    """
    Getter method for in_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_high_priority_packets (oc-yang:counter64)

    YANG Description: Incoming high priority packets towards the integrated-circuit
fabric subsystem block from the previous NPU sub block.
    """
    return self.__in_high_priority_packets
      
  def _set_in_high_priority_packets(self, v, load=False):
    """
    Setter method for in_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_high_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_high_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_high_priority_packets() directly.

    YANG Description: Incoming high priority packets towards the integrated-circuit
fabric subsystem block from the previous NPU sub block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_high_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_high_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_high_priority_packets(self):
    self.__in_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_high_priority_packets(self):
    """
    Getter method for out_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_high_priority_packets (oc-yang:counter64)

    YANG Description: Outgoing high priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    return self.__out_high_priority_packets
      
  def _set_out_high_priority_packets(self, v, load=False):
    """
    Setter method for out_high_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_high_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_high_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_high_priority_packets() directly.

    YANG Description: Outgoing high priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_high_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_high_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_high_priority_packets(self):
    self.__out_high_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_low_priority_packets(self):
    """
    Getter method for in_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_low_priority_packets (oc-yang:counter64)

    YANG Description: Incoming low priority packets towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    return self.__in_low_priority_packets
      
  def _set_in_low_priority_packets(self, v, load=False):
    """
    Setter method for in_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/in_low_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_low_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_low_priority_packets() directly.

    YANG Description: Incoming low priority packets towards the integrated-circuit fabric
subsystem block from the previous NPU sub block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_low_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_low_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_low_priority_packets(self):
    self.__in_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_low_priority_packets(self):
    """
    Getter method for out_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_low_priority_packets (oc-yang:counter64)

    YANG Description: Outgoing low priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    return self.__out_low_priority_packets
      
  def _set_out_low_priority_packets(self, v, load=False):
    """
    Setter method for out_low_priority_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state/out_low_priority_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_low_priority_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_low_priority_packets() directly.

    YANG Description: Outgoing low priority packets towards the fabric from the
integrated-circuit fabric subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_low_priority_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_low_priority_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_low_priority_packets(self):
    self.__out_low_priority_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  in_packets = __builtin__.property(_get_in_packets)
  out_packets = __builtin__.property(_get_out_packets)
  in_bytes = __builtin__.property(_get_in_bytes)
  out_bytes = __builtin__.property(_get_out_bytes)
  fragment_punt_pkts = __builtin__.property(_get_fragment_punt_pkts)
  in_high_priority_packets = __builtin__.property(_get_in_high_priority_packets)
  out_high_priority_packets = __builtin__.property(_get_out_high_priority_packets)
  in_low_priority_packets = __builtin__.property(_get_in_low_priority_packets)
  out_low_priority_packets = __builtin__.property(_get_out_low_priority_packets)


  _pyangbind_elements = OrderedDict([('in_packets', in_packets), ('out_packets', out_packets), ('in_bytes', in_bytes), ('out_bytes', out_bytes), ('fragment_punt_pkts', fragment_punt_pkts), ('in_high_priority_packets', in_high_priority_packets), ('out_high_priority_packets', out_high_priority_packets), ('in_low_priority_packets', in_low_priority_packets), ('out_low_priority_packets', out_low_priority_packets), ])


class yc_host_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet/host-interface-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC host interface block subsystem connects the IC to the
external systems host or control subsystem
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'host-interface-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet', 'host-interface-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state (container)

    YANG Description: State and counters corresponding to the host interface subsystem
of the IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State and counters corresponding to the host interface subsystem
of the IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_packet_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/packet. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: IC packet counters for all five NPU sub-blocks.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_block','__lookup_block','__queueing_block','__fabric_block','__host_interface_block',)

  _yang_name = 'packet'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_block = YANGDynClass(base=yc_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block, is_container='container', yang_name="interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    self.__lookup_block = YANGDynClass(base=yc_lookup_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block, is_container='container', yang_name="lookup-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    self.__queueing_block = YANGDynClass(base=yc_queueing_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block, is_container='container', yang_name="queueing-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    self.__fabric_block = YANGDynClass(base=yc_fabric_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block, is_container='container', yang_name="fabric-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    self.__host_interface_block = YANGDynClass(base=yc_host_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block, is_container='container', yang_name="host-interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'packet']

  def _get_interface_block(self):
    """
    Getter method for interface_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block (container)

    YANG Description: The IC interface subsystem connects the IC to the external PHY or
MAC.
    """
    return self.__interface_block
      
  def _set_interface_block(self, v, load=False):
    """
    Setter method for interface_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/interface_block (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_block is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_block() directly.

    YANG Description: The IC interface subsystem connects the IC to the external PHY or
MAC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block, is_container='container', yang_name="interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_block must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block, is_container='container', yang_name="interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__interface_block = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_block(self):
    self.__interface_block = YANGDynClass(base=yc_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_interface_block, is_container='container', yang_name="interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)


  def _get_lookup_block(self):
    """
    Getter method for lookup_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block (container)

    YANG Description: The IC lookup subsystem perform the next hop lookup of the packet
and other forwarding features such as firewall filters.
    """
    return self.__lookup_block
      
  def _set_lookup_block(self, v, load=False):
    """
    Setter method for lookup_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/lookup_block (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lookup_block is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lookup_block() directly.

    YANG Description: The IC lookup subsystem perform the next hop lookup of the packet
and other forwarding features such as firewall filters.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_lookup_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block, is_container='container', yang_name="lookup-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lookup_block must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_lookup_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block, is_container='container', yang_name="lookup-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__lookup_block = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lookup_block(self):
    self.__lookup_block = YANGDynClass(base=yc_lookup_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_lookup_block, is_container='container', yang_name="lookup-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)


  def _get_queueing_block(self):
    """
    Getter method for queueing_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block (container)

    YANG Description: The IC queueing subsystem buffers the packet while processing it
and queues the packet for delivery to the next stage
    """
    return self.__queueing_block
      
  def _set_queueing_block(self, v, load=False):
    """
    Setter method for queueing_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/queueing_block (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_queueing_block is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_queueing_block() directly.

    YANG Description: The IC queueing subsystem buffers the packet while processing it
and queues the packet for delivery to the next stage
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_queueing_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block, is_container='container', yang_name="queueing-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """queueing_block must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_queueing_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block, is_container='container', yang_name="queueing-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__queueing_block = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_queueing_block(self):
    self.__queueing_block = YANGDynClass(base=yc_queueing_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_queueing_block, is_container='container', yang_name="queueing-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)


  def _get_fabric_block(self):
    """
    Getter method for fabric_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block (container)

    YANG Description: The IC fabric block subsystem connects the IC to the external
systems fabric subsystem
    """
    return self.__fabric_block
      
  def _set_fabric_block(self, v, load=False):
    """
    Setter method for fabric_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/fabric_block (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fabric_block is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fabric_block() directly.

    YANG Description: The IC fabric block subsystem connects the IC to the external
systems fabric subsystem
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_fabric_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block, is_container='container', yang_name="fabric-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fabric_block must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_fabric_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block, is_container='container', yang_name="fabric-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__fabric_block = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fabric_block(self):
    self.__fabric_block = YANGDynClass(base=yc_fabric_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_fabric_block, is_container='container', yang_name="fabric-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)


  def _get_host_interface_block(self):
    """
    Getter method for host_interface_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block (container)

    YANG Description: The IC host interface block subsystem connects the IC to the
external systems host or control subsystem
    """
    return self.__host_interface_block
      
  def _set_host_interface_block(self, v, load=False):
    """
    Setter method for host_interface_block, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/packet/host_interface_block (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host_interface_block is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host_interface_block() directly.

    YANG Description: The IC host interface block subsystem connects the IC to the
external systems host or control subsystem
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_host_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block, is_container='container', yang_name="host-interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host_interface_block must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_host_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block, is_container='container', yang_name="host-interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__host_interface_block = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host_interface_block(self):
    self.__host_interface_block = YANGDynClass(base=yc_host_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_packet_host_interface_block, is_container='container', yang_name="host-interface-block", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  interface_block = __builtin__.property(_get_interface_block)
  lookup_block = __builtin__.property(_get_lookup_block)
  queueing_block = __builtin__.property(_get_queueing_block)
  fabric_block = __builtin__.property(_get_fabric_block)
  host_interface_block = __builtin__.property(_get_host_interface_block)


  _pyangbind_elements = OrderedDict([('interface_block', interface_block), ('lookup_block', lookup_block), ('queueing_block', queueing_block), ('fabric_block', fabric_block), ('host_interface_block', host_interface_block), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_interface_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/drop/interface-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Drop counters corresponding to the interface subsystem of the
IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__oversubscription','__in_drops','__out_drops',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'drop', 'interface-block', 'state']

  def _get_oversubscription(self):
    """
    Getter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state/oversubscription (oc-yang:counter64)

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    return self.__oversubscription
      
  def _set_oversubscription(self, v, load=False):
    """
    Setter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state/oversubscription (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oversubscription is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oversubscription() directly.

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oversubscription must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__oversubscription = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oversubscription(self):
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_drops(self):
    """
    Getter method for in_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state/in_drops (oc-yang:counter64)

    YANG Description: Incoming drops towards the integrated-circuit interface
subsystem block from the interfaces due to any reason.
    """
    return self.__in_drops
      
  def _set_in_drops(self, v, load=False):
    """
    Setter method for in_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state/in_drops (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_drops is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_drops() directly.

    YANG Description: Incoming drops towards the integrated-circuit interface
subsystem block from the interfaces due to any reason.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_drops must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_drops = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_drops(self):
    self.__in_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_drops(self):
    """
    Getter method for out_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state/out_drops (oc-yang:counter64)

    YANG Description: Outgoing drops towards the interfaces from the
integrated-circuit interface subsystem block due to any reason.
    """
    return self.__out_drops
      
  def _set_out_drops(self, v, load=False):
    """
    Setter method for out_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state/out_drops (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_drops is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_drops() directly.

    YANG Description: Outgoing drops towards the interfaces from the
integrated-circuit interface subsystem block due to any reason.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_drops must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_drops = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_drops(self):
    self.__out_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  oversubscription = __builtin__.property(_get_oversubscription)
  in_drops = __builtin__.property(_get_in_drops)
  out_drops = __builtin__.property(_get_out_drops)


  _pyangbind_elements = OrderedDict([('oversubscription', oversubscription), ('in_drops', in_drops), ('out_drops', out_drops), ])


class yc_interface_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_interface_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/drop/interface-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC interface subsystem connects the IC to the external PHY or
MAC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'interface-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'drop', 'interface-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state (container)

    YANG Description: Drop counters corresponding to the interface subsystem of the
IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/interface_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Drop counters corresponding to the interface subsystem of the
IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_interface_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_lookup_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/drop/lookup-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Drop counters corresponding to the lookup subsystem of the IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__oversubscription','__no_route','__no_label','__no_nexthop','__invalid_packet','__forwarding_policy','__incorrect_software_state','__rate_limit','__fragment_total_drops','__lookup_aggregate','__acl_drops',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__no_route = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-route", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__no_label = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__no_nexthop = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-nexthop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__invalid_packet = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-packet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__forwarding_policy = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forwarding-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__incorrect_software_state = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-software-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__fragment_total_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__lookup_aggregate = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__acl_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'drop', 'lookup-block', 'state']

  def _get_oversubscription(self):
    """
    Getter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/oversubscription (oc-yang:counter64)

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    return self.__oversubscription
      
  def _set_oversubscription(self, v, load=False):
    """
    Setter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/oversubscription (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oversubscription is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oversubscription() directly.

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oversubscription must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__oversubscription = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oversubscription(self):
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_no_route(self):
    """
    Getter method for no_route, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/no_route (oc-yang:counter64)

    YANG Description: Packets dropped due to no FIB entry for this ipv4 or ipv6 lookup.
    """
    return self.__no_route
      
  def _set_no_route(self, v, load=False):
    """
    Setter method for no_route, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/no_route (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_no_route is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_no_route() directly.

    YANG Description: Packets dropped due to no FIB entry for this ipv4 or ipv6 lookup.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-route", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """no_route must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-route", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__no_route = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_no_route(self):
    self.__no_route = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-route", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_no_label(self):
    """
    Getter method for no_label, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/no_label (oc-yang:counter64)

    YANG Description: Packets dropped due to no FIB entry for this MPLS label.
    """
    return self.__no_label
      
  def _set_no_label(self, v, load=False):
    """
    Setter method for no_label, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/no_label (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_no_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_no_label() directly.

    YANG Description: Packets dropped due to no FIB entry for this MPLS label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """no_label must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__no_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_no_label(self):
    self.__no_label = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_no_nexthop(self):
    """
    Getter method for no_nexthop, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/no_nexthop (oc-yang:counter64)

    YANG Description: Packets dropped due to no nexthop information - either the nexthop is
not programmed, or there is an invalid nexthop, or there is no ARP
information so the nexthop is in invalid state.
    """
    return self.__no_nexthop
      
  def _set_no_nexthop(self, v, load=False):
    """
    Setter method for no_nexthop, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/no_nexthop (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_no_nexthop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_no_nexthop() directly.

    YANG Description: Packets dropped due to no nexthop information - either the nexthop is
not programmed, or there is an invalid nexthop, or there is no ARP
information so the nexthop is in invalid state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-nexthop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """no_nexthop must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-nexthop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__no_nexthop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_no_nexthop(self):
    self.__no_nexthop = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="no-nexthop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_invalid_packet(self):
    """
    Getter method for invalid_packet, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/invalid_packet (oc-yang:counter64)

    YANG Description: Packets dropped due to invalid packet format for ipv4, ipv6, or MPLS.
    """
    return self.__invalid_packet
      
  def _set_invalid_packet(self, v, load=False):
    """
    Setter method for invalid_packet, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/invalid_packet (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_invalid_packet is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_invalid_packet() directly.

    YANG Description: Packets dropped due to invalid packet format for ipv4, ipv6, or MPLS.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-packet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """invalid_packet must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-packet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__invalid_packet = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_invalid_packet(self):
    self.__invalid_packet = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-packet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_forwarding_policy(self):
    """
    Getter method for forwarding_policy, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/forwarding_policy (oc-yang:counter64)

    YANG Description: Packets dropped due to either a filter applied as part of a forwarding
policy or dropped due to a policy-based-routing policy lookup.
    """
    return self.__forwarding_policy
      
  def _set_forwarding_policy(self, v, load=False):
    """
    Setter method for forwarding_policy, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/forwarding_policy (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_policy() directly.

    YANG Description: Packets dropped due to either a filter applied as part of a forwarding
policy or dropped due to a policy-based-routing policy lookup.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forwarding-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_policy must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forwarding-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__forwarding_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_policy(self):
    self.__forwarding_policy = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forwarding-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_incorrect_software_state(self):
    """
    Getter method for incorrect_software_state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/incorrect_software_state (oc-yang:counter64)

    YANG Description: Packets dropped due to any incorrect or invalid software state of the
forwarding structures during lookup.
    """
    return self.__incorrect_software_state
      
  def _set_incorrect_software_state(self, v, load=False):
    """
    Setter method for incorrect_software_state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/incorrect_software_state (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_incorrect_software_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_incorrect_software_state() directly.

    YANG Description: Packets dropped due to any incorrect or invalid software state of the
forwarding structures during lookup.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-software-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """incorrect_software_state must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-software-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__incorrect_software_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_incorrect_software_state(self):
    self.__incorrect_software_state = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-software-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_rate_limit(self):
    """
    Getter method for rate_limit, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/rate_limit (oc-yang:counter64)

    YANG Description: Packets dropped due to rate limiters - either user configured rate
limiters or system rate limiters in the forwarding path.
    """
    return self.__rate_limit
      
  def _set_rate_limit(self, v, load=False):
    """
    Setter method for rate_limit, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/rate_limit (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_limit() directly.

    YANG Description: Packets dropped due to rate limiters - either user configured rate
limiters or system rate limiters in the forwarding path.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_limit must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rate_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_limit(self):
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_fragment_total_drops(self):
    """
    Getter method for fragment_total_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/fragment_total_drops (oc-yang:counter64)

    YANG Description: Total number of packets dropped that could not be fragmented by NPU
due to DF bit.
    """
    return self.__fragment_total_drops
      
  def _set_fragment_total_drops(self, v, load=False):
    """
    Setter method for fragment_total_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/fragment_total_drops (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fragment_total_drops is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fragment_total_drops() directly.

    YANG Description: Total number of packets dropped that could not be fragmented by NPU
due to DF bit.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fragment_total_drops must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__fragment_total_drops = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fragment_total_drops(self):
    self.__fragment_total_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fragment-total-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_lookup_aggregate(self):
    """
    Getter method for lookup_aggregate, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/lookup_aggregate (oc-yang:counter64)

    YANG Description: Packets dropped due to aggregate lookup drop counters - this counter
is sometimes referred to as Normal Discards or
ENQ_DISCARDED_PACKET_COUNTER.
    """
    return self.__lookup_aggregate
      
  def _set_lookup_aggregate(self, v, load=False):
    """
    Setter method for lookup_aggregate, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/lookup_aggregate (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lookup_aggregate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lookup_aggregate() directly.

    YANG Description: Packets dropped due to aggregate lookup drop counters - this counter
is sometimes referred to as Normal Discards or
ENQ_DISCARDED_PACKET_COUNTER.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lookup_aggregate must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lookup_aggregate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lookup_aggregate(self):
    self.__lookup_aggregate = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_acl_drops(self):
    """
    Getter method for acl_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/acl_drops (oc-yang:counter64)

    YANG Description: Packets dropped due to firewall or acl terms.
    """
    return self.__acl_drops
      
  def _set_acl_drops(self, v, load=False):
    """
    Setter method for acl_drops, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state/acl_drops (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acl_drops is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acl_drops() directly.

    YANG Description: Packets dropped due to firewall or acl terms.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acl_drops must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__acl_drops = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acl_drops(self):
    self.__acl_drops = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acl-drops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  oversubscription = __builtin__.property(_get_oversubscription)
  no_route = __builtin__.property(_get_no_route)
  no_label = __builtin__.property(_get_no_label)
  no_nexthop = __builtin__.property(_get_no_nexthop)
  invalid_packet = __builtin__.property(_get_invalid_packet)
  forwarding_policy = __builtin__.property(_get_forwarding_policy)
  incorrect_software_state = __builtin__.property(_get_incorrect_software_state)
  rate_limit = __builtin__.property(_get_rate_limit)
  fragment_total_drops = __builtin__.property(_get_fragment_total_drops)
  lookup_aggregate = __builtin__.property(_get_lookup_aggregate)
  acl_drops = __builtin__.property(_get_acl_drops)


  _pyangbind_elements = OrderedDict([('oversubscription', oversubscription), ('no_route', no_route), ('no_label', no_label), ('no_nexthop', no_nexthop), ('invalid_packet', invalid_packet), ('forwarding_policy', forwarding_policy), ('incorrect_software_state', incorrect_software_state), ('rate_limit', rate_limit), ('fragment_total_drops', fragment_total_drops), ('lookup_aggregate', lookup_aggregate), ('acl_drops', acl_drops), ])


class yc_lookup_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_lookup_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/drop/lookup-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC lookup subsystem perform the next hop lookup of the packet
and other forwarding features such as firewall filters.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'lookup-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'drop', 'lookup-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state (container)

    YANG Description: Drop counters corresponding to the lookup subsystem of the IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/lookup_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Drop counters corresponding to the lookup subsystem of the IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_lookup_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_queueing_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/drop/queueing-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Drop counters corresponding to the queueing subsystem of the
IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__oversubscription','__memory_limit','__incorrect_state','__lookup_queue',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__memory_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__incorrect_state = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__lookup_queue = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'drop', 'queueing-block', 'state']

  def _get_oversubscription(self):
    """
    Getter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/oversubscription (oc-yang:counter64)

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    return self.__oversubscription
      
  def _set_oversubscription(self, v, load=False):
    """
    Setter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/oversubscription (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oversubscription is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oversubscription() directly.

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oversubscription must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__oversubscription = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oversubscription(self):
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_memory_limit(self):
    """
    Getter method for memory_limit, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/memory_limit (oc-yang:counter64)

    YANG Description: Packets dropped due to running out of the queue memory.
    """
    return self.__memory_limit
      
  def _set_memory_limit(self, v, load=False):
    """
    Setter method for memory_limit, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/memory_limit (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_memory_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_memory_limit() directly.

    YANG Description: Packets dropped due to running out of the queue memory.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """memory_limit must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__memory_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_memory_limit(self):
    self.__memory_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_incorrect_state(self):
    """
    Getter method for incorrect_state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/incorrect_state (oc-yang:counter64)

    YANG Description: Packets dropped due to hardware of software incorrect state of VOQs,
or fabric queues, or interface queues.
    """
    return self.__incorrect_state
      
  def _set_incorrect_state(self, v, load=False):
    """
    Setter method for incorrect_state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/incorrect_state (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_incorrect_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_incorrect_state() directly.

    YANG Description: Packets dropped due to hardware of software incorrect state of VOQs,
or fabric queues, or interface queues.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """incorrect_state must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__incorrect_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_incorrect_state(self):
    self.__incorrect_state = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="incorrect-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_lookup_queue(self):
    """
    Getter method for lookup_queue, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/lookup_queue (oc-yang:counter64)

    YANG Description: Packets dropped in either the lookup or recirculation path.
    """
    return self.__lookup_queue
      
  def _set_lookup_queue(self, v, load=False):
    """
    Setter method for lookup_queue, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state/lookup_queue (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lookup_queue is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lookup_queue() directly.

    YANG Description: Packets dropped in either the lookup or recirculation path.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lookup_queue must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lookup_queue = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lookup_queue(self):
    self.__lookup_queue = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lookup-queue", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  oversubscription = __builtin__.property(_get_oversubscription)
  memory_limit = __builtin__.property(_get_memory_limit)
  incorrect_state = __builtin__.property(_get_incorrect_state)
  lookup_queue = __builtin__.property(_get_lookup_queue)


  _pyangbind_elements = OrderedDict([('oversubscription', oversubscription), ('memory_limit', memory_limit), ('incorrect_state', incorrect_state), ('lookup_queue', lookup_queue), ])


class yc_queueing_block_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_queueing_block(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/drop/queueing-block. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The IC queueing subsystem buffers the packet while processing it
and queues the packet for delivery to the next stage
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'queueing-block'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'drop', 'queueing-block']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state (container)

    YANG Description: Drop counters corresponding to the queueing subsystem of the
IC.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/queueing_block/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Drop counters corresponding to the queueing subsystem of the
IC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_queueing_block_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_platform__components_component_integrated_circuit_pipeline_counters_drop_fabric_block_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/integrated-circuit/pipeline-counters/drop/fabric-block/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Drop counters corresponding to the fabric subsystem of the IC.
  """
  __slots__ = ('_path_helper', '_extmethods', '__oversubscription','__lost_packets','__in_high_priority','__out_high_priority','__in_low_priority','__out_low_priority','__fabric_aggregate',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__lost_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lost-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_high_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_high_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__in_low_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__out_low_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    self.__fabric_aggregate = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fabric-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'integrated-circuit', 'pipeline-counters', 'drop', 'fabric-block', 'state']

  def _get_oversubscription(self):
    """
    Getter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/oversubscription (oc-yang:counter64)

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    return self.__oversubscription
      
  def _set_oversubscription(self, v, load=False):
    """
    Setter method for oversubscription, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/oversubscription (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oversubscription is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oversubscription() directly.

    YANG Description: Number of packets dropped due to oversubscription of the
integrated-circuit subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oversubscription must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__oversubscription = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oversubscription(self):
    self.__oversubscription = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="oversubscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_lost_packets(self):
    """
    Getter method for lost_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/lost_packets (oc-yang:counter64)

    YANG Description: Fabric drops due to re-ordering, or due to packets arriving late, or
due to some loss in the fabric.
    """
    return self.__lost_packets
      
  def _set_lost_packets(self, v, load=False):
    """
    Setter method for lost_packets, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/lost_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lost_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lost_packets() directly.

    YANG Description: Fabric drops due to re-ordering, or due to packets arriving late, or
due to some loss in the fabric.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lost-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lost_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lost-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__lost_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lost_packets(self):
    self.__lost_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="lost-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_high_priority(self):
    """
    Getter method for in_high_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/in_high_priority (oc-yang:counter64)

    YANG Description: Incoming high priority drops towards this integrated-circuit
subsystem block from the previous NPU sub-block or interface.
    """
    return self.__in_high_priority
      
  def _set_in_high_priority(self, v, load=False):
    """
    Setter method for in_high_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/in_high_priority (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_high_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_high_priority() directly.

    YANG Description: Incoming high priority drops towards this integrated-circuit
subsystem block from the previous NPU sub-block or interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_high_priority must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_high_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_high_priority(self):
    self.__in_high_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_high_priority(self):
    """
    Getter method for out_high_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/out_high_priority (oc-yang:counter64)

    YANG Description: Outgoing high priority drops towards the fabric/interface from this
integrated-circuit subsystem block.
    """
    return self.__out_high_priority
      
  def _set_out_high_priority(self, v, load=False):
    """
    Setter method for out_high_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/out_high_priority (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_high_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_high_priority() directly.

    YANG Description: Outgoing high priority drops towards the fabric/interface from this
integrated-circuit subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_high_priority must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_high_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_high_priority(self):
    self.__out_high_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-high-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_low_priority(self):
    """
    Getter method for in_low_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/in_low_priority (oc-yang:counter64)

    YANG Description: Incoming low priority drops towards this integrated-circuit
subsystem block from the previous NPU sub-block or interface.
    """
    return self.__in_low_priority
      
  def _set_in_low_priority(self, v, load=False):
    """
    Setter method for in_low_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/in_low_priority (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_low_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_low_priority() directly.

    YANG Description: Incoming low priority drops towards this integrated-circuit
subsystem block from the previous NPU sub-block or interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_low_priority must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_low_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_low_priority(self):
    self.__in_low_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_low_priority(self):
    """
    Getter method for out_low_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/out_low_priority (oc-yang:counter64)

    YANG Description: Outgoing low priority drops towards the fabric/interface from this
integrated-circuit subsystem block.
    """
    return self.__out_low_priority
      
  def _set_out_low_priority(self, v, load=False):
    """
    Setter method for out_low_priority, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/out_low_priority (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_low_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_low_priority() directly.

    YANG Description: Outgoing low priority drops towards the fabric/interface from this
integrated-circuit subsystem block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_low_priority must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_low_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_low_priority(self):
    self.__out_low_priority = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-low-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)


  def _get_fabric_aggregate(self):
    """
    Getter method for fabric_aggregate, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/fabric_aggregate (oc-yang:counter64)

    YANG Description: Aggregate of fabric-in and fabric-out drops.
    """
    return self.__fabric_aggregate
      
  def _set_fabric_aggregate(self, v, load=False):
    """
    Setter method for fabric_aggregate, mapped from YANG variable /components/component/integrated_circuit/pipeline_counters/drop/fabric_block/state/fabric_aggregate (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fabric_aggregate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fabric_aggregate() directly.

    YANG Description: Aggregate of fabric-in and fabric-out drops.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fabric-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fabric_aggregate must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fabric-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__fabric_aggregate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fabric_aggregate(self):
    self.__fabric_aggregate = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fabric-aggregate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform-pipeline-counters', defining_module='openconfig-platform-pipeline-counters', yang_type='oc-yang:counter64', is_config=False)

  oversubscription = __builtin__.property(_get_oversubscription)
  lost_packets = __builtin__.property(_get_lost_packets)
  in_high_priority = __builtin__.property(_get_in_high_priority)
  out_high_priority = __builtin__.property(_get_out_high_priority)
  in_low_priority = __builtin__.property(_get_in_low_priority)
  out_low_priority = __builtin__.property(_get_out_low_priority)
  fabric_aggregate = __builtin__.property(_get_fabric_aggregate)


  _pyangbind_elements = OrderedDict([('oversubscription', oversubscription), ('lost_packets', lost_packets), ('in_high_priority', in_high_priority), ('out_high_priority', out_high_priority), ('in_low_priority', in_low_priority), ('out_low_priority', out_low_priority), ('fabric_aggregate', fabric_aggregate), ])


class yc_fabric_block_openconfig_platform__components_component_integrated_circuit_pipeline_coun