# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_if_tunnel(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-tunnel - based on the path /openconfig-if-tunnel. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This model adds extensions to the OpenConfig interfaces
model to configure tunnel interfaces on a network
device.
  """
  _pyangbind_elements = {}

  

class openconfig_if_ethernet_ext(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-ethernet-ext - based on the path /openconfig-if-ethernet-ext. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module adds extensions to the base ethernet configuration
and operational state model to support additional use cases.
  """
  _pyangbind_elements = {}

  

class openconfig_if_8021x(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-8021x - based on the path /openconfig-if-8021x. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Model for managing 8021X. Augments the OpenConfig models for
wired interfaces and wireless SSIDs for configuration and state.
  """
  _pyangbind_elements = {}

  

class openconfig_if_poe(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-poe - based on the path /openconfig-if-poe. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and state data for
Power over Ethernet (PoE) based on the IEEE 802.3af
standard.
  """
  _pyangbind_elements = {}

  

class openconfig_if_sdn_ext(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-sdn-ext - based on the path /openconfig-if-sdn-ext. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module provides extensions to the OpenConfig interfaces
module for network elements that support external 'SDN' control
of their interfaces.
  """
  _pyangbind_elements = {}

  

class openconfig_if_ip_ext(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-ip-ext - based on the path /openconfig-if-ip-ext. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module adds extensions to the base IP configuration and
operational state model to support additional use cases.
  """
  _pyangbind_elements = {}

  

class openconfig_if_ip(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-ip - based on the path /openconfig-if-ip. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This model defines data for managing configuration and
operational state on IP (IPv4 and IPv6) interfaces.

This model reuses data items defined in the IETF YANG model for
interfaces described by RFC 7277 with an alternate structure
(particularly for operational state data) and with
additional configuration items.

Portions of this code were derived from IETF RFC 7277.
Please reproduce this note if possible.

IETF code is subject to the following copyright and license:
Copyright (c) IETF Trust and the persons identified as authors of
the code.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, is permitted pursuant to, and subject to the license
terms contained in, the Simplified BSD License set forth in
Section 4.c of the IETF Trust's Legal Provisions Relating
to IETF Documents (http://trustee.ietf.org/license-info).
  """
  _pyangbind_elements = {}

  

class openconfig_if_aggregate(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-if-aggregate - based on the path /openconfig-if-aggregate. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Model for managing aggregated (aka bundle, LAG) interfaces.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_interfaces__interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configurable items at the global, physical interface
level
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__mtu','__loopback_mode','__description','__enabled','__tpid','__forwarding_viable',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    self.__tpid = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=True)
    self.__forwarding_viable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/config/name (string)

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /interfaces/interface/config/type (identityref)

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /interfaces/interface/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-interfaces:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)


  def _get_mtu(self):
    """
    Getter method for mtu, mapped from YANG variable /interfaces/interface/config/mtu (uint16)

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    return self.__mtu
      
  def _set_mtu(self, v, load=False):
    """
    Setter method for mtu, mapped from YANG variable /interfaces/interface/config/mtu (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mtu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mtu() directly.

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mtu must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)""",
        })

    self.__mtu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mtu(self):
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)


  def _get_loopback_mode(self):
    """
    Getter method for loopback_mode, mapped from YANG variable /interfaces/interface/config/loopback_mode (boolean)

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    return self.__loopback_mode
      
  def _set_loopback_mode(self, v, load=False):
    """
    Setter method for loopback_mode, mapped from YANG variable /interfaces/interface/config/loopback_mode (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_mode() directly.

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_mode must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__loopback_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_mode(self):
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/config/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)


  def _get_tpid(self):
    """
    Getter method for tpid, mapped from YANG variable /interfaces/interface/config/tpid (identityref)

    YANG Description: Optionally set the tag protocol identifier field (TPID) that
is accepted on the VLAN
    """
    return self.__tpid
      
  def _set_tpid(self, v, load=False):
    """
    Setter method for tpid, mapped from YANG variable /interfaces/interface/config/tpid (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tpid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tpid() directly.

    YANG Description: Optionally set the tag protocol identifier field (TPID) that
is accepted on the VLAN
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tpid must be of a type compatible with identityref""",
          'defined-type': "openconfig-vlan:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=True)""",
        })

    self.__tpid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tpid(self):
    self.__tpid = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=True)


  def _get_forwarding_viable(self):
    """
    Getter method for forwarding_viable, mapped from YANG variable /interfaces/interface/config/forwarding_viable (boolean)

    YANG Description: This value indicates whether the interface may be used
to route traffic or not.  If set to false, the
interface is not used for forwarding traffic, but as long as
it is up, the interface still maintains its layer-2
adjacencies and runs its configured layer-2 functions
(e.g., LLDP, etc.).
This is used by an external programming entity to disable an interface
(usually part of an aggregate) for the purposes of forwarding
traffic. This allows a logical aggregate to continue to be
used with partial capacity, for example.  Note that setting
`forwarding-viable = false` is not equivalent to
administratively disabling the interface -- in particular, the
interface is expected to participate in L2 protocols such as
LLDP or LACP even if it blocked from forwarding traffic.
    """
    return self.__forwarding_viable
      
  def _set_forwarding_viable(self, v, load=False):
    """
    Setter method for forwarding_viable, mapped from YANG variable /interfaces/interface/config/forwarding_viable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_viable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_viable() directly.

    YANG Description: This value indicates whether the interface may be used
to route traffic or not.  If set to false, the
interface is not used for forwarding traffic, but as long as
it is up, the interface still maintains its layer-2
adjacencies and runs its configured layer-2 functions
(e.g., LLDP, etc.).
This is used by an external programming entity to disable an interface
(usually part of an aggregate) for the purposes of forwarding
traffic. This allows a logical aggregate to continue to be
used with partial capacity, for example.  Note that setting
`forwarding-viable = false` is not equivalent to
administratively disabling the interface -- in particular, the
interface is expected to participate in L2 protocols such as
LLDP or LACP even if it blocked from forwarding traffic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_viable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=True)""",
        })

    self.__forwarding_viable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_viable(self):
    self.__forwarding_viable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  mtu = __builtin__.property(_get_mtu, _set_mtu)
  loopback_mode = __builtin__.property(_get_loopback_mode, _set_loopback_mode)
  description = __builtin__.property(_get_description, _set_description)
  enabled = __builtin__.property(_get_enabled, _set_enabled)
  tpid = __builtin__.property(_get_tpid, _set_tpid)
  forwarding_viable = __builtin__.property(_get_forwarding_viable, _set_forwarding_viable)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('mtu', mtu), ('loopback_mode', loopback_mode), ('description', description), ('enabled', enabled), ('tpid', tpid), ('forwarding_viable', forwarding_viable), ])


class yc_counters_openconfig_interfaces__interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A collection of interface-related statistics objects.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__in_unicast_pkts','__in_broadcast_pkts','__in_multicast_pkts','__in_discards','__in_errors','__in_unknown_protos','__in_fcs_errors','__out_octets','__out_pkts','__out_unicast_pkts','__out_broadcast_pkts','__out_multicast_pkts','__out_discards','__out_errors','__carrier_transitions','__last_clear',)

  _yang_name = 'counters'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /interfaces/interface/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /interfaces/interface/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unicast_pkts(self):
    """
    Getter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_unicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unicast_pkts
      
  def _set_in_unicast_pkts(self, v, load=False):
    """
    Setter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unicast_pkts(self):
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_broadcast_pkts(self):
    """
    Getter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_broadcast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_broadcast_pkts
      
  def _set_in_broadcast_pkts(self, v, load=False):
    """
    Setter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_broadcast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_broadcast_pkts(self):
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_multicast_pkts(self):
    """
    Getter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_multicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_multicast_pkts
      
  def _set_in_multicast_pkts(self, v, load=False):
    """
    Setter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_multicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_multicast_pkts(self):
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_discards(self):
    """
    Getter method for in_discards, mapped from YANG variable /interfaces/interface/state/counters/in_discards (oc-yang:counter64)

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_discards
      
  def _set_in_discards(self, v, load=False):
    """
    Setter method for in_discards, mapped from YANG variable /interfaces/interface/state/counters/in_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_discards() directly.

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_discards(self):
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_errors(self):
    """
    Getter method for in_errors, mapped from YANG variable /interfaces/interface/state/counters/in_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_errors
      
  def _set_in_errors(self, v, load=False):
    """
    Setter method for in_errors, mapped from YANG variable /interfaces/interface/state/counters/in_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_errors(self):
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unknown_protos(self):
    """
    Getter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/state/counters/in_unknown_protos (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unknown_protos
      
  def _set_in_unknown_protos(self, v, load=False):
    """
    Setter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/state/counters/in_unknown_protos (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unknown_protos is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unknown_protos() directly.

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unknown_protos must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unknown_protos = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unknown_protos(self):
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_fcs_errors(self):
    """
    Getter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/state/counters/in_fcs_errors (oc-yang:counter64)

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    return self.__in_fcs_errors
      
  def _set_in_fcs_errors(self, v, load=False):
    """
    Setter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/state/counters/in_fcs_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_fcs_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_fcs_errors() directly.

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_fcs_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_fcs_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_fcs_errors(self):
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /interfaces/interface/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /interfaces/interface/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_unicast_pkts(self):
    """
    Getter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_unicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_unicast_pkts
      
  def _set_out_unicast_pkts(self, v, load=False):
    """
    Setter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_unicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_unicast_pkts(self):
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_broadcast_pkts(self):
    """
    Getter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_broadcast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_broadcast_pkts
      
  def _set_out_broadcast_pkts(self, v, load=False):
    """
    Setter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_broadcast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_broadcast_pkts(self):
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_multicast_pkts(self):
    """
    Getter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_multicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_multicast_pkts
      
  def _set_out_multicast_pkts(self, v, load=False):
    """
    Setter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_multicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_multicast_pkts(self):
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_discards(self):
    """
    Getter method for out_discards, mapped from YANG variable /interfaces/interface/state/counters/out_discards (oc-yang:counter64)

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_discards
      
  def _set_out_discards(self, v, load=False):
    """
    Setter method for out_discards, mapped from YANG variable /interfaces/interface/state/counters/out_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_discards() directly.

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_discards(self):
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_errors(self):
    """
    Getter method for out_errors, mapped from YANG variable /interfaces/interface/state/counters/out_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_errors
      
  def _set_out_errors(self, v, load=False):
    """
    Setter method for out_errors, mapped from YANG variable /interfaces/interface/state/counters/out_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_errors(self):
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_carrier_transitions(self):
    """
    Getter method for carrier_transitions, mapped from YANG variable /interfaces/interface/state/counters/carrier_transitions (oc-yang:counter64)

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    return self.__carrier_transitions
      
  def _set_carrier_transitions(self, v, load=False):
    """
    Setter method for carrier_transitions, mapped from YANG variable /interfaces/interface/state/counters/carrier_transitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_carrier_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_carrier_transitions() directly.

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """carrier_transitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__carrier_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_carrier_transitions(self):
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /interfaces/interface/state/counters/last_clear (oc-types:timeticks64)

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /interfaces/interface/state/counters/last_clear (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  in_unicast_pkts = __builtin__.property(_get_in_unicast_pkts)
  in_broadcast_pkts = __builtin__.property(_get_in_broadcast_pkts)
  in_multicast_pkts = __builtin__.property(_get_in_multicast_pkts)
  in_discards = __builtin__.property(_get_in_discards)
  in_errors = __builtin__.property(_get_in_errors)
  in_unknown_protos = __builtin__.property(_get_in_unknown_protos)
  in_fcs_errors = __builtin__.property(_get_in_fcs_errors)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)
  out_unicast_pkts = __builtin__.property(_get_out_unicast_pkts)
  out_broadcast_pkts = __builtin__.property(_get_out_broadcast_pkts)
  out_multicast_pkts = __builtin__.property(_get_out_multicast_pkts)
  out_discards = __builtin__.property(_get_out_discards)
  out_errors = __builtin__.property(_get_out_errors)
  carrier_transitions = __builtin__.property(_get_carrier_transitions)
  last_clear = __builtin__.property(_get_last_clear)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('in_unicast_pkts', in_unicast_pkts), ('in_broadcast_pkts', in_broadcast_pkts), ('in_multicast_pkts', in_multicast_pkts), ('in_discards', in_discards), ('in_errors', in_errors), ('in_unknown_protos', in_unknown_protos), ('in_fcs_errors', in_fcs_errors), ('out_octets', out_octets), ('out_pkts', out_pkts), ('out_unicast_pkts', out_unicast_pkts), ('out_broadcast_pkts', out_broadcast_pkts), ('out_multicast_pkts', out_multicast_pkts), ('out_discards', out_discards), ('out_errors', out_errors), ('carrier_transitions', carrier_transitions), ('last_clear', last_clear), ])


class yc_state_openconfig_interfaces__interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data at the global interface level
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__mtu','__loopback_mode','__description','__enabled','__ifindex','__admin_status','__oper_status','__last_change','__logical','__management','__cpu','__counters','__tpid','__forwarding_viable',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)
    self.__tpid = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=False)
    self.__forwarding_viable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/state/name (string)

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /interfaces/interface/state/type (identityref)

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /interfaces/interface/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-interfaces:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)


  def _get_mtu(self):
    """
    Getter method for mtu, mapped from YANG variable /interfaces/interface/state/mtu (uint16)

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    return self.__mtu
      
  def _set_mtu(self, v, load=False):
    """
    Setter method for mtu, mapped from YANG variable /interfaces/interface/state/mtu (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mtu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mtu() directly.

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mtu must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)""",
        })

    self.__mtu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mtu(self):
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)


  def _get_loopback_mode(self):
    """
    Getter method for loopback_mode, mapped from YANG variable /interfaces/interface/state/loopback_mode (boolean)

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    return self.__loopback_mode
      
  def _set_loopback_mode(self, v, load=False):
    """
    Setter method for loopback_mode, mapped from YANG variable /interfaces/interface/state/loopback_mode (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_mode() directly.

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_mode must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__loopback_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_mode(self):
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/state/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/state/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_ifindex(self):
    """
    Getter method for ifindex, mapped from YANG variable /interfaces/interface/state/ifindex (uint32)

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    return self.__ifindex
      
  def _set_ifindex(self, v, load=False):
    """
    Setter method for ifindex, mapped from YANG variable /interfaces/interface/state/ifindex (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ifindex is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ifindex() directly.

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ifindex must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__ifindex = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ifindex(self):
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_admin_status(self):
    """
    Getter method for admin_status, mapped from YANG variable /interfaces/interface/state/admin_status (enumeration)

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    return self.__admin_status
      
  def _set_admin_status(self, v, load=False):
    """
    Setter method for admin_status, mapped from YANG variable /interfaces/interface/state/admin_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_status() directly.

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__admin_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_status(self):
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /interfaces/interface/state/oper_status (enumeration)

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /interfaces/interface/state/oper_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_last_change(self):
    """
    Getter method for last_change, mapped from YANG variable /interfaces/interface/state/last_change (oc-types:timeticks64)

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_change
      
  def _set_last_change(self, v, load=False):
    """
    Setter method for last_change, mapped from YANG variable /interfaces/interface/state/last_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_change() directly.

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_change(self):
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)


  def _get_logical(self):
    """
    Getter method for logical, mapped from YANG variable /interfaces/interface/state/logical (boolean)

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    return self.__logical
      
  def _set_logical(self, v, load=False):
    """
    Setter method for logical, mapped from YANG variable /interfaces/interface/state/logical (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical() directly.

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__logical = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical(self):
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_management(self):
    """
    Getter method for management, mapped from YANG variable /interfaces/interface/state/management (boolean)

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    return self.__management
      
  def _set_management(self, v, load=False):
    """
    Setter method for management, mapped from YANG variable /interfaces/interface/state/management (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management() directly.

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__management = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management(self):
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_cpu(self):
    """
    Getter method for cpu, mapped from YANG variable /interfaces/interface/state/cpu (boolean)

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    return self.__cpu
      
  def _set_cpu(self, v, load=False):
    """
    Setter method for cpu, mapped from YANG variable /interfaces/interface/state/cpu (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu() directly.

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__cpu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu(self):
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /interfaces/interface/state/counters (container)

    YANG Description: A collection of interface-related statistics objects.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: A collection of interface-related statistics objects.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)


  def _get_tpid(self):
    """
    Getter method for tpid, mapped from YANG variable /interfaces/interface/state/tpid (identityref)

    YANG Description: Optionally set the tag protocol identifier field (TPID) that
is accepted on the VLAN
    """
    return self.__tpid
      
  def _set_tpid(self, v, load=False):
    """
    Setter method for tpid, mapped from YANG variable /interfaces/interface/state/tpid (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tpid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tpid() directly.

    YANG Description: Optionally set the tag protocol identifier field (TPID) that
is accepted on the VLAN
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tpid must be of a type compatible with identityref""",
          'defined-type': "openconfig-vlan:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=False)""",
        })

    self.__tpid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tpid(self):
    self.__tpid = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X8100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X88A8': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9100': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_0X9200': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}, 'oc-vlan-types:TPID_ANY': {'@module': 'openconfig-vlan-types', '@namespace': 'http://openconfig.net/yang/vlan-types'}},), default=six.text_type("oc-vlan-types:TPID_0X8100"), is_leaf=True, yang_name="tpid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='identityref', is_config=False)


  def _get_forwarding_viable(self):
    """
    Getter method for forwarding_viable, mapped from YANG variable /interfaces/interface/state/forwarding_viable (boolean)

    YANG Description: This value indicates whether the interface may be used
to route traffic or not.  If set to false, the
interface is not used for forwarding traffic, but as long as
it is up, the interface still maintains its layer-2
adjacencies and runs its configured layer-2 functions
(e.g., LLDP, etc.).
This is used by an external programming entity to disable an interface
(usually part of an aggregate) for the purposes of forwarding
traffic. This allows a logical aggregate to continue to be
used with partial capacity, for example.  Note that setting
`forwarding-viable = false` is not equivalent to
administratively disabling the interface -- in particular, the
interface is expected to participate in L2 protocols such as
LLDP or LACP even if it blocked from forwarding traffic.
    """
    return self.__forwarding_viable
      
  def _set_forwarding_viable(self, v, load=False):
    """
    Setter method for forwarding_viable, mapped from YANG variable /interfaces/interface/state/forwarding_viable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_viable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_viable() directly.

    YANG Description: This value indicates whether the interface may be used
to route traffic or not.  If set to false, the
interface is not used for forwarding traffic, but as long as
it is up, the interface still maintains its layer-2
adjacencies and runs its configured layer-2 functions
(e.g., LLDP, etc.).
This is used by an external programming entity to disable an interface
(usually part of an aggregate) for the purposes of forwarding
traffic. This allows a logical aggregate to continue to be
used with partial capacity, for example.  Note that setting
`forwarding-viable = false` is not equivalent to
administratively disabling the interface -- in particular, the
interface is expected to participate in L2 protocols such as
LLDP or LACP even if it blocked from forwarding traffic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_viable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=False)""",
        })

    self.__forwarding_viable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_viable(self):
    self.__forwarding_viable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="forwarding-viable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/interfaces/sdn-ext', defining_module='openconfig-if-sdn-ext', yang_type='boolean', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  mtu = __builtin__.property(_get_mtu)
  loopback_mode = __builtin__.property(_get_loopback_mode)
  description = __builtin__.property(_get_description)
  enabled = __builtin__.property(_get_enabled)
  ifindex = __builtin__.property(_get_ifindex)
  admin_status = __builtin__.property(_get_admin_status)
  oper_status = __builtin__.property(_get_oper_status)
  last_change = __builtin__.property(_get_last_change)
  logical = __builtin__.property(_get_logical)
  management = __builtin__.property(_get_management)
  cpu = __builtin__.property(_get_cpu)
  counters = __builtin__.property(_get_counters)
  tpid = __builtin__.property(_get_tpid)
  forwarding_viable = __builtin__.property(_get_forwarding_viable)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('mtu', mtu), ('loopback_mode', loopback_mode), ('description', description), ('enabled', enabled), ('ifindex', ifindex), ('admin_status', admin_status), ('oper_status', oper_status), ('last_change', last_change), ('logical', logical), ('management', management), ('cpu', cpu), ('counters', counters), ('tpid', tpid), ('forwarding_viable', forwarding_viable), ])


class yc_config_openconfig_interfaces__interfaces_interface_hold_time_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/hold-time/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for interface hold-time settings.
  """
  __slots__ = ('_path_helper', '_extmethods', '__up','__down',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'hold-time', 'config']

  def _get_up(self):
    """
    Getter method for up, mapped from YANG variable /interfaces/interface/hold_time/config/up (uint32)

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    return self.__up
      
  def _set_up(self, v, load=False):
    """
    Setter method for up, mapped from YANG variable /interfaces/interface/hold_time/config/up (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up() directly.

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)""",
        })

    self.__up = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up(self):
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)


  def _get_down(self):
    """
    Getter method for down, mapped from YANG variable /interfaces/interface/hold_time/config/down (uint32)

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    return self.__down
      
  def _set_down(self, v, load=False):
    """
    Setter method for down, mapped from YANG variable /interfaces/interface/hold_time/config/down (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_down is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_down() directly.

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """down must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)""",
        })

    self.__down = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_down(self):
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)

  up = __builtin__.property(_get_up, _set_up)
  down = __builtin__.property(_get_down, _set_down)


  _pyangbind_elements = OrderedDict([('up', up), ('down', down), ])


class yc_state_openconfig_interfaces__interfaces_interface_hold_time_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/hold-time/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for interface hold-time.
  """
  __slots__ = ('_path_helper', '_extmethods', '__up','__down',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'hold-time', 'state']

  def _get_up(self):
    """
    Getter method for up, mapped from YANG variable /interfaces/interface/hold_time/state/up (uint32)

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    return self.__up
      
  def _set_up(self, v, load=False):
    """
    Setter method for up, mapped from YANG variable /interfaces/interface/hold_time/state/up (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up() directly.

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__up = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up(self):
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_down(self):
    """
    Getter method for down, mapped from YANG variable /interfaces/interface/hold_time/state/down (uint32)

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    return self.__down
      
  def _set_down(self, v, load=False):
    """
    Setter method for down, mapped from YANG variable /interfaces/interface/hold_time/state/down (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_down is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_down() directly.

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """down must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__down = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_down(self):
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)

  up = __builtin__.property(_get_up)
  down = __builtin__.property(_get_down)


  _pyangbind_elements = OrderedDict([('up', up), ('down', down), ])


class yc_hold_time_openconfig_interfaces__interfaces_interface_hold_time(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/hold-time. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for hold-time settings to enable
dampening advertisements of interface transitions.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'hold-time'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'hold-time']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/hold_time/config (container)

    YANG Description: Configuration data for interface hold-time settings.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/hold_time/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for interface hold-time settings.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/hold_time/state (container)

    YANG Description: Operational state data for interface hold-time.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/hold_time/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for interface hold-time.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configurable items at the subinterface level
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__enabled',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/index (uint32)

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  description = __builtin__.property(_get_description, _set_description)
  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('enabled', enabled), ])


class yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A collection of interface-related statistics objects.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__in_unicast_pkts','__in_broadcast_pkts','__in_multicast_pkts','__in_discards','__in_errors','__in_unknown_protos','__in_fcs_errors','__out_octets','__out_pkts','__out_unicast_pkts','__out_broadcast_pkts','__out_multicast_pkts','__out_discards','__out_errors','__carrier_transitions','__last_clear',)

  _yang_name = 'counters'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unicast_pkts(self):
    """
    Getter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unicast_pkts
      
  def _set_in_unicast_pkts(self, v, load=False):
    """
    Setter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unicast_pkts(self):
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_broadcast_pkts(self):
    """
    Getter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_broadcast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_broadcast_pkts
      
  def _set_in_broadcast_pkts(self, v, load=False):
    """
    Setter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_broadcast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_broadcast_pkts(self):
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_multicast_pkts(self):
    """
    Getter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_multicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_multicast_pkts
      
  def _set_in_multicast_pkts(self, v, load=False):
    """
    Setter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_multicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_multicast_pkts(self):
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_discards(self):
    """
    Getter method for in_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_discards (oc-yang:counter64)

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_discards
      
  def _set_in_discards(self, v, load=False):
    """
    Setter method for in_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_discards() directly.

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_discards(self):
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_errors(self):
    """
    Getter method for in_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_errors
      
  def _set_in_errors(self, v, load=False):
    """
    Setter method for in_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_errors(self):
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unknown_protos(self):
    """
    Getter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unknown_protos (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unknown_protos
      
  def _set_in_unknown_protos(self, v, load=False):
    """
    Setter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unknown_protos (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unknown_protos is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unknown_protos() directly.

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unknown_protos must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unknown_protos = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unknown_protos(self):
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_fcs_errors(self):
    """
    Getter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_fcs_errors (oc-yang:counter64)

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    return self.__in_fcs_errors
      
  def _set_in_fcs_errors(self, v, load=False):
    """
    Setter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_fcs_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_fcs_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_fcs_errors() directly.

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_fcs_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_fcs_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_fcs_errors(self):
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_unicast_pkts(self):
    """
    Getter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_unicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_unicast_pkts
      
  def _set_out_unicast_pkts(self, v, load=False):
    """
    Setter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_unicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_unicast_pkts(self):
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_broadcast_pkts(self):
    """
    Getter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_broadcast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_broadcast_pkts
      
  def _set_out_broadcast_pkts(self, v, load=False):
    """
    Setter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_broadcast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_broadcast_pkts(self):
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_multicast_pkts(self):
    """
    Getter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_multicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_multicast_pkts
      
  def _set_out_multicast_pkts(self, v, load=False):
    """
    Setter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_multicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_multicast_pkts(self):
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_discards(self):
    """
    Getter method for out_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_discards (oc-yang:counter64)

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_discards
      
  def _set_out_discards(self, v, load=False):
    """
    Setter method for out_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_discards() directly.

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_discards(self):
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_errors(self):
    """
    Getter method for out_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_errors
      
  def _set_out_errors(self, v, load=False):
    """
    Setter method for out_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_errors(self):
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_carrier_transitions(self):
    """
    Getter method for carrier_transitions, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/carrier_transitions (oc-yang:counter64)

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    return self.__carrier_transitions
      
  def _set_carrier_transitions(self, v, load=False):
    """
    Setter method for carrier_transitions, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/carrier_transitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_carrier_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_carrier_transitions() directly.

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """carrier_transitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__carrier_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_carrier_transitions(self):
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/last_clear (oc-types:timeticks64)

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/last_clear (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  in_unicast_pkts = __builtin__.property(_get_in_unicast_pkts)
  in_broadcast_pkts = __builtin__.property(_get_in_broadcast_pkts)
  in_multicast_pkts = __builtin__.property(_get_in_multicast_pkts)
  in_discards = __builtin__.property(_get_in_discards)
  in_errors = __builtin__.property(_get_in_errors)
  in_unknown_protos = __builtin__.property(_get_in_unknown_protos)
  in_fcs_errors = __builtin__.property(_get_in_fcs_errors)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)
  out_unicast_pkts = __builtin__.property(_get_out_unicast_pkts)
  out_broadcast_pkts = __builtin__.property(_get_out_broadcast_pkts)
  out_multicast_pkts = __builtin__.property(_get_out_multicast_pkts)
  out_discards = __builtin__.property(_get_out_discards)
  out_errors = __builtin__.property(_get_out_errors)
  carrier_transitions = __builtin__.property(_get_carrier_transitions)
  last_clear = __builtin__.property(_get_last_clear)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('in_unicast_pkts', in_unicast_pkts), ('in_broadcast_pkts', in_broadcast_pkts), ('in_multicast_pkts', in_multicast_pkts), ('in_discards', in_discards), ('in_errors', in_errors), ('in_unknown_protos', in_unknown_protos), ('in_fcs_errors', in_fcs_errors), ('out_octets', out_octets), ('out_pkts', out_pkts), ('out_unicast_pkts', out_unicast_pkts), ('out_broadcast_pkts', out_broadcast_pkts), ('out_multicast_pkts', out_multicast_pkts), ('out_discards', out_discards), ('out_errors', out_errors), ('carrier_transitions', carrier_transitions), ('last_clear', last_clear), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for logical interfaces
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__enabled','__name','__ifindex','__admin_status','__oper_status','__last_change','__logical','__management','__cpu','__counters',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/index (uint32)

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/name (string)

    YANG Description: The system-assigned name for the sub-interface.  This MAY
be a combination of the base interface name and the
subinterface index, or some other convention used by the
system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The system-assigned name for the sub-interface.  This MAY
be a combination of the base interface name and the
subinterface index, or some other convention used by the
system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_ifindex(self):
    """
    Getter method for ifindex, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/ifindex (uint32)

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    return self.__ifindex
      
  def _set_ifindex(self, v, load=False):
    """
    Setter method for ifindex, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/ifindex (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ifindex is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ifindex() directly.

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ifindex must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__ifindex = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ifindex(self):
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_admin_status(self):
    """
    Getter method for admin_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/admin_status (enumeration)

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    return self.__admin_status
      
  def _set_admin_status(self, v, load=False):
    """
    Setter method for admin_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/admin_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_status() directly.

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__admin_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_status(self):
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/oper_status (enumeration)

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/oper_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_last_change(self):
    """
    Getter method for last_change, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/last_change (oc-types:timeticks64)

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_change
      
  def _set_last_change(self, v, load=False):
    """
    Setter method for last_change, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/last_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_change() directly.

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_change(self):
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)


  def _get_logical(self):
    """
    Getter method for logical, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/logical (boolean)

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    return self.__logical
      
  def _set_logical(self, v, load=False):
    """
    Setter method for logical, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/logical (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical() directly.

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__logical = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical(self):
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_management(self):
    """
    Getter method for management, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/management (boolean)

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    return self.__management
      
  def _set_management(self, v, load=False):
    """
    Setter method for management, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/management (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management() directly.

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__management = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management(self):
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_cpu(self):
    """
    Getter method for cpu, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/cpu (boolean)

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    return self.__cpu
      
  def _set_cpu(self, v, load=False):
    """
    Setter method for cpu, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/cpu (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu() directly.

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__cpu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu(self):
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters (container)

    YANG Description: A collection of interface-related statistics objects.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: A collection of interface-related statistics objects.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)

  index = __builtin__.property(_get_index)
  description = __builtin__.property(_get_description)
  enabled = __builtin__.property(_get_enabled)
  name = __builtin__.property(_get_name)
  ifindex = __builtin__.property(_get_ifindex)
  admin_status = __builtin__.property(_get_admin_status)
  oper_status = __builtin__.property(_get_oper_status)
  last_change = __builtin__.property(_get_last_change)
  logical = __builtin__.property(_get_logical)
  management = __builtin__.property(_get_management)
  cpu = __builtin__.property(_get_cpu)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('enabled', enabled), ('name', name), ('ifindex', ifindex), ('admin_status', admin_status), ('oper_status', oper_status), ('last_change', last_change), ('logical', logical), ('management', management), ('cpu', cpu), ('counters', counters), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for VLANs
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'config']

  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/config/vlan_id (union)

    YANG Description: VLAN id for the subinterface -- specified inline for the
case of a local VLAN.  The id is scoped to the
subinterface, and could be repeated on different
subinterfaces.
Deprecation note: See adjacent elements in the 'vlan' container for
making more expressive VLAN matches.
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/config/vlan_id (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: VLAN id for the subinterface -- specified inline for the
case of a local VLAN.  The id is scoped to the
subinterface, and could be repeated on different
subinterfaces.
Deprecation note: See adjacent elements in the 'vlan' container for
making more expressive VLAN matches.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with union""",
          'defined-type': "openconfig-vlan:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=True)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=True)

  vlan_id = __builtin__.property(_get_vlan_id, _set_vlan_id)


  _pyangbind_elements = OrderedDict([('vlan_id', vlan_id), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State variables for VLANs
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'state']

  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/state/vlan_id (union)

    YANG Description: VLAN id for the subinterface -- specified inline for the
case of a local VLAN.  The id is scoped to the
subinterface, and could be repeated on different
subinterfaces.
Deprecation note: See adjacent elements in the 'vlan' container for
making more expressive VLAN matches.
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/state/vlan_id (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: VLAN id for the subinterface -- specified inline for the
case of a local VLAN.  The id is scoped to the
subinterface, and could be repeated on different
subinterfaces.
Deprecation note: See adjacent elements in the 'vlan' container for
making more expressive VLAN matches.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with union""",
          'defined-type': "openconfig-vlan:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=False)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.((409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])|\\*)'}),], is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='union', is_config=False)

  vlan_id = __builtin__.property(_get_vlan_id)


  _pyangbind_elements = OrderedDict([('vlan_id', vlan_id), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching single-tagged packets with an exact
VLAN identifier.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged', 'config']

  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/config/vlan_id (oc-vlan-types:vlan-id)

    YANG Description: VLAN identifier for single-tagged packets.
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/config/vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: VLAN identifier for single-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  vlan_id = __builtin__.property(_get_vlan_id, _set_vlan_id)


  _pyangbind_elements = OrderedDict([('vlan_id', vlan_id), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching single-tagged packets with an exact VLAN
identifier.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged', 'state']

  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/state/vlan_id (oc-vlan-types:vlan-id)

    YANG Description: VLAN identifier for single-tagged packets.
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/state/vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: VLAN identifier for single-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

  vlan_id = __builtin__.property(_get_vlan_id)


  _pyangbind_elements = OrderedDict([('vlan_id', vlan_id), ])


class yc_single_tagged_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Match single-tagged packets with an exact VLAN identifier.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'single-tagged'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/config (container)

    YANG Description: Configuration for matching single-tagged packets with an exact
VLAN identifier.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for matching single-tagged packets with an exact
VLAN identifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/state (container)

    YANG Description: State for matching single-tagged packets with an exact VLAN
identifier.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State for matching single-tagged packets with an exact VLAN
identifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching single-tagged packets with a list of
VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_ids',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged-list', 'config']

  def _get_vlan_ids(self):
    """
    Getter method for vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/config/vlan_ids (oc-vlan-types:vlan-id)

    YANG Description: VLAN identifiers for single-tagged packets.
    """
    return self.__vlan_ids
      
  def _set_vlan_ids(self, v, load=False):
    """
    Setter method for vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/config/vlan_ids (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_ids is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_ids() directly.

    YANG Description: VLAN identifiers for single-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_ids must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__vlan_ids = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_ids(self):
    self.__vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  vlan_ids = __builtin__.property(_get_vlan_ids, _set_vlan_ids)


  _pyangbind_elements = OrderedDict([('vlan_ids', vlan_ids), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching single-tagged packets with a list of VLAN
identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_ids',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged-list', 'state']

  def _get_vlan_ids(self):
    """
    Getter method for vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/state/vlan_ids (oc-vlan-types:vlan-id)

    YANG Description: VLAN identifiers for single-tagged packets.
    """
    return self.__vlan_ids
      
  def _set_vlan_ids(self, v, load=False):
    """
    Setter method for vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/state/vlan_ids (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_ids is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_ids() directly.

    YANG Description: VLAN identifiers for single-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_ids must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__vlan_ids = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_ids(self):
    self.__vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

  vlan_ids = __builtin__.property(_get_vlan_ids)


  _pyangbind_elements = OrderedDict([('vlan_ids', vlan_ids), ])


class yc_single_tagged_list_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Match single-tagged packets with a list of VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'single-tagged-list'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged-list']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/config (container)

    YANG Description: Configuration for matching single-tagged packets with a list of
VLAN identifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for matching single-tagged packets with a list of
VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/state (container)

    YANG Description: State for matching single-tagged packets with a list of VLAN
identifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_list/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State for matching single-tagged packets with a list of VLAN
identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching single-tagged packets with a range of
VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__low_vlan_id','__high_vlan_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged-range', 'config']

  def _get_low_vlan_id(self):
    """
    Getter method for low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/config/low_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The low-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    return self.__low_vlan_id
      
  def _set_low_vlan_id(self, v, load=False):
    """
    Setter method for low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/config/low_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_low_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_low_vlan_id() directly.

    YANG Description: The low-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """low_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__low_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_low_vlan_id(self):
    self.__low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_high_vlan_id(self):
    """
    Getter method for high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/config/high_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The high-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    return self.__high_vlan_id
      
  def _set_high_vlan_id(self, v, load=False):
    """
    Setter method for high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/config/high_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_high_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_high_vlan_id() directly.

    YANG Description: The high-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """high_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__high_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_high_vlan_id(self):
    self.__high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  low_vlan_id = __builtin__.property(_get_low_vlan_id, _set_low_vlan_id)
  high_vlan_id = __builtin__.property(_get_high_vlan_id, _set_high_vlan_id)


  _pyangbind_elements = OrderedDict([('low_vlan_id', low_vlan_id), ('high_vlan_id', high_vlan_id), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching single-tagged packets with a range of VLAN
identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__low_vlan_id','__high_vlan_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged-range', 'state']

  def _get_low_vlan_id(self):
    """
    Getter method for low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/state/low_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The low-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    return self.__low_vlan_id
      
  def _set_low_vlan_id(self, v, load=False):
    """
    Setter method for low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/state/low_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_low_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_low_vlan_id() directly.

    YANG Description: The low-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """low_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__low_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_low_vlan_id(self):
    self.__low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_high_vlan_id(self):
    """
    Getter method for high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/state/high_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The high-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    return self.__high_vlan_id
      
  def _set_high_vlan_id(self, v, load=False):
    """
    Setter method for high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/state/high_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_high_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_high_vlan_id() directly.

    YANG Description: The high-value VLAN identifier in a range for single-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """high_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__high_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_high_vlan_id(self):
    self.__high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

  low_vlan_id = __builtin__.property(_get_low_vlan_id)
  high_vlan_id = __builtin__.property(_get_high_vlan_id)


  _pyangbind_elements = OrderedDict([('low_vlan_id', low_vlan_id), ('high_vlan_id', high_vlan_id), ])


class yc_single_tagged_range_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Match single-tagged packets with a range of VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'single-tagged-range'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'single-tagged-range']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/config (container)

    YANG Description: Configuration for matching single-tagged packets with a range of
VLAN identifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for matching single-tagged packets with a range of
VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/state (container)

    YANG Description: State for matching single-tagged packets with a range of VLAN
identifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/single_tagged_range/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State for matching single-tagged packets with a range of VLAN
identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_single_tagged_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching double-tagged packets against inner
exact and outer exact VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_id','__outer_vlan_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged', 'config']

  def _get_inner_vlan_id(self):
    """
    Getter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/config/inner_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    return self.__inner_vlan_id
      
  def _set_inner_vlan_id(self, v, load=False):
    """
    Setter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/config/inner_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_id() directly.

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__inner_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_id(self):
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_outer_vlan_id(self):
    """
    Getter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/config/outer_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    return self.__outer_vlan_id
      
  def _set_outer_vlan_id(self, v, load=False):
    """
    Setter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/config/outer_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_id() directly.

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__outer_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_id(self):
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  inner_vlan_id = __builtin__.property(_get_inner_vlan_id, _set_inner_vlan_id)
  outer_vlan_id = __builtin__.property(_get_outer_vlan_id, _set_outer_vlan_id)


  _pyangbind_elements = OrderedDict([('inner_vlan_id', inner_vlan_id), ('outer_vlan_id', outer_vlan_id), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching double-tagged packets against inner exact
and outer exact VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_id','__outer_vlan_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged', 'state']

  def _get_inner_vlan_id(self):
    """
    Getter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/state/inner_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    return self.__inner_vlan_id
      
  def _set_inner_vlan_id(self, v, load=False):
    """
    Setter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/state/inner_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_id() directly.

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__inner_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_id(self):
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_outer_vlan_id(self):
    """
    Getter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/state/outer_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    return self.__outer_vlan_id
      
  def _set_outer_vlan_id(self, v, load=False):
    """
    Setter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/state/outer_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_id() directly.

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__outer_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_id(self):
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

  inner_vlan_id = __builtin__.property(_get_inner_vlan_id)
  outer_vlan_id = __builtin__.property(_get_outer_vlan_id)


  _pyangbind_elements = OrderedDict([('inner_vlan_id', inner_vlan_id), ('outer_vlan_id', outer_vlan_id), ])


class yc_double_tagged_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Match double-tagged packets against inner exact and outer exact
VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'double-tagged'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/config (container)

    YANG Description: Configuration for matching double-tagged packets against inner
exact and outer exact VLAN identifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for matching double-tagged packets against inner
exact and outer exact VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/state (container)

    YANG Description: State for matching double-tagged packets against inner exact
and outer exact VLAN identifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State for matching double-tagged packets against inner exact
and outer exact VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching double-tagged packets against an
inner list and outer exact VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_ids','__outer_vlan_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-inner-list', 'config']

  def _get_inner_vlan_ids(self):
    """
    Getter method for inner_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/config/inner_vlan_ids (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifiers for double-tagged packets.
    """
    return self.__inner_vlan_ids
      
  def _set_inner_vlan_ids(self, v, load=False):
    """
    Setter method for inner_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/config/inner_vlan_ids (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_ids is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_ids() directly.

    YANG Description: Inner VLAN identifiers for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_ids must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__inner_vlan_ids = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_ids(self):
    self.__inner_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_outer_vlan_id(self):
    """
    Getter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/config/outer_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    return self.__outer_vlan_id
      
  def _set_outer_vlan_id(self, v, load=False):
    """
    Setter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/config/outer_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_id() directly.

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__outer_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_id(self):
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  inner_vlan_ids = __builtin__.property(_get_inner_vlan_ids, _set_inner_vlan_ids)
  outer_vlan_id = __builtin__.property(_get_outer_vlan_id, _set_outer_vlan_id)


  _pyangbind_elements = OrderedDict([('inner_vlan_ids', inner_vlan_ids), ('outer_vlan_id', outer_vlan_id), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching double-tagged packets against an inner list
and outer exact VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_ids','__outer_vlan_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-inner-list', 'state']

  def _get_inner_vlan_ids(self):
    """
    Getter method for inner_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/state/inner_vlan_ids (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifiers for double-tagged packets.
    """
    return self.__inner_vlan_ids
      
  def _set_inner_vlan_ids(self, v, load=False):
    """
    Setter method for inner_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/state/inner_vlan_ids (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_ids is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_ids() directly.

    YANG Description: Inner VLAN identifiers for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_ids must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__inner_vlan_ids = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_ids(self):
    self.__inner_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="inner-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_outer_vlan_id(self):
    """
    Getter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/state/outer_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    return self.__outer_vlan_id
      
  def _set_outer_vlan_id(self, v, load=False):
    """
    Setter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/state/outer_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_id() directly.

    YANG Description: Outer VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__outer_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_id(self):
    self.__outer_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

  inner_vlan_ids = __builtin__.property(_get_inner_vlan_ids)
  outer_vlan_id = __builtin__.property(_get_outer_vlan_id)


  _pyangbind_elements = OrderedDict([('inner_vlan_ids', inner_vlan_ids), ('outer_vlan_id', outer_vlan_id), ])


class yc_double_tagged_inner_list_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Match double-tagged packets against an inner list and outer exact
VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'double-tagged-inner-list'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-inner-list']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/config (container)

    YANG Description: Configuration for matching double-tagged packets against an
inner list and outer exact VLAN identifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for matching double-tagged packets against an
inner list and outer exact VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/state (container)

    YANG Description: State for matching double-tagged packets against an inner list
and outer exact VLAN identifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_list/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State for matching double-tagged packets against an inner list
and outer exact VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching double-tagged packets against an
inner exact and outer list of VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_id','__outer_vlan_ids',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__outer_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-outer-list', 'config']

  def _get_inner_vlan_id(self):
    """
    Getter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/config/inner_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    return self.__inner_vlan_id
      
  def _set_inner_vlan_id(self, v, load=False):
    """
    Setter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/config/inner_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_id() directly.

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__inner_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_id(self):
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_outer_vlan_ids(self):
    """
    Getter method for outer_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/config/outer_vlan_ids (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifiers for double-tagged packets.
    """
    return self.__outer_vlan_ids
      
  def _set_outer_vlan_ids(self, v, load=False):
    """
    Setter method for outer_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/config/outer_vlan_ids (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_ids is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_ids() directly.

    YANG Description: Outer VLAN identifiers for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_ids must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__outer_vlan_ids = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_ids(self):
    self.__outer_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  inner_vlan_id = __builtin__.property(_get_inner_vlan_id, _set_inner_vlan_id)
  outer_vlan_ids = __builtin__.property(_get_outer_vlan_ids, _set_outer_vlan_ids)


  _pyangbind_elements = OrderedDict([('inner_vlan_id', inner_vlan_id), ('outer_vlan_ids', outer_vlan_ids), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching double-tagged packets against an inner
exact and outer list of VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_id','__outer_vlan_ids',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__outer_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-outer-list', 'state']

  def _get_inner_vlan_id(self):
    """
    Getter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/state/inner_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    return self.__inner_vlan_id
      
  def _set_inner_vlan_id(self, v, load=False):
    """
    Setter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/state/inner_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_id() directly.

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__inner_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_id(self):
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_outer_vlan_ids(self):
    """
    Getter method for outer_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/state/outer_vlan_ids (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifiers for double-tagged packets.
    """
    return self.__outer_vlan_ids
      
  def _set_outer_vlan_ids(self, v, load=False):
    """
    Setter method for outer_vlan_ids, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/state/outer_vlan_ids (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_ids is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_ids() directly.

    YANG Description: Outer VLAN identifiers for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_ids must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__outer_vlan_ids = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_ids(self):
    self.__outer_vlan_ids = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-ids", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

  inner_vlan_id = __builtin__.property(_get_inner_vlan_id)
  outer_vlan_ids = __builtin__.property(_get_outer_vlan_ids)


  _pyangbind_elements = OrderedDict([('inner_vlan_id', inner_vlan_id), ('outer_vlan_ids', outer_vlan_ids), ])


class yc_double_tagged_outer_list_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Match double-tagged packets against an inner exact and outer list
of VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'double-tagged-outer-list'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-outer-list']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/config (container)

    YANG Description: Configuration for matching double-tagged packets against an
inner exact and outer list of VLAN identifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for matching double-tagged packets against an
inner exact and outer list of VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/state (container)

    YANG Description: State for matching double-tagged packets against an inner
exact and outer list of VLAN identifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_list/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State for matching double-tagged packets against an inner
exact and outer list of VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_list_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching double-tagged packets against an
inner range and outer exact VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_low_vlan_id','__inner_high_vlan_id','__outer_vlan_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__inner_high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__outer_vlan_id = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-inner-range', 'config']

  def _get_inner_low_vlan_id(self):
    """
    Getter method for inner_low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config/inner_low_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The low-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    return self.__inner_low_vlan_id
      
  def _set_inner_low_vlan_id(self, v, load=False):
    """
    Setter method for inner_low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config/inner_low_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_low_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_low_vlan_id() directly.

    YANG Description: The low-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_low_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__inner_low_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_low_vlan_id(self):
    self.__inner_low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_inner_high_vlan_id(self):
    """
    Getter method for inner_high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config/inner_high_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The high-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    return self.__inner_high_vlan_id
      
  def _set_inner_high_vlan_id(self, v, load=False):
    """
    Setter method for inner_high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config/inner_high_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_high_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_high_vlan_id() directly.

    YANG Description: The high-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_high_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__inner_high_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_high_vlan_id(self):
    self.__inner_high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_outer_vlan_id(self):
    """
    Getter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config/outer_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifier of double-tagged packets.
    """
    return self.__outer_vlan_id
      
  def _set_outer_vlan_id(self, v, load=False):
    """
    Setter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config/outer_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_id() directly.

    YANG Description: Outer VLAN identifier of double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__outer_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_id(self):
    self.__outer_vlan_id = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  inner_low_vlan_id = __builtin__.property(_get_inner_low_vlan_id, _set_inner_low_vlan_id)
  inner_high_vlan_id = __builtin__.property(_get_inner_high_vlan_id, _set_inner_high_vlan_id)
  outer_vlan_id = __builtin__.property(_get_outer_vlan_id, _set_outer_vlan_id)


  _pyangbind_elements = OrderedDict([('inner_low_vlan_id', inner_low_vlan_id), ('inner_high_vlan_id', inner_high_vlan_id), ('outer_vlan_id', outer_vlan_id), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching double-tagged packets against an inner
range and outer exact VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_low_vlan_id','__inner_high_vlan_id','__outer_vlan_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__inner_high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__outer_vlan_id = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-inner-range', 'state']

  def _get_inner_low_vlan_id(self):
    """
    Getter method for inner_low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state/inner_low_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The low-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    return self.__inner_low_vlan_id
      
  def _set_inner_low_vlan_id(self, v, load=False):
    """
    Setter method for inner_low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state/inner_low_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_low_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_low_vlan_id() directly.

    YANG Description: The low-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_low_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__inner_low_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_low_vlan_id(self):
    self.__inner_low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_inner_high_vlan_id(self):
    """
    Getter method for inner_high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state/inner_high_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The high-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    return self.__inner_high_vlan_id
      
  def _set_inner_high_vlan_id(self, v, load=False):
    """
    Setter method for inner_high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state/inner_high_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_high_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_high_vlan_id() directly.

    YANG Description: The high-value inner VLAN identifier in a range for double-tagged
packets. The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_high_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__inner_high_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_high_vlan_id(self):
    self.__inner_high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_outer_vlan_id(self):
    """
    Getter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state/outer_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Outer VLAN identifier of double-tagged packets.
    """
    return self.__outer_vlan_id
      
  def _set_outer_vlan_id(self, v, load=False):
    """
    Setter method for outer_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state/outer_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_vlan_id() directly.

    YANG Description: Outer VLAN identifier of double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__outer_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_vlan_id(self):
    self.__outer_vlan_id = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']})), is_leaf=False, yang_name="outer-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

  inner_low_vlan_id = __builtin__.property(_get_inner_low_vlan_id)
  inner_high_vlan_id = __builtin__.property(_get_inner_high_vlan_id)
  outer_vlan_id = __builtin__.property(_get_outer_vlan_id)


  _pyangbind_elements = OrderedDict([('inner_low_vlan_id', inner_low_vlan_id), ('inner_high_vlan_id', inner_high_vlan_id), ('outer_vlan_id', outer_vlan_id), ])


class yc_double_tagged_inner_range_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Match double-tagged packets against an inner range and outer
exact VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'double-tagged-inner-range'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-inner-range']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config (container)

    YANG Description: Configuration for matching double-tagged packets against an
inner range and outer exact VLAN identifiers.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration for matching double-tagged packets against an
inner range and outer exact VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state (container)

    YANG Description: State for matching double-tagged packets against an inner
range and outer exact VLAN identifiers.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_inner_range/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State for matching double-tagged packets against an inner
range and outer exact VLAN identifiers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_inner_range_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_range_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration for matching double-tagged packets against an
inner exact and an outer range of VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_id','__outer_low_vlan_id','__outer_high_vlan_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__outer_low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__outer_high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-outer-range', 'config']

  def _get_inner_vlan_id(self):
    """
    Getter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/config/inner_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    return self.__inner_vlan_id
      
  def _set_inner_vlan_id(self, v, load=False):
    """
    Setter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/config/inner_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_id() directly.

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__inner_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_id(self):
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_outer_low_vlan_id(self):
    """
    Getter method for outer_low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/config/outer_low_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The low-value outer VLAN identifier for double-tagged packets.
The range is matched inclusively.
    """
    return self.__outer_low_vlan_id
      
  def _set_outer_low_vlan_id(self, v, load=False):
    """
    Setter method for outer_low_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/config/outer_low_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_low_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_low_vlan_id() directly.

    YANG Description: The low-value outer VLAN identifier for double-tagged packets.
The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_low_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__outer_low_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_low_vlan_id(self):
    self.__outer_low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_outer_high_vlan_id(self):
    """
    Getter method for outer_high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/config/outer_high_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: The high-value outer VLAN identifier for double-tagged packets.
The range is matched inclusively.
    """
    return self.__outer_high_vlan_id
      
  def _set_outer_high_vlan_id(self, v, load=False):
    """
    Setter method for outer_high_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/config/outer_high_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_outer_high_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_outer_high_vlan_id() directly.

    YANG Description: The high-value outer VLAN identifier for double-tagged packets.
The range is matched inclusively.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """outer_high_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__outer_high_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_outer_high_vlan_id(self):
    self.__outer_high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=True)

  inner_vlan_id = __builtin__.property(_get_inner_vlan_id, _set_inner_vlan_id)
  outer_low_vlan_id = __builtin__.property(_get_outer_low_vlan_id, _set_outer_low_vlan_id)
  outer_high_vlan_id = __builtin__.property(_get_outer_high_vlan_id, _set_outer_high_vlan_id)


  _pyangbind_elements = OrderedDict([('inner_vlan_id', inner_vlan_id), ('outer_low_vlan_id', outer_low_vlan_id), ('outer_high_vlan_id', outer_high_vlan_id), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_vlan_match_double_tagged_outer_range_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State for matching double-tagged packets against an inner
exact and an outer range of VLAN identifiers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__inner_vlan_id','__outer_low_vlan_id','__outer_high_vlan_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__outer_low_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-low-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__outer_high_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="outer-high-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'vlan', 'match', 'double-tagged-outer-range', 'state']

  def _get_inner_vlan_id(self):
    """
    Getter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/state/inner_vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    return self.__inner_vlan_id
      
  def _set_inner_vlan_id(self, v, load=False):
    """
    Setter method for inner_vlan_id, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/vlan/match/double_tagged_outer_range/state/inner_vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_inner_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_inner_vlan_id() directly.

    YANG Description: Inner VLAN identifier for double-tagged packets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """inner_vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="inner-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/vlan', defining_module='openconfig-vlan', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__inner_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_inner_vlan_id(self):
    self.__inner_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restrict