package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVpnPbrRouteEntryPriority invokes the vpc.ModifyVpnPbrRouteEntryPriority API synchronously
func (client *Client) ModifyVpnPbrRouteEntryPriority(request *ModifyVpnPbrRouteEntryPriorityRequest) (response *ModifyVpnPbrRouteEntryPriorityResponse, err error) {
	response = CreateModifyVpnPbrRouteEntryPriorityResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVpnPbrRouteEntryPriorityWithChan invokes the vpc.ModifyVpnPbrRouteEntryPriority API asynchronously
func (client *Client) ModifyVpnPbrRouteEntryPriorityWithChan(request *ModifyVpnPbrRouteEntryPriorityRequest) (<-chan *ModifyVpnPbrRouteEntryPriorityResponse, <-chan error) {
	responseChan := make(chan *ModifyVpnPbrRouteEntryPriorityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVpnPbrRouteEntryPriority(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVpnPbrRouteEntryPriorityWithCallback invokes the vpc.ModifyVpnPbrRouteEntryPriority API asynchronously
func (client *Client) ModifyVpnPbrRouteEntryPriorityWithCallback(request *ModifyVpnPbrRouteEntryPriorityRequest, callback func(response *ModifyVpnPbrRouteEntryPriorityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVpnPbrRouteEntryPriorityResponse
		var err error
		defer close(result)
		response, err = client.ModifyVpnPbrRouteEntryPriority(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVpnPbrRouteEntryPriorityRequest is the request struct for api ModifyVpnPbrRouteEntryPriority
type ModifyVpnPbrRouteEntryPriorityRequest struct {
	*requests.RpcRequest
	RouteSource          string           `position:"Query" name:"RouteSource"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NewPriority          requests.Integer `position:"Query" name:"NewPriority"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Weight               requests.Integer `position:"Query" name:"Weight"`
	VpnGatewayId         string           `position:"Query" name:"VpnGatewayId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Priority             requests.Integer `position:"Query" name:"Priority"`
	RouteDest            string           `position:"Query" name:"RouteDest"`
	NextHop              string           `position:"Query" name:"NextHop"`
}

// ModifyVpnPbrRouteEntryPriorityResponse is the response struct for api ModifyVpnPbrRouteEntryPriority
type ModifyVpnPbrRouteEntryPriorityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVpnPbrRouteEntryPriorityRequest creates a request to invoke ModifyVpnPbrRouteEntryPriority API
func CreateModifyVpnPbrRouteEntryPriorityRequest() (request *ModifyVpnPbrRouteEntryPriorityRequest) {
	request = &ModifyVpnPbrRouteEntryPriorityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyVpnPbrRouteEntryPriority", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVpnPbrRouteEntryPriorityResponse creates a response to parse from ModifyVpnPbrRouteEntryPriority response
func CreateModifyVpnPbrRouteEntryPriorityResponse() (response *ModifyVpnPbrRouteEntryPriorityResponse) {
	response = &ModifyVpnPbrRouteEntryPriorityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
