package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GrantInstanceToVbr invokes the vpc.GrantInstanceToVbr API synchronously
func (client *Client) GrantInstanceToVbr(request *GrantInstanceToVbrRequest) (response *GrantInstanceToVbrResponse, err error) {
	response = CreateGrantInstanceToVbrResponse()
	err = client.DoAction(request, response)
	return
}

// GrantInstanceToVbrWithChan invokes the vpc.GrantInstanceToVbr API asynchronously
func (client *Client) GrantInstanceToVbrWithChan(request *GrantInstanceToVbrRequest) (<-chan *GrantInstanceToVbrResponse, <-chan error) {
	responseChan := make(chan *GrantInstanceToVbrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GrantInstanceToVbr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GrantInstanceToVbrWithCallback invokes the vpc.GrantInstanceToVbr API asynchronously
func (client *Client) GrantInstanceToVbrWithCallback(request *GrantInstanceToVbrRequest, callback func(response *GrantInstanceToVbrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GrantInstanceToVbrResponse
		var err error
		defer close(result)
		response, err = client.GrantInstanceToVbr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GrantInstanceToVbrRequest is the request struct for api GrantInstanceToVbr
type GrantInstanceToVbrRequest struct {
	*requests.RpcRequest
	VbrOwnerUid    requests.Integer `position:"Query" name:"VbrOwnerUid"`
	VbrRegionNo    string           `position:"Query" name:"VbrRegionNo"`
	VbrInstanceIds *[]string        `position:"Query" name:"VbrInstanceIds"  type:"Repeated"`
	GrantType      string           `position:"Query" name:"GrantType"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
}

// GrantInstanceToVbrResponse is the response struct for api GrantInstanceToVbr
type GrantInstanceToVbrResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGrantInstanceToVbrRequest creates a request to invoke GrantInstanceToVbr API
func CreateGrantInstanceToVbrRequest() (request *GrantInstanceToVbrRequest) {
	request = &GrantInstanceToVbrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GrantInstanceToVbr", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGrantInstanceToVbrResponse creates a response to parse from GrantInstanceToVbr response
func CreateGrantInstanceToVbrResponse() (response *GrantInstanceToVbrResponse) {
	response = &GrantInstanceToVbrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
