package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFormat invokes the ververica.CreateFormat API synchronously
func (client *Client) CreateFormat(request *CreateFormatRequest) (response *CreateFormatResponse, err error) {
	response = CreateCreateFormatResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFormatWithChan invokes the ververica.CreateFormat API asynchronously
func (client *Client) CreateFormatWithChan(request *CreateFormatRequest) (<-chan *CreateFormatResponse, <-chan error) {
	responseChan := make(chan *CreateFormatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFormat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFormatWithCallback invokes the ververica.CreateFormat API asynchronously
func (client *Client) CreateFormatWithCallback(request *CreateFormatRequest, callback func(response *CreateFormatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFormatResponse
		var err error
		defer close(result)
		response, err = client.CreateFormat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFormatRequest is the request struct for api CreateFormat
type CreateFormatRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// CreateFormatResponse is the response struct for api CreateFormat
type CreateFormatResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateCreateFormatRequest creates a request to invoke CreateFormat API
func CreateCreateFormatRequest() (request *CreateFormatRequest) {
	request = &CreateFormatRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "CreateFormat", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/formats", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFormatResponse creates a response to parse from CreateFormat response
func CreateCreateFormatResponse() (response *CreateFormatResponse) {
	response = &CreateFormatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
