package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveTask invokes the trademark.SaveTask API synchronously
// api document: https://help.aliyun.com/api/trademark/savetask.html
func (client *Client) SaveTask(request *SaveTaskRequest) (response *SaveTaskResponse, err error) {
	response = CreateSaveTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SaveTaskWithChan invokes the trademark.SaveTask API asynchronously
// api document: https://help.aliyun.com/api/trademark/savetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveTaskWithChan(request *SaveTaskRequest) (<-chan *SaveTaskResponse, <-chan error) {
	responseChan := make(chan *SaveTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveTaskWithCallback invokes the trademark.SaveTask API asynchronously
// api document: https://help.aliyun.com/api/trademark/savetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveTaskWithCallback(request *SaveTaskRequest, callback func(response *SaveTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveTaskResponse
		var err error
		defer close(result)
		response, err = client.SaveTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveTaskRequest is the request struct for api SaveTask
type SaveTaskRequest struct {
	*requests.RpcRequest
	BizType string `position:"Query" name:"BizType"`
	Request string `position:"Query" name:"Request"`
}

// SaveTaskResponse is the response struct for api SaveTask
type SaveTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSaveTaskRequest creates a request to invoke SaveTask API
func CreateSaveTaskRequest() (request *SaveTaskRequest) {
	request = &SaveTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "SaveTask", "trademark", "openAPI")
	return
}

// CreateSaveTaskResponse creates a response to parse from SaveTask response
func CreateSaveTaskResponse() (response *SaveTaskResponse) {
	response = &SaveTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
