package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetLoadBalancerTCPListenerAttribute invokes the slb.SetLoadBalancerTCPListenerAttribute API synchronously
func (client *Client) SetLoadBalancerTCPListenerAttribute(request *SetLoadBalancerTCPListenerAttributeRequest) (response *SetLoadBalancerTCPListenerAttributeResponse, err error) {
	response = CreateSetLoadBalancerTCPListenerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// SetLoadBalancerTCPListenerAttributeWithChan invokes the slb.SetLoadBalancerTCPListenerAttribute API asynchronously
func (client *Client) SetLoadBalancerTCPListenerAttributeWithChan(request *SetLoadBalancerTCPListenerAttributeRequest) (<-chan *SetLoadBalancerTCPListenerAttributeResponse, <-chan error) {
	responseChan := make(chan *SetLoadBalancerTCPListenerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetLoadBalancerTCPListenerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetLoadBalancerTCPListenerAttributeWithCallback invokes the slb.SetLoadBalancerTCPListenerAttribute API asynchronously
func (client *Client) SetLoadBalancerTCPListenerAttributeWithCallback(request *SetLoadBalancerTCPListenerAttributeRequest, callback func(response *SetLoadBalancerTCPListenerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetLoadBalancerTCPListenerAttributeResponse
		var err error
		defer close(result)
		response, err = client.SetLoadBalancerTCPListenerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetLoadBalancerTCPListenerAttributeRequest is the request struct for api SetLoadBalancerTCPListenerAttribute
type SetLoadBalancerTCPListenerAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer                                `position:"Query" name:"ResourceOwnerId"`
	HealthCheckURI                 string                                          `position:"Query" name:"HealthCheckURI"`
	AclStatus                      string                                          `position:"Query" name:"AclStatus"`
	FullNatEnabled                 requests.Boolean                                `position:"Query" name:"FullNatEnabled"`
	HealthCheckTcpFastCloseEnabled requests.Boolean                                `position:"Query" name:"HealthCheckTcpFastCloseEnabled"`
	AclType                        string                                          `position:"Query" name:"AclType"`
	MasterSlaveServerGroup         string                                          `position:"Query" name:"MasterSlaveServerGroup"`
	EstablishedTimeout             requests.Integer                                `position:"Query" name:"EstablishedTimeout"`
	FailoverStrategy               string                                          `position:"Query" name:"FailoverStrategy"`
	PersistenceTimeout             requests.Integer                                `position:"Query" name:"PersistenceTimeout"`
	VpcIds                         string                                          `position:"Query" name:"VpcIds"`
	MasterSlaveModeEnabled         requests.Boolean                                `position:"Query" name:"MasterSlaveModeEnabled"`
	VServerGroupId                 string                                          `position:"Query" name:"VServerGroupId"`
	AclId                          string                                          `position:"Query" name:"AclId"`
	PortRange                      *[]SetLoadBalancerTCPListenerAttributePortRange `position:"Query" name:"PortRange"  type:"Repeated"`
	HealthCheckMethod              string                                          `position:"Query" name:"HealthCheckMethod"`
	HealthCheckDomain              string                                          `position:"Query" name:"HealthCheckDomain"`
	SynProxy                       string                                          `position:"Query" name:"SynProxy"`
	OwnerId                        requests.Integer                                `position:"Query" name:"OwnerId"`
	Tags                           string                                          `position:"Query" name:"Tags"`
	LoadBalancerId                 string                                          `position:"Query" name:"LoadBalancerId"`
	MasterSlaveServerGroupId       string                                          `position:"Query" name:"MasterSlaveServerGroupId"`
	HealthCheckInterval            requests.Integer                                `position:"Query" name:"HealthCheckInterval"`
	FailoverThreshold              requests.Integer                                `position:"Query" name:"FailoverThreshold"`
	ProxyProtocolV2Enabled         requests.Boolean                                `position:"Query" name:"ProxyProtocolV2Enabled"`
	ConnectionDrain                string                                          `position:"Query" name:"ConnectionDrain"`
	HealthCheckSwitch              string                                          `position:"Query" name:"HealthCheckSwitch"`
	AccessKeyId                    string                                          `position:"Query" name:"access_key_id"`
	HealthCheckConnectTimeout      requests.Integer                                `position:"Query" name:"HealthCheckConnectTimeout"`
	SlaveServerGroupId             string                                          `position:"Query" name:"SlaveServerGroupId"`
	Description                    string                                          `position:"Query" name:"Description"`
	UnhealthyThreshold             requests.Integer                                `position:"Query" name:"UnhealthyThreshold"`
	HealthyThreshold               requests.Integer                                `position:"Query" name:"HealthyThreshold"`
	Scheduler                      string                                          `position:"Query" name:"Scheduler"`
	MaxConnection                  requests.Integer                                `position:"Query" name:"MaxConnection"`
	MasterServerGroupId            string                                          `position:"Query" name:"MasterServerGroupId"`
	ListenerPort                   requests.Integer                                `position:"Query" name:"ListenerPort"`
	HealthCheckType                string                                          `position:"Query" name:"HealthCheckType"`
	ResourceOwnerAccount           string                                          `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth                      requests.Integer                                `position:"Query" name:"Bandwidth"`
	OwnerAccount                   string                                          `position:"Query" name:"OwnerAccount"`
	ConnectionDrainTimeout         requests.Integer                                `position:"Query" name:"ConnectionDrainTimeout"`
	HealthCheckConnectPort         requests.Integer                                `position:"Query" name:"HealthCheckConnectPort"`
	HealthCheckHttpCode            string                                          `position:"Query" name:"HealthCheckHttpCode"`
	VServerGroup                   string                                          `position:"Query" name:"VServerGroup"`
}

// SetLoadBalancerTCPListenerAttributePortRange is a repeated param struct in SetLoadBalancerTCPListenerAttributeRequest
type SetLoadBalancerTCPListenerAttributePortRange struct {
	StartPort string `name:"StartPort"`
	EndPort   string `name:"EndPort"`
}

// SetLoadBalancerTCPListenerAttributeResponse is the response struct for api SetLoadBalancerTCPListenerAttribute
type SetLoadBalancerTCPListenerAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetLoadBalancerTCPListenerAttributeRequest creates a request to invoke SetLoadBalancerTCPListenerAttribute API
func CreateSetLoadBalancerTCPListenerAttributeRequest() (request *SetLoadBalancerTCPListenerAttributeRequest) {
	request = &SetLoadBalancerTCPListenerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "SetLoadBalancerTCPListenerAttribute", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetLoadBalancerTCPListenerAttributeResponse creates a response to parse from SetLoadBalancerTCPListenerAttribute response
func CreateSetLoadBalancerTCPListenerAttributeResponse() (response *SetLoadBalancerTCPListenerAttributeResponse) {
	response = &SetLoadBalancerTCPListenerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
