package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSlrRole invokes the sddp.CreateSlrRole API synchronously
func (client *Client) CreateSlrRole(request *CreateSlrRoleRequest) (response *CreateSlrRoleResponse, err error) {
	response = CreateCreateSlrRoleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSlrRoleWithChan invokes the sddp.CreateSlrRole API asynchronously
func (client *Client) CreateSlrRoleWithChan(request *CreateSlrRoleRequest) (<-chan *CreateSlrRoleResponse, <-chan error) {
	responseChan := make(chan *CreateSlrRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSlrRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSlrRoleWithCallback invokes the sddp.CreateSlrRole API asynchronously
func (client *Client) CreateSlrRoleWithCallback(request *CreateSlrRoleRequest, callback func(response *CreateSlrRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSlrRoleResponse
		var err error
		defer close(result)
		response, err = client.CreateSlrRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSlrRoleRequest is the request struct for api CreateSlrRole
type CreateSlrRoleRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// CreateSlrRoleResponse is the response struct for api CreateSlrRole
type CreateSlrRoleResponse struct {
	*responses.BaseResponse
	HasPermission bool   `json:"HasPermission" xml:"HasPermission"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateSlrRoleRequest creates a request to invoke CreateSlrRole API
func CreateCreateSlrRoleRequest() (request *CreateSlrRoleRequest) {
	request = &CreateSlrRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "CreateSlrRole", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSlrRoleResponse creates a response to parse from CreateSlrRole response
func CreateCreateSlrRoleResponse() (response *CreateSlrRoleResponse) {
	response = &CreateSlrRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
