package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScdnSpecificConfig invokes the scdn.DeleteScdnSpecificConfig API synchronously
func (client *Client) DeleteScdnSpecificConfig(request *DeleteScdnSpecificConfigRequest) (response *DeleteScdnSpecificConfigResponse, err error) {
	response = CreateDeleteScdnSpecificConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteScdnSpecificConfigWithChan invokes the scdn.DeleteScdnSpecificConfig API asynchronously
func (client *Client) DeleteScdnSpecificConfigWithChan(request *DeleteScdnSpecificConfigRequest) (<-chan *DeleteScdnSpecificConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteScdnSpecificConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScdnSpecificConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteScdnSpecificConfigWithCallback invokes the scdn.DeleteScdnSpecificConfig API asynchronously
func (client *Client) DeleteScdnSpecificConfigWithCallback(request *DeleteScdnSpecificConfigRequest, callback func(response *DeleteScdnSpecificConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteScdnSpecificConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteScdnSpecificConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteScdnSpecificConfigRequest is the request struct for api DeleteScdnSpecificConfig
type DeleteScdnSpecificConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	ConfigId      string           `position:"Query" name:"ConfigId"`
}

// DeleteScdnSpecificConfigResponse is the response struct for api DeleteScdnSpecificConfig
type DeleteScdnSpecificConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteScdnSpecificConfigRequest creates a request to invoke DeleteScdnSpecificConfig API
func CreateDeleteScdnSpecificConfigRequest() (request *DeleteScdnSpecificConfigRequest) {
	request = &DeleteScdnSpecificConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DeleteScdnSpecificConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteScdnSpecificConfigResponse creates a response to parse from DeleteScdnSpecificConfig response
func CreateDeleteScdnSpecificConfigResponse() (response *DeleteScdnSpecificConfigResponse) {
	response = &DeleteScdnSpecificConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
