package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyClearLogstoreStorage invokes the sas.ModifyClearLogstoreStorage API synchronously
func (client *Client) ModifyClearLogstoreStorage(request *ModifyClearLogstoreStorageRequest) (response *ModifyClearLogstoreStorageResponse, err error) {
	response = CreateModifyClearLogstoreStorageResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyClearLogstoreStorageWithChan invokes the sas.ModifyClearLogstoreStorage API asynchronously
func (client *Client) ModifyClearLogstoreStorageWithChan(request *ModifyClearLogstoreStorageRequest) (<-chan *ModifyClearLogstoreStorageResponse, <-chan error) {
	responseChan := make(chan *ModifyClearLogstoreStorageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyClearLogstoreStorage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyClearLogstoreStorageWithCallback invokes the sas.ModifyClearLogstoreStorage API asynchronously
func (client *Client) ModifyClearLogstoreStorageWithCallback(request *ModifyClearLogstoreStorageRequest, callback func(response *ModifyClearLogstoreStorageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyClearLogstoreStorageResponse
		var err error
		defer close(result)
		response, err = client.ModifyClearLogstoreStorage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyClearLogstoreStorageRequest is the request struct for api ModifyClearLogstoreStorage
type ModifyClearLogstoreStorageRequest struct {
	*requests.RpcRequest
	SourceIp     string `position:"Query" name:"SourceIp"`
	From         string `position:"Query" name:"From"`
	Lang         string `position:"Query" name:"Lang"`
	UserLogStore string `position:"Query" name:"UserLogStore"`
	UserProject  string `position:"Query" name:"UserProject"`
}

// ModifyClearLogstoreStorageResponse is the response struct for api ModifyClearLogstoreStorage
type ModifyClearLogstoreStorageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyClearLogstoreStorageRequest creates a request to invoke ModifyClearLogstoreStorage API
func CreateModifyClearLogstoreStorageRequest() (request *ModifyClearLogstoreStorageRequest) {
	request = &ModifyClearLogstoreStorageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyClearLogstoreStorage", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyClearLogstoreStorageResponse creates a response to parse from ModifyClearLogstoreStorage response
func CreateModifyClearLogstoreStorageResponse() (response *ModifyClearLogstoreStorageResponse) {
	response = &ModifyClearLogstoreStorageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
