package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLoginBaseConfigs invokes the sas.DescribeLoginBaseConfigs API synchronously
func (client *Client) DescribeLoginBaseConfigs(request *DescribeLoginBaseConfigsRequest) (response *DescribeLoginBaseConfigsResponse, err error) {
	response = CreateDescribeLoginBaseConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLoginBaseConfigsWithChan invokes the sas.DescribeLoginBaseConfigs API asynchronously
func (client *Client) DescribeLoginBaseConfigsWithChan(request *DescribeLoginBaseConfigsRequest) (<-chan *DescribeLoginBaseConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeLoginBaseConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLoginBaseConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLoginBaseConfigsWithCallback invokes the sas.DescribeLoginBaseConfigs API asynchronously
func (client *Client) DescribeLoginBaseConfigsWithCallback(request *DescribeLoginBaseConfigsRequest, callback func(response *DescribeLoginBaseConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLoginBaseConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLoginBaseConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLoginBaseConfigsRequest is the request struct for api DescribeLoginBaseConfigs
type DescribeLoginBaseConfigsRequest struct {
	*requests.RpcRequest
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Type        string           `position:"Query" name:"Type"`
	Target      string           `position:"Query" name:"Target"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeLoginBaseConfigsResponse is the response struct for api DescribeLoginBaseConfigs
type DescribeLoginBaseConfigsResponse struct {
	*responses.BaseResponse
	CurrentPage int          `json:"CurrentPage" xml:"CurrentPage"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	PageSize    int          `json:"PageSize" xml:"PageSize"`
	TotalCount  int          `json:"TotalCount" xml:"TotalCount"`
	BaseConfigs []BaseConfig `json:"BaseConfigs" xml:"BaseConfigs"`
}

// CreateDescribeLoginBaseConfigsRequest creates a request to invoke DescribeLoginBaseConfigs API
func CreateDescribeLoginBaseConfigsRequest() (request *DescribeLoginBaseConfigsRequest) {
	request = &DescribeLoginBaseConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeLoginBaseConfigs", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLoginBaseConfigsResponse creates a response to parse from DescribeLoginBaseConfigs response
func CreateDescribeLoginBaseConfigsResponse() (response *DescribeLoginBaseConfigsResponse) {
	response = &DescribeLoginBaseConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
