package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSecret invokes the sae.UpdateSecret API synchronously
func (client *Client) UpdateSecret(request *UpdateSecretRequest) (response *UpdateSecretResponse, err error) {
	response = CreateUpdateSecretResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSecretWithChan invokes the sae.UpdateSecret API asynchronously
func (client *Client) UpdateSecretWithChan(request *UpdateSecretRequest) (<-chan *UpdateSecretResponse, <-chan error) {
	responseChan := make(chan *UpdateSecretResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSecret(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSecretWithCallback invokes the sae.UpdateSecret API asynchronously
func (client *Client) UpdateSecretWithCallback(request *UpdateSecretRequest, callback func(response *UpdateSecretResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSecretResponse
		var err error
		defer close(result)
		response, err = client.UpdateSecret(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSecretRequest is the request struct for api UpdateSecret
type UpdateSecretRequest struct {
	*requests.RoaRequest
	NamespaceId string           `position:"Query" name:"NamespaceId"`
	SecretId    requests.Integer `position:"Query" name:"SecretId"`
	SecretData  string           `position:"Body" name:"SecretData"`
}

// UpdateSecretResponse is the response struct for api UpdateSecret
type UpdateSecretResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateSecretRequest creates a request to invoke UpdateSecret API
func CreateUpdateSecretRequest() (request *UpdateSecretRequest) {
	request = &UpdateSecretRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "UpdateSecret", "/pop/v1/sam/secret/secret", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateSecretResponse creates a response to parse from UpdateSecret response
func CreateUpdateSecretResponse() (response *UpdateSecretResponse) {
	response = &UpdateSecretResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
