package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGreyTagRoute invokes the sae.UpdateGreyTagRoute API synchronously
func (client *Client) UpdateGreyTagRoute(request *UpdateGreyTagRouteRequest) (response *UpdateGreyTagRouteResponse, err error) {
	response = CreateUpdateGreyTagRouteResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGreyTagRouteWithChan invokes the sae.UpdateGreyTagRoute API asynchronously
func (client *Client) UpdateGreyTagRouteWithChan(request *UpdateGreyTagRouteRequest) (<-chan *UpdateGreyTagRouteResponse, <-chan error) {
	responseChan := make(chan *UpdateGreyTagRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGreyTagRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGreyTagRouteWithCallback invokes the sae.UpdateGreyTagRoute API asynchronously
func (client *Client) UpdateGreyTagRouteWithCallback(request *UpdateGreyTagRouteRequest, callback func(response *UpdateGreyTagRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGreyTagRouteResponse
		var err error
		defer close(result)
		response, err = client.UpdateGreyTagRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGreyTagRouteRequest is the request struct for api UpdateGreyTagRoute
type UpdateGreyTagRouteRequest struct {
	*requests.RoaRequest
	GreyTagRouteId requests.Integer `position:"Query" name:"GreyTagRouteId"`
	Description    string           `position:"Query" name:"Description"`
	DubboRules     string           `position:"Query" name:"DubboRules"`
	AlbRules       string           `position:"Query" name:"AlbRules"`
	ScRules        string           `position:"Query" name:"ScRules"`
}

// UpdateGreyTagRouteResponse is the response struct for api UpdateGreyTagRoute
type UpdateGreyTagRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUpdateGreyTagRouteRequest creates a request to invoke UpdateGreyTagRoute API
func CreateUpdateGreyTagRouteRequest() (request *UpdateGreyTagRouteRequest) {
	request = &UpdateGreyTagRouteRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "UpdateGreyTagRoute", "/pop/v1/sam/tagroute/greyTagRoute", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateGreyTagRouteResponse creates a response to parse from UpdateGreyTagRoute response
func CreateUpdateGreyTagRouteResponse() (response *UpdateGreyTagRouteResponse) {
	response = &UpdateGreyTagRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
