package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplicationScalingRule invokes the sae.DescribeApplicationScalingRule API synchronously
func (client *Client) DescribeApplicationScalingRule(request *DescribeApplicationScalingRuleRequest) (response *DescribeApplicationScalingRuleResponse, err error) {
	response = CreateDescribeApplicationScalingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApplicationScalingRuleWithChan invokes the sae.DescribeApplicationScalingRule API asynchronously
func (client *Client) DescribeApplicationScalingRuleWithChan(request *DescribeApplicationScalingRuleRequest) (<-chan *DescribeApplicationScalingRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeApplicationScalingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplicationScalingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApplicationScalingRuleWithCallback invokes the sae.DescribeApplicationScalingRule API asynchronously
func (client *Client) DescribeApplicationScalingRuleWithCallback(request *DescribeApplicationScalingRuleRequest, callback func(response *DescribeApplicationScalingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApplicationScalingRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplicationScalingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApplicationScalingRuleRequest is the request struct for api DescribeApplicationScalingRule
type DescribeApplicationScalingRuleRequest struct {
	*requests.RoaRequest
	ScalingRuleName string `position:"Query" name:"ScalingRuleName"`
	AppId           string `position:"Query" name:"AppId"`
}

// DescribeApplicationScalingRuleResponse is the response struct for api DescribeApplicationScalingRule
type DescribeApplicationScalingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeApplicationScalingRuleRequest creates a request to invoke DescribeApplicationScalingRule API
func CreateDescribeApplicationScalingRuleRequest() (request *DescribeApplicationScalingRuleRequest) {
	request = &DescribeApplicationScalingRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeApplicationScalingRule", "/pop/v1/sam/scale/applicationScalingRule", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeApplicationScalingRuleResponse creates a response to parse from DescribeApplicationScalingRule response
func CreateDescribeApplicationScalingRuleResponse() (response *DescribeApplicationScalingRuleResponse) {
	response = &DescribeApplicationScalingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
