package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSigns invokes the retailadvqa_public.ListSigns API synchronously
func (client *Client) ListSigns(request *ListSignsRequest) (response *ListSignsResponse, err error) {
	response = CreateListSignsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSignsWithChan invokes the retailadvqa_public.ListSigns API asynchronously
func (client *Client) ListSignsWithChan(request *ListSignsRequest) (<-chan *ListSignsResponse, <-chan error) {
	responseChan := make(chan *ListSignsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSigns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSignsWithCallback invokes the retailadvqa_public.ListSigns API asynchronously
func (client *Client) ListSignsWithCallback(request *ListSignsRequest, callback func(response *ListSignsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSignsResponse
		var err error
		defer close(result)
		response, err = client.ListSigns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSignsRequest is the request struct for api ListSigns
type ListSignsRequest struct {
	*requests.RpcRequest
	AccessId    string           `position:"Query" name:"AccessId"`
	SignName    string           `position:"Query" name:"SignName"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	TenantId    string           `position:"Query" name:"TenantId"`
	PlatformId  string           `position:"Query" name:"PlatformId"`
	SignStatus  string           `position:"Query" name:"SignStatus"`
	PageNum     requests.Integer `position:"Query" name:"PageNum"`
	WorkspaceId string           `position:"Query" name:"WorkspaceId"`
}

// ListSignsResponse is the response struct for api ListSigns
type ListSignsResponse struct {
	*responses.BaseResponse
	ErrorCode string          `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string          `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool            `json:"Success" xml:"Success"`
	TraceId   string          `json:"TraceId" xml:"TraceId"`
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Data      DataInListSigns `json:"Data" xml:"Data"`
}

// CreateListSignsRequest creates a request to invoke ListSigns API
func CreateListSignsRequest() (request *ListSignsRequest) {
	request = &ListSignsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ListSigns", "", "")
	request.Method = requests.GET
	return
}

// CreateListSignsResponse creates a response to parse from ListSigns response
func CreateListSignsResponse() (response *ListSignsResponse) {
	response = &ListSignsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
