package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportSmsReceiptToOSS invokes the retailadvqa_public.ExportSmsReceiptToOSS API synchronously
func (client *Client) ExportSmsReceiptToOSS(request *ExportSmsReceiptToOSSRequest) (response *ExportSmsReceiptToOSSResponse, err error) {
	response = CreateExportSmsReceiptToOSSResponse()
	err = client.DoAction(request, response)
	return
}

// ExportSmsReceiptToOSSWithChan invokes the retailadvqa_public.ExportSmsReceiptToOSS API asynchronously
func (client *Client) ExportSmsReceiptToOSSWithChan(request *ExportSmsReceiptToOSSRequest) (<-chan *ExportSmsReceiptToOSSResponse, <-chan error) {
	responseChan := make(chan *ExportSmsReceiptToOSSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportSmsReceiptToOSS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportSmsReceiptToOSSWithCallback invokes the retailadvqa_public.ExportSmsReceiptToOSS API asynchronously
func (client *Client) ExportSmsReceiptToOSSWithCallback(request *ExportSmsReceiptToOSSRequest, callback func(response *ExportSmsReceiptToOSSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportSmsReceiptToOSSResponse
		var err error
		defer close(result)
		response, err = client.ExportSmsReceiptToOSS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportSmsReceiptToOSSRequest is the request struct for api ExportSmsReceiptToOSS
type ExportSmsReceiptToOSSRequest struct {
	*requests.RpcRequest
	AccessId     string `position:"Query" name:"AccessId"`
	MarketTaskId string `position:"Query" name:"MarketTaskId"`
	WorkspaceId  string `position:"Query" name:"WorkspaceId"`
}

// ExportSmsReceiptToOSSResponse is the response struct for api ExportSmsReceiptToOSS
type ExportSmsReceiptToOSSResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateExportSmsReceiptToOSSRequest creates a request to invoke ExportSmsReceiptToOSS API
func CreateExportSmsReceiptToOSSRequest() (request *ExportSmsReceiptToOSSRequest) {
	request = &ExportSmsReceiptToOSSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ExportSmsReceiptToOSS", "", "")
	request.Method = requests.POST
	return
}

// CreateExportSmsReceiptToOSSResponse creates a response to parse from ExportSmsReceiptToOSS response
func CreateExportSmsReceiptToOSSResponse() (response *ExportSmsReceiptToOSSResponse) {
	response = &ExportSmsReceiptToOSSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
