package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDBInstanceTopology invokes the rds.GetDBInstanceTopology API synchronously
func (client *Client) GetDBInstanceTopology(request *GetDBInstanceTopologyRequest) (response *GetDBInstanceTopologyResponse, err error) {
	response = CreateGetDBInstanceTopologyResponse()
	err = client.DoAction(request, response)
	return
}

// GetDBInstanceTopologyWithChan invokes the rds.GetDBInstanceTopology API asynchronously
func (client *Client) GetDBInstanceTopologyWithChan(request *GetDBInstanceTopologyRequest) (<-chan *GetDBInstanceTopologyResponse, <-chan error) {
	responseChan := make(chan *GetDBInstanceTopologyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDBInstanceTopology(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDBInstanceTopologyWithCallback invokes the rds.GetDBInstanceTopology API asynchronously
func (client *Client) GetDBInstanceTopologyWithCallback(request *GetDBInstanceTopologyRequest, callback func(response *GetDBInstanceTopologyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDBInstanceTopologyResponse
		var err error
		defer close(result)
		response, err = client.GetDBInstanceTopology(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDBInstanceTopologyRequest is the request struct for api GetDBInstanceTopology
type GetDBInstanceTopologyRequest struct {
	*requests.RpcRequest
	DBInstanceId string `position:"Query" name:"DBInstanceId"`
}

// GetDBInstanceTopologyResponse is the response struct for api GetDBInstanceTopology
type GetDBInstanceTopologyResponse struct {
	*responses.BaseResponse
	Code      string                      `json:"Code" xml:"Code"`
	Message   string                      `json:"Message" xml:"Message"`
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Data      DataInGetDBInstanceTopology `json:"Data" xml:"Data"`
}

// CreateGetDBInstanceTopologyRequest creates a request to invoke GetDBInstanceTopology API
func CreateGetDBInstanceTopologyRequest() (request *GetDBInstanceTopologyRequest) {
	request = &GetDBInstanceTopologyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "GetDBInstanceTopology", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDBInstanceTopologyResponse creates a response to parse from GetDBInstanceTopology response
func CreateGetDBInstanceTopologyResponse() (response *GetDBInstanceTopologyResponse) {
	response = &GetDBInstanceTopologyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
