package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeADInfo invokes the rds.DescribeADInfo API synchronously
func (client *Client) DescribeADInfo(request *DescribeADInfoRequest) (response *DescribeADInfoResponse, err error) {
	response = CreateDescribeADInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeADInfoWithChan invokes the rds.DescribeADInfo API asynchronously
func (client *Client) DescribeADInfoWithChan(request *DescribeADInfoRequest) (<-chan *DescribeADInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeADInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeADInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeADInfoWithCallback invokes the rds.DescribeADInfo API asynchronously
func (client *Client) DescribeADInfoWithCallback(request *DescribeADInfoRequest, callback func(response *DescribeADInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeADInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeADInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeADInfoRequest is the request struct for api DescribeADInfo
type DescribeADInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// DescribeADInfoResponse is the response struct for api DescribeADInfo
type DescribeADInfoResponse struct {
	*responses.BaseResponse
	ADStatus          string `json:"ADStatus" xml:"ADStatus"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
	ADDNS             string `json:"ADDNS" xml:"ADDNS"`
	ADServerIpAddress string `json:"ADServerIpAddress" xml:"ADServerIpAddress"`
	AbnormalReason    string `json:"AbnormalReason" xml:"AbnormalReason"`
	UserName          string `json:"UserName" xml:"UserName"`
}

// CreateDescribeADInfoRequest creates a request to invoke DescribeADInfo API
func CreateDescribeADInfoRequest() (request *DescribeADInfoRequest) {
	request = &DescribeADInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeADInfo", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeADInfoResponse creates a response to parse from DescribeADInfo response
func CreateDescribeADInfoResponse() (response *DescribeADInfoResponse) {
	response = &DescribeADInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
