package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyActiveOperationTask invokes the r_kvstore.ModifyActiveOperationTask API synchronously
func (client *Client) ModifyActiveOperationTask(request *ModifyActiveOperationTaskRequest) (response *ModifyActiveOperationTaskResponse, err error) {
	response = CreateModifyActiveOperationTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyActiveOperationTaskWithChan invokes the r_kvstore.ModifyActiveOperationTask API asynchronously
func (client *Client) ModifyActiveOperationTaskWithChan(request *ModifyActiveOperationTaskRequest) (<-chan *ModifyActiveOperationTaskResponse, <-chan error) {
	responseChan := make(chan *ModifyActiveOperationTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyActiveOperationTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyActiveOperationTaskWithCallback invokes the r_kvstore.ModifyActiveOperationTask API asynchronously
func (client *Client) ModifyActiveOperationTaskWithCallback(request *ModifyActiveOperationTaskRequest, callback func(response *ModifyActiveOperationTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyActiveOperationTaskResponse
		var err error
		defer close(result)
		response, err = client.ModifyActiveOperationTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyActiveOperationTaskRequest is the request struct for api ModifyActiveOperationTask
type ModifyActiveOperationTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	SwitchTime           string           `position:"Query" name:"SwitchTime"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Ids                  string           `position:"Query" name:"Ids"`
}

// ModifyActiveOperationTaskResponse is the response struct for api ModifyActiveOperationTask
type ModifyActiveOperationTaskResponse struct {
	*responses.BaseResponse
	Ids       string `json:"Ids" xml:"Ids"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyActiveOperationTaskRequest creates a request to invoke ModifyActiveOperationTask API
func CreateModifyActiveOperationTaskRequest() (request *ModifyActiveOperationTaskRequest) {
	request = &ModifyActiveOperationTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyActiveOperationTask", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyActiveOperationTaskResponse creates a response to parse from ModifyActiveOperationTask response
func CreateModifyActiveOperationTaskResponse() (response *ModifyActiveOperationTaskResponse) {
	response = &ModifyActiveOperationTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
