package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckReadable invokes the quickbi_public.CheckReadable API synchronously
func (client *Client) CheckReadable(request *CheckReadableRequest) (response *CheckReadableResponse, err error) {
	response = CreateCheckReadableResponse()
	err = client.DoAction(request, response)
	return
}

// CheckReadableWithChan invokes the quickbi_public.CheckReadable API asynchronously
func (client *Client) CheckReadableWithChan(request *CheckReadableRequest) (<-chan *CheckReadableResponse, <-chan error) {
	responseChan := make(chan *CheckReadableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckReadable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckReadableWithCallback invokes the quickbi_public.CheckReadable API asynchronously
func (client *Client) CheckReadableWithCallback(request *CheckReadableRequest, callback func(response *CheckReadableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckReadableResponse
		var err error
		defer close(result)
		response, err = client.CheckReadable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckReadableRequest is the request struct for api CheckReadable
type CheckReadableRequest struct {
	*requests.RpcRequest
	WorksId     string `position:"Query" name:"WorksId"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
}

// CheckReadableResponse is the response struct for api CheckReadable
type CheckReadableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCheckReadableRequest creates a request to invoke CheckReadable API
func CreateCheckReadableRequest() (request *CheckReadableRequest) {
	request = &CheckReadableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "CheckReadable", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckReadableResponse creates a response to parse from CheckReadable response
func CreateCheckReadableResponse() (response *CheckReadableResponse) {
	response = &CheckReadableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
