package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddUser invokes the quickbi_public.AddUser API synchronously
func (client *Client) AddUser(request *AddUserRequest) (response *AddUserResponse, err error) {
	response = CreateAddUserResponse()
	err = client.DoAction(request, response)
	return
}

// AddUserWithChan invokes the quickbi_public.AddUser API asynchronously
func (client *Client) AddUserWithChan(request *AddUserRequest) (<-chan *AddUserResponse, <-chan error) {
	responseChan := make(chan *AddUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddUserWithCallback invokes the quickbi_public.AddUser API asynchronously
func (client *Client) AddUserWithCallback(request *AddUserRequest, callback func(response *AddUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddUserResponse
		var err error
		defer close(result)
		response, err = client.AddUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddUserRequest is the request struct for api AddUser
type AddUserRequest struct {
	*requests.RpcRequest
	ClientToken   string           `position:"Query" name:"ClientToken"`
	AdminUser     requests.Boolean `position:"Query" name:"AdminUser"`
	AccessPoint   string           `position:"Query" name:"AccessPoint"`
	AccountType   requests.Integer `position:"Query" name:"AccountType"`
	UserType      requests.Integer `position:"Query" name:"UserType"`
	SignType      string           `position:"Query" name:"SignType"`
	AccountId     string           `position:"Query" name:"AccountId"`
	AccountName   string           `position:"Query" name:"AccountName"`
	Phone         string           `position:"Query" name:"Phone"`
	NickName      string           `position:"Query" name:"NickName"`
	AuthAdminUser requests.Boolean `position:"Query" name:"AuthAdminUser"`
	Email         string           `position:"Query" name:"Email"`
}

// AddUserResponse is the response struct for api AddUser
type AddUserResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateAddUserRequest creates a request to invoke AddUser API
func CreateAddUserRequest() (request *AddUserRequest) {
	request = &AddUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "AddUser", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddUserResponse creates a response to parse from AddUser response
func CreateAddUserResponse() (response *AddUserResponse) {
	response = &AddUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
