package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEndpointAttributeByNsiAndServiceId invokes the privatelink.GetEndpointAttributeByNsiAndServiceId API synchronously
func (client *Client) GetEndpointAttributeByNsiAndServiceId(request *GetEndpointAttributeByNsiAndServiceIdRequest) (response *GetEndpointAttributeByNsiAndServiceIdResponse, err error) {
	response = CreateGetEndpointAttributeByNsiAndServiceIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetEndpointAttributeByNsiAndServiceIdWithChan invokes the privatelink.GetEndpointAttributeByNsiAndServiceId API asynchronously
func (client *Client) GetEndpointAttributeByNsiAndServiceIdWithChan(request *GetEndpointAttributeByNsiAndServiceIdRequest) (<-chan *GetEndpointAttributeByNsiAndServiceIdResponse, <-chan error) {
	responseChan := make(chan *GetEndpointAttributeByNsiAndServiceIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEndpointAttributeByNsiAndServiceId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEndpointAttributeByNsiAndServiceIdWithCallback invokes the privatelink.GetEndpointAttributeByNsiAndServiceId API asynchronously
func (client *Client) GetEndpointAttributeByNsiAndServiceIdWithCallback(request *GetEndpointAttributeByNsiAndServiceIdRequest, callback func(response *GetEndpointAttributeByNsiAndServiceIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEndpointAttributeByNsiAndServiceIdResponse
		var err error
		defer close(result)
		response, err = client.GetEndpointAttributeByNsiAndServiceId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEndpointAttributeByNsiAndServiceIdRequest is the request struct for api GetEndpointAttributeByNsiAndServiceId
type GetEndpointAttributeByNsiAndServiceIdRequest struct {
	*requests.RpcRequest
	DryRun    requests.Boolean `position:"Query" name:"DryRun"`
	NextToken string           `position:"Query" name:"NextToken"`
	NsiIndex  string           `position:"Query" name:"NsiIndex"`
	AliUid    requests.Integer `position:"Query" name:"AliUid"`
	ServiceId string           `position:"Query" name:"ServiceId"`
}

// GetEndpointAttributeByNsiAndServiceIdResponse is the response struct for api GetEndpointAttributeByNsiAndServiceId
type GetEndpointAttributeByNsiAndServiceIdResponse struct {
	*responses.BaseResponse
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	EndpointId                string `json:"EndpointId" xml:"EndpointId"`
	Payer                     string `json:"Payer" xml:"Payer"`
	ServiceId                 string `json:"ServiceId" xml:"ServiceId"`
	EndpointStatus            string `json:"EndpointStatus" xml:"EndpointStatus"`
	VpcId                     string `json:"VpcId" xml:"VpcId"`
	EndpointName              string `json:"EndpointName" xml:"EndpointName"`
	EndpointType              string `json:"EndpointType" xml:"EndpointType"`
	ServiceName               string `json:"ServiceName" xml:"ServiceName"`
	Bandwidth                 int    `json:"Bandwidth" xml:"Bandwidth"`
	RegionId                  string `json:"RegionId" xml:"RegionId"`
	ConnectionStatus          string `json:"ConnectionStatus" xml:"ConnectionStatus"`
	ZoneAffinityEnabled       bool   `json:"ZoneAffinityEnabled" xml:"ZoneAffinityEnabled"`
	ResourceOwner             bool   `json:"ResourceOwner" xml:"ResourceOwner"`
	ZonePrivateIpAddressCount int64  `json:"ZonePrivateIpAddressCount" xml:"ZonePrivateIpAddressCount"`
}

// CreateGetEndpointAttributeByNsiAndServiceIdRequest creates a request to invoke GetEndpointAttributeByNsiAndServiceId API
func CreateGetEndpointAttributeByNsiAndServiceIdRequest() (request *GetEndpointAttributeByNsiAndServiceIdRequest) {
	request = &GetEndpointAttributeByNsiAndServiceIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "GetEndpointAttributeByNsiAndServiceId", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEndpointAttributeByNsiAndServiceIdResponse creates a response to parse from GetEndpointAttributeByNsiAndServiceId response
func CreateGetEndpointAttributeByNsiAndServiceIdResponse() (response *GetEndpointAttributeByNsiAndServiceIdResponse) {
	response = &GetEndpointAttributeByNsiAndServiceIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
