package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenAITask invokes the polardb.OpenAITask API synchronously
func (client *Client) OpenAITask(request *OpenAITaskRequest) (response *OpenAITaskResponse, err error) {
	response = CreateOpenAITaskResponse()
	err = client.DoAction(request, response)
	return
}

// OpenAITaskWithChan invokes the polardb.OpenAITask API asynchronously
func (client *Client) OpenAITaskWithChan(request *OpenAITaskRequest) (<-chan *OpenAITaskResponse, <-chan error) {
	responseChan := make(chan *OpenAITaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenAITask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenAITaskWithCallback invokes the polardb.OpenAITask API asynchronously
func (client *Client) OpenAITaskWithCallback(request *OpenAITaskRequest, callback func(response *OpenAITaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenAITaskResponse
		var err error
		defer close(result)
		response, err = client.OpenAITask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenAITaskRequest is the request struct for api OpenAITask
type OpenAITaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	Password             string           `position:"Query" name:"Password"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Username             string           `position:"Query" name:"Username"`
}

// OpenAITaskResponse is the response struct for api OpenAITask
type OpenAITaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateOpenAITaskRequest creates a request to invoke OpenAITask API
func CreateOpenAITaskRequest() (request *OpenAITaskRequest) {
	request = &OpenAITaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "OpenAITask", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenAITaskResponse creates a response to parse from OpenAITask response
func CreateOpenAITaskResponse() (response *OpenAITaskResponse) {
	response = &OpenAITaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
