package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClassList invokes the polardb.DescribeClassList API synchronously
func (client *Client) DescribeClassList(request *DescribeClassListRequest) (response *DescribeClassListResponse, err error) {
	response = CreateDescribeClassListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClassListWithChan invokes the polardb.DescribeClassList API asynchronously
func (client *Client) DescribeClassListWithChan(request *DescribeClassListRequest) (<-chan *DescribeClassListResponse, <-chan error) {
	responseChan := make(chan *DescribeClassListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClassList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClassListWithCallback invokes the polardb.DescribeClassList API asynchronously
func (client *Client) DescribeClassListWithCallback(request *DescribeClassListRequest, callback func(response *DescribeClassListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClassListResponse
		var err error
		defer close(result)
		response, err = client.DescribeClassList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClassListRequest is the request struct for api DescribeClassList
type DescribeClassListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	CommodityCode        string           `position:"Query" name:"CommodityCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OrderType            string           `position:"Query" name:"OrderType"`
}

// DescribeClassListResponse is the response struct for api DescribeClassList
type DescribeClassListResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	RegionId  string      `json:"RegionId" xml:"RegionId"`
	Items     []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeClassListRequest creates a request to invoke DescribeClassList API
func CreateDescribeClassListRequest() (request *DescribeClassListRequest) {
	request = &DescribeClassListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeClassList", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClassListResponse creates a response to parse from DescribeClassList response
func CreateDescribeClassListResponse() (response *DescribeClassListResponse) {
	response = &DescribeClassListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
