package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveAppGroup invokes the opensearch.RemoveAppGroup API synchronously
func (client *Client) RemoveAppGroup(request *RemoveAppGroupRequest) (response *RemoveAppGroupResponse, err error) {
	response = CreateRemoveAppGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveAppGroupWithChan invokes the opensearch.RemoveAppGroup API asynchronously
func (client *Client) RemoveAppGroupWithChan(request *RemoveAppGroupRequest) (<-chan *RemoveAppGroupResponse, <-chan error) {
	responseChan := make(chan *RemoveAppGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveAppGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveAppGroupWithCallback invokes the opensearch.RemoveAppGroup API asynchronously
func (client *Client) RemoveAppGroupWithCallback(request *RemoveAppGroupRequest, callback func(response *RemoveAppGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveAppGroupResponse
		var err error
		defer close(result)
		response, err = client.RemoveAppGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveAppGroupRequest is the request struct for api RemoveAppGroup
type RemoveAppGroupRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// RemoveAppGroupResponse is the response struct for api RemoveAppGroup
type RemoveAppGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    []int  `json:"result" xml:"result"`
}

// CreateRemoveAppGroupRequest creates a request to invoke RemoveAppGroup API
func CreateRemoveAppGroupRequest() (request *RemoveAppGroupRequest) {
	request = &RemoveAppGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "RemoveAppGroup", "/v4/openapi/app-groups/[appGroupIdentity]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateRemoveAppGroupResponse creates a response to parse from RemoveAppGroup response
func CreateRemoveAppGroupResponse() (response *RemoveAppGroupResponse) {
	response = &RemoveAppGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
