package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProceedings invokes the opensearch.ListProceedings API synchronously
func (client *Client) ListProceedings(request *ListProceedingsRequest) (response *ListProceedingsResponse, err error) {
	response = CreateListProceedingsResponse()
	err = client.DoAction(request, response)
	return
}

// ListProceedingsWithChan invokes the opensearch.ListProceedings API asynchronously
func (client *Client) ListProceedingsWithChan(request *ListProceedingsRequest) (<-chan *ListProceedingsResponse, <-chan error) {
	responseChan := make(chan *ListProceedingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProceedings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProceedingsWithCallback invokes the opensearch.ListProceedings API asynchronously
func (client *Client) ListProceedingsWithCallback(request *ListProceedingsRequest, callback func(response *ListProceedingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProceedingsResponse
		var err error
		defer close(result)
		response, err = client.ListProceedings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProceedingsRequest is the request struct for api ListProceedings
type ListProceedingsRequest struct {
	*requests.RoaRequest
	FilterFinished   requests.Boolean `position:"Query" name:"filterFinished"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// ListProceedingsResponse is the response struct for api ListProceedings
type ListProceedingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListProceedingsRequest creates a request to invoke ListProceedings API
func CreateListProceedingsRequest() (request *ListProceedingsRequest) {
	request = &ListProceedingsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListProceedings", "/v4/openapi/app-groups/[appGroupIdentity]/proceedings", "", "")
	request.Method = requests.GET
	return
}

// CreateListProceedingsResponse creates a response to parse from ListProceedings response
func CreateListProceedingsResponse() (response *ListProceedingsResponse) {
	response = &ListProceedingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
