package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteABTestScene invokes the opensearch.DeleteABTestScene API synchronously
func (client *Client) DeleteABTestScene(request *DeleteABTestSceneRequest) (response *DeleteABTestSceneResponse, err error) {
	response = CreateDeleteABTestSceneResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteABTestSceneWithChan invokes the opensearch.DeleteABTestScene API asynchronously
func (client *Client) DeleteABTestSceneWithChan(request *DeleteABTestSceneRequest) (<-chan *DeleteABTestSceneResponse, <-chan error) {
	responseChan := make(chan *DeleteABTestSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteABTestScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteABTestSceneWithCallback invokes the opensearch.DeleteABTestScene API asynchronously
func (client *Client) DeleteABTestSceneWithCallback(request *DeleteABTestSceneRequest, callback func(response *DeleteABTestSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteABTestSceneResponse
		var err error
		defer close(result)
		response, err = client.DeleteABTestScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteABTestSceneRequest is the request struct for api DeleteABTestScene
type DeleteABTestSceneRequest struct {
	*requests.RoaRequest
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// DeleteABTestSceneResponse is the response struct for api DeleteABTestScene
type DeleteABTestSceneResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateDeleteABTestSceneRequest creates a request to invoke DeleteABTestScene API
func CreateDeleteABTestSceneRequest() (request *DeleteABTestSceneRequest) {
	request = &DeleteABTestSceneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DeleteABTestScene", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteABTestSceneResponse creates a response to parse from DeleteABTestScene response
func CreateDeleteABTestSceneResponse() (response *DeleteABTestSceneResponse) {
	response = &DeleteABTestSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
