package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeTaxiInvoice invokes the ocr.RecognizeTaxiInvoice API synchronously
func (client *Client) RecognizeTaxiInvoice(request *RecognizeTaxiInvoiceRequest) (response *RecognizeTaxiInvoiceResponse, err error) {
	response = CreateRecognizeTaxiInvoiceResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeTaxiInvoiceWithChan invokes the ocr.RecognizeTaxiInvoice API asynchronously
func (client *Client) RecognizeTaxiInvoiceWithChan(request *RecognizeTaxiInvoiceRequest) (<-chan *RecognizeTaxiInvoiceResponse, <-chan error) {
	responseChan := make(chan *RecognizeTaxiInvoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeTaxiInvoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeTaxiInvoiceWithCallback invokes the ocr.RecognizeTaxiInvoice API asynchronously
func (client *Client) RecognizeTaxiInvoiceWithCallback(request *RecognizeTaxiInvoiceRequest, callback func(response *RecognizeTaxiInvoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeTaxiInvoiceResponse
		var err error
		defer close(result)
		response, err = client.RecognizeTaxiInvoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeTaxiInvoiceRequest is the request struct for api RecognizeTaxiInvoice
type RecognizeTaxiInvoiceRequest struct {
	*requests.RpcRequest
	ImageType requests.Integer `position:"Body" name:"ImageType"`
	ImageURL  string           `position:"Body" name:"ImageURL"`
}

// RecognizeTaxiInvoiceResponse is the response struct for api RecognizeTaxiInvoice
type RecognizeTaxiInvoiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeTaxiInvoiceRequest creates a request to invoke RecognizeTaxiInvoice API
func CreateRecognizeTaxiInvoiceRequest() (request *RecognizeTaxiInvoiceRequest) {
	request = &RecognizeTaxiInvoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeTaxiInvoice", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeTaxiInvoiceResponse creates a response to parse from RecognizeTaxiInvoice response
func CreateRecognizeTaxiInvoiceResponse() (response *RecognizeTaxiInvoiceResponse) {
	response = &RecognizeTaxiInvoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
