package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizePassportMRZ invokes the ocr.RecognizePassportMRZ API synchronously
func (client *Client) RecognizePassportMRZ(request *RecognizePassportMRZRequest) (response *RecognizePassportMRZResponse, err error) {
	response = CreateRecognizePassportMRZResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizePassportMRZWithChan invokes the ocr.RecognizePassportMRZ API asynchronously
func (client *Client) RecognizePassportMRZWithChan(request *RecognizePassportMRZRequest) (<-chan *RecognizePassportMRZResponse, <-chan error) {
	responseChan := make(chan *RecognizePassportMRZResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizePassportMRZ(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizePassportMRZWithCallback invokes the ocr.RecognizePassportMRZ API asynchronously
func (client *Client) RecognizePassportMRZWithCallback(request *RecognizePassportMRZRequest, callback func(response *RecognizePassportMRZResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizePassportMRZResponse
		var err error
		defer close(result)
		response, err = client.RecognizePassportMRZ(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizePassportMRZRequest is the request struct for api RecognizePassportMRZ
type RecognizePassportMRZRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// RecognizePassportMRZResponse is the response struct for api RecognizePassportMRZ
type RecognizePassportMRZResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizePassportMRZRequest creates a request to invoke RecognizePassportMRZ API
func CreateRecognizePassportMRZRequest() (request *RecognizePassportMRZRequest) {
	request = &RecognizePassportMRZRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizePassportMRZ", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizePassportMRZResponse creates a response to parse from RecognizePassportMRZ response
func CreateRecognizePassportMRZResponse() (response *RecognizePassportMRZResponse) {
	response = &RecognizePassportMRZResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
