package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartOmsOpenAPIProject invokes the oceanbasepro.StartOmsOpenAPIProject API synchronously
func (client *Client) StartOmsOpenAPIProject(request *StartOmsOpenAPIProjectRequest) (response *StartOmsOpenAPIProjectResponse, err error) {
	response = CreateStartOmsOpenAPIProjectResponse()
	err = client.DoAction(request, response)
	return
}

// StartOmsOpenAPIProjectWithChan invokes the oceanbasepro.StartOmsOpenAPIProject API asynchronously
func (client *Client) StartOmsOpenAPIProjectWithChan(request *StartOmsOpenAPIProjectRequest) (<-chan *StartOmsOpenAPIProjectResponse, <-chan error) {
	responseChan := make(chan *StartOmsOpenAPIProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartOmsOpenAPIProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartOmsOpenAPIProjectWithCallback invokes the oceanbasepro.StartOmsOpenAPIProject API asynchronously
func (client *Client) StartOmsOpenAPIProjectWithCallback(request *StartOmsOpenAPIProjectRequest, callback func(response *StartOmsOpenAPIProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartOmsOpenAPIProjectResponse
		var err error
		defer close(result)
		response, err = client.StartOmsOpenAPIProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartOmsOpenAPIProjectRequest is the request struct for api StartOmsOpenAPIProject
type StartOmsOpenAPIProjectRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	WorkerGradeId string           `position:"Body" name:"WorkerGradeId"`
	ProjectId     string           `position:"Body" name:"ProjectId"`
}

// StartOmsOpenAPIProjectResponse is the response struct for api StartOmsOpenAPIProject
type StartOmsOpenAPIProjectResponse struct {
	*responses.BaseResponse
	Success     bool        `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	Advice      string      `json:"Advice" xml:"Advice"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	Cost        string      `json:"Cost" xml:"Cost"`
	Data        bool        `json:"Data" xml:"Data"`
	ErrorDetail ErrorDetail `json:"ErrorDetail" xml:"ErrorDetail"`
}

// CreateStartOmsOpenAPIProjectRequest creates a request to invoke StartOmsOpenAPIProject API
func CreateStartOmsOpenAPIProjectRequest() (request *StartOmsOpenAPIProjectRequest) {
	request = &StartOmsOpenAPIProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "StartOmsOpenAPIProject", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartOmsOpenAPIProjectResponse creates a response to parse from StartOmsOpenAPIProject response
func CreateStartOmsOpenAPIProjectResponse() (response *StartOmsOpenAPIProjectResponse) {
	response = &StartOmsOpenAPIProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
