package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchOmsOpenAPIProjects invokes the oceanbasepro.SearchOmsOpenAPIProjects API synchronously
func (client *Client) SearchOmsOpenAPIProjects(request *SearchOmsOpenAPIProjectsRequest) (response *SearchOmsOpenAPIProjectsResponse, err error) {
	response = CreateSearchOmsOpenAPIProjectsResponse()
	err = client.DoAction(request, response)
	return
}

// SearchOmsOpenAPIProjectsWithChan invokes the oceanbasepro.SearchOmsOpenAPIProjects API asynchronously
func (client *Client) SearchOmsOpenAPIProjectsWithChan(request *SearchOmsOpenAPIProjectsRequest) (<-chan *SearchOmsOpenAPIProjectsResponse, <-chan error) {
	responseChan := make(chan *SearchOmsOpenAPIProjectsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchOmsOpenAPIProjects(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchOmsOpenAPIProjectsWithCallback invokes the oceanbasepro.SearchOmsOpenAPIProjects API asynchronously
func (client *Client) SearchOmsOpenAPIProjectsWithCallback(request *SearchOmsOpenAPIProjectsRequest, callback func(response *SearchOmsOpenAPIProjectsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchOmsOpenAPIProjectsResponse
		var err error
		defer close(result)
		response, err = client.SearchOmsOpenAPIProjects(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchOmsOpenAPIProjectsRequest is the request struct for api SearchOmsOpenAPIProjects
type SearchOmsOpenAPIProjectsRequest struct {
	*requests.RpcRequest
	DestDbTypes   *[]string        `position:"Body" name:"DestDbTypes"  type:"Json"`
	StatusList    *[]string        `position:"Body" name:"StatusList"  type:"Json"`
	SearchKey     string           `position:"Body" name:"SearchKey"`
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	SourceDbTypes *[]string        `position:"Body" name:"SourceDbTypes"  type:"Json"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	WorkerGradeId string           `position:"Body" name:"WorkerGradeId"`
	LabelIds      *[]string        `position:"Body" name:"LabelIds"  type:"Json"`
}

// SearchOmsOpenAPIProjectsResponse is the response struct for api SearchOmsOpenAPIProjects
type SearchOmsOpenAPIProjectsResponse struct {
	*responses.BaseResponse
	Success     bool        `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	Advice      string      `json:"Advice" xml:"Advice"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	Cost        string      `json:"Cost" xml:"Cost"`
	ErrorDetail ErrorDetail `json:"ErrorDetail" xml:"ErrorDetail"`
	Data        []DataItem  `json:"Data" xml:"Data"`
}

// CreateSearchOmsOpenAPIProjectsRequest creates a request to invoke SearchOmsOpenAPIProjects API
func CreateSearchOmsOpenAPIProjectsRequest() (request *SearchOmsOpenAPIProjectsRequest) {
	request = &SearchOmsOpenAPIProjectsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "SearchOmsOpenAPIProjects", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchOmsOpenAPIProjectsResponse creates a response to parse from SearchOmsOpenAPIProjects response
func CreateSearchOmsOpenAPIProjectsResponse() (response *SearchOmsOpenAPIProjectsResponse) {
	response = &SearchOmsOpenAPIProjectsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
