package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTenantReadOnlyConnection invokes the oceanbasepro.CreateTenantReadOnlyConnection API synchronously
func (client *Client) CreateTenantReadOnlyConnection(request *CreateTenantReadOnlyConnectionRequest) (response *CreateTenantReadOnlyConnectionResponse, err error) {
	response = CreateCreateTenantReadOnlyConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTenantReadOnlyConnectionWithChan invokes the oceanbasepro.CreateTenantReadOnlyConnection API asynchronously
func (client *Client) CreateTenantReadOnlyConnectionWithChan(request *CreateTenantReadOnlyConnectionRequest) (<-chan *CreateTenantReadOnlyConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateTenantReadOnlyConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTenantReadOnlyConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTenantReadOnlyConnectionWithCallback invokes the oceanbasepro.CreateTenantReadOnlyConnection API asynchronously
func (client *Client) CreateTenantReadOnlyConnectionWithCallback(request *CreateTenantReadOnlyConnectionRequest, callback func(response *CreateTenantReadOnlyConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTenantReadOnlyConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateTenantReadOnlyConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTenantReadOnlyConnectionRequest is the request struct for api CreateTenantReadOnlyConnection
type CreateTenantReadOnlyConnectionRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
	ZoneId     string `position:"Body" name:"ZoneId"`
}

// CreateTenantReadOnlyConnectionResponse is the response struct for api CreateTenantReadOnlyConnection
type CreateTenantReadOnlyConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTenantReadOnlyConnectionRequest creates a request to invoke CreateTenantReadOnlyConnection API
func CreateCreateTenantReadOnlyConnectionRequest() (request *CreateTenantReadOnlyConnectionRequest) {
	request = &CreateTenantReadOnlyConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateTenantReadOnlyConnection", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTenantReadOnlyConnectionResponse creates a response to parse from CreateTenantReadOnlyConnection response
func CreateCreateTenantReadOnlyConnectionResponse() (response *CreateTenantReadOnlyConnectionResponse) {
	response = &CreateTenantReadOnlyConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
