package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOmsMysqlDataSource invokes the oceanbasepro.CreateOmsMysqlDataSource API synchronously
func (client *Client) CreateOmsMysqlDataSource(request *CreateOmsMysqlDataSourceRequest) (response *CreateOmsMysqlDataSourceResponse, err error) {
	response = CreateCreateOmsMysqlDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOmsMysqlDataSourceWithChan invokes the oceanbasepro.CreateOmsMysqlDataSource API asynchronously
func (client *Client) CreateOmsMysqlDataSourceWithChan(request *CreateOmsMysqlDataSourceRequest) (<-chan *CreateOmsMysqlDataSourceResponse, <-chan error) {
	responseChan := make(chan *CreateOmsMysqlDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOmsMysqlDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOmsMysqlDataSourceWithCallback invokes the oceanbasepro.CreateOmsMysqlDataSource API asynchronously
func (client *Client) CreateOmsMysqlDataSourceWithCallback(request *CreateOmsMysqlDataSourceRequest, callback func(response *CreateOmsMysqlDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOmsMysqlDataSourceResponse
		var err error
		defer close(result)
		response, err = client.CreateOmsMysqlDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOmsMysqlDataSourceRequest is the request struct for api CreateOmsMysqlDataSource
type CreateOmsMysqlDataSourceRequest struct {
	*requests.RpcRequest
	Schema       string `position:"Body" name:"Schema"`
	Description  string `position:"Body" name:"Description"`
	DgDatabaseId string `position:"Body" name:"DgDatabaseId"`
	Type         string `position:"Body" name:"Type"`
	Password     string `position:"Body" name:"Password"`
	Ip           string `position:"Body" name:"Ip"`
	InstanceId   string `position:"Body" name:"InstanceId"`
	Port         string `position:"Body" name:"Port"`
	VpcId        string `position:"Body" name:"VpcId"`
	Name         string `position:"Body" name:"Name"`
	Bid          string `position:"Query" name:"Bid"`
	Username     string `position:"Body" name:"Username"`
}

// CreateOmsMysqlDataSourceResponse is the response struct for api CreateOmsMysqlDataSource
type CreateOmsMysqlDataSourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateOmsMysqlDataSourceRequest creates a request to invoke CreateOmsMysqlDataSource API
func CreateCreateOmsMysqlDataSourceRequest() (request *CreateOmsMysqlDataSourceRequest) {
	request = &CreateOmsMysqlDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateOmsMysqlDataSource", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOmsMysqlDataSourceResponse creates a response to parse from CreateOmsMysqlDataSource response
func CreateCreateOmsMysqlDataSourceResponse() (response *CreateOmsMysqlDataSourceResponse) {
	response = &CreateOmsMysqlDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
